/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
#include <X11/Intrinsic.h>
#include "miscP.h"

Buffer
newBuf ()
{
    Buffer buf;

    buf = (Buffer)XtMalloc (sizeof (BufferRec));
    buf->current = buf->contents = XtMalloc (BUF_INC_LEN);
    buf->len = BUF_INC_LEN;

    return buf;
}

char *
getString (buf)
Buffer buf;
{
    return buf->contents;
}

void
putOut (buf, string)
Buffer buf;
char *string;
{
    unsigned int length;

    length = safe_strlen (string);

    if (buf->contents + buf->len - buf->current <= length)
	{
	    int cur_point;

	    buf->len += length + BUF_INC_LEN;
	    cur_point = buf->current - buf->contents;
	    buf->contents = XtRealloc (buf->contents, buf->len);
	    buf->current =  buf->contents + cur_point;
	}

    strcpy (buf->current, string);
    
    buf->current += length;
}

void freeBuf (buf)
Buffer buf;
{
    XtFree (buf->contents);
    XtFree ((char *)buf);
}

char *makeTerm (text_src, entry)
     char *text_src;
     char *entry;
{
  Buffer buf;
  char *result;
  char *text;
  char *t;

  if (text_src == NULL || strcmp (text_src, "") == 0)
    return NULL;

  buf = newBuf ();

  putOut (buf, entry);
  putOut (buf, "=");

  putOut (buf, "\"");
  putOut (buf, text_src);
  putOut (buf, "\"");

  result = getString (buf);
  result = XtNewString (result);

  freeBuf (buf);

  return result;
}

char *makeExp (t1, t2)
     char *t1;
     char *t2;
{
  char *result;

  if (t1 == NULL || strcmp (t1,"")==0)
    {
      if (t2 == NULL)
	result = NULL;

      result = XtNewString (t2);
    }
  else if (t2 == NULL || strcmp (t2,"")==0)
    {
      result = XtNewString (t1);
    }
  else
    {
      result = XtMalloc (strlen (t1) + strlen (t2) + 7);
      sprintf (result, "and(%s,%s)",t1,t2);
    }

  return result;
}

int safe_strlen (string)
     char *string;
{
  if (string)
    return strlen (string);
  else
    return 0;
}
