/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
/*********************************
  Kappa RPC Client libraly Header

 *********************************/

#include <rpc/rpc.h>
#include <sys/socket.h>
#include <netdb.h>
#include <sys/time.h>

/*************
  RPC Numbers
 *************/
#define KAP_RPC_PROGNUM    0x30000010
#define KAP_RPC_VERSION    1

#define KAP_RPC_MS_OPEN       1
#define KAP_RPC_MS_CLOSE      6
#define KAP_RPC_OPEN         10
#define KAP_RPC_IDXSEARCH    21
#define KAP_RPC_DATSEARCH    22
#define KAP_RPC_MOTIFSEARCH  26
#define KAP_RPC_READ         30
#define KAP_RPC_READ_ALL     31
#define KAP_RPC_CLOSE        40

#define KPS_IDX            1
#define KPS_DAT            2

/*************
  Max Define
 *************/
#define MAX_TABLE_NAME     80
#define MAX_CONDITION      256 /* 512 */
#define MAX_FORMAT         256
#define MAX_ACCESS_TYPE    24 /* 64 */
#define MAX_FILTER_NAME    64
#define MAX_READ_RET       50000

/*********
  Structs
 *********/
typedef struct _KPS {
    struct timeval total_timeout;
    CLIENT *client;
    int    sock;
    char   db_name[MAX_TABLE_NAME + 1];
} KPS;

#define Ktotal_timeout(x)       (x->total_timeout)
#define Kclient(x)              (x->client)
#define Ksocket(x)              (x->sock)
#define Kdb_name(x)             (x->db_name)

typedef struct _KAP_RPCS {
    char condition[MAX_CONDITION + 1];
    char format[MAX_FORMAT + 1];
    char access_type[MAX_ACCESS_TYPE + 1];
    char filter_name[MAX_FILTER_NAME + 1];
} KAP_RPCS;

#define KScondition(x)          (x->condition)
#define KSformat(x)             (x->format)
#define KSaccess_type(x)        (x->access_type)
#define KSfilter_name(x)        (x->filter_name)

typedef struct _KAP_RPCR {
    char read_ret[MAX_READ_RET + 1];
    int  error_ret;
} KAP_RPCR;

#define KRread_ret(x)           (x->read_ret)
#define KRerror_ret(x)          (x->error_ret)


/************
  Error_code
 ************/
#define	KPSERR_NO_HOST		11   /* $B%[%9%H$H@\B3$G$-$J$$(B */
#define	KPSERR_NO_KAPPA		12   /* Kappa_Manager$B$,5/F0$7$F$$$J$$(B */
#define	KPSERR_TABLE_ACCESS	13   /* $BBP1~$9$k%F!<%V%k$,B8:_$7$J$$(B or
                                	$BB><T$,%F!<%V%k$r@lM-$7$F$$$k(B or
					$B%F!<%V%k$N%"%/%;%98"$,$J$$(B */
#define	KPSERR_NOT_OPEN		21   /* $B8!:w$,3+;O$5$l$F$$$J$$(B */
#define	KPSERR_COND_SYNTAX	22   /* $B8!:w>r7o$K8m$j$,$"$k(B */
#define	KPSERR_FORM_SYNTAX	23   /* $B=PNO=q<0$K8m$j$,$"$k(B */

#define	KPSERR_NO_MORE_TERM	31   /* $BFI9~$`9`$,$J$$(B($B4{$KA4ItFI9~$s$G$$$k(B) */
#define	KPSERR_BUFFER_FLOW	32   /* $BFI$_9~$_%P%C%U%!D9$,B-$j$J$$(B */


#define BUF_LEN MAX_READ_RET
extern char *data;
KPS *KappaMSOpen ();
