/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>
#include <Xm/PanedW.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/TextF.h>
#include <Xm/PushB.h>
#include <Xm/List.h>

#include "Define.h"
#include "DataBaseP.h"
#include "Objects.h"
#include "SearchP.h"
#include "app_res.h"
#include "kappa_rpc1.h"

extern Display *display;

void DestroySearchWin (swd)
     SearchWinData swd;
{
  DataBase database = app_resources.database;

  if (swd->dwd)
    DestroyDefineWin (swd->dwd);
  else
    {
      if (swd->string_list)
        freeStringList (swd->string_list);
    }

  XtDestroyWidget (swd->toplevel);
  database->freeSearchInfo (swd->s);
  XtFree ((char *)swd);
}

static void Quit (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  extern KPS *Kappa;
  SearchWinData swd = (SearchWinData) clientData;

  DestroySearchWin (swd);
  XtDestroyApplicationContext (app_con);
  if (KappaMSClose (Kappa))
    {
      fprintf (stderr, "KappaMSClose Error\n");
    }
  exit (0);
}

static void Open (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  SearchWinData swd = (SearchWinData) clientData;
  int *pos_list;
  int count;
  int selected;

  if (XmListGetSelectedPos (swd->list, &pos_list, &count))
    {
      selected = pos_list[0] -1;
      XtFree (pos_list);
    }
  else
    selected = 0;

  if (swd->number_of_hits)
      MakeDispWin (swd->string_list,
		   swd->number_of_hits,
		   selected,
		   app_resources.how_to_display,
		   app_resources.hostname,
                   app_resources.database,
		   app_resources.database_no);
}

static void Define (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  Widget form, all, single, quit;
  SearchWinData swd = (SearchWinData) clientData;

  if (swd->dwd)
    DestroyDefineWin (swd->dwd);

  swd->dwd = MakeDefineWin (swd);
}

void MakeSearchWindowInternal (swd)
     SearchWinData swd;
{
  int i;
  DataBase database = app_resources.database;
  char name[50];
  Widget paned;
  Widget output;
  Widget o_title;
  Widget viewport;
  Widget command_open;
  Widget command_define;
  Widget command_quit;

  swd->paned = paned = XtVaCreateWidget ("paned", xmPanedWindowWidgetClass,
					 swd->toplevel, NULL);
  swd->form =  XtVaCreateWidget ("input_form", xmFormWidgetClass,
				 paned, NULL);
  database->makeSearchInput (swd);
  XtManageChild (swd->form);

  output = XtVaCreateWidget ("output", xmFormWidgetClass, paned,
                             XmNfractionBase, 10,
                             NULL);

  /* Make Output */
  o_title = XtVaCreateManagedWidget("hits", xmLabelGadgetClass, output, 
                                    XmNalignment, XmALIGNMENT_BEGINNING,
                                    XmNtopAttachment,    XmATTACH_FORM,
                                    XmNbottomAttachment, XmATTACH_POSITION,
                                    XmNbottomPosition,   1,
                                    XmNleftAttachment,   XmATTACH_FORM,
                                    XmNrightAttachment,  XmATTACH_POSITION,
                                    XmNrightPosition,    2,
				    NULL);
  swd->total_hits =
    XtVaCreateManagedWidget("num_of_hits", xmLabelGadgetClass, output, 
                            XmNtopAttachment,    XmATTACH_FORM,
                            XmNbottomAttachment, XmATTACH_POSITION,
                            XmNbottomPosition,   1,
                            XmNleftAttachment,   XmATTACH_POSITION,
                            XmNleftPosition,     3,
                            XmNrightAttachment,  XmATTACH_POSITION,
                            XmNrightPosition,    4,
                            NULL);

  swd->list =
    XmCreateScrolledList (output, "scrolledList", NULL, 0);
  XtVaSetValues (swd->list,
                 XmNitems,  NULL,
                 XmNitemCount, 0,
                 XmNvisibleItemCount, 15,
                 NULL);
  XtVaSetValues (XtParent (swd->list),
                 XmNtopAttachment,    XmATTACH_POSITION,
                 XmNtopPosition,      2,
                 XmNbottomAttachment, XmATTACH_FORM,
                 XmNleftAttachment,   XmATTACH_FORM,
                 XmNrightAttachment,  XmATTACH_POSITION,
                 XmNrightPosition,    7,
                 NULL);
  XtManageChild (swd->list);
  XtAddCallback (swd->list, XmNdefaultActionCallback, Open, swd);

  /* command box OPEN */
  command_open =
    XtVaCreateManagedWidget ("open", xmPushButtonWidgetClass, output,
                             XmNtopAttachment,    XmATTACH_FORM,
                             XmNbottomAttachment, XmATTACH_POSITION,
                             XmNbottomPosition,   1,
                             XmNleftAttachment,   XmATTACH_POSITION,
                             XmNleftPosition,     8,
                             XmNrightAttachment,  XmATTACH_FORM,
                             NULL);
  XtAddCallback (command_open, XmNactivateCallback, Open, swd);

  /* command box DEFINE */
  command_define =
    XtVaCreateManagedWidget("define", xmPushButtonWidgetClass, output,
                            XmNtopAttachment,    XmATTACH_POSITION,
                            XmNtopPosition,      6,
                            XmNbottomAttachment, XmATTACH_POSITION,
                            XmNbottomPosition,   7,
                            XmNleftAttachment,   XmATTACH_POSITION,
                            XmNleftPosition,     8,
                            XmNrightAttachment,  XmATTACH_FORM,
                            NULL);
  XtAddCallback (command_define, XmNactivateCallback, Define, swd);

  /* command box QUIT */
  command_quit =
    XtVaCreateManagedWidget("quit", xmPushButtonWidgetClass, output,
                            XmNtopAttachment,    XmATTACH_POSITION,
                            XmNtopPosition,      7,
                            XmNbottomAttachment, XmATTACH_POSITION,
                            XmNbottomPosition,   8,
                            XmNleftAttachment,   XmATTACH_POSITION,
                            XmNleftPosition,     8,
                            XmNrightAttachment,  XmATTACH_FORM,
                            NULL);
  XtAddCallback (command_quit, XmNactivateCallback, Quit, swd);

  XtManageChild (output);
  /* end of  Output */

  XtManageChild (paned); 
 
  sprintf (name, "Query: %c%c%c_kappa",
	   app_resources.database->database_name[0],
	   app_resources.database->database_name[1],
	   app_resources.database->database_name[2]);
	   
  XtVaSetValues (swd->toplevel,
		 XtNtitle, name,
		 NULL);
}

SearchWinData MakeSearchWindow (toplevel)
     Widget toplevel;
{
  SearchWinData swd;

  swd = (SearchWinData) XtMalloc (sizeof (struct _SearchWinDataRec));
  swd->toplevel = toplevel;
  swd->string_list = NULL;
  swd->number_of_hits = 0;
  swd->dwd = NULL;
  MakeSearchWindowInternal (swd);

  return swd;
}
