/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
#include "Pir.h"
typedef struct _GeneralRec     *General;
typedef struct _FeatureRec     *Feature;
typedef struct _FeatureListRec *FeatureList;

typedef struct _GeneralRec {
    char *id_code;
    char *seq_type;
    char *molec_name;
    char *life_name;
    StringList alternative_names;
    StringList includes;
    char *entry_date;
    char *seq_date;
    char *text_date;
    StringList comments;
    StringList keywords;
    char *sequence;
    unsigned int weight;
    unsigned int length;
    FeatureList feature_list;
} GeneralRec;

typedef struct _FeatureRec {
    char *id_func;
    char *name_func;
    PositionList position_list;
    RegionList region_list;
} FeatureRec;

typedef struct _FeatureListRec {
    Feature feature;
    struct _FeatureListRec *next;
} FeatureListRec;

typedef struct _PatternRec * Pattern;
typedef struct _PatternRec {
  char *description;
  char *pattern;
} PatternRec;

typedef struct _PatternListRec * PatternList;
typedef struct _PatternListRec {
  struct _PatternRec *pattern;
  struct _PatternListRec *next;
} PatternListRec;

typedef struct _PirSearchRec *PirSearch;

typedef struct _PirSearchRec {
  Widget id_code;
  Widget molec_name;
  Widget life_name;
  Widget keywords;
} PirSearchRec;

typedef struct _MotifSearchRec *MotifSearch;
typedef struct _MotifSearchRec {
  Widget name_id;
  Widget description;
} MotifSearchRec;

typedef struct _PirSearchByMotifRec *PirSearchByMotif;
typedef struct _PirSearchByMotifRec {
  Widget listbox;
  PatternList pattern_list;
  int number_of_hits;
} PirSearchByMotifRec;

typedef struct _SearchInfoRec * SearchInfo;

#define PIR_SEARCH           1
#define MOTIF_SEARCH          2
#define PIR_SEARCH_BY_MOTIF    3

typedef struct _SearchInfoRec {
  int id;
  void *info;
} SearchInfoRec;
