/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
  
#include "FigTextP.h"
  
  static XtResource resources[] =
{
#define offset(field) XtOffsetOf (FigTextRec, field)
  /* {name, class, type, size, offset, default_type, default_addr}, */
  {
    XtNx1,  XtCPosition, XtRPosition,
    sizeof(Position), offset(fig_text.x1), XtRImmediate,
    0,
  },
  {
    XtNy1,  XtCPosition, XtRPosition,
    sizeof(Position), offset(fig_text.y1), XtRImmediate,
    0,
  },
  {
    XtNlabel,  XtCLabel, XtRString,
    sizeof(String), offset(fig_text.label), XtRImmediate,
    NULL,
  },
  {
    XtNfont, XtCFont, XtRFontStruct,
    sizeof(XFontStruct *), offset(fig_text.font), XtRString,
    (XtPointer)XtDefaultFont,
  },
#undef offset
};

static Boolean SetValues ();
static void Initialize ();
static void Destroy ();

static void Draw ();

FigTextClassRec figTextClassRec = {
  {/* object fields */
    /* superclass */ (WidgetClass) &figObjectClassRec,
		     /* class name */            "FigText",
		     /* size of widget */        sizeof (FigTextRec),
		     /* class_initialize */      NULL,
		     /* class_part_initialize */ NULL,
		     /* class_inited	*/	FALSE,
		     /* initialize	*/	Initialize,
		     /* initialize_hook	*/      NULL,
		     /* 1 */      NULL,
		     /* 2 */      NULL,
		     /* 3 */      NULL,
		     /* resources */	        resources,
		     /* num_resources */	        XtNumber(resources),
		     /* xrm_class */	        NULLQUARK,
		     /* 4 */     NULL,
		     /* 5 */     NULL,
		     /* 6 */     NULL,
		     /* 7 */     NULL,
		     /* destroy		*/      Destroy,
		     /* resize */                NULL,
		     /* expose */                XtInheritExpose,
		     /* set_values	 */     SetValues,
		     /* set_values_hook	 */	NULL,
		     /* set_values_almost */     NULL,
		     /* get_values_hook	 */	NULL,
		     /* 9 */     NULL,
		     /* version		*/	XtVersion,
		     /* callback_private	*/	NULL,
		     /* 10 */    NULL,
		     /* query_geometry */        NULL,
		     /* 11 */    NULL,
		     /* extension	*/	NULL,
		   },
  {/* fig object field */
    /* draw */      Draw,
		  },
};

WidgetClass figTextClass = (WidgetClass)&figTextClassRec;
     
static void SetGeometory (ft)
     FigText ft;
{
  ft->fig_text.length = safe_strlen (ft->fig_text.label);
  
  ft->rect_obj.x = ft->fig_text.x1;
  ft->rect_obj.y = ft->fig_text.y1 - ft->fig_text.font->ascent;
  ft->rect_obj.width  = XTextWidth (ft->fig_text.font,
				    ft->fig_text.label,
				    ft->fig_text.length);
  ft->rect_obj.height = ft->fig_text.font->ascent
    + ft->fig_text.font->descent;
}

static Boolean  SetValues (current, request, new, args, num_args)
     Widget current, request, new;
     ArgList args;
     Cardinal *num_args;
{
  FigText curft = (FigText) current;
  FigText reqft = (FigText) request;
  FigText newft = (FigText) new;
  
  if (curft->fig_text.label   != newft->fig_text.label)
    {
      XtFree (curft->fig_text.label);
      newft->fig_text.label = XtNewString (newft->fig_text.label);
    }

  if (curft->rect_obj.width   != newft->rect_obj.width  ||
      curft->rect_obj.height  != newft->rect_obj.height ||
      curft->rect_obj.x       != newft->rect_obj.x ||
      curft->rect_obj.y       != newft->rect_obj.y  ||
      curft->fig_text.font    != newft->fig_text.font ||
      curft->fig_text.label   != newft->fig_text.label ||
      curft->fig_text.x1      != newft->fig_text.x1 ||
      curft->fig_text.y1      != newft->fig_text.y1)
    {
      SetGeometory (newft);
      return True;
    }
  else
    return False;
}

static void  Initialize (treq, tnew, args, num_args)
     Widget treq, tnew;
     ArgList args;
     Cardinal *num_args;
{
  FigText reqft = (FigText) treq;
  FigText newft = (FigText) tnew;
  
  newft->fig_text.label = XtNewString (newft->fig_text.label);
  SetGeometory (newft);
}

static void  Destroy (w)
     Widget w;
{
  FigText ft = (FigText) w;
  
  XtFree (ft->fig_text.label);
}

static void  Draw (w, event, region)
     Widget w;
     XEvent *event;
     Region region;
{
  FigText ft = (FigText) w;
  Widget parent;
  Display *dsp;
  Window win;
  GC gc;
  XGCValues value;
  
  parent = ft->object.parent;
  dsp = XtDisplay (parent);
  win = XtWindow (parent);
  gc = XCreateGC (dsp, win, 0, &value); /* get default GC */
  XCopyGC (dsp, ft->fig_object.gc,
	   (1L << (GCLastBit+1)) -1, /* Copy all the contents */
	   gc);
  XSetRegion (dsp, gc, region);
  XSetFont (dsp, gc, ft->fig_text.font->fid);
  
  XDrawImageString (dsp, win, gc,
		    ft->fig_text.x1,
		    ft->fig_text.y1,
		    ft->fig_text.label,
		    ft->fig_text.length
		    );
  
  XFreeGC (dsp, gc);
}
