/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "FigLineP.h"

static XtResource resources[] =
{
#define offset(field) XtOffsetOf (FigLineRec, field)
  /* {name, class, type, size, offset, default_type, default_addr}, */
  {
    XtNx1,  XtCPosition, XtRPosition,
    sizeof(Position), offset(fig_line.x1), XtRImmediate,
    0,
  },
  {
    XtNy1,  XtCPosition, XtRPosition,
    sizeof(Position), offset(fig_line.y1), XtRImmediate,
    0,
  },
  {
    XtNx2,  XtCPosition, XtRPosition,
    sizeof(Position), offset(fig_line.x2), XtRImmediate,
    0,
  },
  {
    XtNy2,  XtCPosition, XtRPosition,
    sizeof(Position), offset(fig_line.y2), XtRImmediate,
    0,
  },
  {
    XtNlineWidth,  XtCThickness, XtRInt,
    sizeof(int), offset(fig_line.line_width), XtRImmediate,
    0,
  },
  {
    XtNcapStyle,  XtCCapStyle, XtRInt,
    sizeof(int), offset(fig_line.cap_style), XtRImmediate,
    (XtPointer)CapButt,
  },
  {
    XtNlineStyle,  XtCLineStyle, XtRInt,
    sizeof(int), offset(fig_line.line_style), XtRImmediate,
    (XtPointer)LineSolid,
  },
  {
    XtNjoinStyle,  XtCJoinStyle, XtRInt,
    sizeof(int), offset(fig_line.join_style), XtRImmediate,
    (XtPointer)JoinRound,
  },
#undef offset
};

static Boolean SetValues ();
static void Initialize ();

static void Draw ();

FigLineClassRec figLineClassRec = {
   {/* object fields */
    /* superclass */ (WidgetClass) &figObjectClassRec,
    /* class name */            "FigLine",
    /* size of widget */        sizeof (FigLineRec),
    /* class_initialize */      NULL,
    /* class_part_initialize */ NULL,
    /* class_inited	*/	FALSE,
    /* initialize	*/	Initialize,
    /* initialize_hook	*/      NULL,
    /* 1 */      NULL,
    /* 2 */      NULL,
    /* 3 */      NULL,
    /* resources */	        resources,
    /* num_resources */	        XtNumber(resources),
    /* xrm_class */	        NULLQUARK,
    /* 4 */     NULL,
    /* 5 */     NULL,
    /* 6 */     NULL,
    /* 7 */     NULL,
    /* destroy		*/      NULL,
    /* resize */                NULL,
    /* expose */                XtInheritExpose,
    /* set_values	 */     SetValues,
    /* set_values_hook	 */	NULL,
    /* set_values_almost */     NULL,
    /* get_values_hook	 */	NULL,
    /* 9 */     NULL,
    /* version		*/	XtVersion,
    /* callback_private	*/	NULL,
    /* 10 */    NULL,
    /* query_geometry */        NULL,
    /* 11 */    NULL,
    /* extension	*/	NULL,
   },
   {/* fig object field */
    /* draw */      Draw,
   },
};

WidgetClass figLineClass = (WidgetClass)&figLineClassRec;

static Boolean
SetValues (current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
{
    FigLine curfl = (FigLine) current;
    FigLine reqfl = (FigLine) request;
    FigLine newfl = (FigLine) new;

    if (
	curfl->rect_obj.x  != newfl->rect_obj.x ||
	curfl->rect_obj.y  != newfl->rect_obj.y  ||
	curfl->fig_line.x1 != newfl->fig_line.x1 ||
	curfl->fig_line.y1 != newfl->fig_line.y1 ||
	curfl->fig_line.x2 != newfl->fig_line.x2 ||
	curfl->fig_line.y2 != newfl->fig_line.y2 ||
	curfl->rect_obj.width   != newfl->rect_obj.width  ||
	curfl->rect_obj.height  != newfl->rect_obj.height)
	{
#define min(x,y) ((x<y)?x:y)
	    newfl->rect_obj.x = min (newfl->fig_line.x1, newfl->fig_line.x2)
		- (newfl->fig_line.line_width + 1) / 2;
	    newfl->rect_obj.y = min (newfl->fig_line.y1, newfl->fig_line.y2)
		- (newfl->fig_line.line_width + 1) / 2;
#undef min(x,y)
	    newfl->rect_obj.width  = abs (newfl->fig_line.x2 -
					  newfl->fig_line.x1)
		+ newfl->fig_line.line_width;
	    newfl->rect_obj.height = abs (newfl->fig_line.y2 -
					  newfl->fig_line.y1)
		+ newfl->fig_line.line_width;
	    if (newfl->rect_obj.width <= 0)
		newfl->rect_obj.width = 1;
	    if (newfl->rect_obj.height <= 0)
		newfl->rect_obj.height= 1;
	}

    if (
	curfl->fig_line.line_width  != newfl->fig_line.line_width ||
	curfl->fig_line.line_style  != newfl->fig_line.line_style ||
	curfl->fig_line.join_style  != newfl->fig_line.join_style
	)
	{
	    XGCValues values;
	    XtGCMask mask = GCForeground | GCLineWidth | GCLineStyle |
		GCCapStyle | GCJoinStyle;

	    XtReleaseGC (curfl->object.parent, curfl->fig_object.gc);

	    values.foreground = newfl->fig_object.foreground;
	    values.line_width = newfl->fig_line.line_width;
	    values.line_style = newfl->fig_line.line_style;
	    values.cap_style = newfl->fig_line.cap_style;
	    values.join_style = newfl->fig_line.join_style;

	    newfl->fig_object.gc = XtGetGC (newfl->object.parent,
					    mask, &values);
	    return True;
	}
    else
	return False;
}

static void
Initialize (treq, tnew, args, num_args)
Widget treq, tnew;
ArgList args;
Cardinal *num_args;
{
    FigLine reqfl = (FigLine) treq;
    FigLine newfl = (FigLine) tnew;
    XGCValues values;
    XtGCMask mask = GCBackground | GCForeground | GCLineWidth | GCLineStyle |
	GCCapStyle | GCJoinStyle;

#define min(x,y) ((x<y)?x:y)
	    newfl->rect_obj.x = min (newfl->fig_line.x1, newfl->fig_line.x2)
		- (newfl->fig_line.line_width + 1) / 2;
	    newfl->rect_obj.y = min (newfl->fig_line.y1, newfl->fig_line.y2)
		- (newfl->fig_line.line_width + 1) / 2;
#undef min(x,y)
	    newfl->rect_obj.width  = abs (newfl->fig_line.x2 -
					  newfl->fig_line.x1)
		+ newfl->fig_line.line_width;
	    newfl->rect_obj.height = abs (newfl->fig_line.y2 -
					  newfl->fig_line.y1)
		+ newfl->fig_line.line_width;
	    if (newfl->rect_obj.width <= 0)
		newfl->rect_obj.width = 1;
	    if (newfl->rect_obj.height <= 0)
		newfl->rect_obj.height= 1;

    XtReleaseGC (newfl->object.parent, newfl->fig_object.gc);
    /* get a GC */

    values.background = newfl->fig_object.background;
    values.foreground = newfl->fig_object.foreground;
    values.line_width = newfl->fig_line.line_width;
    values.line_style = newfl->fig_line.line_style;
    values.cap_style  = newfl->fig_line.cap_style;
    values.join_style = newfl->fig_line.join_style;

    newfl->fig_object.gc = XtGetGC (newfl->object.parent, mask, &values);
}

static void
Draw (w, event, region)
Widget w;
XEvent *event;
Region region;
{
    FigLine fl = (FigLine) w;
    Widget parent;
    Display *dsp;
    Window win;
    GC gc;
    XGCValues value;

    parent = fl->object.parent;
    dsp = XtDisplay (parent);
    win = XtWindow (parent);
    gc = XCreateGC (dsp, win, 0, &value); /* get default GC */
    XCopyGC (dsp, fl->fig_object.gc,
	     (1L << (GCLastBit+1)) -1, /* Copy all the contents */
	     gc);
    XSetRegion (dsp, gc, region);

    XDrawLine (dsp, win,
	       gc,
	       fl->fig_line.x1,
	       fl->fig_line.y1,
	       fl->fig_line.x2,
	       fl->fig_line.y2);

    XFreeGC (dsp, gc);
}
