/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "FigArrowP.h"

static XtResource resources[] =
{
#define offset(field) XtOffsetOf (FigArrowRec, field)
  /* {name, class, type, size, offset, default_type, default_addr}, */
  {
    XtNx1, XtCPosition, XtRPosition,
    sizeof(Position), offset(fig_arrow.x), XtRImmediate,
    0,
  },
  {
    XtNy1, XtCPosition, XtRPosition,
    sizeof(Position), offset(fig_arrow.y), XtRImmediate,
    0,
  },
  {
    XtNlineWidth,  XtCThickness, XtRInt,
    sizeof(int), offset(fig_arrow.line_width), XtRImmediate,
    0,
  },
  {
    XtNlength,  XtCThickness, XtRInt,
    sizeof(int), offset(fig_arrow.length), XtRImmediate,
    0,
  },
#undef offset
};

static Boolean SetValues ();
static void Initialize ();

static void Draw ();

FigArrowClassRec figArrowClassRec = {
  {/* object fields */
    /* superclass */ (WidgetClass) &figObjectClassRec,
                     /* class name */           "FigArrow",
                     /* size of widget */        sizeof (FigArrowRec),
                     /* class_initialize */      NULL,
                     /* class_part_initialize */ NULL,
                     /* class_inited    */       FALSE,
                     /* initialize      */       Initialize,
                     /* initialize_hook */       NULL,
                     /* 1 */      NULL,
                     /* 2 */      NULL,
                     /* 3 */      NULL,
                     /* resources */             resources,
                     /* num_resources */         XtNumber(resources),
                     /* xrm_class */             NULLQUARK,
                     /* 4 */     NULL,
                     /* 5 */     NULL,
                     /* 6 */     NULL,
                     /* 7 */     NULL,
                     /* destroy         */       NULL,
                     /* resize */                NULL,
                     /* expose */                XtInheritExpose,
                     /* set_values       */      SetValues,
                     /* set_values_hook  */      NULL,
                     /* set_values_almost */     NULL,
                     /* get_values_hook  */      NULL,
                     /* 9 */    	         NULL,
                     /* version         */       XtVersion,
                     /* callback_private */      NULL,
                     /* 10 */    NULL,
                     /* query_geometry */        NULL,
                     /* 11 */    NULL,
                     /* extension       */      NULL
                     },
                       {/* fig object field */
                         /* draw */      Draw
                         },
};

WidgetClass figArrowClass = (WidgetClass)&figArrowClassRec;

static Boolean SetValues (current, request, new, args, num_args)
     Widget current, request, new;
     ArgList args;
     Cardinal *num_args;
{
  FigArrow curfa = (FigArrow) current;
  FigArrow reqfa = (FigArrow) request;
  FigArrow newfa = (FigArrow) new;

  if (curfa->rect_obj.x  != newfa->rect_obj.x ||
      curfa->rect_obj.y  != newfa->rect_obj.y  ||
      curfa->fig_arrow.x != newfa->fig_arrow.x ||
      curfa->fig_arrow.y != newfa->fig_arrow.y ||
      curfa->fig_arrow.line_width != newfa->fig_arrow.line_width ||
      curfa->fig_arrow.length != newfa->fig_arrow.length ||
      curfa->rect_obj.width   != newfa->rect_obj.width  ||
      curfa->rect_obj.height  != newfa->rect_obj.height)
    {
      newfa->rect_obj.x = newfa->fig_arrow.x
        - (newfa->fig_arrow.length + 7) / 8
          - (newfa->fig_arrow.line_width + 1) / 2;
      newfa->rect_obj.y = newfa->fig_arrow.y
        - (newfa->fig_arrow.line_width + 1) / 2;
      newfa->rect_obj.width  = ((newfa->fig_arrow.length + 7) / 8 )* 2
        + newfa->fig_arrow.line_width;
      newfa->rect_obj.height = newfa->fig_arrow.length
        + newfa->fig_arrow.line_width;

      if (newfa->rect_obj.width <= 0)
        newfa->rect_obj.width = 1;
      if (newfa->rect_obj.height <= 0)
        newfa->rect_obj.height= 1;
    }

  if (curfa->fig_arrow.line_width != newfa->fig_arrow.line_width)
    {
      XGCValues values;
      XtGCMask mask = GCForeground | GCLineWidth ;

      XtReleaseGC (curfa->object.parent, curfa->fig_object.gc);

      values.foreground = newfa->fig_object.foreground;
      values.line_width = newfa->fig_arrow.line_width;

      newfa->fig_object.gc = XtGetGC (newfa->object.parent,
                                      mask, &values);
      return True;
    }
  else
    return False;
}

static void  Initialize (treq, tnew, args, num_args)
     Widget treq, tnew;
     ArgList args;
     Cardinal *num_args;
{
  FigArrow req = (FigArrow) treq;
  FigArrow new = (FigArrow) tnew;
  XGCValues values;
  XtGCMask mask = GCBackground | GCForeground | GCLineWidth;

  new->rect_obj.x = new->fig_arrow.x
    - (new->fig_arrow.length + 7) / 8
      - (new->fig_arrow.line_width + 1) / 2;
  new->rect_obj.y = new->fig_arrow.y
    - (new->fig_arrow.line_width + 1) / 2;
  new->rect_obj.width  = ((new->fig_arrow.length + 7) / 8 )* 2
    + new->fig_arrow.line_width;
  new->rect_obj.height = new->fig_arrow.length
    + new->fig_arrow.line_width;

  if (new->rect_obj.width <= 0)
    new->rect_obj.width = 1;
  if (new->rect_obj.height <= 0)
    new->rect_obj.height= 1;

  XtReleaseGC (new->object.parent, new->fig_object.gc);
  /* get a GC */

  values.background = new->fig_object.background;
  values.foreground = new->fig_object.foreground;
  values.line_width = new->fig_arrow.line_width;

  new->fig_object.gc = XtGetGC (new->object.parent, mask, &values);
}

static void Draw (w, event, region)
     Widget w;
     XEvent *event;
     Region region;
{
  FigArrow fa = (FigArrow) w;
  Widget parent;
  Display *dsp;
  Window win;
  GC gc;
  XGCValues value;

  parent = fa->object.parent;
  dsp = XtDisplay (parent);
  win = XtWindow (parent);
  gc = XCreateGC (dsp, win, 0, &value); /* get default GC */
  XCopyGC (dsp, fa->fig_object.gc,
           (1L << (GCLastBit+1)) -1, /* Copy all the contents */
           gc);
  XSetRegion (dsp, gc, region);

  XDrawLine (dsp, win, gc,
             fa->fig_arrow.x,
             fa->fig_arrow.y,
             fa->fig_arrow.x - (fa->fig_arrow.length + 7) / 8,
             fa->fig_arrow.y + fa->fig_arrow.length/4);

  XDrawLine (dsp, win, gc,
             fa->fig_arrow.x,
             fa->fig_arrow.y,
             fa->fig_arrow.x + (fa->fig_arrow.length + 7) / 8,
             fa->fig_arrow.y + fa->fig_arrow.length/4);

  XDrawLine (dsp, win, gc,
             fa->fig_arrow.x,
             fa->fig_arrow.y,
             fa->fig_arrow.x,
             fa->fig_arrow.y+ fa->fig_arrow.length);


  XFreeGC (dsp, gc);
}
