/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/CompositeP.h>

#include "FigObjectP.h"
#include "FigP.h"

static void ClassPartInitialize ();
static void Redisplay ();
static void Initialize ();
static Boolean SetValues ();
static void Resize ();
static void Destroy ();
static XtGeometryResult PreferredGeometry ();

static XtGeometryResult GeometryManager ();
static void ChangeManaged ();

#define superclass (&compositeClassRec)

FigClassRec figClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) superclass,
    /* class_name		*/	"Fig",
    /* widget_size		*/	sizeof(FigRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	ClassPartInitialize,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	NULL,
    /* num_resources		*/	0 /* XtNumber(resources)*/,
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_expos	*/	        TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	Resize,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	NULL,
    /* query_geometry		*/	PreferredGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  { /* composit fields */
    /* geometry_manager */  GeometryManager,
    /* change_managed   */  ChangeManaged,
    /* insert_child     */  XtInheritInsertChild,
    /* delete_chile     */  XtInheritDeleteChild,
    /* extension */         NULL,
  },
  { /* fig fields */
    /* empty           */      NULL
  }
};

WidgetClass figWidgetClass = (WidgetClass)&figClassRec;

static
CompositeClassExtensionRec extension_rec = {
/* next extension */ NULL,
/* record_type    */ NULLQUARK,
/* version        */ XtCompositeExtensionVersion,
/* record_size    */ sizeof (CompositeClassExtensionRec),
/* accepts_objects */ True,
};

static void ClassPartInitialize (wc)
WidgetClass wc;
{
    FigWidgetClass fwc = (FigWidgetClass) wc;

    extension_rec.next_extension = fwc->composite_class.extension;
    fwc->composite_class.extension = (XtPointer)&extension_rec;
}


static XtGeometryResult
GeometryManager (w, request, reply)
{
    return XtGeometryYes;
}

static void
ChangeManaged (w)
Widget w;
{
  int i;
  FigWidget fw = (FigWidget)w;
  FigObject fo;
  int max_x = 0, max_y = 0;
  int height, width;

  /* compute the extent of Fig widget */

  for (i = 0; i < fw->composite.num_children; i++)
    {
	fo = (FigObject)((fw->composite.children) [i]);

	if (max_x < fo->rect_obj.x + fo->rect_obj.width)
	    max_x = fo->rect_obj.x + fo->rect_obj.width;

	if (max_y < fo->rect_obj.y + fo->rect_obj.height)
	    max_y = fo->rect_obj.y + fo->rect_obj.height;
    }

  width = max_x + MARGIN_X;
  height =  max_y + MARGIN_Y;

  if (fw->core.width < width)
      fw->core.width = width;

  if (fw->core.height < height)
      fw->core.height = height;

  return;
}

static void Redisplay (w, event, region)
     Widget w;
     XEvent *event;
     Region region;
{
  int i;
  FigWidget fw = (FigWidget)w;
  FigObject fo;

  for (i = 0; i < fw->composite.num_children; i++)
    {
	fo = (FigObject)((fw->composite.children) [i]);
	if (!XtIsManaged ((Widget) fo))
	    continue;

	if (region != NULL)
	    switch (XRectInRegion (region,
				   (int)fo->rect_obj.x,
				   (int)fo->rect_obj.y,
				   (unsigned int)fo->rect_obj.width,
				   (unsigned int)fo->rect_obj.height))
		{
		case RectangleIn:
		case RectanglePart:
		    break;
		default:
		    continue;
		}
	(((FigObjectClass)fo->object.widget_class)->rect_obj_class.expose)
	    ((Widget) fo, event, region);
    }
}

static Boolean SetValues (current, request, new, args, num_args)
     Widget current, request, new;
     ArgList args;
     Cardinal *num_args;
{
  return False; /* resizing widget cause Expose event, so it's not needed */
}

static void Resize (w)
     Widget w;
{
  return;
}

static void Initialize (treq, tnew, args, num_args)
     Widget treq, tnew;
     ArgList args;
     Cardinal *num_args;
{
  FigWidget new = (FigWidget)tnew;
  Display *dsp = XtDisplay (tnew);

  new->fig.cur_x = 0;
  new->fig.cur_y = 0;
  return;
}

static XtGeometryResult PreferredGeometry(w, constraints, reply)
    Widget w;
    XtWidgetGeometry *constraints, *reply;
{
  *reply = *constraints;

  return XtGeometryYes;
}

static void Destroy (w)
     Widget w;
{
#if 0
    fprintf (stderr, "Fig destroy!");
#else
    ;
#endif
}
