#include "module.h"

#include <X11/Shell.h>
#include <X11/Vendor.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>

#ifdef XI18N
#include <X11/Xaw/Xawi18n.h>
#endif /* XI18N */

static Widget searchShell = 0;
static int current = -1;

typedef struct _ObjTbl {
    int  widx;
    unsigned char *name;
} ObjTbl;

ObjTbl *objtbl;

static void
Close()
{
    extern Widget search_toggle;

    if (current >= 0)
	InvertObject(wlist[current], False);
    XtVaSetValues(search_toggle, XtNstate, False, NULL);
    XtPopdown(searchShell);
}

static
makeCommandBox(parent)
Widget parent;
{
    Widget close;

    close = XtVaCreateManagedWidget("close", commandWidgetClass, parent, 
				    NULL);
    XtAddCallback(close, XtNcallback, Close, (caddr_t)0);
}

static
compare(s1, s2)
ObjTbl *s1, *s2;
{
    return(strcmp(s1->name, s2->name));
}

static void
SelectObject(w, unused_1, unused_2)
Widget w;
caddr_t unused_1;
caddr_t unused_2;
{
    XawListReturnStruct *list_return;

    if (current >= 0) 
	InvertObject(wlist[current], False);

    list_return = XawListShowCurrent(w);
    current = objtbl[list_return->list_index].widx;
    InvertObject(wlist[current], True);
}

static
makeList(parent)
Widget parent;
{
    Widget list;
    int i, n_obj = n_node-1;	/* TOP ʬ */
    unsigned char **objlist;

    objtbl = (ObjTbl *) XtMalloc (sizeof(ObjTbl) * n_obj);
    for (i = 0; i < n_obj; i++) {
	objtbl[i].widx = i+1;	/* TOP ʤʬ­ */
	objtbl[i].name = NODENAME(node[i+1]);
    }
    qsort((char *)objtbl, n_obj, sizeof(ObjTbl), compare);

    objlist = (unsigned char **) XtMalloc(sizeof(char *) * n_obj);
    for (i = 0; i < n_obj; i++) {
	objlist[i] = objtbl[i].name;
    }

    list = XtVaCreateManagedWidget("searchList", listWidgetClass, parent, 
				   XtNlist, objlist,
				   XtNnumberStrings, n_obj,
				   NULL);
    XtAddCallback(list, XtNcallback, SelectObject, NULL);
}

static Widget
createSearchShell(parent)
Widget parent;
{
    Widget shell, pane, form, box, view, list;

    shell = XtVaCreatePopupShell("Search",
				 vendorShellWidgetClass,
				 parent,
				 XtNallowShellResize, True,
				 NULL);
    pane = XtVaCreateManagedWidget("pane", panedWidgetClass, shell, 
				    NULL);

    box = XtVaCreateManagedWidget("commandbox", boxWidgetClass, pane,
				  XtNorientation, XtorientHorizontal,
				  NULL);
    makeCommandBox(box);

    form = XtCreateManagedWidget("form", formWidgetClass, pane,
				 NULL, 0);

    view = XtVaCreateManagedWidget("view", viewportWidgetClass, form, 
				   XtNallowVert, TRUE,
				   XtNallowHoriz, TRUE,
				   NULL);
    makeList(view);
    return(shell);
}

void
SearchObject(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
    Boolean toggle_on;

    XtVaGetValues(w, XtNstate, &toggle_on, NULL);
    if (toggle_on) {
	if (searchShell == 0)
	    searchShell = (Widget)createSearchShell(toplevel);
	XtPopup(searchShell, XtGrabNone);
    } else
	XtPopdown(searchShell);
}

InvertObject(w, invert)
Widget w;
Boolean invert;
{
    static Pixel fore = 0, back = 0;
    Position x, y;

    if (fore == 0 && back == 0) 
	XtVaGetValues(w, XtNforeground, &fore, XtNbackground, &back, NULL);

    if (invert)
	XtVaSetValues(w, XtNforeground, back, XtNbackground, fore, NULL);
    else
	XtVaSetValues(w, XtNforeground, fore, XtNbackground, back, NULL);

    XtVaGetValues(w, XtNx, &x, XtNy, &y, NULL);
    MoveModule(x-50, y-50);
}
