#include "module.h"

#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>	

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>

#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/SmeBSB.h>

#ifdef XI18N
#include <X11/Xaw/Xawi18n.h>
#endif /* XI18N */
#include "Module.h"

static int wrap, maxlen;

static XtResource my_resources[] = {
    {"wrapCount", "WrapCount", XtRInt, sizeof(int),
	 (Cardinal) &wrap, XtRImmediate, (XtPointer)10},
    {"maxLength", "MaxLength", XtRInt, sizeof(int),
	 (Cardinal) &maxlen, XtRImmediate, (XtPointer)0},
};

static void 	PannerCallback(),
    		PortholeCallback();
static 	makeCommandBox(), 
    	makeModule(), 
    	createMenu();
static Widget menu_item[2], module, panner, porthole;

WidgetList wlist;
Widget search_toggle;

/*
 * GetAppResources
 * 	ץꥱΥ꥽
 */
GetAppResources()
{
    XtGetApplicationResources(toplevel, (caddr_t) NULL,	my_resources,
			      XtNumber(my_resources), NULL, 0);
}

/*
 * CreateWidgets
 *	ᥤΥɥ
 */
CreateWidgets()
{
    Widget vPane, hPane, box;

    vPane = XtCreateManagedWidget("vPane", panedWidgetClass, toplevel, 
				 NULL, 0);

    hPane = XtVaCreateManagedWidget("hPane", panedWidgetClass, vPane, NULL);

    panner = XtVaCreateManagedWidget("panner", pannerWidgetClass, hPane, NULL);

    box = XtVaCreateManagedWidget("box", boxWidgetClass, hPane, NULL);
    makeCommandBox(box);

    porthole = XtVaCreateManagedWidget("porthole", portholeWidgetClass,
				       vPane, NULL);
    /*
     * Allow the panner and porthole to talk to each other.
     */
    XtAddCallback(porthole, 
		  XtNreportCallback, PortholeCallback, (XtPointer) panner);
    XtAddCallback(panner, 
		  XtNreportCallback, PannerCallback, (XtPointer) porthole);

    module = XtVaCreateManagedWidget("module", QxtmoduleWidgetClass, 
				      porthole,
				      XtNgravity, WestGravity,
				      NULL);

    makeModule(module);

    createMenu();
}

static void
Quit()
{
    exit(0);
}

static 
makeCommandBox(parent)
Widget parent;
{
    Widget quit;
    extern void SearchObject();

    quit = XtVaCreateManagedWidget("quit", commandWidgetClass, parent, 
				   NULL);
    XtAddCallback(quit, XtNcallback, Quit, (caddr_t)0);

    search_toggle = XtVaCreateManagedWidget("search", toggleWidgetClass, 
					    parent, NULL);
    XtAddCallback(search_toggle, XtNcallback, SearchObject, (caddr_t)0);
}

static char *
formatString(str)
char *str;
{
    static char buf[BUFSIZ];
    int n = 0, len = strlen(str), wl, i;
    Boolean kanji1;

    /* check length */
    if (maxlen > 0 && len > maxlen) {
	for (i = 0, kanji1 = False; i < maxlen; i++) {
	    if (kanji1 == True)
		kanji1 = False;
	    else if (str[i]&0x80)
		kanji1 = True;
	}
	if (kanji1)
	    i++;
	len =i;
    }

    /* check wrap */
    if (wrap == 0)
	(void)strcpy(buf, str);
    else {
	buf[0] = '\0';
	wl = wrap;
	while (1) {
	    if (n+wl < len) {
		for (i = 0, kanji1 = False; i < wl; i++) {
		    if (kanji1 == True)
			kanji1 = False;
		    else if (str[n+i]&0x80) 
			kanji1 = True;
		}
	    }
	    if (kanji1)
		wl++;
	    (void)strncat(buf, &str[n], MIN(len,wl));
	    if ((n+=wl) >= len)
		break;
	    (void)strcat(buf, "\n");
	}
    }
    return(buf);
}


#define TRANS_STR "<Btn1Down>: popup-menu(RuleMenu,"
static void popupMenu();

static
makeModule(lw)
Widget lw;
{
    register int i, j;

    /* menu popup action */
    static XtActionsRec menu_actiontable[] = {
	{"popup-menu", popupMenu},
    };

    XtTranslations menuTrans;
    XtAppAddActions(appContext, menu_actiontable, XtNumber(menu_actiontable));

    XawSimpleMenuAddGlobalActions(appContext);
    XtRegisterGrabAction (popupMenu, True,
			  (ButtonPressMask|ButtonReleaseMask),
			  GrabModeAsync, GrabModeAsync);

    wlist = (WidgetList)XtMalloc(sizeof(Widget)*n_node);
    for (i = 0; i < n_node; i++) {
	char tstr[512];

	wlist[i] = XtVaCreateWidget("node", commandWidgetClass, lw, 
			    XtNlabel, formatString(NODENAME(node[i])),
			    NULL);

	sprintf(tstr, "%s%d)", TRANS_STR, i);
	XtOverrideTranslations(wlist[i], XtParseTranslationTable(tstr));
    }

    for (i = 0; i < n_node; i++) {
	WidgetList wl;

	if (node[i]->n_parents == 0)
	    continue;
	wl = (WidgetList)XtMalloc(sizeof(Widget)*node[i]->n_parents);
	for (j = 0; j < node[i]->n_parents; j++) {
	    wl[j] = wlist[node[i]->parents[j]];
	}
	XtVaSetValues(wlist[i], XtNparents, wl, 
		      XtNnumParents, node[i]->n_parents, NULL);
    }
    /* don't  manage top */
    XtManageChildren(&wlist[1], n_node-1);
}

/*
 * rule menu
 */
int cur_node;

char *menu_label[] = {
    "user's rules", 
    "normalized rules",
};
    
static 
createMenu()
{
    Widget shell;
    register int i;
    extern void ShowRule();

    shell = XtVaCreatePopupShell("RuleMenu", 	
				 simpleMenuWidgetClass, 
				 toplevel, 
#ifdef XI18N
				 XtNlabelClass, smeBSBLocaleObjectClass,
#endif
				 NULL);

    (void)XtCreateManagedWidget("line", smeLineObjectClass, shell, NULL, 0);

    for (i = 0; i < 2; i++) {
	menu_item[i] = XtVaCreateManagedWidget("menu_item",
					       smeBSBObjectClass,
					       shell, 
					       XtNlabel, menu_label[i],
					       NULL);
	XtAddCallback(menu_item[i], XtNcallback, ShowRule, (XtPointer)i);
    }
}

static void
popupMenu(w, event, params, param_count)
Widget w;
XEvent *event;
String *params;
Cardinal *param_count;
{
    Node *p;

    cur_node = atoi(params[1]);
    p = node[cur_node];

    /* set menu item sensitivity */
    XtVaSetValues(menu_item[0], 
		  XtNsensitive, (p->uRuleCnt > 0) ? True : False, NULL);
    XtVaSetValues(menu_item[1], 
		  XtNsensitive, (p->nRuleCnt > 0) ? True : False, NULL);

    XtCallActionProc (w, "XawPositionSimpleMenu", event, params, 1);
    XtCallActionProc (w, "MenuPopup", event, params, 1);
}

static void 
PannerCallback(w, closure, report_ptr)
Widget w;
XtPointer closure, report_ptr;
{
    XawPannerReport *report = (XawPannerReport *) report_ptr;

    XtVaSetValues(module, XtNx, -report->slider_x,
		  XtNy, -report->slider_y, NULL);
}

static void 
PortholeCallback(w, panner_ptr, report_ptr)
Widget w;
XtPointer panner_ptr, report_ptr;
{
    Arg args[10];
    Cardinal n = 0;
    XawPannerReport *report = (XawPannerReport *) report_ptr;
    Widget panner = (Widget) panner_ptr;

    XtSetArg (args[n], XtNsliderX, report->slider_x); n++;
    XtSetArg (args[n], XtNsliderY, report->slider_y); n++;
    if (report->changed != (XawPRSliderX | XawPRSliderY)) {
	XtSetArg (args[n], XtNsliderWidth, report->slider_width); n++;
	XtSetArg (args[n], XtNsliderHeight, report->slider_height); n++;
	XtSetArg (args[n], XtNcanvasWidth, report->canvas_width); n++;
	XtSetArg (args[n], XtNcanvasHeight, report->canvas_height); n++;
    }
    XtSetValues (panner, args, n);
}

MoveModule(x, y)
{
    XtVaSetValues(panner, XtNsliderX, x, XtNsliderY, y, NULL); 
    XtVaSetValues(module, XtNx, -x, XtNy, -y, NULL);
}
