%{
#include <stdio.h>
#define YYSTYPE	unsigned int
int mid_flg = 1;	/* flag for module_id */
static int start = -1;	/* rule start index */
static int cnt = 0;	/* rule counter */
static int u_id;	/* user's rule start index */
static int u_cnt;	/* user's rule count */
static int n_id;	/* normalized rule start index */
static int n_cnt;	/* normalized rule count */
%}
%token STRING VOID
%token LPAR RPAR 
%token LCBRA RCBRA 
%token LSBRA RSBRA 
%token COMMA 
%%
s		: list
		;
list		: LCBRA ModuleHierarchy COMMA ModuleRules RCBRA
    		;
ModuleHierarchy	: LSBRA hierarchy_list RSBRA
		;
hierarchy_list	: /* empty */
    		| mid_pair_list
		;
mid_pair_list	: mid_pair
		| mid_pair_list COMMA mid_pair
		;
mid_pair	: LCBRA h_mid COMMA h_mid RCBRA
		{
		    if ((int)$2 >= 0 && (int)$4 >= 0) {
			AddChildren($2, $4);
			AddParents($4, $2);
		    }
		}
		;
ModuleRules	: LSBRA rule_contents RSBRA
		;
rule_contents	: /* empty */
    		| mod_rule_list
		;
mod_rule_list	: module_rule
		| mod_rule_list COMMA module_rule
		;
module_rule	: LCBRA r_mid COMMA user_rules COMMA normal_rules RCBRA
		{
		    SetRule($2, u_id, u_cnt, n_id, n_cnt);
		    mid_flg = 1;
		}
		;
user_rules	: rules			
		{ 
		    u_id = start; 
		    u_cnt = cnt; 
		}
		;
normal_rules	: rules			
		{ 
		    n_id = start; 
		    n_cnt = cnt; 
		}
		;
rules		: LSBRA RuleList RSBRA	
		;
RuleList	: /* empty */		{ cnt = 0; }
		| rule_list
    		;
rule_list	: rule			{ start = $1; cnt = 1; }
		| rule_list COMMA rule	{ cnt++; }
		;
h_mid		: /* empty */		{ $$ = -1; }
    		| VOID			{ $$ = -1; }
    		| STRING 		{ $$ = $1; }
		;
r_mid		: STRING		
		{
		    $$ = $1; 
		    mid_flg = 0;
		}
		;
rule		: STRING		{ $$ = $1; }
		;
%%
yyerror(s)
char *s;
{
    extern char yytext[];

    fprintf(stderr, "syntax error...%s\n", yytext);
    exit(-2);
}
