#include <stdio.h>
#include "module.h"

#define MAXNODE		500
#define NAMESIZE	2000

Node *node[MAXNODE];
int n_node = 0;

unsigned char **name;
int  n_name;
int  max_name;

unsigned char **rule;
int n_rule = 0;
int max_rule = 0;

extern int yynerrs;
#ifdef YYDEBUG
extern int yydebug;
#endif

#ifdef DEBUG
extern FILE *dbgfp;
#endif

InitNodeList()
{
    int i, tidx;
    Node *p;

    /* create TOP */
    tidx = NewNode("TOP", 0);

    /* 
     * ɸϤǡɤ߹ lex, yacc ǲϤ
     * ΡɥꥹȤ
     */
#ifdef DEBUG
    fprintf(dbgfp, "start: parse data\n");
    fflush(dbgfp);
#endif
    if (yyparse() || yynerrs)
	fatal("parser error");
#ifdef DEBUG
    fprintf(dbgfp, "end: parse data\n");
    fflush(dbgfp);
#endif
    if (n_node == 1)	/* ɸϤΥǡʤ */
	fatal("no data.");

    /* 
     * TOP ʳΥΡɤåƤΤʤΡɤ TOP λҶˤ롣
     */
    for (i = 1; i < n_node; i++) {
	if (node[i]->n_parents == 0) {
	    AddParents(i, tidx);
	    AddChildren(tidx, i);
	}
    }
}

/*
 * NewNode 
 * 	Ρɤκ
 */
NewNode(s, check)
unsigned char *s;
Boolean check;
{
    register int i;
    Node *p;
    int idx;

#ifdef DEBUG
    fprintf(dbgfp, "<%s>\n", s);
#endif    
    /* s ϿѤߤɤå */
    if (check) {
	for (i = 0; i < n_node; i++) {
	    if (!strcmp(s, NODENAME(node[i])))
		return(i);
	}
    }
    /*
     * ޤϿƤʤΤǿΡɤȤϿ
     */
    /* ߤΥΡɿä */
    if (n_node >= MAXNODE)
	fatal("node name table overflow");

    /* ꥢݤ */
    idx = n_node;
    p = node[idx] = (Node *)malloc(sizeof(Node));
    p->nameID = pool(s);
    p->parents = p->children = NULL;
    p->n_parents = p->max_parents = 0;
    p->n_children = p->max_children = 0;
    p->uRuleId = p->uRuleCnt = 0;
    p->nRuleId = p->nRuleCnt = 0;
    n_node++;
    
    return(idx);
}

/* 
 * AddParents
 *	n ֤ΥΡɤ sidx ֤ΥΡɤοƥꥹȤɲä
 */
AddParents(sidx, n)
{
    Node *p = node[sidx];
    int pidx = p->n_parents;

    if (p->n_parents == p->max_parents) {
	p->max_parents += (p->max_parents / 2) + 2;
	p->parents = (int *) XtRealloc (p->parents,
					(p->max_parents * sizeof(int)));
    } 
    p->parents[pidx] = n;
    p->n_parents++;
}

/* 
 * AddChildren
 *	n ֤ΥΡɤ sidx ֤ΥΡɤλҶꥹȤɲä
 */
AddChildren(sidx, n)
{
    Node *p = node[sidx];
    int pidx = p->n_children;

    if (p->n_children == p->max_children) {
	p->max_children += (p->max_children / 2) + 2;
	p->children = (int *) XtRealloc (p->children,
					 (p->max_children * sizeof(int)));
    } 
    p->children[pidx] = n;
    p->n_children++;
}

/*
 * pool 
 * 	s ХåեκǸƳϰ֤֤
 */
pool(s)
unsigned char *s;
{
    int ret;
    unsigned char *p;

    ret = n_name;
    p = (unsigned char *)malloc(strlen(s)+1);
    strcpy(p, s);
    if (n_name == max_name) {
	max_name += (max_name / 2) + 2;
	name = (unsigned char **)XtRealloc(name, 
				   max_name * sizeof(unsigned char *));
    }
    name[n_name++] = p;
    return(ret);
}

/*
 * NewRule 
 * 	롼Ͽ
 */
NewRule(s)
unsigned char *s;
{
    int index = n_rule;
    unsigned char *p = (unsigned char *)malloc(strlen(s)+1);

    strcpy(p, s);

    if (n_rule == max_rule) {
	max_rule += (max_rule / 2) + 2;
	rule = (unsigned char **)XtRealloc(rule, 
					   max_rule * sizeof(unsigned char *));
    }
    rule[n_rule++] = p;
    return(index);
}

SetRule(n, uidx, ucnt, nidx, ncnt)
{
    Node *p;

    if (n >= n_node)
	return(-1);
    p = node[n];
    p->uRuleId = uidx;
    p->uRuleCnt = ucnt;
    p->nRuleId = nidx;
    p->nRuleCnt = ncnt;
}
