#include <stdio.h>
#include "lattice.h"

#define MAXNODE		500
#define NAMESIZE	2000

Node *node[MAXNODE];
int n_node = 0;

unsigned char **name;
int  n_name;
int  max_name;

extern int yynerrs;
#ifdef YYDEBUG
extern int yydebug;
#endif

#ifdef DEBUG
extern FILE *dbgfp;
#endif

static 
compare(m, n)
int *m, *n;
{
    return(*m > *n);
}

/*
 * InitNodeList
 *	ɸϤǡɤ߹ǡΡɤΥꥹȤ
 *	롣BOTTOM Ǻ롣
 */
InitNodeList()
{
    int i, tidx, bidx;
    Node *p;

    /* TOP  */
    tidx = NewNode(pool("'&top'"), 0);

    /* 
     * ɸϤǡɤ߹ lex, yacc ǲϤ
     * ΡɥꥹȤ
     */
#ifdef DEBUG
    fprintf(dbgfp, "start: parse data\n");
    fflush(dbgfp);
#endif
    if (yyparse() || yynerrs)
	fatal("parser error");
#ifdef DEBUG
    fprintf(dbgfp, "end: parse data\n");
    fflush(dbgfp);
#endif
    if (n_node == 1)	/* ɸϤΥǡʤ */
	fatal("no data.");

    /* BOTTOM */
    bidx = NewNode(pool("'&bottom'"), 0);

    /* 
     * TOP, BOTTOM ʳΥΡɤåҶΤʤΡɤ 
     * BOTTOM Ҷˤ롣
     */
    for (i = 1; i < bidx; i++) {
	p = node[i];
#ifdef OLD
	if (p->n_parents == 0) {
	    /* TOP 򤽤ΥΡɤοƤˤ */
	    AddParents(i, tidx);
	    /* TOP λҶˤΥΡɤɲä */
	    AddChildren(tidx, i);
	}
#endif
	if (p->n_children == 0) {
	    /* BOTTOM 򤽤ΥΡɤλҶˤ */
	    AddChildren(i, bidx);
	    /* BOTTOM οƤˤΥΡɤɲä */
	    AddParents(bidx, i);
	}
    }
}


/*
 * NewNode 
 * 	Ρɤκ
 */
NewNode(nameid, check)
int nameid;
Boolean check;
{
    register int i;
    Node *p;
    int idx;

#ifdef DEBUG
    fprintf(dbgfp, "<%s>\n", name[nameid]);
#endif    
    /* ϿѤߤɤå */
    if (check) {
	for (i = 0; i < n_node; i++) {
	    if (nameid == node[i]->nameID)
		return(i);
	}
    }
    /*
     * ޤϿƤʤΤǿΡɤȤϿ
     */
    /* ߤΥΡɿå */
    if (n_node >= MAXNODE)
	fatal("node name table overflow");

    /* ꥢݤ */
    idx = n_node;
    p = node[idx] = (Node *)malloc(sizeof(Node));
    p->nameID = nameid;
    p->parents = p->children = NULL;
    p->n_parents = p->max_parents = 0;
    p->n_children = p->max_children = 0;
    n_node++;
    
    return(idx);
}

/* 
 * AddParents
 *	n ֤ΥΡɤ sidx ֤ΥΡɤοƥꥹȤɲä
 */
AddParents(sidx, n)
{
    Node *p = node[sidx];
    int pidx = p->n_parents;

    if (p->n_parents == p->max_parents) {
	p->max_parents += (p->max_parents / 2) + 2;
	p->parents = (int *) XtRealloc (p->parents,
					(p->max_parents * sizeof(int)));
    } 
    p->parents[pidx] = n;
    p->n_parents++;
}

/* 
 * AddChildren
 *	n ֤ΥΡɤ sidx ֤ΥΡɤλҶꥹȤɲä
 */
AddChildren(sidx, n)
{
    Node *p = node[sidx];
    int pidx = p->n_children;

    if (p->n_children == p->max_children) {
	p->max_children += (p->max_children / 2) + 2;
	p->children = (int *) XtRealloc (p->children,
					 (p->max_children * sizeof(int)));
    } 
    p->children[pidx] = n;
    p->n_children++;
}

/*
 * pool 
 *	s ϿѤߤǤʤä顢name ɲä롣
 */
pool(s)
unsigned char *s;
{
    int i, ret;
    unsigned char *p;

    for (i = 0; i < n_name; i++) {
	if (!strcmp(s, name[i]))
	    return(i);
    }

    ret = n_name;
    p = (unsigned char *)malloc(strlen(s)+1);
    strcpy(p, s);
    if (n_name == max_name) {
	max_name += (max_name / 2) + 2;
	name = (unsigned char **)XtRealloc(name, 
				   max_name * sizeof(unsigned char *));
    }
    name[n_name++] = p;
    return(ret);
}
