%{
#include <stdio.h>
#define YYSTYPE	unsigned int
static int c_id = -1, p_id = -1;
%}
%token ATOM
%token LPAR RPAR 
%token LCBRA RCBRA 
%token LSBRA RSBRA 
%token COMMA 
%%
s		: list
    		;
list		: LSBRA subsum_list RSBRA
		;
subsum_list	: subsum
		| subsum_list COMMA subsum
		;
subsum		: LCBRA child COMMA parent_list RCBRA
		;
parent_list	: LSBRA parents RSBRA
		;
parents		: parent 
    		| parents COMMA parent
    		;
child		: ATOM
		{
		    c_id = NewNode($1, 1);
		}
		;
parent		: ATOM
		{
		    p_id = NewNode($1, 1);

		    AddChildren(p_id, c_id);
		    AddParents(c_id, p_id);
		}
		;
%%
yyerror(s)
char *s;
{
    extern char yytext[];

    fprintf(stderr, "syntax error...%s\n", yytext);
    exit(-2);
}

