/* Copyright	Massachusetts Institute of Technology	1987, 1988
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef _Lattice_h
#define _Lattice_h

#include <X11/Xmu/Converters.h>
#include <X11/Xfuncproto.h>

/****************************************************************
 *
 * Lattice widget
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

 

*/

/* define any special resource names here that are not in <X11/StringDefs.h> */

#define XtNhPad		"hPad"
#define XtNvPad		"vPad"
#define XtCHPad		"HPad"
#define XtCVPad		"VPad"

#define XtNlineWidth 		"lineWidth"
#define XtNlineColor 		"lineColor"
#define XtNlatticeGC 		"latticeGC"
#define XtNparents		"parents"
#define XtNnumParents		"numParents"
#define XtNgravity 		"gravity"

#define XtCLineWidth 		"LineWidth"
#define XtCLineColor 		"LineColor"
#define XtCLatticeGC 		"LatticeGC"
#define XtCParents		"Parents"
#define XtCNumParents		"NumParents"
#define XtCGravity 		"Gravity"

#define XtRGC "GC"

/* declare specific LatticeWidget class and instance datatypes */

typedef struct _QxtLatticeClassRec*	QxtLatticeWidgetClass;
typedef struct _QxtLatticeRec*		QxtLatticeWidget;

/* declare the class constant */
extern WidgetClass QxtlatticeWidgetClass;

#endif /* _Lattice_h */
