#include <stdio.h>
#include "term.h"

#define True	1
#define False	0
#define MAXBUF	(8 * 1024)
#define MAXLINE	(64)

Term *input_term;
List *element;
static char text_buf[MAXBUF];
static char *bufp, *top;

static int print_dot1(list)
    List *list;
{
    if (list->head->id == is_string) {
	sprintf(bufp, " %s", list->head->string.string);
	bufp += strlen(bufp);
    } else
	return False;
    list = list->tail;
    while (list != NIL) {
	if (list->head->id == is_string) {
	    if ((bufp - top) < MAXLINE)  {
		sprintf(bufp, "%s ", list->head->string.string);
		bufp += strlen(bufp);
	    } else {
		sprintf(bufp, "\n   %s", list->head->string.string);
		top = bufp + 1;
		bufp += strlen(bufp);
	    }
	} else
	    return False;
	list = list->tail;
    }
    return True;
}

static int print_dot2(list)
    List *list;
{
    if (list->head->id == is_string) {
	sprintf(bufp, " %s", list->head->string.string);
	bufp += strlen(bufp);
    } else
	return False;
    list = list->tail;
    while (list != NIL) {
	if (list->head->id == is_string) {
	    if ((bufp - top) < MAXLINE)  {
		sprintf(bufp, " %s", list->head->string.string);
		bufp += strlen(bufp);
	    } else {
		sprintf(bufp, "\n   %s", list->head->string.string);
		top = bufp + 1;
		bufp += strlen(bufp);
	    }
	} else
	    return False;
	list = list->tail;
    }
    return True;
}

static int print_var1(list)
    List *list;
{
    while (list != NIL) {
	if (list->head->id == is_string) {
	    if ((bufp - top) < MAXLINE)  {
		sprintf(bufp, "%s ", list->head->string.string);
		bufp += strlen(bufp);
	    } else {
		sprintf(bufp, "\n%s", list->head->string.string);
		top = bufp + 1;
		bufp += strlen(bufp);
	    }
	} else
	    return False;
	list = list->tail;
    }	
    return True;
}

static int print_var2(list)
    List *list;
{
    if (list->head->id == is_string) {
	sprintf(bufp, " %s", list->head->string.string);
	bufp += strlen(bufp);
    } else
	return False;
    list = list->tail;
    while (list != NIL) {
	if (list->head->id == is_string) {
	    if ((bufp - top) < MAXLINE)  {
		sprintf(bufp, " %s", list->head->string.string);
		bufp += strlen(bufp);
	    } else {
		sprintf(bufp, "\n     %s", list->head->string.string);
		top = bufp + 1;
		bufp += strlen(bufp);
	    }
	} else
	    return False;
	list = list->tail;
    }
    return True;
}

static int print_answer(dot, var)
    List *dot, *var;
{
    if (dot->head == NIL) {
	if (var->head == NIL) {
	    sprintf(bufp, "YES\n");
	    bufp += strlen(bufp);
	} else {
	    if (print_var1(var) == False)
		return False;
	    sprintf(bufp, "\n");
	    bufp += strlen(bufp);
	}
    } else {
	if (var->head == NIL) {
	    sprintf(bufp, "IF");
	    bufp += strlen(bufp);
	    if (print_dot1(dot) == False)
		return False;
	    if (top != text_buf)
		sprintf(bufp, "\nTHEN YES\n");
	    else
		sprintf(bufp, " THEN YES\n");
	    bufp += strlen(bufp);
	} else {
	    sprintf(bufp, "IF");
	    bufp += strlen(bufp);
	    if (print_dot2(dot) == False)
		return False;
	    sprintf(bufp, "\nTHEN");
	    top = bufp + 1;
	    bufp += strlen(bufp);
	    if (print_var2(var) == False)
		return False;
	}
    }
    return True;
}

int answer_element(buf, addr)
    char **buf, **addr;
{
    Term *ptr, *term;
    static char answer_element[] = "answer_element";

    bufp = top = text_buf;
    if (element == NIL)
	return False;
    if (element->head == NIL) {
	sprintf(bufp, "NO\n");
	element = NIL;
	*buf = text_buf;
	*addr = NULL;
	return True;
    }
    term = element->head;
    if (term->id != is_vector)
	return False;
    if (term->vector.size != 4)
	return False;
    ptr = term->vector.element;
    if (ptr[0].id != is_atom)
	return False;
    if (strncmp(ptr[0].atom.string, answer_element,
		sizeof(answer_element))	!= 0)
	return False;
    if (ptr[1].id != is_list)
	return False;
    if (ptr[2].id != is_list)
	return False;
    if (print_answer(&(ptr[1]), &(ptr[2])) == False)
	return False;
    element = element->tail;
    *buf = text_buf;
    *addr = (char *)&(ptr[3]);
    return True;
}

static int answer(term)
    Term *term;
{
    Term *ptr;
    static char answer[] = "answer";

    bufp = top = text_buf;
    if (term->id != is_vector)
	return False;
    if (term->vector.size != 2)
	return False;
    ptr = term->vector.element;
    if (ptr[0].id != is_atom)
	return False;
    if (strncmp(ptr[0].atom.string, answer, sizeof(answer)) != 0)
	return False;
    if (ptr[1].id != is_list)
	return False;
    element = (List *)&(ptr[1]);
    return True;
}

int parse()
{
    if (yyparse() == 0) {
	return answer(input_term);
    }
    return False;
}
