/*
  Function:
    input KL1 term and built up C object using term.h interface

  History:
  (01) 92.10.6  by T.A. created for term parser  
  (02) 92.12.18 by T.A. add [] and {}
  (03) 92.12.25 by T.A. add Quote_Atom(Arg)
*/

%{
#include <stdio.h>
#include "term.h"
extern Term *input_term;
extern char yytext[];
%}
%union {
  Term *y_term;
  List *y_list;
  Vector *y_vector;
  Integer *y_integer;
  String *y_string;
  Atom *y_atom;
  Qatom *y_qatom;
  Variable *y_variable;
}

%type <y_term>   start term vector predicate
%type <y_term>  list list_element
%type <y_term>   vector_element  argument
%token <y_term>  INTEGER STRING ATOM QATOM VARIABLE
%token <y_term> LPAR RPAR LCBRA RCBRA LSBRA RSBRA COMMA 
%%
 start: term { input_term = $1;}

 term: list  | vector  | predicate
  | INTEGER  | STRING  | ATOM  | QATOM  | VARIABLE

 list: LSBRA  RSBRA  {$$ = (Term *)new_list(NIL);}
 list: LSBRA  list_element RSBRA  {$$ = $2;}

 list_element: 
  term                    { $$ = (Term *)new_list($1);}
| list_element COMMA term { $$ = (Term *)append_list($1, new_list($3));}

 vector: LCBRA  RCBRA
                          { $$ = (Term *)new_vector(0);}
 vector: LCBRA vector_element RCBRA
                          { $$ = (Term *)list_to_vector($2);}
 vector_element: 
  term                      { $$ = (Term *)new_list($1);}
| vector_element COMMA term { $$ = (Term *)append_list($1, new_list($3));}

 predicate: QATOM LPAR argument RPAR
  { $$ = (Term *)list_to_vector(append_list(new_list($1), $3));}

 predicate: ATOM LPAR argument RPAR
  { $$ = (Term *)list_to_vector(append_list(new_list($1), $3));}

 argument: term           { $$ = (Term *)new_list($1);}
  | argument COMMA term   { $$ = (Term *)append_list($1, new_list($3));}

%%
yyerror(str)
char *str;
{
  fprintf(stderr, "syntax error\n %s\n", yytext);
  exit(-2);
}

yywrap()
{
  return(1);
}

