#include <stdio.h>
#include "qxt.h"
#include "dotsrc.h"

extern PseudoObject *parse();

char *progname;
char *dbname;

static PseudoObject *o;

qxt_output (s)
  char *s;
{
  fprintf (netout, "%s", s);
}

main (argc, argv)
     int argc;
     char *argv[];
{
  char *line;
  char **contents;
  char **p;
  int length;
  char *d;

  init_qio ();

  if (argc > 3 || argc < 2)
    {
      fprintf (stderr, "USAGE: create-database NAME [FILE]\n");
      exit (0);
    }

  progname = argv[0];
  dbname = argv[1];

  if (argc == 3)
    freopen (argv[2], "r", stdin);

  contents = read_filecontents (stdin);
  length = 0;
  for (p = contents; *p; p++)
    length += strlen (*p) + 1;
  d = xmalloc (length +1);
  d[0] = 0;
  for (p = contents; *p; p++)
    {
      strcat (d, *p);
      strcat (d, "\n");
    }

  init_input_from_string (d);

  o = parse ();
  free (d);

  if (o == NULL)
    exit (0);

  if (use_timer)
    fprintf (netout, "CMD T\n");
  else
    fprintf (netout, "CMD\n");
  fflush (netout);
  check_result ("CMD failed\n");

  fprintf (netout, "create_database(%s,", dbname);
  fprintf (netout, "[");

  p = contents;
  while (1)
    {
      char *string_x;

      string_x = string_in_kl1 (*p);
      free (*p);
      p++;
      fprintf (netout, "%s", string_x);
      free (string_x);

      if (*p != NULL)
	fprintf (netout, ",");
      else
	break;
    }
  free (contents);

  fprintf (netout, "],");
  unparse(o,netout/**/);
  fprintf (netout, ")\n");
  fflush (netout);
  check_result ("command failed\n");
  check_execution_end ();

  /* and then, this is result */
  line = readline_stream (netin);
  fputs (line, stdout);
  fputs ("\ncreated\n", stdout);
  free (line);
  fflush (stdout);
  exit (DB_SESSION);
}
