# Makefile -*- text -*-
#

CC= gcc

CFLAGS  = -g -I../lib -I../../parser
LDFLAGS = -g -L../lib -L../../parser
QSHDIR = /db/Quixote/v3/SS/lib/qshell
THIS = ss
TARGETS = cd ls mkdir pwd rmdir show_status crd open

all: ${TARGETS}

cd:	cd.o
	$(CC) $(LDFLAGS) -o cd cd.o -lqxt

crd:	crd.o
	$(CC) $(LDFLAGS) -o crd crd.o \
	 -lqxt -lqxtcnv -lqxtsrc -lm

ls:	ls.o
	$(CC) $(LDFLAGS) -o ls ls.o -lqxt

mkdir:	mkdir.o
	$(CC) $(LDFLAGS) -o mkdir mkdir.o -lqxt

pwd:	pwd.o
	$(CC) $(LDFLAGS) -o pwd pwd.o -lqxt

rmdir:	rmdir.o
	$(CC) $(LDFLAGS) -o rmdir rmdir.o -lqxt

show_status:	show_status.o
	$(CC) $(LDFLAGS) -o show_status show_status.o -lqxt

clean:
	rm -f *.o ${TARGETS}

install: ${TARGETS}
	cp ${TARGETS} qsh.conf ${QSHDIR}/${THIS}
