extern char *malloc(), *realloc();

# line 17 "parse.y"
#include <stdio.h>
#include "qxt.h"
#include "qshell.h"
#define YYDEBUG 1

static int lineno;

static WORD_LIST *new_word_list ();
static REDIRECT  *new_redirect ();
static COMMAND   *new_command ();
static void free_word_list ();
static void free_redirect ();
       void free_command ();
static void free_all ();

COMMAND *command;

extern void *xmalloc ();
extern void *xrealloc ();
extern char *newstring ();

extern int interactive;

static int yylex();
static void free_word_list_deep ();
static void free_redirect_deep ();



# line 46 "parse.y"
typedef union  {
  char *word;
  WORD_LIST *word_list;
  REDIRECT  *redirect;
  COMMAND   *command;
} YYSTYPE;
# define QUERY 257
# define WORD 258
# define GREATER_GREATER 259
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 205 "parse.y"


char *token = (char *) NULL;
int token_buffer_size = 0;

/****************

           Y   Y   L   E  X

  Context            Regep            Action/definition

                     [0-9a-zA-Z_-@:]+ word

  beginning of line  \?.+\n           QUERY
  non interactive    #.*\n            skip like white space
                     {word}           WORD
                     .                the token is the character itself
  

 ****************/

static char *token_string;
static int token_length;
static int token_string_allocated;
#define YYLEX_TOKEN_LENGTH 16

init_yylex ()
{
  token_string = xmalloc (YYLEX_TOKEN_LENGTH);
  token_string_allocated = YYLEX_TOKEN_LENGTH;
  lineno = 1;
}

#define is_word(c) (c >= 'a' && c <= 'z' || \
		    c >= 'A' && c <= 'Z' || \
		    c >= '0' && c <= '9' || \
		    c == '_' || c == '-' || \
		    c == '.' || c == '/' || \
		    c == ',' || c == '+' || \
		    c == '@' || c == ':')

static char *yy_line;
static char *yy_line_end;

init_yylex_for_line (line)
     char *line;
{
  yy_line = line;
  yy_line_end = yy_line + strlen (yy_line);
}

static int see_newline = 1;

static yygetchar ()
{
  int c;

  if (yy_line > yy_line_end)
    return EOF;

  if (yy_line == yy_line_end)
    c = '\n';
  else
    c = *yy_line;

  yy_line++;

  return c;
}

static yyungetchar (c)
     int c;
{
  if (c != EOF)
    yy_line--;
}

static yylex ()
{
  int c;

  token_length = 0;

 loop:
  c = yygetchar ();

  if (c == EOF)
    {
      see_newline = 0;
      return EOF;
    }
  if (c == ' ' || c == '\t')
    /* skip white space */
    goto loop;

  if (see_newline && c == '?')
    { /* Query */
      /* skip to next newline */
      while (1)
	{
	  token_string[token_length] = c;
	  token_length++;
	  if (token_string_allocated <= token_length)
	    {
	      token_string_allocated *= 2;
	      token_string = xrealloc (token_string, token_string_allocated);
	    }
	  c = yygetchar ();
	  if (c == '\n' || c == EOF)
	    break;
	}
      yyungetchar (c);
      token_string[token_length] = 0;
      yylval.word = newstring (token_string);

      see_newline = 0;
      return QUERY;
    }

  if (c == '#' && !interactive)
    { /* skip to next newline */
      while (1)
	{
	  c = yygetchar ();
	  if (c == '\n')
	    {
	      see_newline = 1;
	      return '\n';
	    }
	  else if (c == EOF)
	    {
	      see_newline = 0;
	      return EOF;
	    }
	}
    }

  if (c == '\"')
    {
      c = yygetchar ();

      while (1)
	{
	  if (c == '\"')
	    {
	      c = yygetchar ();
	      break;
	    }
	  else if (c == '\n')
	    {
	      fprintf (stderr, "String termnated by newsline.\n");
	      break;
	    }
	  token_string[token_length] = c;
	  token_length++;
	  if (token_string_allocated <= token_length)
	    {
	      token_string_allocated *= 2;
	      token_string = xrealloc (token_string, token_string_allocated);
	    }
	  c = yygetchar ();
	}
      yyungetchar (c);
      token_string[token_length] = 0;
      yylval.word = newstring (token_string);

      see_newline = 0;
      return WORD;
    }
  else if (is_word(c))
    {
      while (1)
	{
	  token_string[token_length] = c;
	  token_length++;
	  if (token_string_allocated <= token_length)
	    {
	      token_string_allocated *= 2;
	      token_string = xrealloc (token_string, token_string_allocated);
	    }
	  c = yygetchar ();
	  if (!is_word(c))
	    break;
	}
      yyungetchar (c);
      token_string[token_length] = 0;
      yylval.word = newstring (token_string);

      see_newline = 0;
      return WORD;
    }

  if (c == '>')
    {
      see_newline = 0;
      c = yygetchar ();
      if (c == '>')
	return GREATER_GREATER;
      else
	{
	  yyungetchar (c);
	  return '>';
	}
    }

  if (c == '\n')
    see_newline = 1;
  else
    see_newline = 0;

  return c;
}

static ANY head_content;
static ANY *head = &head_content;

static init_alloc ()
{
  head_content.prev_entry = NULL;
  head_content.next_entry = NULL;
}

static WORD_LIST *new_word_list (word, next)
     char *word;
     WORD_LIST *next;
{
  WORD_LIST *x;

  x = xmalloc (sizeof (WORD_LIST));
  x->type = TYPE_WORD_LIST;
  x->prev_entry = head;
  x->next_entry = head->next_entry;
  if (head->next_entry)
    head->next_entry->prev_entry = (ANY *)x;
  head->next_entry = (ANY *)x;

  x->word = word;
  x->next = next;

  return x;
}

static REDIRECT *new_redirect (mode, file_name, next)
     input_mode mode;
     char *file_name;
     REDIRECT * next;
{
  REDIRECT *x;

  x = xmalloc (sizeof (REDIRECT));
  x->type = TYPE_REDIRECT;
  x->prev_entry = head;
  x->next_entry = head->next_entry;
  if (head->next_entry)
    head->next_entry->prev_entry = (ANY *)x;
  head->next_entry = (ANY *)x;

  x->mode = mode;
  x->file_name = file_name;
  x->next = next;

  return x;
}

static COMMAND *new_command (argc, argv, redirect)
     int argc;
     char **argv;
     REDIRECT *redirect;
{
  COMMAND *x;

  x = xmalloc (sizeof (COMMAND));
  x->type = TYPE_COMMAND;
  x->prev_entry = head;
  x->next_entry = head->next_entry;
  if (head->next_entry)
    head->next_entry->prev_entry = (ANY *)x;
  head->next_entry = (ANY *)x;

  x->argc = argc;
  x->argv = argv;
  x->redirect = redirect;

  return x;
}

static void free_word_list(x)
     WORD_LIST *x;
{
  x->prev_entry->next_entry = x->next_entry;
  if (x->next_entry)
    x->next_entry->prev_entry = x->prev_entry;
  free (x->word);
  free (x);
}

static void free_word_list_deep (x)
     WORD_LIST *x;
{
  WORD_LIST *y;

  while (x)
    {
      y = x->next;
      free_word_list (x);
      x = y;
    }
}

static void free_redirect (x)
     REDIRECT *x;
{
  x->prev_entry->next_entry = x->next_entry;
  if (x->next_entry)
    x->next_entry->prev_entry = x->prev_entry;
  free (x->file_name);
  free (x);
}

static void free_redirect_deep (x)
     REDIRECT *x;
{
  REDIRECT *y;

  while (x)
    {
      y = x->next;
      free_redirect (x);
      x = y;
    }
}

void free_command (x)
     COMMAND *x;
{
  char **s;
  int i;

  x->prev_entry->next_entry = x->next_entry;
  if (x->next_entry)
    x->next_entry->prev_entry = x->prev_entry;
  for (s=x->argv; *s; s++)
    free (*s);
  free (x->argv);
  free (x);
}

void free_command_deep (x)
     COMMAND *x;
{
  free_redirect_deep (x->redirect);
  free_command (x);
}

static void free_all ()
{
  ANY *x;

  while (x = head->next_entry)
    {
      switch (x->type)
	{
	case TYPE_WORD_LIST:
	  free_word_list_deep ((WORD_LIST *)x);
	  break;
	case TYPE_REDIRECT:
	  free_redirect_deep ((REDIRECT *)x);
	  break;
	case TYPE_COMMAND:
	  free_command_deep ((COMMAND *)x);
	  break;
	default:
	  abort ();
	}
    }
}

yyerror (message)
     char *message;
{
  if (interactive)
    fprintf (stderr, "Qshell: %s\n", message);
  else
    fprintf (stderr, "Qshell: %s at line %d\n", message, lineno);
}
int yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 14
# define YYLAST 258
int yyact[]={

     7,    22,    21,    20,    17,    14,    19,    10,    16,     4,
     8,     2,     1,     0,    15,     0,    18,     0,     0,     0,
     0,     0,     0,    18,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    12,    12,    11,    11,    12,    12,    11,    11,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     9,    13,
    13,     0,     0,    13,    13,     5,     3,     6 };
int yypact[]={

    -1, -1000,   -10,    -5, -1000,    -2, -1000, -1000,    -6, -1000,
 -1000,  -252,  -255,  -256, -1000,    -9, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000 };
int yypgo[]={

     0,    12,    11,     7,    10 };
int yyr1[]={

     0,     1,     1,     1,     1,     1,     1,     2,     2,     3,
     3,     3,     4,     4 };
int yyr2[]={

     0,     5,     7,     5,     7,     3,     5,     3,     5,     5,
     5,     5,     2,     5 };
int yychk[]={

 -1000,    -1,    -2,   257,    10,   256,   258,    10,    -4,   258,
    -3,    62,    60,   259,    10,    -4,    10,    10,    -3,   258,
   258,   258,    10 };
int yydef[]={

     0,    -2,     0,     0,     5,     0,     7,     1,     0,     8,
    12,     0,     0,     0,     3,     0,     6,     2,    13,     9,
    10,    11,     4 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"QUERY",	257,
	"WORD",	258,
	"GREATER_GREATER",	259,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"line : word_list '\n'",
	"line : word_list redirections '\n'",
	"line : QUERY '\n'",
	"line : QUERY redirections '\n'",
	"line : '\n'",
	"line : error '\n'",
	"word_list : WORD",
	"word_list : word_list WORD",
	"redirection : '>' WORD",
	"redirection : '<' WORD",
	"redirection : GREATER_GREATER WORD",
	"redirections : redirection",
	"redirections : redirections redirection",
};
#endif /* YYDEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	{ free(yys); free(yyv); return(0); }
#define YYABORT		{ free(yys); free(yyv); return(1); }
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** static variables used by the parser
*/
static YYSTYPE *yyv;			/* value stack */
static int *yys;			/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */

int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */
	unsigned yymaxdepth = YYMAXDEPTH;

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yyv = (YYSTYPE*)malloc(yymaxdepth*sizeof(YYSTYPE));
	yys = (int*)malloc(yymaxdepth*sizeof(int));
	if (!yyv || !yys)
	{
		yyerror( "out of memory" );
		return(1);
	}
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			(void)printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			yymaxdepth += YYMAXDEPTH;
			yyv = (YYSTYPE*)realloc((char*)yyv,
				yymaxdepth * sizeof(YYSTYPE));
			yys = (int*)realloc((char*)yys,
				yymaxdepth * sizeof(int));
			if (!yyv || !yys)
			{
				yyerror( "yacc stack overflow" );
				return(1);
			}
			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			(void)printf( "Received token " );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				(void)printf( "Received token " );
				if ( yychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( yychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						(void)printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					(void)printf( "Error recovery discards " );
					if ( yychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 61 "parse.y"
{
  WORD_LIST *wl;
  int argc;
  char **argv;
  int i;

  argc = 0;
  for (wl = yypvt[-1].word_list; wl; wl = wl->next)
    argc++;

  argv = (char **) xmalloc (sizeof(char *) * (argc + 1));
  for (i=argc-1,wl = yypvt[-1].word_list; i >= 0; i--,wl = wl->next)
    argv[i] = newstring (wl->word);
  argv[argc] = NULL;

  free_word_list_deep (yypvt[-1].word_list);

  yyval.command = new_command (argc, argv, NULL);
  command = yyval.command;
  lineno++;
  YYACCEPT
} break;
case 2:
# line 84 "parse.y"
{
  WORD_LIST *wl;
  int argc;
  char **argv;
  REDIRECT *rdir1, *rdir2;
  int i;

  argc = 0;
  for (wl = yypvt[-2].word_list; wl; wl = wl->next)
    argc++;

  argv = (char **) xmalloc (sizeof(char *) * (argc + 1));

  for (i=argc-1,wl = yypvt[-2].word_list; i >= 0; i--,wl = wl->next)
    argv[i] = newstring (wl->word);
  argv[argc] = NULL;

  free_word_list_deep (yypvt[-2].word_list);

  /* reverse the order of $2 */
  rdir2 = NULL;
  for (rdir1 = yypvt[-1].redirect; rdir1; rdir1 = rdir1->next)
    rdir2 = new_redirect (rdir1->mode, rdir1->file_name, rdir2);
  free_redirect_deep (rdir1);

  yyval.command = new_command (argc, argv, rdir2);
  command = yyval.command;
  lineno++;
  YYACCEPT
} break;
case 3:
# line 115 "parse.y"
{ /* query -e "${word}" */
  int argc;
  char **argv;

  argc = 3;
  argv = (char **) xmalloc (sizeof(char *) * (argc + 1));
  argv[0] = newstring ("query");
  argv[1] = newstring ("-e");
  argv[2] = newstring (yypvt[-1].word);
  argv[argc] = NULL;

  yyval.command = new_command (argc, argv, NULL);
  command = yyval.command;
  lineno++;
  YYACCEPT
} break;
case 4:
# line 132 "parse.y"
{ /* query -e "${word}" */
  int argc;
  char **argv;
  REDIRECT *rdir1, *rdir2;

  argc = 3;
  argv = (char **) xmalloc (sizeof(char *) * (argc + 1));
  argv[0] = newstring ("query");
  argv[1] = newstring ("-e");
  argv[2] = newstring (yypvt[-2].word);
  argv[argc] = NULL;

  /* reverse the order of $2 */
  rdir2 = NULL;
  for (rdir1 = yypvt[-1].redirect; rdir1; rdir1 = rdir1->next)
    rdir2 = new_redirect (rdir1->mode, rdir1->file_name, rdir2);
  free_redirect_deep (rdir1);

  yyval.command = new_command (argc, argv, rdir2);
  command = yyval.command;
  lineno++;
  YYACCEPT
} break;
case 5:
# line 156 "parse.y"
{
  command = NULL;
  lineno++;
  YYACCEPT
} break;
case 6:
# line 162 "parse.y"
{
  command = NULL;
  free_all ();
  lineno++;
  if (interactive)
    YYACCEPT
  else
    YYABORT
} break;
case 7:
# line 174 "parse.y"
{
  yyval.word_list = new_word_list (yypvt[-0].word, NULL);
} break;
case 8:
# line 178 "parse.y"
{
  yyval.word_list = new_word_list (yypvt[-0].word, yypvt[-1].word_list);
} break;
case 9:
# line 184 "parse.y"
{
  yyval.redirect = new_redirect (output, yypvt[-0].word, NULL);
} break;
case 10:
# line 188 "parse.y"
{
  yyval.redirect = new_redirect (input, yypvt[-0].word, NULL);
} break;
case 11:
# line 192 "parse.y"
{
  yyval.redirect = new_redirect (output_append, yypvt[-0].word, NULL);
} break;
case 13:
# line 199 "parse.y"
{
  yypvt[-0].redirect->next = yypvt[-1].redirect;
  yyval.redirect = yypvt[-0].redirect;
} break;
	}
	goto yystack;		/* reset registers in driver code */
}
