# Makefile for Qshell -*- text -*-
#

# for ME

CC= gcc
RANLIB = /usr/bin/ranlib
AR = /bin/ar
RM = /bin/rm
SHELL = /bin/sh
YACC = /usr/local/bin/bison
YFLAGS = 

CFLAGS  = -g -I../readline -I../lib
LDFLAGS = -g -L../readline -L../lib

all: qshell

qshell: qshell.o read_config.o parse.o alloc.o metacommand.o
	$(CC) $(LDFLAGS) -o qshell qshell.o read_config.o metacommand.o -lqxt -lreadline -ltermcap

qshell.o: qshell.c qshell.h
read_config.o: read_config.c qshell.h
meta_command.o: meta_command.c qshell.h
parse.o: parse.c qshell.h

parse.c: parse.y
	$(YACC) parse.y

clean:
	rm -f *.o parse.c qshell
