#include <stdio.h>
#include "qxt.h"

#define LINE_INITIAL_SIZE 80

/* $B0l9TFI$_(B, $B$=$N(B string $B$r@8@.$7!"JV$jCM$H$9$k!#(B */
/* $B:G8e$N2~9T$O(B string $B$K4^$^$l$J$$!#(B             */
/* $BJV$jCM$N(B string $B$r(B free $B$9$k$N$O8F$s$@J}$N@UG$(B */

char *readline_stream (stream)
     FILE *stream;
{
  char *line;
  int size;
  int readed;
  char *result;

  line = xmalloc (LINE_INITIAL_SIZE);
  size = LINE_INITIAL_SIZE;
  readed = 0;

  while (1)
    {
      result = fgets (line+readed, size - readed, stream);
      if (result == NULL)
	{
	  if (readed == 0)
	    {
	      free (line);
	      return NULL;
	    }
	  return line;
	}
      readed += strlen (line+readed);
      if (line[readed-1] == '\n')
	{
	  line[readed-1] = 0;
	  return line;
	}
      if (size == readed +1)
	{
	  size *= 2;
	  line = xrealloc (line, size);
	}
      else
	return line;
    }
}

#define FILE_INITIAL_LINES 50

/* NULL end */

char **read_filecontents (stream)
     FILE *stream;
{
  char **contents;
  char *line;
  int size;
  int readed;

  contents = xmalloc (FILE_INITIAL_LINES * sizeof(char *));
  size = FILE_INITIAL_LINES * sizeof(char *);
  readed = 0;

  while (1)
    {
      line = readline_stream (stream);
      contents[readed++] = line;
      if (line == NULL)
	return contents;

      if (readed * sizeof (char *) == size)
	{
	  size *= 2;
	  contents = xrealloc (contents, size);
	}
    }
}
