#include <stdio.h>
#include <string.h>

extern fatal ();
extern void *realloc ();
extern void *malloc ();

void *xmalloc (size)
     unsigned int size;
{
  void *p;

  p = malloc (size);
#ifdef MALLOC_DEBUG
  fprintf (stderr, "allocated size (%d) at %x\n", size, p);
#endif
  if (p)
    return p;
  else
    fatal ("Memory exhausted.", 0);
}

void *xrealloc (p, size)
     void *p;
     unsigned int size;
{
  void *p1;

  p1 = realloc (p, size);
#ifdef MALLOC_DEBUG
  fprintf (stderr, "reallocated size (%d) at %x (orig. %x)\n", size, p1, p);
#endif
  if (p1)
    return p1;
  else
    fatal ("Memory exhausted.", 0);
}

char *newstring (str)
     char *str;
{
  char *s;

  if (str == NULL)
    return NULL;
  s = xmalloc (strlen (str));
  strcpy (s, str);
  return s;
}
