/**************************************************************
 *       OPERATION MODULE(PART 2)           <STROPR.C>
 *                                     '93.12.15  by R.K
 **************************************************************/

#include     <stdio.h>
#include     <string.h>
#include     <sys/types.h>

#include     "oprprot.h"

/**************************************************************
 *     SEARCH "{" & "}" 
 *-------------------------------------------------------------
 *  <calling sequence>
 *          p = opr_search_vector(buf, start, vend)     
 *
 *  <input>
 *          char           *buf    : search buffer pointer
 *          unsigned int   start   : search start point
 *          char           **vend   : search start point
 *
 *  <output>
 *          char           *vstart : search char next point
 *                                           (not found = NULL)
 *-------------------------------------------------------------
 *  <description>
 *         this function search "{" & "}" for buffer.
 *         search start point is argument "start".
 *         when search "{", return this pointer to "vstart".
 *         and when search "}", return this pointer + 1 to "vend"
 *         if "{" not found, return NULL.
 **************************************************************/
char  *opr_search_vector(buf, start, vend)


     char           *buf ;
     unsigned int   start ;
     char           **vend ;
{
  char *vstart, *curpnt ;
  int  i, stcnt = 0, stmark = '{';
  char c ;

  /*** start num check ***/
  if( (strlen(buf)) < start )
    return  NULL;            /*** start num too large ***/ 

  /*** make current pointer ***/
  curpnt = (buf+start);

  /*** search first "{" ***/
  vstart = strchr(curpnt,stmark);
  if( vstart == NULL )    return  vstart; 

  /*** search "}" ***/
  for( i = 1; i < strlen(curpnt); i++ ){
    c = vstart[i];
    if( c == '{' )  stcnt++;
    else if( c == '}' ) {
      if( stcnt != 0 )  stcnt--;
      else {
	*vend = vstart+(i+1);
	return  vstart;
      }
    }
  }
  return  NULL;
}
/***** <<< END OF STROPR2.C >>> *********************************/

