/**************************************************************
 *     FILE OPERATION MODULE       <FILEOPR.C>
 *                                     '93.12.7  by R.K
 **************************************************************/
#include   <stdio.h>
#include   <sys/types.h>

#include   "oprprot.h"

/**************************************************************
 *     WRITE STRING TO FILE
 *-------------------------------------------------------------
 *  <calling sequence>
 *          ret = opr_write(*fp, *data, len)     
 *
 *  <input>
 *          FILE  *fp     : file pointer
 *          char  *data   : write string to file
 *          int   len     : length of string
 *
 *  <output>
 *          int    ret    : return status
 *                                0 = normal end
 *                               -1 = abnormal end
 *-------------------------------------------------------------
 *  <description>
 *         this function write string to file.
 *         when saccess ,return normal end status(0), 
 *         else return abnormal end status(-1).
 *         before call this function,must be file open.(used "fopen"...etc)
 **************************************************************/
int opr_write(fp, data, len)

     FILE     *fp ;
     char     *data ;
     size_t   len ;

{
  int   ret ;

  ret = fwrite(data,sizeof(*data),len,fp);
  if(ret == NULL)      ret = STS_ABNORM;
  return  ret;
}
/***** << opr_write() END >> *****/

/**************************************************************
 *     READ STRING FROM FILE
 *-------------------------------------------------------------
 *  <calling sequence>
 *          ret = opr_read(fp, buf, len)     
 *
 *  <input>
 *          FILE   *fp     : file pointer
 *          char   *buf    : save buffer pointer for read string from file
 *          size_t len     : string length for reading
 *
 *  <output>
 *          int    ret    : return status
 *                                0 > string length
 *                               -1 = abnormal end
 *-------------------------------------------------------------
 *  <description>
 *         this function read string from file.
 *         when read fail ,return abnormal end status.
 *         if file length shorter than "len", all file reading,
 *         and return read string length.
 *         if file length larger than "len", read only "len"
 *         and return read length.("len" = return length)
 *         before call this function,must be file open.(used "fopen"...etc)
 **************************************************************/
int opr_read(fp, buf, len)

     FILE     *fp ;
     char     *buf ;
     size_t   len ;

{
  int   ret ;

  ret = fread(buf,sizeof((char)fp),len,fp);
  if(ret == NULL)      ret = -1;
  return  ret;
}
/***** << opr_read() END >> *****/
 
/***** << END OF FILEOPR.C >> *********************************/
