%{
#include "dotsrc.h"
/* #define YYSTYPE char * */

#define QPMAX 4096
static char qp[QPMAX] = {0,};
static int qpi = 0;

 PseudoObject	*xquery = NULL;
 PseudoObject	*xprogram = NULL;
static PseudoObject	*xenv_def = NULL;
static PseudoObject	*xexp_def = NULL;
static PseudoObject	*xobj_def = NULL;
static PseudoObject	*xmod_def = NULL;
static PseudoObject	*xlink_def = NULL;
static PseudoObject 	*xrule_def = NULL;

static ObjList *qmodes = NULL;

static ObjList *xdef_libs = NULL;
static ObjList *xlib_names = NULL;
static ObjList *xobj_subs = NULL;
static ObjList *xmod_subs = NULL;
static ObjList *xrules = NULL;
static ObjList *xm_ids = NULL;
static ObjList *xclusters = NULL;
static ObjList *xcnstrs = NULL;
static ObjList *xo_terms[32] = {NULL,};
static int xo_termsi = 0;
static ObjList *xa_terms = NULL;
static ObjList *xset_terms = NULL;
static NoAssume xnoassume = NULL;	/* NULL or NOASSUME */

static int xbasic_obj = NULL;

/* static COTerm *xc_o_term = NULL; */
%}

%union {	int	name;
		PseudoObject	*psob;
		int	tnum;
	}

%token Qry		    /* ?- */
%token Qmd		    /* &q_mod */
%token Pgm		    /* &pgm */
%token Env		    /* &env */
%token Exp		    /* &exp */
%token Obj		    /* &obj */
%token Mod		    /* &mod */
%token Link		    /* &link */
%token Rule		    /* &rule */
%token End		    /* &end */
%token DoubleSemicolon      /* ;; */
%token DoubleSemicolonx     /* ;; end of definition */
%token DoubleColon          /* :: */
%token DoubleLeftBrace      /* {{ */
%token DoubleRightBrace     /* }} */
%token LargeLeftArrow       /* <= */
%token Parallel             /* || */
%token SetSubsumed          /* =< */  
%token SetSubsumes          /* >= */
%token SetCong              /* == */
%token SetSubsumedop        /* +< */  
%token SetSubsumesop        /* >+ */
%token SetCongop            /* =+= */
%token Subsumes             /* >- */
%token Subsumed             /* -< */
%token RightArrow           /* -> */
%token LeftArrow            /* <- */
%token Nil                  /* [] */

%token Period	/* . */
%token SqBrL      /* [ */
%token SqBrR      /* ] */
%token Equal      /* = */
%token Comma      /* , */
%token BrL        /* { */
%token BrR        /* } */
%token RnBrL      /* ( */
%token RnBrR      /* ) */

%left Plus       /* + */
%left Minus      /* - */
%left Excl       /* ! */

%token Cln        /* : */
%token SCln       /* ; */
%token Slash      /* / */
%token VtLn       /* | */
%token At         /* @ */

%token Procmode			/* &proc_mode */
%token Ansmode			/* &ans_mode */
%token Inheritance		/* &inheritance */
%token Merge			/* &merge */
%token Explanation		/* &explanation */
%token Single			/* &single */
%token Multi			/* &multi */
%token Normal			/* &normal */
%token Minimal			/* &minimal */
%token Yes			/* &yes */
%token No			/* &no */
%token On			/* &on */
%token Off			/* &off */
%token All			/* &all */
%token Down			/* &down */
%token Up			/* &up */

%token Name                 /* &name */
%token Pgmname              /* &pgm-name */
%token Author               /* &author */
%token Autname              /* &aut-name */
%token Date                 /* &date */
%token Include              /* &include */
%token Explib               /* &exp_lib */
%token Pgmlib               /* &pgm_lib */
%token Sortlib              /* &sort_lib */
%token NoAssume		    /* &no_assume */
%token Consis		    /* &consis */
%token InConsis		    /* &inconsis */
%token Self                 /* &self */
%token Del                  /* &del */
%token Add                  /* &add */
%token Abs                  /* &abs */
%token Car                  /* &car */
%token Cdr                  /* &cdr */
%token In	            /* &in */
%token Ni	            /* &ni */
%token Localx               /* &l */
%token OverWrite            /* &o */
%token LocalAndOverwrite    /* &ol,&lo */
%token BT                   /* &bt */
%token ET                   /* &et */
%token AT                   /* &at */
%token <name>Variable
%token <name>SetVariable
%token <name>Atom
%token <name>SetAtom
%token <name>ExpName
%token <name>SortName
%token <name>String
%token <name>Integer

%type <name>basic_obj
%type <name>basic_objx
%type <name>o_head
%type <name>exp_name
%type <name>l_var
%type <name>g_var

%type <psob>env_def
%type <psob>exp_def
%type <psob>obj_def
%type <psob>mod_def
%type <psob>link_def
%type <psob>rule_def

%type <psob>o_cnstr
%type <psob>a_cnstr
%type <psob>o_attr
%type <psob>a_attr
%type <psob>c_o_term
%type <psob>list_o_term
%type <psob>list_o_term_list
%type <psob>cnstr_o_term
%type <psob>ind_term
%type <psob>dot_term
%type <psob>o_term
%type <psob>mid
%type <psob>m_sub
%type <psob>m_desc
%type <psob>lab
%type <psob>set_lab
%type <psob>a_term
%type <psob>set_terms
%type <psob>prop
%type <psob>propx
%type <psob>trans
%type <psob>clause
%type <psob>u_clause
%type <psob>rule
%type <psob>basic_objy
%type <psob>basic_objz
%type <psob>q_mode

%type <tnum>attr_op
%type <tnum>u_flag
%type <tnum>sub_rel
%type <tnum>set_rel
%type <tnum>lib_lab

%start program

%%
program:  program_def Period 
		{	YYACCEPT;
		}
	| qryx query Period
		{	YYACCEPT;
		}
	;

qryx:	  Qry
		{	xquery = (PseudoObject *)new_query();
			xclusters = new_obj_list(CLUSTER);
		}
	;

program_def:
	  b_pgm DoubleSemicolon definitions End
		{	xprogram = (PseudoObject *)new_program();
			if(xenv_def) write_env_def(xprogram,xenv_def);
			if(xexp_def) write_exp_def(xprogram,xexp_def);
			if(xobj_def) write_obj_def(xprogram,xobj_def);
			if(xmod_def) write_mod_def(xprogram,xmod_def);
			if(xlink_def) write_link_def(xprogram,xlink_def);
			if(xrule_def) write_rule_def(xprogram,xrule_def);
			fprintfx(stderr,"end\n");
			/* prnt_program(xprogram,stdout,1); */
		}
	;

b_pgm:	  Pgm
	;

definitions:
	  definition
	| definitions  definition
	;

definition:
	  env_def
		{	fprintfx(stderr,"env_def\n");
		}
	| exp_def
		{	fprintfx(stderr,"exp_def\n");
		}
	| obj_def
		{	fprintfx(stderr,"obj_def\n");
		}
	| mod_def
		{	fprintfx(stderr,"mod_def\n");
		}
	| link_def
		{	fprintfx(stderr,"link_def\n");
		}
	| rule_def
		{	fprintfx(stderr,"rule_def\n");
		}
	;

env_def:  b_env DoubleSemicolon envs
		{	/* prnt_env_def(xenv_def,stdout,1); */
		}
	;
	
b_env:	  Env
		{	xenv_def = (PseudoObject *)new_env_def();
		}
	;

envs:     env
	| envs env
	;

env:      name DoubleSemicolon
  		{	fprintfx(stderr,"env_name\n");
		}
	| author DoubleSemicolon
  		{	fprintfx(stderr,"env_author\n");
		}
	| date DoubleSemicolon
  		{	fprintfx(stderr,"env_date\n");
		}
	| include DoubleSemicolon
  		{	fprintfx(stderr,"env_include\n");
		}
 	;

name:	  Name SqBrL Pgmname Equal String SqBrR
		{	write_name_inEnvDef(xenv_def,&qp[$5]);
		}
	;

author:	  Author SqBrL Autname Equal String SqBrR
		{	write_author(xenv_def,&qp[$5]);
		}
	;

date:	  Date SqBrL Date Equal String SqBrR
		{	write_date(xenv_def,&qp[$5]);
		}
	;

include:  includex SqBrL def_libs SqBrR
		{	write_def_libs(xenv_def,xdef_libs);
		}
	;

includex:  Include
		{	xdef_libs = new_obj_list(DEF_LIB);
		}
	;

def_libs: def_lib
	| def_libs Comma def_lib
	;

def_lib:  lib_lab Equal lib_name
		{	PseudoObject *w;
			w = (PseudoObject *)create_def_lib($1,xlib_names);
			append_to_obj_list(xdef_libs,w);
		}
	| lib_lab Equal BrL lib_names BrR
		{	PseudoObject *w;
			w = (PseudoObject *)create_def_lib($1,xlib_names);
			append_to_obj_list(xdef_libs,w);
		}
	;

lib_names:
	  lib_name
	| lib_names Comma lib_name
	;

lib_name: String
		{	PseudoObject *w;
			w = (PseudoObject *)create_string(&qp[$1]);
			append_to_obj_list(xlib_names,w);
		}
	;

lib_lab:  Explib
		{	xlib_names = new_obj_list(STRING);
			$$ = EXPLIB;
		}
	| Pgmlib
		{	xlib_names = new_obj_list(STRING);
			$$ = PGMLIB;
		}
	| Sortlib
		{	xlib_names = new_obj_list(STRING);
			$$ = SORTLIB;
		}
	;

exp_def:  b_exp DoubleSemicolon exps
		{	fprintfx(stderr,"exp_def\n");
		}
	;

b_exp:	  Exp
		{	xexp_def = (PseudoObject *)new_exp_def();
		}
	;

exps:     exp
	| exps exp
	;

exp:      exp_name Equal exp_operation DoubleSemicolon
	;

exp_name: ExpName
	;

exp_operation:
          o_term
  		{	fprintfx(stderr,"exp_o_term or exp_mid\n");
		}
	| del
  		{	fprintfx(stderr,"exp_del\n");
		}
	| add
  		{	fprintfx(stderr,"exp_add\n");
		}
	| abs
  		{	fprintfx(stderr,"exp_abs\n");
		}
 	;

del:	  Del RnBrL basic_objs RnBrR exp_name
	;

add:	  Add RnBrL sqbrlx o_attrs sqbrrx RnBrR exp_name
	| Add RnBrL sqbrlx o_attrs sqbrrx Comma
			       o_cnstr_list RnBrR exp_name
	;

abs:	  Abs RnBrL o_attr RnBrR exp_name
	| Abs RnBrL o_attr Comma
			       o_cnstr_list RnBrR exp_name
	;

obj_def:  b_obj DoubleSemicolon obj_subs
		{	write_obj_subs(xobj_def,xobj_subs);
		}
	;

b_obj:	  Obj
		{	xobj_def = (PseudoObject *)new_obj_def();
			xobj_subs = new_obj_list(OBJ_SUB);
		}
	;

obj_subs: obj_sub
	| obj_subs obj_sub
	;

obj_sub:  basic_objx SetSubsumed basic_objy DoubleSemicolon
  		{	fprintfx(stderr,"obj_sub\n");
		}
	| basic_objx SetSubsumes basic_objz DoubleSemicolon
  		{	fprintfx(stderr,"obj_sub\n");
		}
       	| basic_objx SetSubsumed BrL basic_objsy BrR DoubleSemicolon
  		{	fprintfx(stderr,"obj_sub\n");
		}
       	| basic_objx SetSubsumes BrL basic_objsz BrR DoubleSemicolon
  		{	fprintfx(stderr,"obj_sub\n");
		}
 	;

basic_objsy:
	  basic_objy
	| basic_objsy Comma basic_objy
	;

basic_objsz:
	  basic_objz
	| basic_objsz Comma basic_objz
	;

basic_objx:
          Atom
		{	xbasic_obj = $1;
		}
        ;

basic_objy:
          Atom
		{	$$ = (PseudoObject *)create_obj_sub(&qp[xbasic_obj],
							    &qp[$1]);
			append_to_obj_list(xobj_subs,$$);
		}
        ;

basic_objz:
          Atom
		{	$$ = (PseudoObject *)create_obj_sub(&qp[$1],
							    &qp[xbasic_obj]);
			append_to_obj_list(xobj_subs,$$);
		}
        ;

mod_def:  b_mod DoubleSemicolon m_subs
		{	set_mod_def(xmod_def,xmod_subs);
		}
	;
	
b_mod:	  Mod
		{	xmod_def = (PseudoObject *)new_mod_def();
			xmod_subs = new_obj_list(M_SUB);
		}
	;

m_subs:	  m_sub
	| m_subs m_sub
	;

m_sub:	  mid Subsumes m_desc DoubleSemicolon
		{	$$ = (PseudoObject *)create_m_sub($1,$3);
			append_to_obj_list(xmod_subs,$$);
		}
	| m_desc Subsumed mid DoubleSemicolon
		{	$$ = (PseudoObject *)create_m_sub($3,$1);
			append_to_obj_list(xmod_subs,$$);
		}
	;

m_desc:	  mid
		{	$$ = (PseudoObject *)create_m_desc_m_id($1);
		}
	| RnBrL m_desc RnBrR
		{	$$ = $2;
		}
	| m_desc Plus m_desc
		{	$$ = (PseudoObject *)create_m2_desc($1,'+',$3);
			$$ = (PseudoObject *)create_m_desc_m2_desc($$);
		}
	| m_desc Minus m_desc
		{	$$ = (PseudoObject *)create_m2_desc($1,'-',$3);
			$$ = (PseudoObject *)create_m_desc_m2_desc($$);
		}
	;

link_def: b_link DoubleSemicolon links
		{	fprintfx(stderr,"link_def\n");
		}
	;
	
b_link:	  Link
	;

links:	  link
	| links link
	;

link:	  SqBrL link_name Comma Comma
	  SqBrR DoubleSemicolon
	| SqBrL link_name Comma
			    BrL o_links BrR Comma
	  SqBrR DoubleSemicolon
	| SqBrL link_name Comma Comma
			    BrL m_links BrR
	  SqBrR DoubleSemicolon
	| SqBrL link_name Comma 
			    BrL o_links BrR Comma
			    BrL m_links BrR
	  SqBrR DoubleSemicolon
	;

link_name:
	  Atom
	;

o_links:  o_link
	| o_links Comma o_link
	;

m_links:  m_link
	| m_links Comma m_link
	;

o_link:   SqBrL o_term Comma o_term SqBrR
	| SqBrL o_term Comma o_term_list SqBrR
	;

m_link:   SqBrL mid Comma mid SqBrR
	| SqBrL mid Comma mid_list SqBrR
	;

rule_def: b_rule DoubleSemicolon rules
		{	xrule_def = (PseudoObject *)set_rule_def(xrule_def,
								 xrules);
		}
	;
	
b_rule:	  Rule
		{	xrule_def = (PseudoObject *)new_rule_def();
			xm_ids = new_obj_list(O_TERM);
			xrules = new_obj_list(RULE);
			fprintfx(stderr,"b_rule\n");
		}
	;

rules:    rules_sub
	| rules rules_sub
	;

rules_sub:
	  rules_suby
		{	xm_ids = new_obj_list(O_TERM);
			xnoassume = NULL;
			fprintfx(stderr,"rules_sub\n");
		}
	| mod DoubleColon rules_suby
		{	xm_ids = new_obj_list(O_TERM);
			xnoassume = NULL;
			fprintfx(stderr,"rules_sub\n");
		}
	| mod DoubleColon rules_subx
		{	xm_ids = new_obj_list(O_TERM);
			xnoassume = NULL;
			fprintfx(stderr,"rules_sub\n");
		}
	| NoAssume rules_suby
		{	xm_ids = new_obj_list(O_TERM);
			xnoassume = NOASSUME;
			fprintfx(stderr,"rules_sub\n");
		}
	| NoAssume mod DoubleColon rules_suby
		{	xm_ids = new_obj_list(O_TERM);
			xnoassume = NOASSUME;
			fprintfx(stderr,"rules_sub\n");
		}
	| NoAssume mod DoubleColon rules_subx
		{	xm_ids = new_obj_list(O_TERM);
			xnoassume = NOASSUME;
			fprintfx(stderr,"rules_sub\n");
		}
	;

mod:	  mid
		{	xnoassume = NULL;
			append_to_obj_list(xm_ids,$1);
		}
	| mod_mid_list
		{	xnoassume = NULL;
		}
	;

mod_mid_list:
	  BrL mod_mids BrR
	;

mod_mids:  
	  mod_mid
	| mod_mids Comma mod_mid
	;

mod_mid: o_head
		{	fprintfx(stderr,"mod_mid\n");
		}
	| o_head sqbrlx o_attrs sqbrrx 
	| o_head sqbrlx o_attrs sqbrrx vtlnx o_cnstr_list
	| o_head RnBrL o_terms RnBrR
	| a_o_term
	;

rules_suby:
          rule DoubleSemicolon
		{	fprintfx(stderr,"rules_subx\n");
		}
	;

rules_subx:
          BrL ruleList BrR DoubleSemicolon
	;

ruleList: rule
	| ruleList DoubleSemicolon rule
	;

rule:     clause
		{	$$ = (PseudoObject *)write_rule_class($1,RCNOUPDATE);
			$$ = (PseudoObject *)write_m_ids_inRule($$,xm_ids);
			$$ = (PseudoObject *)
			     write_no_assume_inRule($$,xnoassume);
			append_to_obj_list(xrules,$$);
		}
        | u_clause
		{	$$ = (PseudoObject *)write_rule_class($1,RCUPDATE);
			$$ = (PseudoObject *)write_m_ids_inRule($$,xm_ids);
			$$ = (PseudoObject *)
			     write_no_assume_inRule($$,xnoassume);
			append_to_obj_list(xrules,$$);
		}
	| RnBrL rule_id_etc RnBrR clause
		{	
		}
        | RnBrL rule_id_etc RnBrR u_clause
		{	
		}
        ;

clause:	  a_term
		{	$$ = (PseudoObject *)new_rule();
			$$ = (PseudoObject *)write_head_inRule($$,$1);
		}
	| a_term largeleftarrowx body
		{	$$ = (PseudoObject *)new_rule();
			$$ = (PseudoObject *)write_head_inRule($$,$1);
			$$ = (PseudoObject *)
			     write_clusters_inRule($$,xclusters);
			if(xcnstrs != NULL)
				{
				$$ = (PseudoObject *)
				     write_cnstrs_inRule($$,xcnstrs);
				}
		}
	;

largeleftarrowx:
	  LargeLeftArrow
		{	xclusters = new_obj_list(CLUSTER);
		}
	;

body:	  props
		{	xcnstrs = NULL;
		}
	| props parallelx a_cnstr_list
	;

parallelx:
	  Parallel
/*		{	xcnstrs = new_obj_list(CNSTR); */
		{	xcnstrs = new_obj_list(CNSTR_DATA);
		}
	;

props:	  prop
	| props Comma prop
	;

prop:	  a_term
		{	$$ = (PseudoObject *)create_normal(NULL,$1);
			/* $$ = (PseudoObject *)create_cluster_normal($$); */
			append_to_obj_list(xclusters,$$);
		}
	| mid Cln a_term
		{	$$ = (PseudoObject *)create_normal($1,$3);
			/* $$ = (PseudoObject *)create_cluster_normal($$); */
			append_to_obj_list(xclusters,$$);
		}
	| o_term sub_rel objs
	;

u_clause: a_term largeleftarrowx u_body
		{	$$ = (PseudoObject *)new_rule();
			$$ = (PseudoObject *)write_head_inRule($$,$1);
			$$ = (PseudoObject *)
			     write_clusters_inRule($$,xclusters);
		}
	;

u_body:	  u_props
	;

u_props:  u_prop
	| prop SCln u_prop
	| prop SCln prop
	| u_props SCln prop
	| u_props SCln u_prop
	;

u_prop:	  u_flag propx
		{	$2 = (PseudoObject *)write_u_flag($2,$1);
			append_to_obj_list(xclusters,$2);
		}
	| trans
		{	append_to_obj_list(xclusters,$1);
		}
	| integrity
	;

propx:	  a_term
		{	$$ = (PseudoObject *)create_update(NULL,NULL,$1);
			$$ = (PseudoObject *)create_cluster_update($$);
		}
	| mid Cln a_term
		{	$$ = (PseudoObject *)create_update(NULL,$1,$3);
			$$ = (PseudoObject *)create_cluster_update($$);
		}
	| o_term sub_rel objs
	;

trans:	  BT
		{	$$ = (PseudoObject *)create_transaction(TDBT);
			$$ = (PseudoObject *)create_cluster_transaction($$);
		}
	| ET
		{	$$ = (PseudoObject *)create_transaction(TDET);
			$$ = (PseudoObject *)create_cluster_transaction($$);
		}
        | AT
		{	$$ = (PseudoObject *)create_transaction(TDAT);
			$$ = (PseudoObject *)create_cluster_transaction($$);
		}
	;

u_flag:	  Plus
		{	$$ = (int)UFPLUS;
		}
	| Minus
		{	$$ = (int)UFMINUS;
		}
	;

integrity:
	  Consis RnBrL i_check RnBrR
	| InConsis RnBrL i_check RnBrR
	;

i_check:  a_term
	| mid Cln a_term
	| a_cnstr_list
	;

objs:	  o_term
	| o_term_list
	;

rule_id_etc:
	  rule_id
	| rule_mode
	| rule_id Comma rule_mode
	;

rule_id:  Atom
        | Variable
	;

rule_mode:
	  inheritance_mode
	| RnBrL inheritance_mode Comma NoAssume RnBrR
	;

inheritance_mode:
          Localx
        | OverWrite
        | LocalAndOverwrite
	;

a_term:	  o_term
		{	$$ = (PseudoObject *)create_a_term($1,NULL,NULL);
		}
	| o_term Slash a_attr_list
		{	
			$$ = (PseudoObject *)
			     create_a_term($1,
					   xo_terms[xo_termsi+1],NULL);
		}
	| o_term Slash vtlnx a_cnstr_list
		{	$$ = (PseudoObject *)create_a_term($1,NULL,xcnstrs);
		}
	| o_term Slash a_attr_list vtlnx a_cnstr_list
		{	
			$$ = (PseudoObject *)
			     create_a_term($1,
					   xo_terms[xo_termsi+1],NULL);
			$$ = (PseudoObject *)write_cnstrs_inATerm($$,xcnstrs);
		}
	;

vtlnx:	  VtLn
/*		{	xcnstrs = new_obj_list(CNSTR); */
		{	xcnstrs = new_obj_list(CNSTR_DATA);
		}
	;

a_attr_list:
	  sqbrlx a_attrs sqbrrx
	;

a_attrs:  a_attr
	| a_attrs Comma a_attr
	;

a_attr:	  lab attr_op ind_term
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_attr();
			$$ = (PseudoObject *)write_label_inAttr($$,$1);
			$$ = (PseudoObject *)write_attr_op($$,$2);
			w = (PseudoObject *)create_value_o_term($3);
			$$ = (PseudoObject *)write_value($$,w);
			append_to_obj_list(xo_terms[xo_termsi],$$);
		}
	| set_lab set_rel set_terms
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_attr();
			$$ = (PseudoObject *)write_label_inAttr($$,$1);
			$$ = (PseudoObject *)write_attr_op($$,$2);
			w = (PseudoObject *)create_value_set($3);
			$$ = (PseudoObject *)write_value($$,w);
			append_to_obj_list(xo_terms[xo_termsi],$$);
		}
/*	| lab RightArrow set_terms */
/*	| set_lab LeftArrow ind_term */
	;

ind_term: c_o_term
		{	$$ = (PseudoObject *)create_o_term_c_o_term($1);
		}
/*	| exp_name */
/*	| list */
	| String
		{	$$ = (PseudoObject *)create_string(&qp[$1]);
			$$ = (PseudoObject *)create_non_struct_string($$);
			$$ = (PseudoObject *)create_o_term_non_struct($$);
		}
	| Integer
		{	$$ = (PseudoObject *)create_integer(atoi(&qp[$1]));
			$$ = (PseudoObject *)create_non_struct_integer($$);
			$$ = (PseudoObject *)create_o_term_non_struct($$);
		}
	| g_var
		{	$$ = (PseudoObject *)create_var(VARIND,&qp[$1]);
			$$ = (PseudoObject *)create_o_term_var($$);
		}
	| dot_term
		{	$$ = (PseudoObject *)create_o_term_dot($1);
		}
/*	| Self */
/*	| sort */
	;

sort:	  sort_name
	| sort_name Slash a_attr_list
	;

sort_name:
	  SortName
	| SortName sqbrlx o_attrs sqbrrx
	| SortName sqbrlx o_attrs sqbrrx vtlnx o_cnstr_list
	| SortName RnBrL o_terms RnBrR
	;

a_cnstr_list:
	  BrL a_cnstrs BrR
	;

a_cnstrs: a_cnstr
	| a_cnstrs Comma a_cnstr
	;

a_cnstr:  ind_term sub_rel ind_term
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			w = (PseudoObject *)create_value_o_term($1);
			$$ = (PseudoObject *)write_value1($$,w);
			$$ = (PseudoObject *)write_rel_inCnstrData($$,$2);
			w = (PseudoObject *)create_value_o_term($3);
			$$ = (PseudoObject *)write_value2($$,w);
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			/* w = $$; w->cnstr.tag = CNSTR; */
			append_to_obj_list(xcnstrs,$$);
		}
	| ind_term sub_rel mid Cln ind_term
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			w = (PseudoObject *)create_value_o_term($1);
			$$ = (PseudoObject *)write_value1($$,w);
			$$ = (PseudoObject *)write_rel_inCnstrData($$,$2);
			$$ = (PseudoObject *)write_m_id2_inCnstrData($$,$3);
			w = (PseudoObject *)create_value_o_term($5);
			$$ = (PseudoObject *)write_value2($$,w);
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			/* w = $$; w->cnstr.tag = CNSTR; */
			append_to_obj_list(xcnstrs,$$);
		}
	| mid Cln ind_term sub_rel ind_term
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$ = (PseudoObject *)write_m_id1_inCnstrData($$,$1);
			w = (PseudoObject *)create_value_o_term($3);
			$$ = (PseudoObject *)write_value1($$,w);
			$$ = (PseudoObject *)write_rel_inCnstrData($$,$4);
			w = (PseudoObject *)create_value_o_term($5);
			$$ = (PseudoObject *)write_value2($$,w);
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			/* w = $$; w->cnstr.tag = CNSTR; */
			append_to_obj_list(xcnstrs,$$);
		}
	| mid Cln ind_term sub_rel mid Cln ind_term
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$ = (PseudoObject *)write_m_id1_inCnstrData($$,$1);
			w = (PseudoObject *)create_value_o_term($3);
			$$ = (PseudoObject *)write_value1($$,w);
			$$ = (PseudoObject *)write_rel_inCnstrData($$,$4);
			$$ = (PseudoObject *)write_m_id2_inCnstrData($$,$5);
			w = (PseudoObject *)create_value_o_term($7);
			$$ = (PseudoObject *)write_value2($$,w);
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			/* w = $$; w->cnstr.tag = CNSTR; */
			append_to_obj_list(xcnstrs,$$);
		}
/*	| set_lhs set_rel set_terms
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			append_to_obj_list(xcnstrs,$$);
		}
	| set_lhs set_rel mid Cln set_terms
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$= (PseudoObject *)create_cnstr_cnstr($$);
			append_to_obj_list(xcnstrs,$$);
		}
	| mid Cln set_lhs set_rel set_terms
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			append_to_obj_list(xcnstrs,$$);
		}
	| mid Cln set_lhs set_rel mid Cln set_terms
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			append_to_obj_list(xcnstrs,$$);
		}
	| ind_term In set_terms
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			append_to_obj_list(xcnstrs,$$);
		}
	| ind_term In mid Cln set_terms
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$= (PseudoObject *)create_cnstr_cnstr($$);
			append_to_obj_list(xcnstrs,$$);
		}
	| mid Cln ind_term In set_terms
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			append_to_obj_list(xcnstrs,$$);
		}
	| mid Cln ind_term In mid Cln set_terms
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			append_to_obj_list(xcnstrs,$$);
		}
	| set_lhs Ni ind_term
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			append_to_obj_list(xcnstrs,$$);
		}
	| set_lhs Ni mid Cln ind_term
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$= (PseudoObject *)create_cnstr_cnstr($$);
			append_to_obj_list(xcnstrs,$$);
		}
	| mid Cln set_lhs Ni ind_term
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$= (PseudoObject *)create_cnstr_cnstr($$);
			append_to_obj_list(xcnstrs,$$);
		}
	| mid Cln set_lhs Ni mid Cln ind_term
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			$$ = (PseudoObject *)create_cnstr_cnstr($$);
			append_to_obj_list(xcnstrs,$$);
		} */
	;

set_lab:  SetAtom
		{	PseudoObject *w;
			char ws[256];
			strcpy(ws,&qp[$1]);
			ws[strlen(ws)-1] = 0;
			w = (PseudoObject *)create_c_o_term(ws,
							     NULL,NULL);
			w = (PseudoObject *)create_o_term_c_o_term(w);
			$$ = (PseudoObject *)create_set_lab(w);
		}
	;

set_terms:	  list_o_term_list
		{	$$ = (PseudoObject *)create_set($1);
		}
/*	| set_lhs */
	;

/*
set_lhs:  o_term Excl set_lab
	| set_var
	; */

/*
set_var:  SetVariable
	; */

attr_op:  RightArrow
		{	$$ = ATRARROW;
		}
	| LeftArrow
		{	$$ = ATLARROW;
		}
	| Equal
		{	$$ = ATEQ;
		}
	;

o_term_list:
	  BrL o_terms BrR
	;

o_terms:  o_term
	| o_terms Comma o_term
	;

o_term:	  c_o_term
		{	$$ = (PseudoObject *)create_o_term_c_o_term($1);
		}
/*	| exp_name */
/*	| list */
	| String
		{	$$ = (PseudoObject *)create_string(&qp[$1]);
			$$ = (PseudoObject *)create_non_struct_string($$);
			$$ = (PseudoObject *)create_o_term_non_struct($$);
		}
	| Integer
		{	$$ = (PseudoObject *)create_integer(atoi(&qp[$1]));
			$$ = (PseudoObject *)create_non_struct_integer($$);
			$$ = (PseudoObject *)create_o_term_non_struct($$);
		}
	| g_var
		{	$$ = (PseudoObject *)create_var(VARIND,&qp[$1]);
			$$ = (PseudoObject *)create_o_term_var($$);
		}
	| dot_term
		{	$$ = (PseudoObject *)create_o_term_dot($1);
		}
	;

list_o_term_list:
	  brlx list_o_terms BrR
		{	$$ = (PseudoObject *)xset_terms;
		}
	;

brlx:	  BrL
		{	xset_terms = new_obj_list(O_TERM);
		}

list_o_terms:  
	  list_o_term
	| list_o_terms Comma list_o_term
	;

list_o_term:
  	  c_o_term
		{	append_to_obj_list(xset_terms,$1);
		}
/*	| exp_name */
/*	| list */
	| String
		{	$$ = (PseudoObject *)create_string(&qp[$1]);
			$$ = (PseudoObject *)create_non_struct_string($$);
			append_to_obj_list(xset_terms,$$);
		}
	| Integer
		{	$$ = (PseudoObject *)create_integer(atoi(&qp[$1]));
			$$ = (PseudoObject *)create_non_struct_integer($$);
			append_to_obj_list(xset_terms,$$);
		}
	;

dot_term: o_term Excl lab
		{	$$ = (PseudoObject *)create_dot($1,$3);
		}
	;

c_o_term_list:
	  BrL c_o_terms BrR
	;

c_o_terms:  
	  c_o_term
	| c_o_terms Comma c_o_term
	;

c_o_term: o_head
		{	$$ = (PseudoObject *)create_c_o_term(&qp[$1],
							     NULL,NULL);
		}
	| o_head sqbrlx o_attrs sqbrrx
		{	
			$$ = (PseudoObject *)
			     create_c_o_term(&qp[$1],
					     xo_terms[xo_termsi+1],
					     NULL);
		}
/*	| o_head sqbrlx o_attrs sqbrrx vtlnx o_cnstr_list */
/*	| o_head RnBrL o_terms RnBrR */
/*	| a_o_term */
	;

o_head:	  basic_obj
		{	$$ = $1;
		}
	;

sqbrlx:	  SqBrL
		{	xo_terms[++xo_termsi] = new_obj_list(ATTR);
		}
	;

sqbrrx:	  SqBrR
		{	--xo_termsi;
		}
	;

o_attr_list:
	  sqbrlx o_attrs sqbrrx
	;

o_attrs:  o_attr
	| o_attrs Comma o_attr
	;

o_attr:	  basic_obj Equal o_term
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_attr();
			w = (PseudoObject *)create_c_o_term(&qp[$1],
							     NULL,NULL);
			w = (PseudoObject *)create_o_term_c_o_term(w);
			/* w = (PseudoObject *)create_lab(w,LAB); */
			w = (PseudoObject *)create_label(w);
			$$ = (PseudoObject *)write_label_inAttr($$,w);
			$$ = (PseudoObject *)write_attr_op($$,ATEQ);
			w = (PseudoObject *)create_value_o_term($3);
			$$ = (PseudoObject *)write_value($$,w);
			append_to_obj_list(xo_terms[xo_termsi],$$);
		}
	;

lab:	  c_o_term
		{	PseudoObject *w;
			w = (PseudoObject *)create_o_term_c_o_term($1);
			/* w = (PseudoObject *)create_lab(w,LAB); */
			$$ = (PseudoObject *)create_label(w);
		}
	| Car 
		{	PseudoObject *w;
			w = (PseudoObject *)create_c_o_term("&car",
							     NULL,NULL);
			w = (PseudoObject *)create_o_term_c_o_term(w);
			/* w = (PseudoObject *)create_lab(w,LAB); */
			$$ = (PseudoObject *)create_label(w);
		}
	| Cdr
		{	PseudoObject *w;
			w = (PseudoObject *)create_c_o_term("&cdr",
							     NULL,NULL);
			w = (PseudoObject *)create_o_term_c_o_term(w);
			/* w = (PseudoObject *)create_lab(w,LAB); */
			$$ = (PseudoObject *)create_label(w);
		}
	;

basic_objs:
	  basic_obj
	| basic_objs Comma basic_obj
	;

basic_obj:
          Atom
		{	$$ = $1;
		}
        ;

mid_list: BrL mids BrR
	;

mids:	  mid
	| mids Comma mid
	;

mid:      c_o_term
		{	$$ = (PseudoObject *)create_o_term_c_o_term($1);
		}
	| g_var
		{	$$ = (PseudoObject *)create_var(VARIND,&qp[$1]);
			$$ = (PseudoObject *)create_o_term_var($$);
		}
/*	| Self */
	;

o_cnstr_list:
	  BrL o_cnstrs BrR
	;

o_cnstrs: o_cnstr
	| o_cnstrs Comma o_cnstr
	;

o_cnstr:  l_var SetCong cnstr_o_term
		{	PseudoObject *w;
			$$ = (PseudoObject *)new_cnstr_data();
			w = (PseudoObject *)create_var(VARIND,&qp[$1]);
			w = (PseudoObject *)create_o_term_var($$);
			w = (PseudoObject *)create_value_o_term($$);
			$$ = (PseudoObject *)write_value1($$,w);
			$$ = (PseudoObject *)write_rel_inCnstrData($$,CNEQ);
			$$ = (PseudoObject *)write_value2($$,$3);
			$$= (PseudoObject *)create_cnstr_cnstr($$);
			/* w = $$; w->cnstr.tag = CNSTR; */
			append_to_obj_list(xcnstrs,$$);
		}
        ;

cnstr_o_term:
          o_head
		{	$$ = (PseudoObject *)create_c_o_term(&qp[$1],
							     NULL,NULL);
		}
	| exp_name
		{	$$ = (PseudoObject *)create_c_o_term(&qp[$1],
							     NULL,NULL);
		}
	| o_head sqbrlx o_attrs sqbrrx
		{	$$ = (PseudoObject *)
			     create_c_o_term(&qp[$1],
					     xo_terms[xo_termsi+1],
					     NULL);
		}
        | l_var
		{	$$ = (PseudoObject *)create_var(VARIND,&qp[$1]);
			$$ = (PseudoObject *)create_o_term_var($$);
			$$ = (PseudoObject *)create_value_o_term($$);
		}
	;

a_o_term: l_var At c_o_term
	;

list:	  SqBrL o_terms SqBrR
	| SqBrL o_terms VtLn list SqBrR
	| SqBrL o_terms VtLn g_var SqBrR
	| Nil
	;

g_var:    Variable
		{	$$ = $1;
		}
        ;

l_var:    Variable
		{	$$ = $1;
		}
        ;

sub_rel:  SetSubsumed
		{	$$ = CNLE;
		}
        | SetSubsumes
		{	$$ = CNGE;
		}
        | SetCong
		{	$$ = CNEQ;
		}
        ;

set_rel:  SetSubsumedop
		{	$$ = CNPL;
		}
        | SetSubsumesop
		{	$$ = CNPG;
		}
        | SetCongop
		{	$$ = CNEPE;
		}
        ;

query:	  q_body
		{	
		write_query_class(xquery,RCNOUPDATE);
		}
	| u_body
		{	write_query_class(xquery,RCUPDATE);
		}
	| q_body q_attach
		{	
		write_query_class(xquery,RCNOUPDATE);
		}
	| u_body q_attach
		{	write_query_class(xquery,RCUPDATE);
		}
	;

q_body:	  q_props
		{	write_clusters_inQuery(xquery,xclusters);
		}
	| q_props parallelx q_cnstr_list
		{	write_clusters_inQuery(xquery,xclusters);
			write_cnstrs_inQuery(xquery,xcnstrs);
		}
	;

q_cnstr_list:
	  BrL q_cnstrs BrR
	;

q_cnstrs: q_cnstr
	| q_cnstrs Comma q_cnstr
	;

q_cnstr:  a_cnstr
	;

q_props:  q_prop
	| q_props Comma q_prop
	;

q_prop:	  prop
	;

q_attach:
	  DoubleSemicolon qmdx q_mode_list
		{	write_q_modes(xquery,qmodes);
		}
	| DoubleSemicolon program_def
		{	write_program_inQuery(xquery,xprogram);
		}
	| DoubleSemicolon qmdx q_mode_list DoubleSemicolon program_def
		{	write_q_modes(xquery,qmodes);
			write_program_inQuery(xquery,xprogram);
		}
	;

qmdx:	Qmd
		{	qmodes = new_obj_list(Q_MODE);	
		}
	;

q_mode_list:
	  SqBrL q_modes SqBrR
	;

q_modes:  q_mode
	| q_modes Comma q_mode
	;

q_mode:	  Procmode Equal Single
		{	$$ = (PseudoObject *)create_p_mode(PSINGLE);
			$$ = (PseudoObject *)create_q_mode_p_mode($$);
			append_to_obj_list(qmodes,$$);
		}
	| Procmode Equal Multi
		{	$$ = (PseudoObject *)create_p_mode(PMULTI);
			$$ = (PseudoObject *)create_q_mode_p_mode($$);
			append_to_obj_list(qmodes,$$);
		}
	| Ansmode Equal Normal
		{	$$ = (PseudoObject *)create_a_mode(ANORMAL);
			$$ = (PseudoObject *)create_q_mode_a_mode($$);
			append_to_obj_list(qmodes,$$);
		}
	| Ansmode Equal Minimal
		{	$$ = (PseudoObject *)create_a_mode(AMINIMAL);
			$$ = (PseudoObject *)create_q_mode_a_mode($$);
			append_to_obj_list(qmodes,$$);
		}
	| Inheritance Equal All
		{	$$ = (PseudoObject *)create_i_mode(IALL);
			$$ = (PseudoObject *)create_q_mode_i_mode($$);
			append_to_obj_list(qmodes,$$);
		}
	| Inheritance Equal Down
		{	$$ = (PseudoObject *)create_i_mode(IDOWN);
			$$ = (PseudoObject *)create_q_mode_i_mode($$);
			append_to_obj_list(qmodes,$$);
		}
	| Inheritance Equal Up
		{	$$ = (PseudoObject *)create_i_mode(IUP);
			$$ = (PseudoObject *)create_q_mode_i_mode($$);
			append_to_obj_list(qmodes,$$);
		}
	| Inheritance Equal No
		{	$$ = (PseudoObject *)create_i_mode(INO);
			$$ = (PseudoObject *)create_q_mode_i_mode($$);
			append_to_obj_list(qmodes,$$);
		}
	| Merge Equal Yes
		{	$$ = (PseudoObject *)create_m_mode(MYES);
			$$ = (PseudoObject *)create_q_mode_m_mode($$);
			append_to_obj_list(qmodes,$$);
		}
	| Merge Equal No
		{	$$ = (PseudoObject *)create_m_mode(MNO);
			$$ = (PseudoObject *)create_q_mode_m_mode($$);
			append_to_obj_list(qmodes,$$);
		}
	| Explanation Equal On
		{	$$ = (PseudoObject *)create_e_mode(EON);
			$$ = (PseudoObject *)create_q_mode_e_mode($$);
			append_to_obj_list(qmodes,$$);
		}
	| Explanation Equal Off
		{	$$ = (PseudoObject *)create_e_mode(EOFF);
			$$ = (PseudoObject *)create_q_mode_e_mode($$);
			append_to_obj_list(qmodes,$$);
		}
	;

	  
%%

int pool(p)
	char *p;
	{
	int i, j;

	if((i = qpi + strlen(p) + 1) > QPMAX)
		qpi = 0;
	j = qpi;
	strcpy(&qp[qpi], p);
	qpi = i;
	return(j);
	}

#include "rule_l.c"
