/*
  test_f: .src access function test program

  test_f [pseudo_object, ...]

  Test functions for designated pseudo_objects.  For all
pseudo_objects, if not designated any pseudo_object.
*/

#include <assert.h>
#include <ctype.h>

#define MALLOC_DEBUG
#define FILE_NAME "test_f.out"

#include "dotsrc.h"
#include "test1.h"
#include "test2.h"
#include "test3.h"
#include "test4.h"

FILE *fp;

typedef struct f_table {
    char* f_name;
    void (*func)();
} Ftable;

Local void test_pseudo_object()
{
    printf("testing pseudo_object...\n");
}

Local Ftable f_table[] = {
    {"program", test_program},
    {"env_def", test_env_def},
    {"def_lib", test_def_lib},
    {"string", test_string},
    {"exp_def", test_exp_def},
    {"exp", test_exp},
    {"obj_def", test_obj_def},
    {"obj_sub", test_obj_sub},
    {"mod_def", test_mod_def},
    {"m_sub", test_m_sub},
    {"m_desc", test_m_desc},
    {"m2_desc", test_m2_desc},
    {"o_term", test_o_term},
    {"link_def", test_link_def},
    {"link", test_link},
    {"m_id_pair", test_m_id_pair},
    {"o_term_pair", test_o_term_pair},
    {"rule_def", test_rule_def},
    {"rule", test_rule},
    {"rule_id", test_rule_id},
    {"cluster", test_cluster},
    {"normal", test_normal},
    {"rel", test_rel},
    {"update", test_update},
    {"transaction", test_transaction},
    {"i_check", test_i_check},
    {"i_check", test_i_check_content},
    {"prop", test_prop},
    {"a_term", test_a_term},
    {"c_o_term", test_c_o_term},
    {"dot", test_dot},
    {"label", test_label},
    {"list", test_list},
    {"sub_list", test_sub_list},
    {"remain", test_remain},
    {"non_struct", test_non_struct},
    {"exp_name", test_exp_name},
    {"integer", test_integer},
    {"attr", test_attr},
    {"value", test_value},
    {"set", test_set},
    {"cnstr", test_cnstr},
    {"cnstr_data", test_cnstr_data},
    {"query_cnstr", test_query_cnstr},
    {"prolog", test_prolog},
    {"var", test_var},
    {"sort", test_sort},
    {"query", test_query},
    {"q_mode", test_q_mode},
    {"p_mode", test_p_mode},
    {"a_mode", test_a_mode},
    {"i_mode", test_i_mode},
    {"m_mode", test_m_mode},
    {"e_mode", test_e_mode},
    {"answer", test_answer},
    {"answer_element", test_answer_element},
    {"anse_explanation", test_anse_explanation},
    {"rir_pair", test_rir_pair},
    {"dot_cnstr", test_dot_cnstr},
    {"var_cnstr", test_var_cnstr},
    {"explanation", test_explanation},
    {"unit_explanation", test_unit_explanation},
    {"inherit", test_inherit},
    {"merge_explanation", test_merge_explanation},
    {"lookup_explanation", test_lookup_explanation},
    {"one_rule", test_one_rule},
    {"fact", test_fact},
    {"reduce", test_reduce},
    {"sub_goal", test_sub_goal},
    {"vc_pair", test_vc_pair},
    {"constraint", test_constraint},
    {"con", test_con},
    {"assump", test_assump},
    {"query_explanation", test_query_explanation},
    {"obj_list", test_obj_list},
    {"obj_array", test_obj_array},
    {"pseudo_object", test_pseudo_object}
};

Local Bool streqi(s1, s2)
     char *s1, *s2;
{
    do {
	if (*s1 == *s2)
	  continue;
	if (isascii(*s1) && isascii(*s2))
	  if (islower(*s1) && isupper(*s2) && toupper(*s1) == *s2)
	    continue;
	  else if (isupper(*s1) && islower(*s2) && tolower(*s1) == *s2)
	    continue;
	return FALSE;
    } while (s1++, *s2++);
    return TRUE;
}

Public void main(argc, argv)
     int argc;
     char** argv;
{
    int table_entries = sizeof(f_table)/sizeof(Ftable);
    int i, j;    

    init_memory_usage();
    fp = fopen(FILE_NAME, "wt");
    if (argc == 1)
      for (j = 0; j < table_entries; ++j)
 	f_table[j].func();
    else
      for (i = 1; i < argc; ++i)
 	for (j = 0; j < table_entries; ++j)
 	  if (streqi(argv[i], f_table[j].f_name)) {
 	      f_table[j].func();
 	      break;
 	  }
    fclose(fp);
}

