#include <assert.h>
#include <ctype.h>

#define MALLOC_DEBUG

#define INDENT 4

#include "dotsrc.h"

extern FILE *fp;

/*
 EXPLANATION (union)
*/

Local void test_explanation1()
{
    Explanation *explanation = NULL;

    assert(is_explanation(explanation));
    explanation = new_explanation();
    assert(is_explanation(explanation));
    delete_explanation(explanation);
    check_memory_usage("test_explanation1");
}

Local void test_explanation2()
{
    UnitExplanation *unit = new_unit_explanation(), 
                    *unit2 = copy_unit_explanation(unit);
    MergeExplanation *merge = new_merge_explanation(), 
                     *merge2 = copy_merge_explanation(merge);
    LookupExplanation *lookup = new_lookup_explanation(), 
                      *lookup2 = copy_lookup_explanation(lookup);
    OneRule *one_rule = new_one_rule(), *one_rule2 = copy_one_rule(one_rule);
    Inherit *inherit = new_inherit(), *inherit2 = copy_inherit(inherit);
    Reduce *reduce = new_reduce(), *reduce2 = copy_reduce(reduce);
    Fact *rule_id = new_fact(), *rule_id2 = copy_fact(rule_id);
    QueryExplanation *query = new_query_explanation(), 
                     *query2 = copy_query_explanation(query);
    Explanation *explanation = new_explanation();
    Explanation *explanation_unit = create_explanation_unit(unit);
    Explanation *explanation_merge = create_explanation_merge(merge);
    Explanation *explanation_lookup = create_explanation_lookup(lookup);
    Explanation *explanation_one_rule = 
      create_explanation_unit((UnitExplanation*)one_rule);
    Explanation *explanation_inherit = 
      create_explanation_unit((UnitExplanation*)inherit);
    Explanation *explanation_reduce = 
      create_explanation_unit((UnitExplanation*)reduce);
    Explanation *explanation_rule_id = 
      create_explanation_unit((UnitExplanation*)rule_id);
    Explanation *explanation_query = 
      create_explanation_unit((UnitExplanation*)query);
    PMode *p_mode = new_p_mode();

    assert(fis_explanation(explanation_unit) && 
	   fis_explanation(explanation_merge) && 
	   fis_explanation(explanation_lookup) && 
	   fis_explanation(explanation_one_rule) && 
	   fis_explanation(explanation_inherit) &&
	   fis_explanation(explanation_reduce) && 
	   fis_explanation(explanation_rule_id) &&
	   fis_explanation(explanation_query) &&
	   fis_explanation(explanation) &&
	   fis_explanation(NULL));
/*
    assert((UnitExplanation)explanation_unit == *unit2 && 
	   (MergeExplanation)explanation_merge == *merge2 && 
	   (LookupExplanation)explanation_lookup == *lookup2 && 
	   (OneRule)explanation_one_rule == *one_rule2 && 
	   (Inherit)explanation_inherit == *inherit2 &&
	   (Reduce)explanation_reduce == *reduce2 &&
	   (RuleId)explanation_rule_id == *rule_id2 &&
	   (QueryExplanation)explanation_query == *query2);
*/
    assert(! is_explanation(p_mode));
    assert(! fis_explanation(p_mode));
    delete_unit_explanation(unit2);
    delete_merge_explanation(merge2);
    delete_lookup_explanation(lookup2);
    delete_one_rule(one_rule2);
    delete_inherit(inherit2);
    delete_reduce(reduce2);
    delete_rule_id(rule_id2);
    delete_query_explanation(query2);
    delete_explanation(explanation);
    delete_explanation(explanation_unit);
    delete_explanation(explanation_merge);
    delete_explanation(explanation_lookup);
    delete_explanation(explanation_one_rule);
    delete_explanation(explanation_inherit);
    delete_explanation(explanation_reduce);
    delete_explanation(explanation_rule_id);
    delete_explanation(explanation_query);
    delete_p_mode(p_mode);
    check_memory_usage("test_explanation2");
}

Local void test_explanation3()
{
    Explanation *explanation_unit = 
      create_explanation_unit(new_unit_explanation()), 
                *explanation_unit2;
    Explanation *explanation_merge = 
      create_explanation_merge(new_merge_explanation()), 
                *explanation_merge2;
    Explanation *explanation_lookup = 
      create_explanation_lookup(new_lookup_explanation()), 
                *explanation_lookup2;
    Explanation *explanation_one_rule = 
      create_explanation_unit((UnitExplanation*)new_one_rule()), 
                *explanation_one_rule2;
    Explanation *explanation_inherit = 
      create_explanation_unit((UnitExplanation*)new_inherit()), 
                *explanation_inherit2;
    Explanation *explanation_reduce = 
      create_explanation_unit((UnitExplanation*)new_reduce()), 
                *explanation_reduce2;
    Explanation *explanation_rule_id = 
      create_explanation_unit((UnitExplanation*)new_fact()), 
                 *explanation_rule_id2;
    Explanation *explanation_query = 
      create_explanation_unit((UnitExplanation*)new_query_explanation()), 
                 *explanation_query2;

    assert(fis_unit_explanation(explanation_unit) && 
	   fis_merge_explanation(explanation_merge) && 
	   fis_lookup_explanation(explanation_lookup) && 
	   fis_one_rule(explanation_one_rule) && 
	   fis_inherit(explanation_inherit) &&
	   fis_reduce(explanation_reduce) && 
	   fis_fact(explanation_rule_id) &&
	   fis_query_explanation(explanation_query));
    explanation_unit2 = copy_explanation(explanation_unit);
    explanation_merge2 = copy_explanation(explanation_merge);
    explanation_lookup2 = copy_explanation(explanation_lookup);
    explanation_one_rule2 = copy_explanation(explanation_one_rule);
    explanation_inherit2 = copy_explanation(explanation_inherit);
    explanation_reduce2 = copy_explanation(explanation_reduce);
    explanation_rule_id2 = copy_explanation(explanation_rule_id);
    explanation_query2 = copy_explanation(explanation_query);
    delete_explanation(explanation_unit);
    delete_explanation(explanation_merge);
    delete_explanation(explanation_lookup);
    delete_explanation(explanation_one_rule);
    delete_explanation(explanation_inherit);
    delete_explanation(explanation_reduce);
    delete_explanation(explanation_rule_id);
    delete_explanation(explanation_query);
    delete_explanation(explanation_unit2);
    delete_explanation(explanation_merge2);
    delete_explanation(explanation_lookup2);
    delete_explanation(explanation_one_rule2);
    delete_explanation(explanation_inherit2);
    delete_explanation(explanation_reduce2);
    delete_explanation(explanation_rule_id2);
    delete_explanation(explanation_query2);
    check_memory_usage("test_explanation3");
}

Local void test_explanation4()
{
    Explanation *explanation = new_explanation(), *explanation2;
    Explanation *explanation_unit = 
      create_explanation_unit(new_unit_explanation()), 
                *explanation_unit2;
    Explanation *explanation_merge = 
      create_explanation_merge(new_merge_explanation()), 
                *explanation_merge2;
    Explanation *explanation_lookup = 
      create_explanation_lookup(new_lookup_explanation()), 
                *explanation_lookup2;
    Explanation *explanation_one_rule = 
      create_explanation_unit((UnitExplanation*)new_one_rule()), 
                *explanation_one_rule2;
    Explanation *explanation_inherit = 
      create_explanation_unit((UnitExplanation*)new_inherit()), 
                *explanation_inherit2;
    Explanation *explanation_reduce = 
      create_explanation_unit((UnitExplanation*)new_reduce()), 
                *explanation_reduce2;
    Explanation *explanation_rule_id = 
      create_explanation_unit((UnitExplanation*)new_fact()), 
                 *explanation_rule_id2;
    Explanation *explanation_query = 
      create_explanation_unit((UnitExplanation*)new_query_explanation()), 
                 *explanation_query2;
    int n;

    n = strcmp(type_name(explanation->tag), "EXPLANATION");
    assert(n == 0);
    assert(is_type(explanation->tag, EXPLANATION) &&
	   is_type(explanation_unit->tag, explanation->tag) &&
	   is_type(explanation_merge->tag, explanation->tag) &&
	   is_type(explanation_lookup->tag, explanation->tag) &&
	   is_type(explanation_one_rule->tag, explanation->tag) &&
	   is_type(explanation_inherit->tag, explanation->tag) &&
	   is_type(explanation_reduce->tag, explanation->tag) &&
	   is_type(explanation_rule_id->tag, explanation->tag) &&
	   is_type(explanation_query->tag, explanation->tag));
    explanation2 = (Explanation*)copy_pseudo_object(explanation);
    explanation_unit2 = (Explanation*)copy_pseudo_object(explanation_unit);
    explanation_merge2 = (Explanation*)copy_pseudo_object(explanation_merge);
    explanation_lookup2 = (Explanation*)copy_pseudo_object(explanation_lookup);
    explanation_one_rule2 = 
      (Explanation*)copy_pseudo_object(explanation_one_rule);
    explanation_inherit2 = 
      (Explanation*)copy_pseudo_object(explanation_inherit);
    explanation_reduce2 = 
      (Explanation*)copy_pseudo_object(explanation_reduce);
    explanation_rule_id2 = 
      (Explanation*)copy_pseudo_object(explanation_rule_id);
    explanation_query2 = 
      (Explanation*)copy_pseudo_object(explanation_query);
    print_pseudo_object(explanation2, fp, INDENT);
    print_pseudo_object(explanation_unit2, fp, INDENT);
    print_pseudo_object(explanation_merge2, fp, INDENT);
    print_pseudo_object(explanation_lookup2, fp, INDENT);
    print_pseudo_object(explanation_one_rule2, fp, INDENT);
    print_pseudo_object(explanation_inherit2, fp, INDENT);
    print_pseudo_object(explanation_reduce2, fp, INDENT);
    print_pseudo_object(explanation_rule_id2, fp, INDENT);
    print_pseudo_object(explanation_query2, fp, INDENT);
    delete_pseudo_object(explanation2);
    delete_pseudo_object(explanation_unit2);
    delete_pseudo_object(explanation_merge2);
    delete_pseudo_object(explanation_lookup2);
    delete_pseudo_object(explanation_one_rule2);
    delete_pseudo_object(explanation_inherit2);
    delete_pseudo_object(explanation_reduce2);
    delete_pseudo_object(explanation_rule_id2);
    delete_pseudo_object(explanation_query2);
    delete_explanation(explanation);
    delete_explanation(explanation_unit);
    delete_explanation(explanation_merge);
    delete_explanation(explanation_lookup);
    delete_explanation(explanation_one_rule);
    delete_explanation(explanation_inherit);
    delete_explanation(explanation_reduce);
    delete_explanation(explanation_rule_id);
    delete_explanation(explanation_query);
    check_memory_usage("test_explanation4");
}

Public void test_explanation()
{
    printf("testing explanation...\n");
    test_explanation1();
    test_explanation2();
    test_explanation3();
    test_explanation4();
}

/*
 UNIT_EXPLANATION (union)
*/

Local void test_unit_explanation1()
{
    UnitExplanation *unit_explanation = NULL;

    assert(is_unit_explanation(unit_explanation));
    unit_explanation = new_unit_explanation();
    assert(is_unit_explanation(unit_explanation));
    delete_unit_explanation(unit_explanation);
    check_memory_usage("test_unit_explanation1");
}

Local void test_unit_explanation2()
{
    OneRule *one_rule = new_one_rule(), *one_rule2 = copy_one_rule(one_rule);
    Inherit *inherit = new_inherit(), *inherit2 = copy_inherit(inherit);
    Reduce *reduce = new_reduce(), *reduce2 = copy_reduce(reduce);
    Fact *rule_id = new_fact(), *rule_id2 = copy_fact(rule_id);
    QueryExplanation *query = new_query_explanation(), *query2 = copy_query_explanation(query);
    UnitExplanation *unit_explanation = new_unit_explanation();
    UnitExplanation *unit_explanation_one_rule = 
      create_unit_explanation_one_rule(one_rule);
    UnitExplanation *unit_explanation_inherit = 
      create_unit_explanation_inherit(inherit);
    UnitExplanation *unit_explanation_reduce = 
      create_unit_explanation_one_rule((OneRule*)reduce);
    UnitExplanation *unit_explanation_rule_id = 
      create_unit_explanation_one_rule((OneRule*)rule_id);
    UnitExplanation *unit_explanation_query = 
      create_unit_explanation_one_rule((OneRule*)query);
    PMode *p_mode = new_p_mode();

    assert(fis_unit_explanation(unit_explanation_one_rule) && 
	   fis_unit_explanation(unit_explanation_inherit) &&
	   fis_unit_explanation(unit_explanation_reduce) && 
	   fis_unit_explanation(unit_explanation_rule_id) &&
	   fis_unit_explanation(unit_explanation_query) &&
	   fis_unit_explanation(unit_explanation) &&
	   fis_unit_explanation(NULL));
/*
    assert((OneRule)unit_explanation_one_rule == *one_rule2 && 
	   (Inherit)unit_explanation_inherit == *inherit2 &&
	   (Reduce)unit_explanation_reduce == *reduce2 &&
	   (RuleId)unit_explanation_rule_id == *rule_id2 &&
	   (QueryExplanation)unit_explanation_query == *query2);
*/
    assert(! is_unit_explanation(p_mode));
    assert(! fis_unit_explanation(p_mode));
    delete_one_rule(one_rule2);
    delete_inherit(inherit2);
    delete_reduce(reduce2);
    delete_rule_id(rule_id2);
    delete_query_explanation(query2);
    delete_unit_explanation(unit_explanation);
    delete_unit_explanation(unit_explanation_one_rule);
    delete_unit_explanation(unit_explanation_inherit);
    delete_unit_explanation(unit_explanation_reduce);
    delete_unit_explanation(unit_explanation_rule_id);
    delete_unit_explanation(unit_explanation_query);
    delete_p_mode(p_mode);
    check_memory_usage("test_unit_explanation2");
}

Local void test_unit_explanation3()
{
    UnitExplanation *unit_explanation_one_rule = 
      create_unit_explanation_one_rule(new_one_rule()), 
                    *unit_explanation_one_rule2;
    UnitExplanation *unit_explanation_inherit = 
      create_unit_explanation_inherit(new_inherit()), 
                    *unit_explanation_inherit2;
    UnitExplanation *unit_explanation_reduce = 
      create_unit_explanation_one_rule((OneRule*)new_reduce()), 
                    *unit_explanation_reduce2;
    UnitExplanation *unit_explanation_rule_id = 
      create_unit_explanation_one_rule((OneRule*)new_fact()), 
                    *unit_explanation_rule_id2;
    UnitExplanation *unit_explanation_query = 
      create_unit_explanation_one_rule((OneRule*)new_query_explanation()), 
                    *unit_explanation_query2;

    assert(fis_one_rule(unit_explanation_one_rule) && 
	   fis_inherit(unit_explanation_inherit) &&
	   fis_reduce(unit_explanation_reduce) && 
	   fis_fact(unit_explanation_rule_id) &&
	   fis_query_explanation(unit_explanation_query));
    unit_explanation_one_rule2 = 
      copy_unit_explanation(unit_explanation_one_rule);
    unit_explanation_inherit2 = 
      copy_unit_explanation(unit_explanation_inherit);
    unit_explanation_reduce2 = 
      copy_unit_explanation(unit_explanation_reduce);
    unit_explanation_rule_id2 = 
      copy_unit_explanation(unit_explanation_rule_id);
    unit_explanation_query2 = 
      copy_unit_explanation(unit_explanation_query);
    delete_unit_explanation(unit_explanation_one_rule);
    delete_unit_explanation(unit_explanation_inherit);
    delete_unit_explanation(unit_explanation_reduce);
    delete_unit_explanation(unit_explanation_rule_id);
    delete_unit_explanation(unit_explanation_query);
    delete_unit_explanation(unit_explanation_one_rule2);
    delete_unit_explanation(unit_explanation_inherit2);
    delete_unit_explanation(unit_explanation_reduce2);
    delete_unit_explanation(unit_explanation_rule_id2);
    delete_unit_explanation(unit_explanation_query2);
    check_memory_usage("test_unit_explanation3");
}

Local void test_unit_explanation4()
{
    UnitExplanation *unit_explanation = new_unit_explanation(), 
                     *unit_explanation2;
    UnitExplanation *unit_explanation_one_rule = 
      create_unit_explanation_one_rule(new_one_rule()), 
                    *unit_explanation_one_rule2;
    UnitExplanation *unit_explanation_inherit = 
      create_unit_explanation_inherit(new_inherit()), 
                    *unit_explanation_inherit2;
    UnitExplanation *unit_explanation_reduce = 
      create_unit_explanation_one_rule((OneRule*)new_reduce()), 
                    *unit_explanation_reduce2;
    UnitExplanation *unit_explanation_rule_id = 
      create_unit_explanation_one_rule((OneRule*)new_fact()), 
                    *unit_explanation_rule_id2;
    UnitExplanation *unit_explanation_query = 
      create_unit_explanation_one_rule((OneRule*)new_query_explanation()), 
                    *unit_explanation_query2;
    int n;

    n = strcmp(type_name(unit_explanation->tag), "UNIT_EXPLANATION");
    assert(n == 0);    
    assert(is_type(unit_explanation->tag, UNIT_EXPLANATION) &&
	   is_type(unit_explanation_one_rule->tag, unit_explanation->tag) &&
	   is_type(unit_explanation_inherit->tag, unit_explanation->tag) &&
	   is_type(unit_explanation_reduce->tag, unit_explanation->tag) &&
	   is_type(unit_explanation_rule_id->tag, unit_explanation->tag) &&
	   is_type(unit_explanation_query->tag, unit_explanation->tag));
    unit_explanation2 = 
      (UnitExplanation*)copy_pseudo_object(unit_explanation);
    unit_explanation_one_rule2 = 
      (UnitExplanation*)copy_pseudo_object(unit_explanation_one_rule);
    unit_explanation_inherit2 = 
      (UnitExplanation*)copy_pseudo_object(unit_explanation_inherit);
    unit_explanation_reduce2 = 
      (UnitExplanation*)copy_pseudo_object(unit_explanation_reduce);
    unit_explanation_rule_id2 = 
      (UnitExplanation*)copy_pseudo_object(unit_explanation_rule_id);
    unit_explanation_query2 = 
      (UnitExplanation*)copy_pseudo_object(unit_explanation_query);
    print_pseudo_object(unit_explanation2, fp, INDENT);
    print_pseudo_object(unit_explanation_one_rule2, fp, INDENT);
    print_pseudo_object(unit_explanation_inherit2, fp, INDENT);
    print_pseudo_object(unit_explanation_reduce2, fp, INDENT);
    print_pseudo_object(unit_explanation_rule_id2, fp, INDENT);
    print_pseudo_object(unit_explanation_query2, fp, INDENT);
    delete_pseudo_object(unit_explanation2);
    delete_pseudo_object(unit_explanation_one_rule2);
    delete_pseudo_object(unit_explanation_inherit2);
    delete_pseudo_object(unit_explanation_reduce2);
    delete_pseudo_object(unit_explanation_rule_id2);
    delete_pseudo_object(unit_explanation_query2);
    delete_unit_explanation(unit_explanation);
    delete_unit_explanation(unit_explanation_one_rule);
    delete_unit_explanation(unit_explanation_inherit);
    delete_unit_explanation(unit_explanation_reduce);
    delete_unit_explanation(unit_explanation_rule_id);
    delete_unit_explanation(unit_explanation_query);
    check_memory_usage("test_unit_explanation4");
}

Public void test_unit_explanation()
{
    printf("testing unit_explanation...\n");
    test_unit_explanation1();
    test_unit_explanation2();
    test_unit_explanation3();
    test_unit_explanation4();
}

/*
 INHERIT (have ObjList)
*/

Local void test_inherit1()
{
    Inherit *inherit = NULL;

    assert(is_inherit(inherit));
    inherit = new_inherit();
    assert(is_inherit(inherit));
    delete_inherit(inherit);
    check_memory_usage("test_inherit1");
}

Local void test_inherit2()
{
    OneRule *one_rule = new_one_rule(), *one_rule2;
    ObjList *ups = new_obj_list(ONE_RULE), *ups2;
    ObjList *downs = new_obj_list(ONE_RULE), *downs2;
    Inherit *inherit = create_inherit(one_rule, ups, downs);

    assert(fis_inherit(NULL));
    assert(fis_inherit(inherit));
    assert(! is_inherit(one_rule));
    assert(! fis_inherit(one_rule));
    decompose_inherit(inherit, &one_rule2, &ups2, &downs2);
    assert(one_rule2 == one_rule && ups2 == ups && downs2 == downs);
    assert(read_one_rule(inherit) == one_rule &&
	   read_ups(inherit) == ups &&
	   read_downs(inherit) == downs);
    assert(mread_one_rule(inherit) == one_rule &&
	   mread_ups(inherit) == ups &&
	   mread_downs(inherit) == downs);
    delete_inherit(inherit);
    check_memory_usage("test_inherit2");
}

Local void test_inherit3()
{
    Inherit *inherit = new_inherit();
    OneRule *one_rule = new_one_rule(), *one_rule2;
    ObjList *ups = new_obj_list(ONE_RULE), *ups2;
    ObjList *downs = new_obj_list(ONE_RULE), *downs2;

    decompose_inherit(
      set_inherit(inherit, one_rule, ups, downs), 
      &one_rule2, &ups2, &downs2);
    assert(one_rule2 == one_rule && ups2 == ups && downs2 == downs);
    delete_inherit(inherit);
    check_memory_usage("test_inherit3");
}

Local void test_inherit4()
{
    Inherit *inherit = new_inherit(), *inherit2, *inherit3 = new_inherit();
    OneRule *one_rule = new_one_rule(), *one_rule2;
    ObjList *ups = new_obj_list(ONE_RULE), *ups2;
    ObjList *downs = new_obj_list(ONE_RULE), *downs2;

    decompose_inherit(
      write_one_rule(
        write_ups(
	  write_downs(inherit, downs),
          ups),
        one_rule),
      &one_rule2, &ups2, &downs2);
    assert(one_rule2 == one_rule && ups2 == ups && downs2 == downs);
    one_rule = new_one_rule();
    ups = new_obj_list(ONE_RULE);
    downs = new_obj_list(ONE_RULE);
    decompose_inherit(
      mwrite_one_rule(
        mwrite_ups(
	  mwrite_downs(inherit3, downs),
          ups),
        one_rule),
      &one_rule2, &ups2, &downs2);
    assert(one_rule2 == one_rule && ups2 == ups && downs2 == downs);
    inherit2 = copy_inherit(inherit);
    delete_inherit(inherit);
    delete_inherit(inherit2);
    delete_inherit(inherit3);
    check_memory_usage("test_inherit4");
}

Local void test_inherit5()
{
    Inherit *inherit;
    ObjList *obj_list, *obj_list2, *obj_list3, *obj_list4; 
    OneRule *up, *up2, *up3, *up4;
    OneRule *down, *down2, *down3, *down4;

    inherit = new_inherit();
    obj_list = new_obj_list(ONE_RULE);
    obj_list2 = new_obj_list(ONE_RULE);
    obj_list3 = new_obj_list(ONE_RULE);
    obj_list4 = new_obj_list(ONE_RULE);
    up = new_one_rule();
    up2 = new_one_rule();
    up3 = new_one_rule();
    up4 = new_one_rule();
    down = new_one_rule();
    down2 = new_one_rule();
    down3 = new_one_rule();
    down4 = new_one_rule();
    append_to_obj_list(append_to_obj_list(obj_list, up), up2);
    append_to_obj_list(append_to_obj_list(obj_list2, up3), up4);
    append_to_obj_list(append_to_obj_list(obj_list3, down), down2);
    append_to_obj_list(append_to_obj_list(obj_list4, down3), down4);
    insert_ups(insert_ups(inherit, obj_list2), obj_list);
    insert_downs(insert_downs(inherit, obj_list4), obj_list3);
    assert(car_of_ups(inherit) == up &&
	   car_of_ups(inherit) == up2 &&
	   car_of_ups(inherit) == up3 &&
	   car_of_ups(inherit) == up4);
    assert(car_of_downs(inherit) == down &&
	   car_of_downs(inherit) == down2 &&
	   car_of_downs(inherit) == down3 &&
	   car_of_downs(inherit) == down4);

    obj_list = new_obj_list(ONE_RULE);
    obj_list2 = new_obj_list(ONE_RULE);
    obj_list3 = new_obj_list(ONE_RULE);
    obj_list4 = new_obj_list(ONE_RULE);
    cons_to_obj_list(cons_to_obj_list(obj_list, up), up2);
    cons_to_obj_list(cons_to_obj_list(obj_list2, up3), up4);
    cons_to_obj_list(cons_to_obj_list(obj_list3, down), down2);
    cons_to_obj_list(cons_to_obj_list(obj_list4, down3), down4);
    add_ups(add_ups(inherit, obj_list2), obj_list);
    add_downs(add_downs(inherit, obj_list4), obj_list3);
    assert(car_of_ups(inherit) == up4 &&
	   car_of_ups(inherit) == up3 &&
	   car_of_ups(inherit) == up2 &&
	   car_of_ups(inherit) == up);
    assert(car_of_downs(inherit) == down4 &&
	   car_of_downs(inherit) == down3 &&
	   car_of_downs(inherit) == down2 &&
	   car_of_downs(inherit) == down);
    delete_one_rule(up);
    delete_one_rule(up2);
    delete_one_rule(up3);
    delete_one_rule(up4);
    delete_one_rule(down);
    delete_one_rule(down2);
    delete_one_rule(down3);
    delete_one_rule(down4);
    delete_inherit(inherit);
    check_memory_usage("test_inherit5");
}

Local void test_inherit6()
{
    Inherit *inherit = new_inherit(), *inherit2;
    OneRule *one_rule = new_one_rule();
    ObjList *ups = new_obj_list(ONE_RULE);
    ObjList *downs = new_obj_list(ONE_RULE);
    int n;

    n = strcmp(type_name(inherit->tag), "INHERIT");
    assert(n == 0);
    assert(is_type(inherit->tag, INHERIT));
    inherit2 = (Inherit*)copy_pseudo_object
      (set_inherit(inherit, one_rule, ups, downs));
    print_pseudo_object(inherit2, fp, INDENT);
    delete_pseudo_object(inherit2);
    delete_inherit(inherit);
    check_memory_usage("test_inherit6");
}

Public void test_inherit()
{
    printf("testing inherit...\n");
    test_inherit1();
    test_inherit2();
    test_inherit3();
    test_inherit4();
    test_inherit5();
    test_inherit6();
}

/*
 MERGE_EXPLANATION (have ObjList)
*/

Local void test_merge_explanation1()
{
    MergeExplanation *merge_explanation = NULL;

    assert(is_merge_explanation(merge_explanation));
    merge_explanation = new_merge_explanation();
    assert(is_merge_explanation(merge_explanation));
    delete_merge_explanation(merge_explanation);
    check_memory_usage("test_merge_explanation1");
}

Local void test_merge_explanation2()
{
    ObjList *unit_explanations = new_obj_list(UNIT_EXPLANATION), 
            *unit_explanations2;
    MergeExplanation *merge_explanation = 
      create_merge_explanation(unit_explanations);

    assert(fis_merge_explanation(NULL));
    assert(fis_merge_explanation(merge_explanation));
    assert(! is_merge_explanation(unit_explanations));
    assert(! fis_merge_explanation(unit_explanations));
    decompose_merge_explanation(merge_explanation, &unit_explanations2);
    assert(unit_explanations2 == unit_explanations);
    assert(read_unit_explanations(merge_explanation) == unit_explanations);
    assert(mread_unit_explanations(merge_explanation) == unit_explanations);
    delete_merge_explanation(merge_explanation);
    check_memory_usage("test_merge_explanation2");
}

Local void test_merge_explanation3()
{
    MergeExplanation *merge_explanation = new_merge_explanation();
    ObjList *unit_explanations = new_obj_list(UNIT_EXPLANATION), 
            *unit_explanations2;

    decompose_merge_explanation(
      set_merge_explanation(merge_explanation, unit_explanations), 
      &unit_explanations2);
    assert(unit_explanations2 == unit_explanations);
    delete_merge_explanation(merge_explanation);
    check_memory_usage("test_merge_explanation3");
}

Local void test_merge_explanation4()
{
    MergeExplanation *merge_explanation = new_merge_explanation(), 
                     *merge_explanation2,
                     *merge_explanation3 = new_merge_explanation();
    ObjList *unit_explanations = new_obj_list(UNIT_EXPLANATION), 
            *unit_explanations2;

    decompose_merge_explanation(
      write_unit_explanations(merge_explanation, unit_explanations),
      &unit_explanations2);
    assert(unit_explanations2 == unit_explanations);
    unit_explanations = new_obj_list(UNIT_EXPLANATION);
    decompose_merge_explanation(
      mwrite_unit_explanations(merge_explanation3, unit_explanations),
      &unit_explanations2);
    assert(unit_explanations2 == unit_explanations);
    merge_explanation2 = copy_merge_explanation(merge_explanation);
    delete_merge_explanation(merge_explanation);
    delete_merge_explanation(merge_explanation2);
    delete_merge_explanation(merge_explanation3);
    check_memory_usage("test_merge_explanation4");
}

Local void test_merge_explanation5()
{
    MergeExplanation *merge_explanation;
    ObjList *obj_list, *obj_list2;
    UnitExplanation *unit_explanation, *unit_explanation2, *unit_explanation3, 
                    *unit_explanation4;

    merge_explanation = new_merge_explanation();
    obj_list = new_obj_list(UNIT_EXPLANATION);
    obj_list2 = new_obj_list(UNIT_EXPLANATION);
    unit_explanation = new_unit_explanation();
    unit_explanation2 = new_unit_explanation();
    unit_explanation3 = new_unit_explanation();
    unit_explanation4 = new_unit_explanation();
    append_to_obj_list(append_to_obj_list(obj_list, unit_explanation), 
		         unit_explanation2);
    append_to_obj_list(append_to_obj_list(obj_list2, unit_explanation3), 
		         unit_explanation4);
    insert_unit_explanations
      (insert_unit_explanations(merge_explanation, obj_list2), obj_list);
    assert(car_of_unit_explanations(merge_explanation) == unit_explanation &&
	   car_of_unit_explanations(merge_explanation) == unit_explanation2 &&
	   car_of_unit_explanations(merge_explanation) == unit_explanation3 &&
	   car_of_unit_explanations(merge_explanation) == unit_explanation4);

    obj_list = new_obj_list(UNIT_EXPLANATION);
    obj_list2 = new_obj_list(UNIT_EXPLANATION);
    cons_to_obj_list(cons_to_obj_list(obj_list, unit_explanation), 
		       unit_explanation2);
    cons_to_obj_list(cons_to_obj_list(obj_list2, unit_explanation3), 
		       unit_explanation4);
    add_unit_explanations
      (add_unit_explanations(merge_explanation, obj_list2), obj_list);
    assert(car_of_unit_explanations(merge_explanation) == unit_explanation4 &&
	   car_of_unit_explanations(merge_explanation) == unit_explanation3 &&
	   car_of_unit_explanations(merge_explanation) == unit_explanation2 &&
	   car_of_unit_explanations(merge_explanation) == unit_explanation);
    delete_unit_explanation(unit_explanation);
    delete_unit_explanation(unit_explanation2);
    delete_unit_explanation(unit_explanation3);
    delete_unit_explanation(unit_explanation4);
    delete_merge_explanation(merge_explanation);
    check_memory_usage("test_merge_explanation5");
}

Local void test_merge_explanation6()
{
    MergeExplanation *merge_explanation = new_merge_explanation(), 
                     *merge_explanation2;
    ObjList *unit_explanations = new_obj_list(UNIT_EXPLANATION);
    int n;

    n = strcmp(type_name(merge_explanation->tag), "MERGE_EXPLANATION");
    assert(n == 0);
    assert(is_type(merge_explanation->tag, MERGE_EXPLANATION));
    merge_explanation2 = (MergeExplanation*)copy_pseudo_object
      (set_merge_explanation(merge_explanation, unit_explanations));
    print_pseudo_object(merge_explanation2, fp, INDENT);
    delete_pseudo_object(merge_explanation2);
    delete_merge_explanation(merge_explanation);
    check_memory_usage("test_merge_explanation6");
}

Public void test_merge_explanation()
{
    printf("testing merge_explanation...\n");
    test_merge_explanation1();
    test_merge_explanation2();
    test_merge_explanation3();
    test_merge_explanation4();
    test_merge_explanation5();
    test_merge_explanation6();
}

/*
 LOOKUP_EXPLANATION
*/

Local void test_lookup_explanation1()
{
    LookupExplanation *lookup_explanation = NULL;

    assert(is_lookup_explanation(lookup_explanation));
    lookup_explanation = new_lookup_explanation();
    assert(is_lookup_explanation(lookup_explanation));
    delete_lookup_explanation(lookup_explanation);
    check_memory_usage("test_lookup_explanation1");
}

Local void test_lookup_explanation2()
{
    SubGoal *sub_goal = new_sub_goal(), *sub_goal2;
    int looked_s = NULL, looked_s2;
    int looking_s = NULL, looking_s2;
    Explanation *explanation = new_explanation(), *explanation2;
    LookupExplanation *lookup_explanation = 
      create_lookup_explanation(sub_goal,looked_s, looking_s, explanation);

    assert(fis_lookup_explanation(NULL));
    assert(fis_lookup_explanation(lookup_explanation));
    assert(! is_lookup_explanation(sub_goal));
    assert(! fis_lookup_explanation(sub_goal));
    decompose_lookup_explanation(lookup_explanation, 
      &sub_goal2, &looked_s2, &looking_s2, &explanation2);
    assert(sub_goal2 == sub_goal && looked_s2 == looked_s &&
	   looking_s2 == looking_s && explanation2 == explanation);
    assert(read_sub_goal_inLookupExplanation(lookup_explanation)
	     == sub_goal &&
	   read_looked_s(lookup_explanation) == looked_s &&
	   read_looking_s(lookup_explanation) == looking_s &&
	   read_explanation_inLookupExplanation(lookup_explanation) 
	     == explanation);
    assert(mread_sub_goal_inLookupExplanation(lookup_explanation)
	     == sub_goal &&
	   mread_looked_s(lookup_explanation) == looked_s &&
	   mread_looking_s(lookup_explanation) == looking_s &&
	   mread_explanation_inLookupExplanation(lookup_explanation) 
	     == explanation);
    delete_lookup_explanation(lookup_explanation);
    check_memory_usage("test_lookup_explanation2");
}

Local void test_lookup_explanation3()
{
    LookupExplanation *lookup_explanation = new_lookup_explanation();
    SubGoal *sub_goal = new_sub_goal(), *sub_goal2;
    int looked_s = NULL, looked_s2;
    int looking_s = NULL, looking_s2;
    Explanation *explanation = new_explanation(), *explanation2;

    decompose_lookup_explanation(
      set_lookup_explanation(lookup_explanation, sub_goal,
        looked_s, looking_s, explanation), 
      &sub_goal2, &looked_s2, &looking_s2, &explanation2);
    assert(sub_goal2 == sub_goal && looked_s2 == looked_s &&
	   looking_s2 == looking_s && explanation2 == explanation);
    delete_lookup_explanation(lookup_explanation);
    check_memory_usage("test_lookup_explanation3");
}

Local void test_lookup_explanation4()
{
    LookupExplanation *lookup_explanation = new_lookup_explanation(), 
                      *lookup_explanation2,
                      *lookup_explanation3 = new_lookup_explanation();
    SubGoal *sub_goal = new_sub_goal(), *sub_goal2;
    int looked_s = NULL, looked_s2;
    int looking_s = NULL, looking_s2;
    Explanation *explanation = new_explanation(), *explanation2;

    decompose_lookup_explanation(
      write_sub_goal_inLookupExplanation(
        write_looked_s(
          write_looking_s(
            write_explanation_inLookupExplanation(
	      lookup_explanation, explanation),
	    looking_s),
          looked_s),
        sub_goal),
      &sub_goal2, &looked_s2, &looking_s2, &explanation2);      
    assert(sub_goal2 == sub_goal && looked_s2 == looked_s &&
	   looking_s2 == looking_s && explanation2 == explanation);
    sub_goal = new_sub_goal();
    looked_s = NULL;
    looking_s = NULL;
    explanation = new_explanation();
    decompose_lookup_explanation(
      mwrite_sub_goal_inLookupExplanation(
        mwrite_looked_s(
          mwrite_looking_s(
            mwrite_explanation_inLookupExplanation(
	      lookup_explanation3, explanation),
	    looking_s),
          looked_s),
        sub_goal),
      &sub_goal2, &looked_s2, &looking_s2, &explanation2);      
    assert(sub_goal2 == sub_goal && looked_s2 == looked_s &&
	   looking_s2 == looking_s && explanation2 == explanation);
    lookup_explanation2 = copy_lookup_explanation(lookup_explanation);
    delete_lookup_explanation(lookup_explanation);
    delete_lookup_explanation(lookup_explanation2);
    delete_lookup_explanation(lookup_explanation3);
    check_memory_usage("test_lookup_explanation4");
}

Local void test_lookup_explanation5()
{
    LookupExplanation *lookup_explanation = new_lookup_explanation(), 
                      *lookup_explanation2;
    SubGoal *sub_goal = new_sub_goal();
    int looked_s = NULL;
    int looking_s = NULL;
    Explanation *explanation = new_explanation();
    int n;

    n = strcmp(type_name(lookup_explanation->tag), "LOOKUP_EXPLANATION");
    assert(n == 0);
    assert(is_type(lookup_explanation->tag, LOOKUP_EXPLANATION));
    lookup_explanation2 = (LookupExplanation*)copy_pseudo_object
      (set_lookup_explanation(lookup_explanation, sub_goal,
			      looked_s, looking_s, explanation));
    print_pseudo_object(lookup_explanation2, fp, INDENT);
    delete_pseudo_object(lookup_explanation2);
    delete_lookup_explanation(lookup_explanation);
    check_memory_usage("test_lookup_explanation5");
}

Public void test_lookup_explanation()
{
    printf("testing lookup_explanation...\n");
    test_lookup_explanation1();
    test_lookup_explanation2();
    test_lookup_explanation3();
    test_lookup_explanation4();
    test_lookup_explanation5();
}

/*
 ONE_RULE (union)
*/

Local void test_one_rule1()
{
    OneRule *one_rule = NULL;

    assert(is_one_rule(one_rule));
    one_rule = new_one_rule();
    assert(is_one_rule(one_rule));
    delete_one_rule(one_rule);
    check_memory_usage("test_one_rule1");
}

Local void test_one_rule2()
{
    Reduce *reduce = new_reduce(), *reduce2 = copy_reduce(reduce);
    Fact *rule_id = new_fact(), *rule_id2 = copy_fact(rule_id);
    QueryExplanation *query = new_query_explanation(), *query2 = copy_query_explanation(query);
    OneRule *one_rule = new_one_rule();
    OneRule *one_rule_reduce = create_one_rule_reduce(reduce);
    OneRule *one_rule_rule_id = create_one_rule_rule_id(rule_id);
    OneRule *one_rule_query = create_one_rule_query(query);
    PMode *p_mode = new_p_mode();

    assert(fis_one_rule(one_rule_reduce) && fis_one_rule(one_rule_rule_id) &&
	   fis_one_rule(one_rule_query) && fis_one_rule(one_rule) &&
	   fis_one_rule(NULL));
/*
    assert((Reduce)one_rule_reduce == *reduce2 && 
	   (Fact)one_rule_rule_id == *rule_id2 &&
	   (QueryExplanation)one_rule_query == *query2);
*/
    assert(! is_one_rule(p_mode));
    assert(! fis_one_rule(p_mode));
    delete_reduce(reduce2);
    delete_fact(rule_id2);
    delete_query_explanation(query2);
    delete_one_rule(one_rule);
    delete_one_rule(one_rule_reduce);
    delete_one_rule(one_rule_rule_id);
    delete_one_rule(one_rule_query);
    delete_p_mode(p_mode);
    check_memory_usage("test_one_rule2");
}

Local void test_one_rule3()
{
    OneRule *one_rule_reduce = create_one_rule_reduce(new_reduce()), 
            *one_rule_reduce2;
    OneRule *one_rule_rule_id = create_one_rule_rule_id(new_fact()), 
            *one_rule_rule_id2;
    OneRule *one_rule_query = create_one_rule_query(new_query_explanation()), 
            *one_rule_query2;

    assert(fis_reduce(one_rule_reduce) && 
	   fis_fact(one_rule_rule_id) &&
	   fis_query_explanation(one_rule_query));
    one_rule_reduce2 = copy_one_rule(one_rule_reduce);
    one_rule_rule_id2 = copy_one_rule(one_rule_rule_id);
    one_rule_query2 = copy_one_rule(one_rule_query);
    delete_one_rule(one_rule_reduce);
    delete_one_rule(one_rule_rule_id);
    delete_one_rule(one_rule_query);
    delete_one_rule(one_rule_reduce2);
    delete_one_rule(one_rule_rule_id2);
    delete_one_rule(one_rule_query2);
    check_memory_usage("test_one_rule3");
}


Local void test_one_rule4()
{
    OneRule *one_rule = new_one_rule(), *one_rule2;
    OneRule *one_rule_reduce = create_one_rule_reduce(new_reduce()),
            *one_rule_reduce2;
    OneRule *one_rule_rule_id = create_one_rule_rule_id(new_fact()),
            *one_rule_rule_id2;
    OneRule *one_rule_query = create_one_rule_query(new_query_explanation()),
            *one_rule_query2;
    int n;

    n = strcmp(type_name(one_rule->tag), "ONE_RULE");
    assert(n == 0);
    assert(is_type(one_rule->tag, ONE_RULE) &&
	   is_type(one_rule_reduce->tag, one_rule->tag) &&
	   is_type(one_rule_rule_id->tag, one_rule->tag) &&
	   is_type(one_rule_query->tag, one_rule->tag));
    one_rule2 = (OneRule*)copy_pseudo_object(one_rule);
    one_rule_reduce2 = 
      (OneRule*)copy_pseudo_object(one_rule_reduce);
    one_rule_rule_id2 = 
      (OneRule*)copy_pseudo_object(one_rule_rule_id);
    one_rule_query2 = 
      (OneRule*)copy_pseudo_object(one_rule_query);
    print_pseudo_object(one_rule2, fp, INDENT);
    print_pseudo_object(one_rule_reduce2, fp, INDENT);
    print_pseudo_object(one_rule_rule_id2, fp, INDENT);
    print_pseudo_object(one_rule_query2, fp, INDENT);
    delete_pseudo_object(one_rule2);
    delete_pseudo_object(one_rule_reduce2);
    delete_pseudo_object(one_rule_rule_id2);
    delete_pseudo_object(one_rule_query2);
    delete_one_rule(one_rule);
    delete_one_rule(one_rule_reduce);
    delete_one_rule(one_rule_rule_id);
    delete_one_rule(one_rule_query);
    check_memory_usage("test_one_rule4");
}

Public void test_one_rule()
{
    printf("testing one_rule...\n");
    test_one_rule1();
    test_one_rule2();
    test_one_rule3();
    test_one_rule4();
}


/*
 FACT
*/

Local void test_fact1()
{
    Fact *fact = NULL;

    assert(is_fact(fact));
    fact = new_fact();
    assert(is_fact(fact));
    delete_fact(fact);
    check_memory_usage("test_fact1");
}

#define TEST_FACT_DATA "Factiable"

Local void test_fact2()
{
    char *fact_data = dotsrc_malloc(strlen(TEST_FACT_DATA) + 1), *fact_data2;
    Fact *fact = create_fact(fact_data);
    Sort *sort = new_sort();

    strcpy(fact_data, TEST_FACT_DATA);
    assert(fis_fact(NULL));
    assert(fis_fact(fact));
    assert(! is_fact(sort));
    assert(! fis_fact(sort));
    decompose_fact(fact, &fact_data2);
    assert(fact_data2 == fact_data);
    assert(read_fact_data(fact) == fact_data);
    assert(mread_fact_data(fact) == fact_data);
    delete_fact(fact);
    delete_sort(sort);
    check_memory_usage("test_fact2");
}

Local void test_fact3()
{
    Fact *fact = new_fact();
    char *fact_data = dotsrc_malloc(strlen(TEST_FACT_DATA)), *fact_data2;

    strcpy(fact_data, TEST_FACT_DATA);
    decompose_fact(set_fact(fact, fact_data), &fact_data2);
    assert(fact_data2 == fact_data);
    delete_fact(fact);
    check_memory_usage("test_fact3");
}

Local void test_fact4()
{
    Fact *fact = new_fact(), *fact2, *fact3 = new_fact();
    char *fact_data = dotsrc_malloc(strlen(TEST_FACT_DATA)), *fact_data2;

    strcpy(fact_data, TEST_FACT_DATA);
    decompose_fact(write_fact_data(fact, fact_data), &fact_data2);
    assert(fact_data2 == fact_data);
    fact_data = dotsrc_malloc(strlen(TEST_FACT_DATA));
    strcpy(fact_data, TEST_FACT_DATA);
    decompose_fact(mwrite_fact_data(fact3, fact_data), &fact_data2);
    assert(fact_data2 == fact_data);
    fact2 = copy_fact(fact);
    delete_fact(fact);
    delete_fact(fact2);
    delete_fact(fact3);
    check_memory_usage("test_fact4");
}


Local void test_fact5()
{
    Fact *fact = new_fact(), *fact2;
    char *fact_data = dotsrc_malloc(strlen(TEST_FACT_DATA));
    int n;

    strcpy(fact_data, TEST_FACT_DATA);
    n = strcmp(type_name(fact->tag), "FACT");
    assert(n == 0);
    assert(is_type(fact->tag, FACT));
    fact2 = (Fact*)copy_pseudo_object(set_fact(fact, fact_data));
    print_pseudo_object(fact2, fp, INDENT);
    delete_pseudo_object(fact2);
    delete_fact(fact);
    check_memory_usage("test_fact5");
}

Public void test_fact()
{
    printf("testing fact...\n");
    test_fact1();
    test_fact2();
    test_fact3();
    test_fact4();
    test_fact5();
}

/*
 REDUCE (have ObjList)
*/

Local void test_reduce1()
{
    Reduce *reduce = NULL;

    assert(is_reduce(reduce));
    reduce = new_reduce();
    assert(is_reduce(reduce));
    delete_reduce(reduce);
    check_memory_usage("test_reduce1");
}

Local void test_reduce2()
{
    SubGoal *sub_goal = new_sub_goal(), *sub_goal2;
    RuleId *rule_id = new_rule_id(), *rule_id2;
    ObjList *explanations = new_obj_list(EXPLANATION), *explanations2;
    ObjList *assumps = new_obj_list(ASSUMP), *assumps2;
    Reduce *reduce = 
      create_reduce(sub_goal, rule_id, explanations, assumps);

    assert(fis_reduce(NULL));
    assert(fis_reduce(reduce));
    assert(! is_reduce(sub_goal));
    assert(! fis_reduce(sub_goal));
    decompose_reduce(
      reduce, &sub_goal2, &rule_id2, &explanations2, &assumps2);
    assert(sub_goal2 == sub_goal && rule_id2 == rule_id && 
	   explanations2 == explanations && assumps2 == assumps);
    assert(read_sub_goal_inReduce(reduce) == sub_goal &&
	   read_rule_id_inReduce(reduce) == rule_id &&
	   read_explanations(reduce) == explanations &&
	   read_assumps(reduce) == assumps);
    assert(mread_sub_goal_inReduce(reduce) == sub_goal &&
	   mread_rule_id_inReduce(reduce) == rule_id &&
	   mread_explanations(reduce) == explanations &&
	   mread_assumps(reduce) == assumps);
    delete_reduce(reduce);
    check_memory_usage("test_reduce2");
}

Local void test_reduce3()
{
    Reduce *reduce = new_reduce();
    SubGoal *sub_goal = new_sub_goal(), *sub_goal2;
    RuleId *rule_id = new_rule_id(), *rule_id2;
    ObjList *explanations = new_obj_list(EXPLANATION), *explanations2;
    ObjList *assumps = new_obj_list(ASSUMP), *assumps2;

    decompose_reduce(
      set_reduce(reduce, sub_goal, rule_id, explanations, assumps), 
      &sub_goal2, &rule_id2, &explanations2, &assumps2);
    assert(sub_goal2 == sub_goal && rule_id2 == rule_id && 
	   explanations2 == explanations && assumps2 == assumps);
    delete_reduce(reduce);
    check_memory_usage("test_reduce3");
}

Local void test_reduce4()
{
    Reduce *reduce = new_reduce(), *reduce2, *reduce3 = new_reduce();
    SubGoal *sub_goal = new_sub_goal(), *sub_goal2;
    RuleId *rule_id = new_rule_id(), *rule_id2;
    ObjList *explanations = new_obj_list(EXPLANATION), *explanations2;
    ObjList *assumps = new_obj_list(ASSUMP), *assumps2;

    decompose_reduce(
      write_sub_goal_inReduce(
        write_rule_id_inReduce(
	  write_explanations(
            write_assumps(reduce, assumps),
            explanations),
          rule_id),
        sub_goal),
      &sub_goal2, &rule_id2, &explanations2, &assumps2);
    assert(sub_goal2 == sub_goal && rule_id2 == rule_id && 
	   explanations2 == explanations && assumps2 == assumps);
    sub_goal = new_sub_goal();
    rule_id = new_rule_id();
    explanations = new_obj_list(EXPLANATION);
    assumps = new_obj_list(ASSUMP);
    decompose_reduce(
      mwrite_sub_goal_inReduce(
        mwrite_rule_id_inReduce(
	  mwrite_explanations(
            mwrite_assumps(reduce3, assumps),
            explanations),
          rule_id),
        sub_goal),
      &sub_goal2, &rule_id2, &explanations2, &assumps2);
    assert(sub_goal2 == sub_goal && rule_id2 == rule_id && 
	   explanations2 == explanations && assumps2 == assumps);
    reduce2 = copy_reduce(reduce);
    delete_reduce(reduce);
    delete_reduce(reduce2);
    delete_reduce(reduce3);
    check_memory_usage("test_reduce4");
}

Local void test_reduce5()
{
    Reduce *reduce;
    ObjList *obj_list, *obj_list2, *obj_list3, *obj_list4;
    Explanation *explanation, *explanation2, *explanation3, *explanation4;
    Assump *assump, *assump2, *assump3, *assump4;

    reduce = new_reduce();
    obj_list = new_obj_list(EXPLANATION);
    obj_list2 = new_obj_list(EXPLANATION);
    obj_list3 = new_obj_list(ASSUMP);
    obj_list4 = new_obj_list(ASSUMP);
    explanation = new_explanation();
    explanation2 = new_explanation();
    explanation3 = new_explanation();
    explanation4 = new_explanation();
    assump = new_assump();
    assump2 = new_assump();
    assump3 = new_assump();
    assump4 = new_assump();
    append_to_obj_list(append_to_obj_list(obj_list, explanation), 
		         explanation2);
    append_to_obj_list(append_to_obj_list(obj_list2, explanation3), 
		         explanation4);
    append_to_obj_list(append_to_obj_list(obj_list3, assump), assump2);
    append_to_obj_list(append_to_obj_list(obj_list4, assump3), assump4);
    insert_explanations(insert_explanations(reduce, obj_list2), obj_list);
    insert_assumps(insert_assumps(reduce, obj_list4), obj_list3);
/*    assert(car_of_explanations(reduce) == explanation &&
	   car_of_explanations(reduce) == explanation2 &&
	   car_of_explanations(reduce) == explanation3 &&
	   car_of_explanations(reduce) == explanation4 &&
	   car_of_assumps(reduce) == assump &&
	   car_of_assumps(reduce) == assump2 &&
	   car_of_assumps(reduce) == assump3 &&
	   car_of_assumps(reduce) == assump4);
*/
    assert(car_of_explanations(reduce) == explanation &&
	   car_of_explanations(reduce) == explanation2 &&
	   car_of_explanations(reduce) == explanation3 &&
	   car_of_explanations(reduce) == explanation4);
    assert(car_of_assumps(reduce) == assump);
    assert(car_of_assumps(reduce) == assump2);
    assert(car_of_assumps(reduce) == assump3);
    assert(car_of_assumps(reduce) == assump4);

    obj_list = new_obj_list(EXPLANATION);
    obj_list2 = new_obj_list(EXPLANATION);
    obj_list3 = new_obj_list(ASSUMP);
    obj_list4 = new_obj_list(ASSUMP);
    cons_to_obj_list(cons_to_obj_list(obj_list, explanation), explanation2);
    cons_to_obj_list(cons_to_obj_list(obj_list2, explanation3), explanation4);
    cons_to_obj_list(cons_to_obj_list(obj_list3, assump), assump2);
    cons_to_obj_list(cons_to_obj_list(obj_list4, assump3), assump4);
    add_explanations(add_explanations(reduce, obj_list2), obj_list);
    add_assumps(add_assumps(reduce, obj_list4), obj_list3);
    assert(car_of_explanations(reduce) == explanation4 &&
	   car_of_explanations(reduce) == explanation3 &&
	   car_of_explanations(reduce) == explanation2 &&
	   car_of_explanations(reduce) == explanation &&
	   car_of_assumps(reduce) == assump4 &&
	   car_of_assumps(reduce) == assump3 &&
	   car_of_assumps(reduce) == assump2 &&
	   car_of_assumps(reduce) == assump);
    delete_explanation(explanation);
    delete_explanation(explanation2);
    delete_explanation(explanation3);
    delete_explanation(explanation4);
    delete_assump(assump);
    delete_assump(assump2);
    delete_assump(assump3);
    delete_assump(assump4);
    delete_reduce(reduce);
    check_memory_usage("test_reduce5");
}

Local void test_reduce6()
{
    Reduce *reduce = new_reduce(), *reduce2;
    SubGoal *sub_goal = new_sub_goal();
    RuleId *rule_id = new_rule_id();
    ObjList *explanations = new_obj_list(EXPLANATION);
    ObjList *assumps = new_obj_list(ASSUMP);
    int n;

    n = strcmp(type_name(reduce->tag), "REDUCE");
    assert(n == 0);
    assert(is_type(reduce->tag, REDUCE));
    reduce2 = (Reduce*)copy_pseudo_object
      (set_reduce(reduce, sub_goal, rule_id, explanations, assumps));
    print_pseudo_object(reduce2, fp, INDENT);
    delete_pseudo_object(reduce2);
    delete_reduce(reduce);
    check_memory_usage("test_reduce6");
}

Public void test_reduce()
{
    printf("testing reduce...\n");
    test_reduce1();
    test_reduce2();
    test_reduce3();
    test_reduce4();
    test_reduce5();
    test_reduce6();
}

/*
 SUB_GOAL (have ObjList)
*/

Local void test_sub_goal1()
{
    SubGoal *sub_goal = NULL;

    assert(is_sub_goal(sub_goal));
    sub_goal = new_sub_goal();
    assert(is_sub_goal(sub_goal));
    delete_sub_goal(sub_goal);
    check_memory_usage("test_sub_goal1");
}

Local void test_sub_goal2()
{
    MId *m_id = new_o_term(), *m_id2;
    OTerm *o_term = new_o_term(), *o_term2;
    ObjList *vc_pairs = new_obj_list(VC_PAIR), *vc_pairs2;
    SubGoal *sub_goal = create_sub_goal(m_id, o_term, vc_pairs);

    assert(fis_sub_goal(NULL));
    assert(fis_sub_goal(sub_goal));
    assert(! is_sub_goal(m_id));
    assert(! fis_sub_goal(m_id));
    decompose_sub_goal(sub_goal, &m_id2, &o_term2, &vc_pairs2);
    assert(m_id2 == m_id && o_term2 == o_term && vc_pairs2 == vc_pairs);
    assert(read_m_id_inSubGoal(sub_goal) == m_id &&
	   read_o_term_inSubGoal(sub_goal) == o_term &&
	   read_vc_pairs_inSubGoal(sub_goal) == vc_pairs);
    assert(mread_m_id_inSubGoal(sub_goal) == m_id &&
	   mread_o_term_inSubGoal(sub_goal) == o_term &&
	   mread_vc_pairs_inSubGoal(sub_goal) == vc_pairs);
    delete_sub_goal(sub_goal);
    check_memory_usage("test_sub_goal2");
}

Local void test_sub_goal3()
{
    SubGoal *sub_goal = new_sub_goal();
    MId *m_id = new_o_term(), *m_id2;
    OTerm *o_term = new_o_term(), *o_term2;
    ObjList *vc_pairs = new_obj_list(VC_PAIR), *vc_pairs2;

    decompose_sub_goal(
      set_sub_goal(sub_goal, m_id, o_term, vc_pairs), 
      &m_id2, &o_term2, &vc_pairs2);
    assert(m_id2 == m_id && o_term2 == o_term && vc_pairs2 == vc_pairs);
    delete_sub_goal(sub_goal);
    check_memory_usage("test_sub_goal3");
}

Local void test_sub_goal4()
{
    SubGoal *sub_goal = new_sub_goal(), *sub_goal2, 
            *sub_goal3 = new_sub_goal();
    MId *m_id = new_o_term(), *m_id2;
    OTerm *o_term = new_o_term(), *o_term2;
    ObjList *vc_pairs = new_obj_list(VC_PAIR), *vc_pairs2;

    decompose_sub_goal(
      write_m_id_inSubGoal(
        write_o_term_inSubGoal(
	  write_vc_pairs_inSubGoal(sub_goal, vc_pairs),
          o_term),
        m_id),
      &m_id2, &o_term2, &vc_pairs2);
    assert(m_id2 == m_id && o_term2 == o_term && vc_pairs2 == vc_pairs);
    m_id = new_o_term();
    o_term = new_o_term();
    vc_pairs = new_obj_list(VC_PAIR);
    decompose_sub_goal(
      mwrite_m_id_inSubGoal(
        mwrite_o_term_inSubGoal(
	  mwrite_vc_pairs_inSubGoal(sub_goal3, vc_pairs),
          o_term),
        m_id),
      &m_id2, &o_term2, &vc_pairs2);
    assert(m_id2 == m_id && o_term2 == o_term && vc_pairs2 == vc_pairs);
    sub_goal2 = copy_sub_goal(sub_goal);
    delete_sub_goal(sub_goal);
    delete_sub_goal(sub_goal2);
    delete_sub_goal(sub_goal3);
    check_memory_usage("test_sub_goal4");
}

Local void test_sub_goal5()
{
    SubGoal *sub_goal;
    ObjList *obj_list, *obj_list2;
    VcPair *vc_pair, *vc_pair2, *vc_pair3, *vc_pair4;

    sub_goal = new_sub_goal();
    obj_list = new_obj_list(VC_PAIR);
    obj_list2 = new_obj_list(VC_PAIR);
    vc_pair = new_vc_pair();
    vc_pair2 = new_vc_pair();
    vc_pair3 = new_vc_pair();
    vc_pair4 = new_vc_pair();
    append_to_obj_list(append_to_obj_list(obj_list, vc_pair), vc_pair2);
    append_to_obj_list(append_to_obj_list(obj_list2, vc_pair3), vc_pair4);
    insert_vc_pairs_inSubGoal(insert_vc_pairs_inSubGoal(sub_goal, obj_list2), 
			        obj_list);
    assert(car_of_vc_pairs_inSubGoal(sub_goal) == vc_pair &&
	   car_of_vc_pairs_inSubGoal(sub_goal) == vc_pair2 &&
	   car_of_vc_pairs_inSubGoal(sub_goal) == vc_pair3 &&
	   car_of_vc_pairs_inSubGoal(sub_goal) == vc_pair4);

    obj_list = new_obj_list(VC_PAIR);
    obj_list2 = new_obj_list(VC_PAIR);
    cons_to_obj_list(cons_to_obj_list(obj_list, vc_pair), vc_pair2);
    cons_to_obj_list(cons_to_obj_list(obj_list2, vc_pair3), vc_pair4);
    add_vc_pairs_inSubGoal(add_vc_pairs_inSubGoal(sub_goal, obj_list2), 
			     obj_list);
    assert(car_of_vc_pairs_inSubGoal(sub_goal) == vc_pair4 &&
	   car_of_vc_pairs_inSubGoal(sub_goal) == vc_pair3 &&
	   car_of_vc_pairs_inSubGoal(sub_goal) == vc_pair2 &&
	   car_of_vc_pairs_inSubGoal(sub_goal) == vc_pair);
    delete_vc_pair(vc_pair);
    delete_vc_pair(vc_pair2);
    delete_vc_pair(vc_pair3);
    delete_vc_pair(vc_pair4);
    delete_sub_goal(sub_goal);
    check_memory_usage("test_sub_goal5");
}

Local void test_sub_goal6()
{
    SubGoal *sub_goal = new_sub_goal(), *sub_goal2;
    MId *m_id = new_o_term();
    OTerm *o_term = new_o_term();
    ObjList *vc_pairs = new_obj_list(VC_PAIR);
    int n;

    n = strcmp(type_name(sub_goal->tag), "SUB_GOAL");
    assert(n == 0);
    assert(is_type(sub_goal->tag, SUB_GOAL));
    sub_goal2 = (SubGoal*)copy_pseudo_object
      (set_sub_goal(sub_goal, m_id, o_term, vc_pairs));
    print_pseudo_object(sub_goal2, fp, INDENT);
    delete_pseudo_object(sub_goal2);
    delete_sub_goal(sub_goal);
    check_memory_usage("test_sub_goal6");
}

Public void test_sub_goal()
{
    printf("testing sub_goal...\n");
    test_sub_goal1();
    test_sub_goal2();
    test_sub_goal3();
    test_sub_goal4();
    test_sub_goal5();
    test_sub_goal6();
}

/*
 VC_PAIR
*/

Local void test_vc_pair1()
{
    VcPair *vc_pair = NULL;

    assert(is_vc_pair(vc_pair));
    vc_pair = new_vc_pair();
    assert(is_vc_pair(vc_pair));
    delete_vc_pair(vc_pair);
    check_memory_usage("test_vc_pair1");
}

Local void test_vc_pair2()
{
    Var *var = new_var(), *var2;
    Constraint *constraint = new_constraint(), *constraint2;
    VcPair *vc_pair = create_vc_pair(var, constraint);

    assert(fis_vc_pair(NULL));
    assert(fis_vc_pair(vc_pair));
    assert(! is_vc_pair(var));
    assert(! fis_vc_pair(var));
    decompose_vc_pair(vc_pair, &var2, &constraint2);
    assert(var2 == var && constraint2 == constraint);
    assert(read_var_inVcPair(vc_pair) == var &&
	   read_constraint(vc_pair) == constraint);
    assert(mread_var_inVcPair(vc_pair) == var &&
	   mread_constraint(vc_pair) == constraint);
    delete_vc_pair(vc_pair);
    check_memory_usage("test_vc_pair2");
}

Local void test_vc_pair3()
{
    VcPair *vc_pair = new_vc_pair();
    Var *var = new_var(), *var2;
    Constraint *constraint = new_constraint(), *constraint2;

    decompose_vc_pair(set_vc_pair(vc_pair, var, constraint), 
		      &var2, &constraint2);
    assert(var2 == var && constraint2 == constraint);
    delete_vc_pair(vc_pair);
    check_memory_usage("test_vc_pair3");
}

Local void test_vc_pair4()
{
    VcPair *vc_pair = new_vc_pair(), *vc_pair2, *vc_pair3 = new_vc_pair();
    Var *var = new_var(), *var2;
    Constraint *constraint = new_constraint(), *constraint2;

    decompose_vc_pair(
      write_var_inVcPair(
        write_constraint(vc_pair, constraint),
        var),
      &var2, &constraint2);
    assert(var2 == var && constraint2 == constraint);
    var = new_var();
    constraint = new_constraint();
    decompose_vc_pair(
      mwrite_var_inVcPair(
        mwrite_constraint(vc_pair3, constraint),
        var),
      &var2, &constraint2);
    assert(var2 == var && constraint2 == constraint);
    vc_pair2 = copy_vc_pair(vc_pair);
    delete_vc_pair(vc_pair);
    delete_vc_pair(vc_pair2);
    delete_vc_pair(vc_pair3);
    check_memory_usage("test_vc_pair4");
}

Local void test_vc_pair5()
{
    VcPair *vc_pair = new_vc_pair(), *vc_pair2;
    Var *var = new_var();
    Constraint *constraint = new_constraint();
    int n;

    n = strcmp(type_name(vc_pair->tag), "VC_PAIR");
    assert(n == 0);
    assert(is_type(vc_pair->tag, VC_PAIR));
    vc_pair2 = (VcPair*)copy_pseudo_object
      (set_vc_pair(vc_pair, var, constraint));
    print_pseudo_object(vc_pair2, fp, INDENT);
    delete_pseudo_object(vc_pair2);
    delete_vc_pair(vc_pair);
    check_memory_usage("test_vc_pair5");
}

Public void test_vc_pair()
{
    printf("testing vc_pair...\n");
    test_vc_pair1();
    test_vc_pair2();
    test_vc_pair3();
    test_vc_pair4();
    test_vc_pair5();
}

/*
 CONSTRAINT
*/

Local void test_constraint1()
{
    Constraint *constraint = NULL;

    assert(is_constraint(constraint));
    constraint = new_constraint();
    assert(is_constraint(constraint));
    delete_constraint(constraint);
    check_memory_usage("test_constraint1");
}

Local void test_constraint2()
{
    Con *const_data = new_con(), *const_data2;
    Constraint *constraint = create_constraint(const_data);

    assert(fis_constraint(NULL));
    assert(fis_constraint(constraint));
    assert(! is_constraint(const_data));
    assert(! fis_constraint(const_data));
    decompose_constraint(constraint, &const_data2);
    assert(const_data2 == const_data);
    assert(read_const_data(constraint) == const_data);
    assert(mread_const_data(constraint) == const_data);
    delete_constraint(constraint);
    check_memory_usage("test_constraint2");
}

Local void test_constraint3()
{
    Constraint *constraint = new_constraint();
    Con *const_data = new_con(), *const_data2;

    decompose_constraint(set_constraint(constraint, const_data), &const_data2);
    assert(const_data2 == const_data);
    delete_constraint(constraint);
    check_memory_usage("test_constraint3");
}

Local void test_constraint4()
{
    Constraint *constraint = new_constraint(), *constraint2, 
               *constraint3 = new_constraint();
    Con *const_data = new_con(), *const_data2;

    decompose_constraint(write_const_data(constraint, const_data), 
			 &const_data2);
    assert(const_data2 == const_data);
    const_data = new_con();
    decompose_constraint(mwrite_const_data(constraint3, const_data), 
			 &const_data2);
    assert(const_data2 == const_data);
    constraint2 = copy_constraint(constraint);
    delete_constraint(constraint);
    delete_constraint(constraint2);
    delete_constraint(constraint3);
    check_memory_usage("test_constraint4");
}

Local void test_constraint5()
{
    Constraint *constraint = new_constraint(), *constraint2;
    Con *const_data = new_con();
    int n;

    n = strcmp(type_name(constraint->tag), "CONSTRAINT");
    assert(n == 0);
    assert(is_type(constraint->tag, CONSTRAINT));
    constraint2 = (Constraint*)copy_pseudo_object
      (set_constraint(constraint, const_data));
    print_pseudo_object(constraint2, fp, INDENT);
    delete_pseudo_object(constraint2);
    delete_constraint(constraint);
    check_memory_usage("test_constraint5");
}

Public void test_constraint()
{
    printf("testing constraint...\n");
    test_constraint1();
    test_constraint2();
    test_constraint3();
    test_constraint4();
    test_constraint5();
}

/*
 CON (have ObjList)
*/

Local void test_con1()
{
    Con *con = NULL;

    assert(is_con(con));
    con = new_con();
    assert(is_con(con));
    delete_con(con);
    check_memory_usage("test_con1");
}

Local void test_con2()
{
    ObjList *o_terms1 = new_obj_list(O_TERM), *o_terms12;
    ObjList *o_terms2 = new_obj_list(O_TERM), *o_terms22;
    Con *con = create_con(o_terms1, o_terms2);

    assert(fis_con(NULL));
    assert(fis_con(con));
    assert(! is_con(o_terms1));
    assert(! fis_con(o_terms1));
    decompose_con(con, &o_terms12, &o_terms22);
    assert(o_terms12 == o_terms1 && o_terms22 == o_terms2);
    assert(read_o_terms1_inCon(con) == o_terms1 &&
	   read_o_terms2_inCon(con) == o_terms2);
    assert(mread_o_terms1_inCon(con) == o_terms1 &&
	   mread_o_terms2_inCon(con) == o_terms2);
    delete_con(con);
    check_memory_usage("test_con2");
}

Local void test_con3()
{
    Con *con = new_con();
    ObjList *o_terms1 = new_obj_list(O_TERM), *o_terms12;
    ObjList *o_terms2 = new_obj_list(O_TERM), *o_terms22;

    decompose_con(set_con(con, o_terms1, o_terms2), &o_terms12, &o_terms22);
    assert(o_terms12 == o_terms1 && o_terms22 == o_terms2);
    delete_con(con);
    check_memory_usage("test_con3");
}

Local void test_con4()
{
    Con *con = new_con(), *con2, *con3 = new_con();
    ObjList *o_terms1 = new_obj_list(O_TERM), *o_terms12;
    ObjList *o_terms2 = new_obj_list(O_TERM), *o_terms22;

    decompose_con(
      write_o_terms1_inCon(
        write_o_terms2_inCon(con, o_terms2),
        o_terms1),		     
      &o_terms12, &o_terms22);
    assert(o_terms12 == o_terms1 && o_terms22 == o_terms2);
    o_terms1 = new_obj_list(O_TERM);
    o_terms2 = new_obj_list(O_TERM);
    decompose_con(
      mwrite_o_terms1_inCon(
        mwrite_o_terms2_inCon(con3, o_terms2),
        o_terms1),		     
      &o_terms12, &o_terms22);
    assert(o_terms12 == o_terms1 && o_terms22 == o_terms2);
    con2 = copy_con(con);
    delete_con(con);
    delete_con(con2);
    delete_con(con3);
    check_memory_usage("test_con4");
}

Local void test_con5()
{
    Con *con;
    ObjList *obj_list, *obj_list2, *obj_list3, *obj_list4; 
    OTerm *o_term1, *o_term12, *o_term13, *o_term14;
    OTerm *o_term2, *o_term22, *o_term23, *o_term24;

    con = new_con();
    obj_list = new_obj_list(O_TERM);
    obj_list2 = new_obj_list(O_TERM);
    obj_list3 = new_obj_list(O_TERM);
    obj_list4 = new_obj_list(O_TERM);
    o_term1 = new_o_term();
    o_term12 = new_o_term();
    o_term13 = new_o_term();
    o_term14 = new_o_term();
    o_term2 = new_o_term();
    o_term22 = new_o_term();
    o_term23 = new_o_term();
    o_term24 = new_o_term();
    append_to_obj_list(append_to_obj_list(obj_list, o_term1), o_term12);
    append_to_obj_list(append_to_obj_list(obj_list2, o_term13), o_term14);
    append_to_obj_list(append_to_obj_list(obj_list3, o_term2), o_term22);
    append_to_obj_list(append_to_obj_list(obj_list4, o_term23), o_term24);
    insert_o_terms1_inCon(insert_o_terms1_inCon(con, obj_list2), obj_list);
    insert_o_terms2_inCon(insert_o_terms2_inCon(con, obj_list4), obj_list3);
    assert(car_of_o_terms1_inCon(con) == o_term1 &&
	   car_of_o_terms1_inCon(con) == o_term12 &&
	   car_of_o_terms1_inCon(con) == o_term13 &&
	   car_of_o_terms1_inCon(con) == o_term14);
    assert(car_of_o_terms2_inCon(con) == o_term2 &&
	   car_of_o_terms2_inCon(con) == o_term22 &&
	   car_of_o_terms2_inCon(con) == o_term23 &&
	   car_of_o_terms2_inCon(con) == o_term24);

    obj_list = new_obj_list(O_TERM);
    obj_list2 = new_obj_list(O_TERM);
    obj_list3 = new_obj_list(O_TERM);
    obj_list4 = new_obj_list(O_TERM);
    cons_to_obj_list(cons_to_obj_list(obj_list, o_term1), o_term12);
    cons_to_obj_list(cons_to_obj_list(obj_list2, o_term13), o_term14);
    cons_to_obj_list(cons_to_obj_list(obj_list3, o_term2), o_term22);
    cons_to_obj_list(cons_to_obj_list(obj_list4, o_term23), o_term24);
    add_o_terms1_inCon(add_o_terms1_inCon(con, obj_list2), obj_list);
    add_o_terms2_inCon(add_o_terms2_inCon(con, obj_list4), obj_list3);
    assert(car_of_o_terms1_inCon(con) == o_term14 &&
	   car_of_o_terms1_inCon(con) == o_term13 &&
	   car_of_o_terms1_inCon(con) == o_term12 &&
	   car_of_o_terms1_inCon(con) == o_term1);
    assert(car_of_o_terms2_inCon(con) == o_term24 &&
	   car_of_o_terms2_inCon(con) == o_term23 &&
	   car_of_o_terms2_inCon(con) == o_term22 &&
	   car_of_o_terms2_inCon(con) == o_term2);
    delete_o_term(o_term1);
    delete_o_term(o_term12);
    delete_o_term(o_term13);
    delete_o_term(o_term14);
    delete_o_term(o_term2);
    delete_o_term(o_term22);
    delete_o_term(o_term23);
    delete_o_term(o_term24);
    delete_con(con);
    check_memory_usage("test_con5");
}

Local void test_con6()
{
    Con *con = new_con(), *con2;
    ObjList *o_terms1 = new_obj_list(O_TERM);
    ObjList *o_terms2 = new_obj_list(O_TERM);
    int n;

    n = strcmp(type_name(con->tag), "CON");
    assert(n == 0);
    assert(is_type(con->tag, CON));
    con2 = (Con*)copy_pseudo_object(set_con(con, o_terms1, o_terms2));
    print_pseudo_object(con2, fp, INDENT);
    delete_pseudo_object(con2);
    delete_con(con);
    check_memory_usage("test_con6");
}

Public void test_con()
{
    printf("testing con...\n");
    test_con1();
    test_con2();
    test_con3();
    test_con4();
    test_con5();
    test_con6();
}

/*
 ASSUMP (have ObjList)
*/

Local void test_assump1()
{
    Assump *assump = NULL;

    assert(is_assump(assump));
    assump = new_assump();
    assert(is_assump(assump));
    delete_assump(assump);
    check_memory_usage("test_assump1");
}

Local void test_assump2()
{
    MId *m_id = new_o_term(), *m_id2;
    Dot *dot = new_dot(), *dot2;
    ObjList *vc_pairs = new_obj_list(VC_PAIR), *vc_pairs2;
    Assump *assump = create_assump(m_id, dot, vc_pairs);

    assert(fis_assump(NULL));
    assert(fis_assump(assump));
    assert(! is_assump(m_id));
    assert(! fis_assump(m_id));
    decompose_assump(assump, &m_id2, &dot2, &vc_pairs2);
    assert(m_id2 == m_id && dot2 == dot && vc_pairs2 == vc_pairs);
    assert(read_m_id_inAssump(assump) == m_id &&
	   read_dot_inAssump(assump) == dot &&
	   read_vc_pairs_inAssump(assump) == vc_pairs);
    assert(mread_m_id_inAssump(assump) == m_id &&
	   mread_dot_inAssump(assump) == dot &&
	   mread_vc_pairs_inAssump(assump) == vc_pairs);
    delete_assump(assump);
    check_memory_usage("test_assump2");
}

Local void test_assump3()
{
    Assump *assump = new_assump();
    MId *m_id = new_o_term(), *m_id2;
    Dot *dot = new_dot(), *dot2;
    ObjList *vc_pairs = new_obj_list(VC_PAIR), *vc_pairs2;

    decompose_assump(
      set_assump(assump, m_id, dot, vc_pairs), 
      &m_id2, &dot2, &vc_pairs2);
    assert(m_id2 == m_id && dot2 == dot && vc_pairs2 == vc_pairs);
    delete_assump(assump);
    check_memory_usage("test_assump3");
}

Local void test_assump4()
{
    Assump *assump = new_assump(), *assump2, *assump3 = new_assump();
    MId *m_id = new_o_term(), *m_id2;
    Dot *dot = new_dot(), *dot2;
    ObjList *vc_pairs = new_obj_list(VC_PAIR), *vc_pairs2;

    decompose_assump(
      write_m_id_inAssump(
        write_dot_inAssump(
	  write_vc_pairs_inAssump(assump, vc_pairs),
          dot),
        m_id),
      &m_id2, &dot2, &vc_pairs2);
    assert(m_id2 == m_id && dot2 == dot && vc_pairs2 == vc_pairs);
    m_id = new_o_term();
    dot = new_dot();
    vc_pairs = new_obj_list(VC_PAIR);
    decompose_assump(
      mwrite_m_id_inAssump(
        mwrite_dot_inAssump(
	  mwrite_vc_pairs_inAssump(assump3, vc_pairs),
          dot),
        m_id),
      &m_id2, &dot2, &vc_pairs2);
    assert(m_id2 == m_id && dot2 == dot && vc_pairs2 == vc_pairs);
    assump2 = copy_assump(assump);
    delete_assump(assump);
    delete_assump(assump2);
    delete_assump(assump3);
    check_memory_usage("test_assump4");
}

Local void test_assump5()

{
    Assump *assump;
    ObjList *obj_list, *obj_list2;
    VcPair *vc_pair, *vc_pair2, *vc_pair3, *vc_pair4;

    assump = new_assump();
    obj_list = new_obj_list(VC_PAIR);
    obj_list2 = new_obj_list(VC_PAIR);
    vc_pair = new_vc_pair();
    vc_pair2 = new_vc_pair();
    vc_pair3 = new_vc_pair();
    vc_pair4 = new_vc_pair();
    append_to_obj_list(append_to_obj_list(obj_list, vc_pair), vc_pair2);
    append_to_obj_list(append_to_obj_list(obj_list2, vc_pair3), vc_pair4);
    insert_vc_pairs_inAssump(insert_vc_pairs_inAssump(assump, obj_list2), 
			        obj_list);
    assert(car_of_vc_pairs_inAssump(assump) == vc_pair &&
	   car_of_vc_pairs_inAssump(assump) == vc_pair2 &&
	   car_of_vc_pairs_inAssump(assump) == vc_pair3 &&
	   car_of_vc_pairs_inAssump(assump) == vc_pair4);

    obj_list = new_obj_list(VC_PAIR);
    obj_list2 = new_obj_list(VC_PAIR);
    cons_to_obj_list(cons_to_obj_list(obj_list, vc_pair), vc_pair2);
    cons_to_obj_list(cons_to_obj_list(obj_list2, vc_pair3), vc_pair4);
    add_vc_pairs_inAssump(add_vc_pairs_inAssump(assump, obj_list2), 
			     obj_list);
    assert(car_of_vc_pairs_inAssump(assump) == vc_pair4 &&
	   car_of_vc_pairs_inAssump(assump) == vc_pair3 &&
	   car_of_vc_pairs_inAssump(assump) == vc_pair2 &&
	   car_of_vc_pairs_inAssump(assump) == vc_pair);
    delete_vc_pair(vc_pair);
    delete_vc_pair(vc_pair2);
    delete_vc_pair(vc_pair3);
    delete_vc_pair(vc_pair4);
    delete_assump(assump);
    check_memory_usage("test_assump5");
}

Local void test_assump6()
{
    Assump *assump = new_assump(), *assump2;
    MId *m_id = new_o_term();
    Dot *dot = new_dot();
    ObjList *vc_pairs = new_obj_list(VC_PAIR);
    int n;

    n = strcmp(type_name(assump->tag), "ASSUMP");
    assert(n == 0);
    assert(is_type(assump->tag, ASSUMP));
    assump2 = (Assump*)copy_pseudo_object
      (set_assump(assump, m_id, dot, vc_pairs)); 
    print_pseudo_object(assump2, fp, INDENT);
    delete_pseudo_object(assump2);
    delete_assump(assump);
    check_memory_usage("test_assump6");
}

Public void test_assump()
{
    printf("testing assump...\n");
    test_assump1();
    test_assump2();
    test_assump3();
    test_assump4();
    test_assump5();
    test_assump6();
}

/*
 QUERY_EXPLANATION
*/

Local void test_query_explanation1()
{
    QueryExplanation *query_explanation = NULL;

    assert(is_query_explanation(query_explanation));
    query_explanation = new_query_explanation();
    assert(is_query_explanation(query_explanation));
    delete_query_explanation(query_explanation);
    check_memory_usage("test_query_explanation1");
}

Local void test_query_explanation2()
{
    QueryExplanation *query_explanation = new_query_explanation(), 
                     *query_explanation2;
    Var *var = new_var();

    assert(fis_query_explanation(NULL));
    assert(fis_query_explanation(query_explanation));
    assert(! is_query_explanation(var));
    assert(! fis_query_explanation(var));
    query_explanation2 = copy_query_explanation(query_explanation);
    delete_query_explanation(query_explanation);
    delete_query_explanation(query_explanation2);
    delete_var(var);
    check_memory_usage("test_query_explanation4");
}

Local void test_query_explanation3()
{
    QueryExplanation *query_explanation = new_query_explanation(), 
                      *query_explanation2;
    int n;

    n = strcmp(type_name(query_explanation->tag), "QUERY_EXPLANATION");
    assert(n == 0); 
    assert(is_type(query_explanation->tag, QUERY_EXPLANATION));
    query_explanation2 = 
      (QueryExplanation*)copy_pseudo_object(query_explanation);
    print_pseudo_object(query_explanation2, fp, INDENT);
    delete_pseudo_object(query_explanation2);
    delete_query_explanation(query_explanation);
    check_memory_usage("test_query_explanation3");
}

Public void test_query_explanation()
{
    printf("testing query_explanation...\n");
    test_query_explanation1();
    test_query_explanation2();
    test_query_explanation3();
}
