/**  identification macros **/
#define  is_mod_def(A) ((A)== NULL || (A)->tag == MOD_DEF)
#define  is_mod_def_non_NULL(A) ((A) != NULL && (A)->tag == MOD_DEF)

#define  is_m_sub(A) ((A)== NULL || (A)->tag == M_SUB)
#define  is_m_sub_non_NULL(A) ((A) != NULL && (A)->tag == M_SUB)

#define  is_rule(A) ((A)== NULL || (A)->tag == RULE)

#define  is_o_term(A) ((A)== NULL || (A)->tag == O_TERM || is_prolog(A)\
                      || is_c_o_term(A) || is_var(A) || is_dot(A)\
                      || is_list(A) || is_non_struct(A))
#define  is_o_term_non_NULL(A) ((A) != NULL && (A)->tag == O_TERM || is_prolog(A)\
                      || is_c_o_term(A) || is_var(A) || is_dot(A)\
                      || is_list(A) || is_non_struct(A))

#define  is_m_id(A) ((A)== NULL || is_o_term(A) || (A)->tag == M_ID || (A)->tag == O_TERM)

#define  is_m_desc(A) ((A)== NULL || (A)->tag == M_DESC || is_m_id(A) || is_m2_desc(A))
#define  is_m_desc_no_NULL(A) ((A)!= NULL && (A)->tag == M_DESC || is_m_id(A) || is_m2_desc(A))

#define  is_m2_desc(A) ((A)== NULL || (A)->tag == M2_DESC)
#define  is_m2_desc_non_NULL(A) ((A)!= NULL && (A)->tag == M2_DESC)

#define  is_link_def(A) ((A)== NULL || (A)->tag == LINK_DEF)
#define  is_link_def_non_NULL(A) ((A)!= NULL && (A)->tag == LINK_DEF)

#define  is_link(A) ((A)== NULL || (A)->tag == LINK)
#define  is_link_non_NULL(A) ((A)!= NULL && (A)->tag == LINK)

#define  is_m_id_pair(A) ((A)== NULL || (A)->tag == M_ID_PAIR)
#define  is_m_id_pair_non_NULL(A) ((A)!= NULL && (A)->tag == M_ID_PAIR)

#define  is_o_term_pair(A) ((A)== NULL || (A)->tag == O_TERM_PAIR)
#define  is_o_term_pair_non_NULL(A) ((A)!= NULL && (A)->tag == O_TERM_PAIR)

#define  is_rule_def(A) ((A)== NULL || (A)->tag == RULE_DEF)
#define  is_rule_def_non_NULL(A) ((A)!= NULL && (A)->tag == RULE_DEF)

#define  is_rule(A) ((A)== NULL || (A)->tag == RULE)
#define  is_rule_non_NULL(A) ((A)!= NULL && (A)->tag == RULE)

#define  is_rule_id(A) ((A)== NULL || (A)->tag == RULE_ID)
#define  is_rule_id_non_NULL(A) ((A)!= NULL && (A)->tag == RULE_ID)

#define  is_cluster(A) ((A)== NULL || (A)->tag == CLUSTER\
         || is_normal(A) || is_rel(A) || is_update(A)\
         ||is_transaction(A) || is_i_check(A))
#define  is_cluster_non_NULL(A) ((A)!= NULL && is_(A)->tag == CLUSTER\
         || is_normal(A) || is_rel(A) || is_update(A)\
         || is_transactiob(A) || is_i_check(A))

#define  is_normal(A) ((A)== NULL || (A)->tag == NORMAL)
#define  is_normal_non_NULL(A) ((A)!= NULL && (A)->tag == NORMAL)

#define  is_rel(A) ((A)== NULL || (A)->tag == REL)
#define  is_rel_non_NULL(A) ((A)!= NULL && (A)->tag == REL)

#define  is_update(A) ((A)== NULL || (A)->tag == UPDATE)
#define  is_update_non_NULL(A) ((A)!= NULL && (A)->tag == UPDATE)

#define  is_transaction(A) ((A)== NULL || (A)->tag == TRANSACTION)
#define  is_transaction_non_NULL(A) ((A)!= NULL && (A)->tag == TRANSACTION)

#define  is_i_check_content(A) ((A)== NULL || (A)->tag == I_CHECK_CONTENT\
                                 || is_prop(A) || is_obj_list(A,CNSTR))
#define  is_i_check_content_non_NULL(A) ((A)!= NULL && ((A)->tag == I_CHECK_CONTENT\
                                 || is_prop(A) || is_obj_list(A,CNSTR)))

#define  is_i_check(A)  ((A) == NULL || (A)->tag == I_CHECK\
                            || (A)->tag == CONSIS || (A)->tag == INCONSIS)
#define  is_i_check_non_NULL(A)  ((A) != NULL && ((A)->tag == I_CHECK\
                            || (A)->tag == CONSIS || (A)->tag == INCONSIS))

#define  is_consis(A)  ((A) == NULL || (A)->tag == CONSIS)
#define  is_consis_non_NULL(A)  ((A) == NULL && (A)->tag == CONSIS)

#define  is_inconsis(A)  ((A) == NULL || (A)->tag == INCONSIS)
#define  is_inconsis_non_NULL(A)  ((A) == NULL && (A)->tag == INCONSIS)

#define  is_prop(A) ((A)== NULL || (A)->tag == PROP)
#define  is_prop_non_NULL(A) ((A)!= NULL && (A)->tag == PROP)

#define  is_a_term(A) ((A)== NULL || (A)->tag == A_TERM)
#define  is_a_term_non_NULL(A) ((A)!= NULL && (A)->tag == A_TERM)

#define  is_c_o_term(A) ((A)== NULL || (A)->tag == C_O_TERM)
#define  is_c_o_term_non_NULL(A) ((A)!= NULL && (A)->tag == C_O_TERM)

#define  is_dot(A) ((A)== NULL || (A)->tag == DOT)
#define  is_dot_non_NULL(A) ((A)!= NULL && (A)->tag == DOT)

#define  is_label(A) ((A)== NULL || (A)->tag == LABEL ||(A)->tag == IND_LAB\
                    || (A)->tag == SET_LAB || (A)->tag == CURL_IND || (A)->tag == CURL_SET)
#define  is_label_non_NULL(A) ((A)!= NULL && ((A)->tag == LABEL || (A)->tag == IND_LAB\
       || (A)->tag == SET_LAB  || (A)->tag == CURL_IND || (A)->tag == CURL_SET))

#define  is_ind_lab(A) ((A) == NULL || (A)->tag == IND_LAB)
#define  is_ind_lab_non_NULL(A) ((A)!=NULL && ((A)->tag == IND_LAB))

#define  is_set_lab(A) ((A) == NULL || (A)->tag == SET_LAB)
#define  is_set_lab_non_NULL(A) ((A)!=NULL && ((A)->tag == SET_LAB))

#define  is_curl_ind(A) ((A) == NULL || (A)->tag == CURL_IND)
#define  is_curl_ind_non_NULL(A) ((A)!=NULL && ((A)->tag == CURL_IND))

#define  is_curl_set(A) ((A) == NULL || (A)->tag == CURL_SET)
#define  is_curl_set_non_NULL(A) ((A)!=NULL && ((A)->tag == CURL_SET))

#define  is_list(A) ((A)== NULL || (A)->tag == LIST || is_obj_list(A,NORMAL) || is_sub_list(A))
#define  is_list_non_NULL(A) ((A)!= NULL && (A)->tag == LIST || is_obj_list(A,NORMAL) ||is_sub_list(A))

#define  is_sub_list(A) ((A)== NULL || (A)->tag == SUB_LIST)
#define  is_sub_list_non_NULL(A) ((A)!= NULL && (A)->tag == SUB_LIST)

#define  is_remain(A) ((A)== NULL || (A)->tag == REMAIN || is_list(A) || is_var(A))
#define  is_remain_non_NULL(A) ((A)!= NULL && (A)->tag == REMAIN || is_list(A) || is_var(A))

#define  is_non_struct(A) ((A)== NULL || (A)->tag == NON_STRUCT || is_exp_name(A) || is_string(A)\
                          || is_integer(A))
#define  is_non_struct_non_NULL(A) ((A)!= NULL && (A)->tag == NON_STRUCT || is_exp_name(A)\
                          || is_string(A) || is_integer(A))

#define  is_exp_name(A) ((A)== NULL || (A)->tag == EXP_NAME)
#define  is_exp_name_non_NULL(A) ((A)!= NULL && (A)->tag == EXP_NAME)

#define  is_integer(A) ((A)== NULL || (A)->tag == INTEGER)
#define  is_integer_non_NULL(A) ((A)!= NULL && (A)->tag == INTEGER)

#define  is_attr(A) ((A)== NULL || (A)->tag == ATTR)
#define  is_attr_non_NULL(A) ((A)!= NULL && (A)->tag == ATTR)
