/* typedef int Bool; */

/*
 EXPLANATION (union)
*/

Bool fis_explanation(/* PseudoObject* */);
Explanation* create_explanation_unit(/* UnitExplanation* */);
Explanation* create_explanation_merge(/* MergeExplanation* */);
Explanation* create_explanation_lookup(/* LookupExplanation* */);
Explanation* copy_explanation(/* Explanation* */);
Explanation* new_explanation();
void delete_explanation(/* Explanation* */);


/*
 UNIT_EXPLANATION (union)
*/

Bool fis_unit_explanation(/* PseudoObject* */);
UnitExplanation* create_unit_explanation_one_rule(/* OneRule* */);
UnitExplanation* create_unit_explanation_inherit(/* Inherit* */);
UnitExplanation* copy_unit_explanation(/* UnitExplanation* */);
UnitExplanation* new_unit_explanation();
void delete_unit_explanation(/* UnitExplanation* */);


/*
 INHERIT (have ObjList)
*/

Bool fis_inherit(/* PseudoObject* */);
void decompose_inherit(/* Inherit*, OneRule**, ObjList**, ObjList** */);
OneRule* read_one_rule(/* Inherit* */);
ObjList* read_ups(/* Inherit* */);
ObjList* read_downs(/* Inherit* */);
Inherit* create_inherit(/* OneRule*, ObjList*, ObjList* */);
Inherit* copy_inherit(/* Inherit* */);
Inherit* set_inherit(/* Inherit*, OneRule*, ObjList*, ObjList* */);
Inherit* write_one_rule(/* Inherit*, OneRule* */);
Inherit* write_ups(/* Inherit*, ObjList* */);
Inherit* write_downs(/* Inherit*, ObjList* */);
Inherit* new_inherit();
void delete_inherit(/* Inherit* */);
Inherit* insert_ups(/* Inherit*, ObjList* */);
Inherit* insert_downs(/* Inherit*, ObjList* */);
Inherit* add_ups(/* Inherit*, ObjList* */);
Inherit* add_downs(/* Inherit*, ObjList* */);
OneRule* car_of_ups(/* Inherit* */);
OneRule* car_of_downs(/* Inherit* */);


/*
 MERGE_EXPLANATION (have ObjList)
*/

Bool fis_merge_explanation(/* PseudoObject* */);
void decompose_merge_explanation(/* MergeExplanation*, ObjList** */);
ObjList* read_unit_explanations(/* MergeExplanation* */);
MergeExplanation* create_merge_explanation(/* ObjList* */);
MergeExplanation* copy_merge_explanation(/* MergeExplanation* */);
MergeExplanation* set_merge_explanation(/* MergeExplanation*, ObjList* */);
MergeExplanation* write_unit_explanations(/* MergeExplanation*, ObjList* */);
MergeExplanation* new_merge_explanation();
void delete_merge_explanation(/* MergeExplanation* */);
MergeExplanation* insert_unit_explanations(/* MergeExplanation*, ObjList* */);
MergeExplanation* add_unit_explanations(/* MergeExplanation*, ObjList* */);
UnitExplanation* car_of_unit_explanations(/* MergeExplanation* */);


/*
 LOOKUP_EXPLANATION
*/

Bool fis_lookup_explanation(/* PseudoObject* */);
void decompose_lookup_explanation
         (/* LookupExplanation*, SubGoal**, int*, int*, Explanation** */);
SubGoal* read_sub_goal_inLookupExplanation(/* LookupExplanation* */);
int read_looked_s(/* LookupExplanation* */);
int read_looking_s(/* LookupExplanation* */);
Explanation* read_explanation_inLookupExplanation(/* LookupExplanation* */);
LookupExplanation* create_lookup_explanation
                            (/* SubGoal*, int, int, Explanation* */);
LookupExplanation* copy_lookup_explanation(/* LookupExplanation* */);
LookupExplanation* set_lookup_explanation
         (/* LookupExplanation*, SubGoal*, int, int, Explanation* */);
LookupExplanation* write_sub_goal_inLookupExplanation
                            (/* LookupExplanation*, SubGoal* */);
LookupExplanation* write_looked_s
                            (/* LookupExplanation*, int */);
LookupExplanation* write_looking_s
                            (/* LookupExplanation*, int */);
LookupExplanation* write_explanation_inLookupExplanation
                            (/* LookupExplanation*, Explanation* */);
LookupExplanation* new_lookup_explanation();
void delete_lookup_explanation(/* LookupExplanation* */);


/*
 ONE_RULE (union)
*/

Bool fis_one_rule(/* PseudoObject* */);
OneRule* create_one_rule_reduce(/* Reduce* */);
OneRule* create_one_rule_rule_id(/* Fact* */);
OneRule* create_one_rule_query(/* QueryExplanation* */);
OneRule* copy_one_rule(/* OneRule* */);
OneRule* new_one_rule();
void delete_one_rule(/* OneRule* */);


/*
 FACT
*/

Bool fis_fact(/* PseudoObject* */);
void decompose_fact(/* Fact*, char** */);
char* read_fact_data(/* Fact */);
Fact* create_fact(/* char* */);
Fact* copy_fact(/* Fact */);
Fact* set_fact(/* Fact*, char** */);
Fact* write_fact_data(/* Fact*, char** */);
Fact* new_fact();
void delete_fact(/* Fact */);

/*
 REDUCE (have ObjList)
*/

Bool fis_reduce(/* PseudoObject* */);
void decompose_reduce(/* Reduce*, SubGoal**, RuleId**, ObjList**, ObjList** */);
SubGoal* read_sub_goal_inReduce(/* Reduce* */);
RuleId* read_rule_id_inReduce(/* Reduce* */);
ObjList* read_explanations(/* Reduce* */);
ObjList* read_assumps(/* Reduce* */);
Reduce* create_reduce(/* SubGoal*, RuleId*, ObjList*, ObjList* */);
Reduce* copy_reduce(/* Reduce* */);
Reduce* set_reduce(/* Reduce*, SubGoal*, RuleId*, ObjList*, ObjList* */);
Reduce* write_sub_goal_inReduce(/* Reduce*, SubGoal* */);
Reduce* write_rule_id_inReduce(/* Reduce*, RuleId* */);
Reduce* write_explanations(/* Reduce*, ObjList* */);
Reduce* write_assumps(/* Reduce*, ObjList* */);
Reduce* new_reduce();
void delete_reduce(/* Reduce* */);
Reduce* insert_explanations(/* Reduce*, ObjList* */);
Reduce* insert_assumps(/* Reduce*, ObjList* */);
Reduce* add_explanations(/* Reduce*, ObjList* */);
Reduce* add_assumps(/* Reduce*, ObjList* */);
Explanation* car_of_explanations(/* Reduce* */);
Assump* car_of_assumps(/* Reduce* */);


/*
 SUB_GOAL (have ObjList)
*/

Bool fis_sub_goal(/* PseudoObject* */);
void decompose_sub_goal(/* SubGoal*, MId**, OTerm**, ObjList** */);
MId* read_m_id_inSubGoal(/* SubGoal* */);
OTerm* read_o_term_inSubGoal(/* SubGoal* */);
ObjList* read_vc_pairs_inSubGoal(/* SubGoal* */);
SubGoal* create_sub_goal(/* MId*, OTerm*, ObjList* */);
SubGoal* copy_sub_goal(/* SubGoal* */);
SubGoal* set_sub_goal(/* SubGoal*, MId*, OTerm*, ObjList* */);
SubGoal* write_m_id_inSubGoal(/* SubGoal*, MId* */);
SubGoal* write_o_term_inSubGoal(/* SubGoal*, OTerm* */);
SubGoal* write_vc_pairs_inSubGoal(/* SubGoal*, ObjList* */);
SubGoal* new_sub_goal();
void delete_sub_goal(/* SubGoal* */);
SubGoal* insert_vc_pairs_inSubGoal(/* SubGoal*, ObjList* */);
SubGoal* add_vc_pairs_inSubGoal(/* SubGoal*, ObjList* */);
VcPair* car_of_vc_pairs_inSubGoal(/* SubGoal* */);


/*
 VC_PAIR
*/

Bool fis_vc_pair(/* PseudoObject* */);
void decompose_vc_pair(/* VcPair*, Var**, Constraint** */);
Var* read_var_inVcPair(/* VcPair* */);
Constraint* read_constraint(/* VcPair* */);
VcPair* create_vc_pair(/* Var*, Constraint* */);
VcPair* copy_vc_pair(/* VcPair* */);
VcPair* set_vc_pair(/* VcPair*, Var*, Constraint* */);
VcPair* write_var_inVcPair(/* VcPair*, Var* */);
VcPair* write_constraint(/* VcPair*, Constraint* */);
VcPair* new_vc_pair();
void delete_vc_pair(/* VcPair* */);


/*
 CONSTRAINT
*/

Bool fis_constraint(/* PseudoObject* */);
void decompose_constraint(/* Constraint*, Con** */);
Con* read_const_data(/* Constraint* */);
Constraint* create_constraint(/* Con* */);
Constraint* copy_constraint(/* Constraint* */);
Constraint* set_constraint(/* Constraint*, Con* */);
Constraint* write_const_data(/* Constraint*, Con* */);
Constraint* new_constraint();
void delete_constraint(/* Constraint* */);


/*
 CON (have ObjList)
*/

Bool fis_con(/* PseudoObject* */);
void decompose_con(/* Con*, ObjList**, ObjList** */);
ObjList* read_o_terms1_inCon(/* Con* */);
ObjList* read_o_terms2_inCon(/* Con* */);
Con* create_con(/* ObjList*, ObjList* */);
Con* copy_con(/* Con* */);
Con* set_con(/* Con*, ObjList*, ObjList* */);
Con* write_o_terms1_inCon(/* Con*, ObjList* */);
Con* write_o_terms2_inCon(/* Con*, ObjList* */);
Con* new_con();
void delete_con(/* Con* */);
Con* insert_o_terms1_inCon(/* Con*, ObjList* */);
Con* insert_o_terms2_inCon(/* Con*, ObjList* */);
Con* add_o_terms1_inCon(/* Con*, ObjList* */);
Con* add_o_terms2_inCon(/* Con*, ObjList* */);
OTerm* car_of_o_terms1_inCon(/* Con* */);
OTerm* car_of_o_terms2_inCon(/* Con* */);


/*
 ASSUMP (have ObjList)
*/

Bool fis_assump(/* PseudoObject* */);
void decompose_assump(/* Assump*, MId**, Dot**, ObjList** */);
MId* read_m_id_inAssump(/* Assump* */);
Dot* read_dot_inAssump(/* Assump* */);
ObjList* read_vc_pairs_inAssump(/* Assump* */);
Assump* create_assump(/* MId*, Dot*, ObjList* */);
Assump* copy_assump(/* Assump* */);
Assump* set_assump(/* Assump*, MId*, Dot*, ObjList* */);
Assump* write_m_id_inAssump(/* Assump*, MId* */);
Assump* write_dot_inAssump(/* Assump*, Dot* */);
Assump* write_vc_pairs_inAssump(/* Assump*, ObjList* */);
Assump* new_assump();
void delete_assump(/* Assump* */);
Assump* insert_vc_pairs_inAssump(/* Assump*, ObjList* */);
Assump* add_vc_pairs_inAssump(/* Assump*, ObjList* */);
VcPair* car_of_vc_pairs_inAssump(/* Assump* */);


/*
 QUERY_EXPLANATION
*/

Bool fis_query_explanation(/* PseudoObject* */);
QueryExplanation* copy_query_explanation(/* QueryExplanation* */);
QueryExplanation* new_query_explanation();
void delete_query_explanation(/* QueryExplanation* */);



