/* typedef int Bool; */

/*
 VALUE (union)
*/

Bool fis_value(/* PseudoObject* */);
Value* create_value_set(/* Set* */);
Value* create_value_sort(/* Sort* */);
Value* create_value_o_term(/* OTerm* */);
Value* copy_value(/* Value* */);
Value* new_value();
void delete_value(/* Value* */);


/*
 SET (have ObjList)
*/

Bool fis_set(/* PseudoObject* */);
void decompose_set(/* Set*, ObjList** */);
ObjList* read_o_terms_inSet(/* Set* */);
Set* create_set(/* ObjList* */);
Set* copy_set(/* Set* */);
Set* set_set(/* Set*, ObjList* */);
Set* write_o_terms_inSet(/* Set*, ObjList* */);
Set* new_set();
void delete_set(/* Set* */);
Set* insert_o_terms_inSet(/* Set*, ObjList* */);
Set* add_o_terms_inSet(/* Set*, ObjList* */);
OTerm* car_of_o_terms_inSet(/* Set* */);


/*
 CNSTR (union)
*/

Bool fis_cnstr(/* PseudoObject* */);
Cnstr* create_cnstr_cnstr(/* CnstrData* */);
Cnstr* create_cnstr_query_cnstr(/* QueryCnstr* */);
Cnstr* copy_cnstr(/* Cnstr* */);
Cnstr* new_cnstr();
void delete_cnstr(/* Cnstr* */);


/*
 CNSTR_DATA
*/

Bool fis_cnstr_data(/* PseudoObject* */);
void decompose_cnstr_data(/* CnstrData*, MId**, Value**, CnRel*, 
				   MId**, Value** */);
MId* read_m_id1_inCnstrData(/* CnstrData* */);
Value* read_value1(/* CnstrData* */);        
CnRel read_rel_inCnstrData(/* CnstrData* */);
MId* read_m_id2_inCnstrData(/* CnstrData* */);
Value* read_value2(/* CnstrData* */);        
CnstrData* create_cnstr_data(/* MId*, Value*, CnRel, MId*, Value* */);
CnstrData* copy_cnstr_data(/* CnstrData* */);
CnstrData* set_cnstr_data(/* CnstrData*, MId*, Value*, CnRel, MId*, Value* */);
CnstrData* write_m_id1_inCnstrData(/* CnstrData*, MId* */);   
CnstrData* write_value1(/* CnstrData*, Value* */);   
CnstrData* write_rel_inCnstrData(/* CnstrData*, CnRel */);
CnstrData* write_m_id2_inCnstrData(/* CnstrData*, MId* */);   
CnstrData* write_value2(/* CnstrData*, Value* */);   
CnstrData* new_cnstr_data();
void delete_cnstr_data(/* CnstrData* */);


/*
 QUERY_CNSTR
*/
 
Bool fis_query_cnstr(/* PseudoObject* */);
void decompose_query_cnstr(/* QueryCnstr*, MId**, MId** */);
MId* read_m_id1_inQueryCnstr(/* QueryCnstr* */);
MId* read_m_id2_inQueryCnstr(/* QueryCnstr* */);
QueryCnstr* create_query_cnstr(/* MId*, MId* */);
QueryCnstr* copy_query_cnstr(/* QueryCnstr* */);
QueryCnstr* set_query_cnstr(/* QueryCnstr*, MId*, MId* */);
QueryCnstr* write_m_id1_inQueryCnstr(/* QueryCnstr*, MId* */);
QueryCnstr* write_m_id2_inQueryCnstr(/* QueryCnstr*, MId* */);
QueryCnstr* new_query_cnstr();
void delete_query_cnstr(/* QueryCnstr* */);


/*
 PROLOG (have ObjList)
*/

Bool fis_prolog(/* PseudoObject* */);
void decompose_prolog(/* Prolog*, char**, ObjList** */);
char* read_head_inProlog(/* Prolog* */);
ObjList* read_o_terms_inProlog(/* Prolog* */);
Prolog* create_prolog(/* char*, ObjList* */);
Prolog* copy_prolog(/* Prolog* */);
Prolog* set_prolog(/* Prolog*, char*, ObjList* */);
Prolog* write_head_inProlog(/* Prolog*, char* */);
Prolog* write_o_terms_inProlog(/* Prolog*, ObjList* */);
Prolog* new_prolog();
void delete_prolog(/* Prolog* */);
Prolog* insert_o_terms_inProlog(/* Prolog*, ObjList* */);
Prolog* add_o_terms_inProlog(/* Prolog*, ObjList* */);
OTerm* car_of_o_terms_inProlog(/* Prolog */);


/*
 VAR
*/

Bool fis_var(/* PseudoObject* */);
void decompose_var(/* Var*, VarType*, char** */);
VarType read_type(/* Var* */);
char* read_var_data(/* Var* */);
Var* create_var(/* VarType, char* */);
Var* copy_var(/* Var* */);
Var* set_var(/* Var*, VarType, char* */);
Var* write_type(/* Var*, VarType */);
Var* write_var_data(/* Var*, char* */);
Var* new_var();
void delete_var(/* Var* */);


/*
 SORT
*/

Bool fis_sort(/* PseudoObject* */);
void decompose_sort(/* Sort*, Prolog** */);
Prolog* read_prolog(/* Sort* */);
Sort* create_sort(/* Prolog* */);
Sort* copy_sort(/* Sort* */);
Sort* set_sort(/* Sort*, Prolog* */);
Sort* write_prolog(/* Sort*, Prolog* */);
Sort* new_sort();
void delete_sort(/* Sort* */);


/*
 QUERY (have ObjList)
*/
 
Bool fis_query(/* PseudoObject* */);
void decompose_query(/* Query*, RuleClass*, ATerm** ObjList**, ObjList**,
			ObjList**, Program** */);
RuleClass read_query_class(/* Query* */);
ATerm* read_q_head(/* Query */);
ObjList* read_clusters_inQuery(/* Query* */);
ObjList* read_cnstrs_inQuery(/* Query* */);
ObjList* read_q_modes(/* Query* */);
Program* read_program_inQuery(/* Query* */);
Query* create_query(/* RuleClass, ATerm*, ObjList*, ObjList*, ObjList*, 
		       Program* */);
Query* copy_query(/* Query* */);
Query* set_query(/* Query*, RuleClass, ATerm*, ObjList*, ObjList*,
			ObjList*, Program* */);
Query* write_query_class(/* Query*, RuleClass */);
Query* write_q_head(/* Query*, ATerm* */);
Query* write_clusters_inQuery(/* Query*, ObjList* */);
Query* write_cnstrs_inQuery(/* Query*, ObjList* */);
Query* write_q_modes(/* Query*, ObjList* */);
Query* write_program_inQuery(/* Query*, Program* */);
Query* new_query();
void delete_query(/* Query* */);
Query* insert_clusters(/* Query*, ObjList* */);
Query* insert_cnstrs(/* Query*, ObjList* */);
Query* insert_q_modes(/* Query*, ObjList* */);
Query* add_clusters(/* Query*, ObjList* */);
Query* add_cnstrs(/* Query*, ObjList* */);
Query* add_q_modes(/* Query*, ObjList* */);
Cluster* car_of_clusters(/* Query* */);
Cnstr* car_of_cnstrs(/* Query* */);
QMode* car_of_q_modes(/* Query* */);


/*
 Q_MODE (union)
*/

Bool fis_q_mode(/* PseudoObject* */);
QMode* create_q_mode_p_mode(/* PMode* */);
QMode* create_q_mode_a_mode(/* AMode* */);
QMode* create_q_mode_i_mode(/* IMode* */);
QMode* create_q_mode_m_mode(/* MMode* */);
QMode* create_q_mode_e_mode(/* EMode* */);
QMode* copy_q_mode(/* QMode* */);
QMode* new_q_mode();
void delete_q_mode(/* QMode* */);


/*
 P_MODE
*/

Bool fis_p_mode(/* PseudoObject* */);
void decompose_p_mode(/* PMode*, PModeData* */); 
PModeData read_p_mode_data(/* PMode* */);
PMode* create_p_mode(/* PModeData */);
PMode* copy_p_mode(/* PMode* */);
PMode* set_p_mode(/* PMode*, PModeData */);
PMode* write_p_mode_data(/* PMode*, PModeData */);
PMode* new_p_mode();
void delete_p_mode(/* PMode* */);


/*
 A_MODE
*/

Bool fis_a_mode(/* PseudoObject* */);
void decompose_a_mode(/* AMode*, AModeData* */); 
AModeData read_a_mode_data(/* AMode* */);
AMode* create_a_mode(/* AModeData */);
AMode* copy_a_mode(/* AMode* */);
AMode* set_a_mode(/* AMode*, AModeData */);
AMode* write_a_mode_data(/* AMode*, AModeData */);
AMode* new_a_mode();
void delete_a_mode(/* AMode* */);


/*
 I_MODE
*/

Bool fis_i_mode(/* PseudoObject* */);
void decompose_i_mode(/* IMode*, IModeData* */); 
IModeData read_i_mode_data(/* IMode* */);
IMode* create_i_mode(/* IModeData */);
IMode* copy_i_mode(/* IMode* */);
IMode* set_i_mode(/* IMode*, IModeData */);
IMode* write_i_mode_data(/* IMode*, IModeData */);
IMode* new_i_mode();
void delete_i_mode(/* IMode* */);


/*
 M_MODE
*/

Bool fis_m_mode(/* PseudoObject* */);
void decompose_m_mode(/* MMode*, MModeData* */); 
MModeData read_m_mode_data(/* MMode* */);
MMode* create_m_mode(/* MModeData */);
MMode* copy_m_mode(/* MMode* */);
MMode* set_m_mode(/* MMode*, MModeData */);
MMode* write_m_mode_data(/* MMode*, MModeData */);
MMode* new_m_mode();
void delete_m_mode(/* MMode* */);


/*
 E_MODE
*/

Bool fis_e_mode(/* PseudoObject* */);
void decompose_e_mode(/* EMode*, EModeData* */); 
EModeData read_e_mode_data(/* EMode* */);
EMode* create_e_mode(/* EModeData* */);
EMode* copy_e_mode(/* EMode* */);
EMode* set_e_mode(/* EMode*, EModeData* */);
EMode* write_e_mode_data(/* EMode*, EModeData* */);
EMode* new_e_mode();
void delete_e_mode(/* EMode* */);


/*
 ANSWER (have ObjList)
*/

Bool fis_answer(/* PseudoObject* */);
void decompose_answer(/* Answer*, ObjList** */);
ObjList* read_answer_elements(/* Answer* */);
Answer* create_answer(/* ObjList* */);
Answer* copy_answer(/* Answer* */);
Answer* set_answer(/* Answer*, ObjList* */);
Answer* write_answer_elements(/* Answer*, ObjList* */);
Answer* new_answer();
void delete_answer(/* Answer* */);
Answer* insert_answer_elements(/* Answer*, ObjList* */);
Answer* add_answer_elements(/* Answer*, ObjList* */);
AnswerElement* car_of_answer_elements(/* Answer* */);


/*
 ANSWER_ELEMENT (have ObjList)
*/

Bool fis_answer_element(/* PseudoObject* */);
void decompose_answer_element(/* AnswerElement*, ObjList**, 
				 ObjList**, AnseExplanation** */);
ObjList* read_dot_cnstrs(/* AnswerElement* */);
ObjList* read_var_cnstrs(/* AnswerElement* */);
AnseExplanation* read_anse_explanation(/* AnswerElement* */);
AnswerElement* create_answer_element(/* ObjList*, ObjList*, 
					AnseExplanation* */);
AnswerElement* copy_answer_element(/* AnswerElement* */);
AnswerElement* set_answer_element(/* AnswerElement*, ObjList*, 
				     ObjList*, AnseExplanation* */);
AnswerElement* write_dot_cnstrs(/* AnswerElement*, ObjList* */);
AnswerElement* write_var_cnstrs(/* AnswerElement*, ObjList* */);
AnswerElement* write_anse_explanation
                        (/* AnswerElement*, AnseExplanation* */);
AnswerElement* new_answer_element();
void delete_answer_element(/* AnswerElement* */);
AnswerElement* insert_dot_cnstrs(/* AnswerElement*, ObjList* */);
AnswerElement* insert_var_cnstrs(/* AnswerElement*, ObjList* */);
AnswerElement* add_dot_cnstrs(/* AnswerElement*, ObjList* */);
AnswerElement* add_var_cnstrs(/* AnswerElement*, ObjList* */);
DotCnstr* car_of_dot_cnstrs(/* AnswerElement* */);
VarCnstr* car_of_var_cnstrs(/* AnswerElement* */);


/*
 ANSE_EXPLANATION (have ObjList)
*/

Bool fis_anse_explanation(/* PseudoObject* */);
void decompose_anse_explanation(/* AnseExplanation*, Explanation**,
				   ObjList** */);
Explanation* read_explanation_inAnseExplanation(/* AnseExplanation* */);
ObjList* read_rir_pairs(/* AnseExplanation* */);
AnseExplanation* create_anse_explanation(/* Explanation*, ObjList* */);
AnseExplanation* copy_anse_explanation(/* AnseExplanation* */);
AnseExplanation* set_anse_explanation(/* AnseExplanation*, Explanation*,
					 ObjList* */);
AnseExplanation* write_explanation_inAnseExplanation
                        (/* AnseExplanation*, Explanation* */);
AnseExplanation* write_rir_pairs(/* AnseExplanation*, ObjList* */);
AnseExplanation* new_anse_explanation();
void delete_anse_explanation(/* AnseExplanation* */);
AnseExplanation* insert_rir_pairs(/* AnseExplanation*, ObjList* */);
AnseExplanation* add_rir_pairs(/* AnseExplanation*, ObjList* */);
RirPair* car_of_rir_pairs(/* AnseExplanation* */);


/*
 RIR_PAIR
*/

Bool fis_rir_pair(/* PseudoObject* */);
void decompose_rir_pair(/* RirPair*, RuleId**, Rule** */);
RuleId* read_rule_id_inRirPair(/* RirPair* */);
Rule* read_rule(/* RirPair* */);
RirPair* create_rir_pair(/* RuleId*, Rule* */);
RirPair* copy_rir_pair(/* RirPair* */);
RirPair* set_rir_pair(/* RirPair*, RuleId*, Rule* */);
RirPair* write_rule_id_inRirPair(/* RirPair*, RuleId* */);
RirPair* write_rule(/* RirPair*, Rule* */);
RirPair* new_rir_pair();
void delete_rir_pair(/* RirPair* */);

/*
 DOT_CNSTR
*/

Bool fis_dot_cnstr(/* PseudoObject* */);
void decompose_dot_cnstr(/* DotCnstr*, MId**, Dot**, CnRel*, Value** */);
MId* read_m_id_inDotCnstr(/* DotCnstr* */);
Dot* read_dot_inDotCnstr(/* DotCnstr* */);
CnRel read_rel_inDotCnstr(/* DotCnstr* */);
Value* read_value_inDotCnstr(/* DotCnstr* */);
DotCnstr* create_dot_cnstr(/* MId, Dot*, CnRel, Value* */);
DotCnstr* copy_dot_cnstr(/* DotCnstr* */);
DotCnstr* set_dot_cnstr(/* DotCnstr*, MId*, Dot*, CnRel, Value* */);
DotCnstr* write_m_id_inDotCnstr(/* DotCnstr*, MId* */);
DotCnstr* write_dot_inDotCnstr(/* DotCnstr*, Dot* */);
DotCnstr* write_rel_inDotCnstr(/* DotCnstr*, CnRel */);
DotCnstr* write_value_inDotCnstr(/* DotCnstr*, Value* */);
DotCnstr* new_dot_cnstr();
void delete_dot_cnstr(/* DotCnstr* */);


/*
 VAR_CNSTR
*/

Bool fis_var_cnstr(/* PseudoObject* */);
void decompose_var_cnstr(/* VarCnstr*, Var**, CnRel*, Value** */);
Var* read_var_inVarCnstr(/* VarCnstr* */);
CnRel read_rel_inVarCnstr(/* VarCnstr* */);
Value* read_value_inVarCnstr(/* VarCnstr* */);
VarCnstr* create_var_cnstr(/* Var*, CnRel, Value* */);
VarCnstr* copy_var_cnstr(/* VarCnstr* */);
VarCnstr* set_var_cnstr(/* VarCnstr*, Var*, CnRel, Value* */);
VarCnstr* write_var_inVarCnstr(/* VarCnstr*, Var* */);
VarCnstr* write_rel_inVarCnstr(/* VarCnstr*, CnRel */);
VarCnstr* write_value_inVarCnstr(/* VarCnstr*, Value* */);
VarCnstr* new_var_cnstr();
void delete_var_cnstr(/* VarCnstr* */);


