/******* functions *******/
/*   mod_def */
Bool              fis_mod_def();
void              decompose_mod_def();
ModDef*           create_mod_def();
ModDef*           copy_mod_def();
ModDef*           set_mod_def();
ModDef*           new_mod_def();
ModDef*           insert_m_subs();
ModDef*           add_m_subs();
MSub*             car_of_m_subs();
void              delete_mod_def();

/*  m_sub  */
Bool              fis_m_sub();
void              decompose_m_sub();
MId*              read_m_id_inMSub();
MDesc*            read_m_desc();
MSub*             create_m_sub();
MSub*             copy_m_sub();
MSub*             set_m_sub();
MSub*             write_m_id_inMSub();
MSub*             write_m_desc();
MSub*             new_m_sub();
void              delete_m_sub();

/* m_desc */
Bool              fis_m_desc();
MDesc*            create_m_desc_m_id();
MDesc*            create_m_desc_m2_desc();
MDesc*            new_m_desc();
MDesc*            copy_m_desc();
void              delete_m_desc();

/*  m2_desc */
Bool              fis_m2_desc();
void              decompose_m2_desc();
MDesc*            read_m_desc1();
char              read_op();
MDesc*            read_m_desc2();
M2Desc*           create_m2_desc();
M2Desc*           copy_m2_desc();
M2Desc*           set_m2_desc();
M2Desc*           write_m_desc1();
M2Desc*           write_op();
M2Desc*           write_m_desc2();
M2Desc*           new_m2_desc();
void              delete_m2_desc();

/*  link_def  */
Bool              fis_link_def();
void              decompose_link_def();
LinkDef*          create_link_def();
LinkDef*          copy_link_def();
LinkDef*          set_link_def();
LinkDef*          new_link_def();
LinkDef*          insert_links();
Link*             car_of_links();
LinkDef*          add_links();
void              delete_link_def();

/*  link  */
Bool              fis_link();
void              decompose_link();
char*             read_link_name();
ObjList*          read_m_ids_inLink();
ObjList*          read_o_terms_inLink();
Link*             create_link();
Link*             copy_link();
Link*             set_link();
Link*             write_link_name();
Link*             write_m_ids_inLink();
Link*             write_o_terms_inLink();
Link*             new_link();
Link*             insert_m_ids_inLink();
Link*             insert_o_terms_inLink();
Link*             add_m_ids_inLink();
Link*             add_o_terms_inLink();
MId*              car_of_m_ids_inLink();
OTerm*            car_of_o_terms_inLink();
void              delete_link();

/*  m_id_pair */
Bool              fis_m_id_pair();
void              decompose_m_id_pair();
MId*              read_m_id1();
MId*              read_m_id2();
MIdPair*          create_m_id_pair();
MIdPair*          copy_m_id_pair();
MIdPair*          set_m_id_pair();
MIdPair*          write_m_id1();
MIdPair*          write_m_id2();
MIdPair*          new_m_id_pair();
void              delete_m_id_pair();

/*  o_term_pair */
Bool              fis_o_term_pair();
void              decompose_o_term_pair();
OTerm*            read_o_term1();
OTerm*            read_o_term2();
OTermPair*        create_o_term_pair();
OTermPair*        copy_o_term_pair();
OTermPair*        set_o_term_pair();
OTermPair*        write_o_term1();
OTermPair*        write_o_term2();
OTermPair*        new_o_term_pair();
void              delete_o_term_pair();

/*  rule_def  */
Bool              fis_rule_def();
void              decompose_rule_def();
RuleDef*          create_rule_def();
RuleDef*          copy_rule_def();
RuleDef*          set_rule_def();
RuleDef*          new_rule_def();
RuleDef*          insert_rules();
RuleDef*          add_rules();
Rule*             car_of_rules();
void              delete_rule_def();

/*  rule  */
Bool              fis_rule();
void              decompose_rule();
RuleClass         read_rule_class();
ObjList*          read_m_ids_inRule();
RuleId*           read_rule_id_inRule();
InheritanceMode   read_inheritance_mode();
NoAssume          read_no_assume();
ATerm*            read_head_inRule();
ObjList*          read_clusters_inRule();
ObjList*          read_cnstrs_inRule();
Rule*             create_rule();
Rule*             copy_rule();
Rule*             set_rule();
Rule*             write_rule_class();
Rule*             write_m_ids_inRule();
Rule*             write_rule_id_inRule();
Rule*             write_inheritance_mode_inRule();
Rule*             write_no_assume_inRule();
Rule*             write_head_inRule();
Rule*             write_clusters_inRule();
Rule*             write_cnsters_inRule();
Rule*             insert_m_ids_inRule();
Rule*             insert_clusters_inRule();
Rule*             insert_cnstrs_inRule();
Rule*             add_m_ids_inRule();
Rule*             add_clusters_inRule();
Rule*             add_cnstrs_inRule();
MId*              car_of_m_ids_inRule();
Cluster*          car_of_clusters_inRule();
Cnstr*            car_of_cnstrs_inRule();
Rule*             new_rule();
void              delete_rule();

/*  rule_id  */
Bool              fis_rule_id();
void              decompose_rule_id();
RuleId*           create_rule_id();
RuleId*           copy_rule_id();
RuleId*           set_rule_id();
RuleId*           new_rule_id();
void              delete_rule_id();

/*  cluster  */
Bool              fis_cluster();
Cluster*          create_cluster_normal();
Cluster*          create_cluster_rel();
Cluster*          create_cluster_update();
Cluster*          create_cluster_transaction();
Cluster*          create_cluster_consis();
Cluster*          create_cluster_inconsis();
Cluster*          copy_cluster();
Cluster*          new_cluster();
void              delete_cluster();

/*   normal  */
Bool              fis_normal();
Normal*           create_normal();
MId*              read_m_id_inNormal();
ATerm*            read_a_term_inNormal();
Normal*           copy_normal();
Normal*           set_normal();
Normal*           write_m_id_inNormal();
Normal*           write_a_term_inNormal();
Normal*           new_normal();
void              delete_normal();

/*  rel  */
Bool              fis_rel();
void              decompose_rel();
OTerm*            read_o_term1_inRel();
CnRel             read_sub_rel_inRel();
OTerm*            read_o_term2_inRel();
Rel*              create_rel();
Rel*              copy_rel();
Rel*              set_rel();
Rel*              write_o_term1_inRel();
Rel*              write_sub_rel_inRel();
Rel*              write_o_term2_inRel();
Rel*              new_rel();
void              delete_rel();

/*  update */
Bool              fis_update();
void              decompose_update();
UFlag             read_u_flag();
MId*              read_m_id_inUpdate();
ATerm*            read_a_term_inUpdate();
Update*           create_update();
Update*           copy_update();
Update*           set_update();
Update*           write_u_flag();
Update*           write_m_id_inUpdate();
Update*           write_a_term_inUpdate();
Update*           new_update();
void              delete_update();

/*  transaction  */
Bool              fis_transaction();
void              decompose_transaction();
Transaction*      create_transaction();
Transaction*      copy_transaction();
Transaction*      set_transaction();
Transaction*      new_transaction();
void              delete_transaction();

/*  i_check_content  */
Bool              fis_i_check_content();
ICheckContent*    copy_i_check_content();
ICheckContent*    create_i_check_content_prop();
ICheckContent*    create_i_check_content_cnstrs();
ICheckContent*    new_i_check_content();
void              delete_i_check_content();

/*  i_check  */
Bool              fis_i_check();
Bool              fis_consis();
Bool              fis_inconsis();
void              decompose_i_check();
ICheck*           create_i_check();
Consis*           create_consis();
InConsis*         create_inconsis();
ICheck*           copy_i_check();
ICheck*           set_i_check();
ICheck*           new_i_check();
Consis*           new_consis();
InConsis*         new_inconsis();
void              delete_i_check();

/*  prop  */
Bool              fis_prop();
void              decompose_prop();
MId*              read_m_id_inProp();
ATerm*            read_a_term_inProp();
Prop*             create_prop();
Prop*             copy_prop();
Prop*             set_prop();
Prop*             write_m_id_inProp();
Prop*             write_a_term_inProp();
Prop*             new_prop();
void              delete_prop();

/*  a_term  */
Bool              fis_a_term();
void              decompose_a_term();
OTerm*            read_o_term_inATerm();
ObjList*          read_attrs_inATerm();
ObjList*          read_cnstrs_inATerm();
ATerm*            create_a_term();
ATerm*            copy_a_term();
ATerm*            set_a_term();
ATerm*            write_o_term_inATerm();
ATerm*            write_attrs_inATerm();
ATerm*            write_cnstrs_inATerm();
ATerm*            new_a_term();
ATerm*            insert_attrs_inATerm();
ATerm*            insert_cnstrs_inATerm();
ATerm*            add_attrs_inATerm();
ATerm*            add_cnstrs_inATerm();
Attr*             car_of_attrs_inATerm();
Cnstr*            car_of_cnstrs_inATerm();
void              delete_a_term();

/*  o_term  */
Bool              fis_o_term();
OTerm*            create_o_term_prolog();
OTerm*            create_o_term_c_o_term();
OTerm*            create_o_term_var();
OTerm*            create_o_term_dot();
OTerm*            create_o_term_list();
OTerm*            create_o_term_non_struct();
OTerm*            copy_o_term();
OTerm*            new_o_term();
void              delete_o_term();

/*  c_o_term  */
Bool              fis_c_o_term();
void              decompose_c_o_term();
char*             read_head_inCOTerm();
ObjList*          read_attrs_inCOTerm();
ObjList*          read_cnstrs_inCOTerm();
COTerm*           create_c_o_term();
COTerm*           copy_c_o_term();
COTerm*           set_c_o_term();
COTerm*           write_head_inCOTerm();
COTerm*           write_attrs_inCOTerm();
COTerm*           write_cnstrs_inCOTerm();
COTerm*           new_c_o_term();
COTerm*           insert_attrs_inCOTerm();
COTerm*           insert_cnstrs_inCOTerm();
COTerm*           add_attrs_inCOTerm();
COTerm*           add_cnstrs_inCOTerm();
Attr*             car_of_attrs_inCOTerm();
Cnstr*            car_of_cnstrs_inCOTerm();
void              delete_c_o_term();

/*  dot  */
Bool              fis_dot();
void              decompose_dot();
OTerm*            read_o_term_inDot();
Label*            read_label_inDot();
Dot*              create_dot();
Dot*              copy_dot();
Dot*              set_dot();
Dot*              write_o_term_inDot();
Dot*              write_label_inDot();
Dot*              new_dot();
void              delete_dot();

/*  label  */
Bool              fis_label();
Bool              fis_ind_lab();
Bool              fis_set_lab();
Bool              fis_curl_ind();
Bool              fis_curl_set();
void              decompose_label();
Label*            create_label();
IndLab*           create_ind_lab();
SetLab*           create_set_lab();
CurlInd*          create_curl_ind();
CurlSet*          create_curl_set();
Label*            copy_label();
Label*            set_label();
Label*            new_label();
IndLab*              new_ind_lab();
SetLab*              new_set_lab();
CurlInd*          new_curl_ind();
CurlSet*          new_curl_set();
void              delete_label();

/*  list  */
Bool              fis_list();
List*             create_list_normal();
List*             create_list_sub_list();
List*             copy_list();
List*             new_list();
void              delete_list();

/*  sub_list  */
Bool              fis_sub_list();
void              decompose_sub_list();
ObjList*          read_o_terms_inSubList();
Remain*           read_remain_inSubList();
SubList*          create_sub_list();
SubList*          copy_sub_list();
SubList*          set_sub_list();
SubList*          write_o_terms_inSubList();
SubList*          write_remain_inSubList();
SubList*          new_sub_list();
SubList*          insert_o_terms_inSubList();
SubList*          add_o_terms_inSubList();
OTerm*            car_of_o_terms_inSubList();
void              delete_sub_list();

/*  remain  */
Bool              fis_remain();
Remain*           create_remain_list();
Remain*           create_remain_var();
Remain*           copy_remain();
Remain*           new_remain();
void              delete_remain();

/*  non_struct  */
Bool              fis_non_struct();
NonStruct*        create_non_struct_exp_name();
NonStruct*        create_non_struct_string();
NonStruct*        create_non_struct_integer();
NonStruct*        copy_non_struct();
NonStruct*        new_non_struct();
void              delete_non_struct();

/*  exp_name  */
Bool              fis_exp_name();
void              decompose_exp_name();
ExpName*          create_exp_name();
ExpName*          copy_exp_name();
ExpName*          set_exp_name();
ExpName*          new_exp_name();
void              delete_exp_name();

/*  integer  */
Bool              fis_integer();
void              decompose_integer();
Integer*          create_integer();
Integer*          copy_integer();
Integer*          set_integer();
Integer*          new_integer();
void              delete_integer();

/*  attr  */
Bool              fis_attr();
void              decompose_attr();
Label*            read_label_inAttr();
AttrOp            read_attr_op();
Value*            read_value();
Attr*             create_attr();
Attr*             copy_attr();
Attr*             set_attr();
Attr*             write_label_inAttr();
Attr*             write_attr_op();
Attr*             write_value();
Attr*             new_attr();
void              delete_attr();
