/*
SGPC: Simple Genetic Programming in C
(c) 1993 by Walter Alden Tackett and Aviram Carmi
 
 This code and documentation is copyrighted and is not in the public domain.
 All rights reserved. 
 
 - This notice may not be removed or altered.
 
 - You may not try to make money by distributing the package or by using the
   process that the code creates.
 
 - You may not distribute modified versions without clearly documenting your
   changes and notifying the principal author.
 
 - The origin of this software must not be misrepresented, either by
   explicit claim or by omission.  Since few users ever read sources,
   credits must appear in the documentation.
 
 - Altered versions must be plainly marked as such, and must not be
   misrepresented as being the original software.  Since few users ever read
   sources, credits must appear in the documentation.
 
 - The authors are not responsible for the consequences of use of this 
   software, no matter how awful, even if they arise from flaws in it.
 
If you make changes to the code, or have suggestions for changes,
let us know!  (gpc@ipld01.hac.com)
*/

#ifndef _PROTO_H_
#define _PROTO_H_

#ifndef lint
static char proto_h_rcsid[]="$Id: proto.h,v 2.14 1993/04/15 09:14:39 gpc-avc Exp gpc-avc $";
#endif

/*
 *
 * $Log: proto.h,v $
 * Revision 2.14  1993/04/15  09:14:39  gpc-avc
 * Added bsd_qsort()
 *
 * 
 */

#if __STDC__ || defined(__cplusplus)
#define P_(s) s
#include <stddef.h>
#else
#define P_(s) ()
#endif

/* gpc.c */

int main P_((
  int	argc,
  char	**argv,
  char	**envp
  ));
void startup P_((
  int		argc,
  char		**argv,
  int		*numpops,
  int 		*numgens,
  int 		*start_gen,
  FILE		**ckpt_file,
  pop_struct 	**pop
  ));
void run_gp_system P_((
  int		numpops,
  int  		numgens,
  int 		start_gen,
  pop_struct 	*pop
  ));

/* treeio.c */
int read_terminal_set_values P_((
  pop_struct *pop,
  int p,
  FILE *f
  ));
void load_terminal_set_values P_((
  pop_struct *pop,
  int p,
  float *v
  ));
tree *read_tree P_((
  pop_struct *pop,
  int p,
  FILE *f
  ));
void write_tree P_((
  pop_struct *pop,
  tree *t,
  char *format,
  FILE *f
  ));
void pprint_tree P_((
  pop_struct *pop,
  tree *t,
  char *format,
  FILE *f,
  int level
  ));
int lookup_function_name P_((
  pop_struct *pop,
  int p,
  char *buf
  ));
int lookup_terminal_name P_((
  pop_struct *pop,
  int p,
  char *buf
  ));
void get_next_token P_((
  char *buf,
  FILE *f
  ));
void blanks P_((
  int n,
  FILE *f
  ));

/* treegen.c */
tree *create_random_tree P_((
  pop_struct *pop,
  int p,
  int max_depth,
  int root_p,
  int full_p
  ));

/* treeops.c */
tree *copy_tree P_((
  tree *t
  ));
void free_tree P_((
  tree *t
  ));
tree *create_tree_node P_((
  int pop,
  int nodetype,
  int id
  ));
void init_function P_((
  tree *t
  ));
void init_terminal P_((
  tree *t
  ));
tree *copy_function P_((
  tree *t
  ));
tree *copy_terminal P_((
  tree *t
  ));
void free_function P_((
  tree *t
  ));
void free_terminal P_((
  tree *t
  ));

/* selection.c */
tree *find_tree P_((
  pop_struct 	*pop,
  int 		p,
  int		*worst,
  int		*best
  ));
float random_float_with_overselect P_((
  pop_struct *pop,
  int p
  ));
tree *find_tree_using_tournament_2 P_((
  pop_struct *pop,
  int p
  ));
tree *find_tree_using_tournament P_((
  pop_struct *pop,
  int 	p,
  int	*worst,
  int	*best
  ));
tree *find_tree_using_fitnessprop P_((
  pop_struct *pop,
  int p,
  float thresh
  ));

/* crossover.c */
int count_crossover_pts P_((
  tree *t
  ));
void crossover_at_any_pt P_((
  pop_struct *pop,
  tree *p1,
  tree *p2,
  tree **o1,
  tree **o2
  ));
void crossover_at_func_pt P_((
  pop_struct *pop,
  tree *p1,
  tree *p2,
  tree **o1,
  tree **o2
  ));
void validate_crossover P_((
  pop_struct *pop,
  tree *p1,
  tree *p2,
  tree **o1,
  tree **o2
  ));
int depth_of_tree P_((
  tree *t
  ));
int count_crossover_pts P_((
  tree *t
  ));
int count_function_pts P_((
  tree *t
  ));
tree *get_subtree P_((
  tree *t,
  int n
  ));
tree *gs P_((
  tree *t,
  int *n
  ));
tree *get_function_subtree P_((
  tree *t,
  int n
  ));
tree *gfs P_((
  tree *t,
  int *n
  ));
tree **pointer_to_subtree P_((
  tree **pointer,
  tree *subt
  ));

/* populations.c */
void allocate_populations P_((
  int numpops,
  pop_struct *pop
  ));
void initialize_populations P_((
  int numpops,
  pop_struct *pop
  ));
void breed_new_population P_((
  pop_struct *pop,
  int p
  ));
void free_population P_((
  pop_struct *pop,
  int p
  ));
void load_new_population P_((
  pop_struct *pop,
  int p
  ));

/* generations.c */
void generations P_((
  int		numpops,
  int		numgens,
  int		start_gen,
  pop_struct	*pop
  ));
void dump_population P_((
  pop_struct *pop,
  int p
  ));
void zero_fitness_of_populations P_((
  int	     numpops,
  pop_struct *pop,
  int	     p
  ));
void sort_population_by_fitness P_((
  pop_struct *pop,
  int p
  ));
void add_parsimony_to_fitness P_((
  pop_struct *pop,
  int p
  ));
void normalize_fitness_of_population P_((
  pop_struct *pop,
  int p
  ));
void report_on_generation P_((
  int g,
  pop_struct *pop,
  int p
  ));
void report_on_run P_((
  int	     numpops,
  pop_struct *pop
  ));

/* mutation.c */
tree *mutate P_((
  pop_struct 	*pop,
  tree 		*t
  ));

/* eval.c */
GENERIC eval P_((
  tree *t
  ));

GENERIC evaluate_tree P_((
  tree *t
  ));

/* getparams.c */
void getparams P_((
  int		argc,
  char		**argv,
  int 		*numpops,
  int		*numgens,
  int 		*start_gen,
  FILE		**ckpt_file,
  pop_struct 	**pop
  ));
void defaultparams P_((
  pop_struct *pop,
  int i
  ));
void readparams P_((
  pop_struct *pop,
  int i,
  FILE *f
  ));
void writeparams P_((
  pop_struct *pop,
  int i,
  FILE *f
  ));
void checkpoint P_((
  int           numpops,
  int           numgens,
  pop_struct 	*pop,
  int		g
  ));
void recover_params P_((
  FILE		*cf,
  int           *numpops,
  int           *numgens,
  pop_struct	**pop,
  int		*g
  ));


/* fitness.c */
void evaluate_fitness_of_populations P_((
  int numpops,
  int numgens,
  pop_struct *pop,
  int p
  ));
float evaluate_fitness_of_individual P_((
     pop_struct	*pop,
     int	p,
     tree	*t,
     int	i
     ));
float validate_fitness_of_tree P_((
  int numpops,
  int numgens,
  pop_struct *pop,
  int	p,
  tree *t
  ));
int terminate_early P_((
  int numpops,
  int numgens,
  pop_struct *pop
  ));
void define_fitness_cases P_((
  int numpops,
  int numgens,
  pop_struct *pop
  ));

/* setup.c */
void make_function_table P_((
  int numpops,
  pop_struct *pop
  ));
void make_terminal_table P_((
  int numpops,
  pop_struct *pop
  ));

#include "random.h"

#ifdef ANSI_FUNC

/* system library routines */

VOID setbuffer P_((
  FILE *stream,
  char *buf,
  int  size
  ));

int printf P_((
  const char *format,
  ...
  ));

int fprintf P_((
  FILE *stream,
  const char *format,
  ...
  ));

int fscanf P_((
  FILE *stream,
  const char *format,
  ...
  ));

int scanf P_((
  const char *format,
  ...
  ));

int sscanf P_((
  char *s,
  const char *format,
  ...
  ));

int getc P_((
  FILE *stream
  ));


int ungetc P_((
  int c,
  FILE *stream
  ));

int fclose P_((
  FILE *stream
  ));

FILE *fopen P_((
  const char *filename,
  const char *mode
  ));

VOID perror P_((
  const char *s
  ));

int strcasecmp P_((
  const char *s1,
  const char *s2
  ));

int isspace P_((
  int c
  ));

void *malloc P_((
  size_t size
  ));

int bsd_qsort P_((
  const void *base,
  size_t nmemb,
  size_t size,
  int (*compar) P_((
         const void *,
         const void *
         ))
   ));

#endif

#endif
