/* 
	IMINL.H:  Inlines and constants for Imogene
	Copyright 1993 Harley Davis
*/

#include <math.h>

const double pi 			= 3.1415926535897932626;
const long lResultMax 		= 32767;
const double dResultMax 	= (double)lResultMax;
const long lResultMax_1 	= lResultMax-1;
const long lResultMax2 		= lResultMax/2;
const double dResultMax2 	= dResultMax/2;
const long lMaxDist 		= long(hypot(dResultMax, dResultMax));
const int nPalSize 			= 256;
const double ScaledPi		= (2*pi)/dResultMax;
const int lShowLines 		= 10;
const int MaxProgramLength 	= 1024;
const double dLogFactor 	= dResultMax/log(dResultMax);

extern long *lsin_table;
extern long *lcos_table;
extern long *lln_table;
// static long lasin_table[lMaxResult];

inline long lScale(long x, long XMax = lResultMax, long ResultMax = lResultMax)
{   
	if (XMax==0)
		return 0; 	// reasonable?
	else
		return (ResultMax*x)/XMax;
}

inline double dScale(double x, double XMax, double ResultMax = dResultMax)
{
	if (XMax==0)
		return 0;	// reasonable?
	else
		return (ResultMax*x)/XMax;
}

inline long lEvResult(long x)
{
	return (x<0 ? (-x)%lResultMax : x%lResultMax);
}

inline long lsin(long x) { return lsin_table[x]; }
inline long lcos(long x) { return lcos_table[x]; }
inline long lln(long x)  { return lln_table[x]; }

void init_math();
void end_math();
	