
Magnitude subclass: #Ran2
  instanceVariableNames: 
    'm ia ic iy ir idum '
  classVariableNames: ''
  poolDictionaries: '' !


!Ran2 class methods !

standardInitialize
        "Answer a randomizer initialized with
            standard value"

    ^self new initialize: -1618033.! !



!Ran2 methods !
 
getMax: anInt
        "comment"

    | theNo theInt |

   theNo := self next.

    theInt := (theNo * anInt asFloat ) truncated.
    (theInt > (anInt - 1))
        ifTrue: [ theInt := anInt - 1 ].
    ^theInt.!

initialize: seed
        "From C Recipes Book"
    " y := Ran2 new initialize: -1618033."

    m := 714025.
    ia := 1366.
    ic := 150889.

    idum := seed.
    ir := Array new: 98.

    idum := (ic - idum) \\ m.
    (idum < 0)
        ifTrue: [idum := -1 * idum].
    1 to: 97 do: [ :j |
        idum := ((ia * idum) + ic) \\ m.
        ir at: j put: idum.
    ].
    idum := ((ia * idum) + ic) \\ m.
    iy := idum.

    ^self.!
 
next
        "Answer next random number"
   | j |

    j := 1 + ((97.0 * (iy asFloat)) / (m asFloat)) truncated.
    iy := ir at: j.
    idum := ((ia * idum) + ic) \\ m.
    ir at: j put: idum.
    ^((iy asFloat)/(m asFloat)).!
 
nextBinaryChar
        "Answer next random binary digit ....
                either 0, or 1."
    (self next > 0.5)
        ifTrue: [ ^$1 ]
        ifFalse: [ ^$0 ].!
 
nextBinaryDigit
        "Answer next random binary digit ....
                either 0, or 1."
    (self next > 0.5)
        ifTrue: [ ^1 ]
        ifFalse: [ ^0 ].!
  
nextG
        "Answer a random number between -1 and + 1
            with Gaussian Distribution"
    | u1 u2 c s x1 x2 |

    u1 := self next.
    u2 := self next.
    c := (2.0 * Float pi * u2) cos.
    s := (2.0 * Float pi * u2) sin.
    x1 := ((-2.0 * (u1 ln)) sqrt) * c.
    x2 := ((-2.0 * (u1 ln)) sqrt) * s.
    ^x1. "x1 and x2 are independent normal deviates."!
 
nextS
        "Answer next random number between +1 and -1"
    (self next > 0.5)
        ifTrue: [ ^self next ]
        ifFalse: [ ^(self next) * -1.0 ].! !



!ClassReader methods !
 
fileOutTheClassOn: aFileStream
        "comment"
    aFileStream lineDelimiter: Cr.
    class fileOutOn: aFileStream.
    aFileStream nextChunkPut: String new.
    (ClassReader forClass: class class) fileOutOn: aFileStream.
    self fileOutOn: aFileStream.! !



!Array methods !
   
shuffle
        "Answer a shuffled collection of objects
            from the receiver"

    | y max aSeq aShuffledSeq pick numLeft |

    y := Ran2 new initialize: -1618033.

    max := self size.
    aSeq := Array new: max.
    1 to: max do: [ :i |
        aSeq at: i put: i.
    ].

    aShuffledSeq := Array new: max.
    numLeft := max.
    [numLeft > 0]
        whileTrue: [
            pick := ((y next * (max - 0.000000001)) + 1) truncated.
            ((aSeq at: pick) = nil)
                ifFalse: [
                    aShuffledSeq at: numLeft put: (aSeq at: pick).
                    aSeq at: pick put: nil.
                    numLeft := numLeft - 1.
                ].
        ].

    ^aShuffledSeq.! !



!Character methods !
  
isComma
        "Answer true if the receiver is white space,
        else answer false."
    ^self asInteger = $, asInteger! !



!IndexedCollection methods !
   
max
        "Answer the maximum value in this collection"

    | theMax |

    theMax := 1.0e-38.

    1 to: self size do: [ :i |
        ((self at: i) > theMax)
            ifTrue: [ theMax := (self at: i).  ].
    ].
    ^theMax.! !



!IndexedCollection methods !
   
min
        "Answer the minimum value in this collection"

    | theMin |

    theMin := 1.0e38.

    1 to: self size do: [ :i |
        ((self at: i) < theMin)
            ifTrue: [ theMin := (self at: i).  ].
    ].
    ^theMin.! !



!String methods !
   
asArrayOfCSSubstrings! !

WindowDialog subclass: #GPGenerate
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants WBConstants '  !


!GPGenerate class methods !
  
wbCreated

    ^true! !



!GPGenerate methods !
  
comment
    ^(self paneNamed: 'comment').!
 
createViews

     "WARNING!!  This method was automatically generated by
      WindowBuilder.  Code you add here which does not conform
      to the WindowBuilder API will probably be lost the next time
      you save your layout definition."

     | v |

    self addView: (
        v := self topPaneClass new
            owner: self;
            labelWithoutPrefix:  'Please Wait';
            noSmalltalkMenuBar;
            viewName: 'mainView';
            framingBlock: ( FramingParameters new iDUE: 569 @ 320; xC; yC; cRDU: (2 @ 318 rightBottom: 567 @ 2));
            pStyle: #();
            backColor: ClrPalegray;
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 484 @ 38; lDU: 36 r: #left; rDU: 519 r: #left; tDU: 32 r: #top; bDU: 70 r: #top);
                    centered;
                    contents: 'Generating Initial Population';
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                CPCircularGauge new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 92 @ 77; lDU: 235 r: #left; tDU: 179 r: #top);
                    paneName: 'progress';
                    min: 0;
                    contents: 0;
                    showPercentage: false;
                    startGroup;
                    foreColor: ClrBlue;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 420 @ 38; lDU: 71 r: #left; rDU: 491 r: #left; tDU: 102 r: #top; bDU: 141 r: #top);
                    paneName: 'comment';
                    centered;
                    startGroup;
                    contents: '';
                    backColor: ClrPalegray;
                    yourself
            );
        yourself
    ).!
   
progress
    ^(self paneNamed: 'progress').! !

Object subclass: #Graph
  instanceVariableNames: 
    'xSeries ySeries bitmap font title minX minY maxX maxY '
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants WBConstants '  !


!Graph class methods !
   
new: anExtent
        "Answer a graph object"
    | theBitmap thePen theGraph |

    theBitmap := Bitmap extent: anExtent.

    theGraph := Graph new.
    theGraph font:  (Font face: 'Arial' size: 6@16 fixedWidth: false attributes: 0).

    theGraph bitmap: theBitmap.

    thePen := theBitmap pen.
    thePen setLineWidth: 2.
    thePen font: theGraph font.

    theGraph drawFrame.

    ^theGraph.! !



!Graph methods !
 
bitmap
        "Answer the bitmap associated with this Graph"

    ^bitmap.!
 
bitmap: aBitmap
        "Set the bitmap associated with this Graph to aBitmap"

    bitmap := aBitmap.!
  
centerString: aString at: aPoint
        "comment"

    | theRect xPos yPos theWidth theHeight theStart theTextRect z |

    self pen setBackgroundMode: Transparent.
    self pen foreColor: ClrBlack.

    self pen centerText: aString at: aPoint.

    ^self.!

drawAxes
        "comment"
    | theMinX theMinY theMaxX theMaxY xLowPoint
                     theSize xHighPoint yLowPoint yHighPoint |

    (xSeries isNil)
        ifTrue: [
            (maxX isNil)
                ifTrue: [theSize := ySeries size]
                ifFalse: [theSize := maxX].
            xSeries := Array new: theSize.
            1 to: theSize do: [ :i |
                xSeries at: i put: i.
            ].
            self maxX: theSize. self minX: 1.
    ].

    theMaxY := self maxY.
    theMinY := self minY.
    theMaxX := self maxX.
    theMinX := self minX.

    xLowPoint := self insetRect leftBottom + (0@(self font height + 2)).
    xHighPoint := self insetRect rightBottom + (0@(self font height + 2)).
    self drawString: (theMinX asString) at: xLowPoint.
    self drawString: (theMaxX asString) at: xHighPoint.

    yHighPoint := 10 @ self insetRect top.
    yLowPoint := 10 @ self insetRect bottom.
    self drawString: (theMinY asString) at: yLowPoint.
    self drawString: (theMaxY asString) at: yHighPoint.!
   
drawBarGraph
        "comment"
    | xScale yScale xDelta yDelta base xPixels yPixels
                            xRange yRange xMin yMin xMax yMax xP yP |

    "First scale it"

    yDelta := self insetRect height.
    xDelta := self insetRect width.

    base := self insetRect leftBottom.

    xMin := self minX.  xMax := self maxX.
    yMin := self minY.  yMax := self maxY.

    xRange := (xMax - xMin) asFloat.
    yRange := (yMax - yMin) asFloat.
    ((xRange < 1e-30) or: [yRange < 1e-30])
        ifTrue: [ self error: 'Range too small'. ^self].

    xScale := (xDelta asFloat) / xRange.
    yScale := (yDelta asFloat) / yRange.

    "Now draw it"

    self pen setLineWidth: 8.


    1 to: ySeries size do: [ :aPoint |
        self pen up; north; turn: 90.
        xP := ((xSeries at: aPoint) asFloat) - (xMin asFloat).
        yP := ((ySeries at: aPoint) asFloat) - (yMin asFloat).
        xPixels := (xP * xScale) truncated.
        yPixels := (yP * yScale) truncated.
        self pen goto: ((base x + xPixels)@(base y)).
        self pen down.
        self pen goto: ((base x + xPixels)@(base y - yPixels)).
    ].!
  
drawDotGraph
        "comment"
    | xScale yScale xDelta yDelta base xPixels yPixels
                            xRange yRange xMin yMin xMax yMax xP yP |

    "First scale it"

    yDelta := self insetRect height.
    xDelta := self insetRect width.

    base := self insetRect leftBottom.

    xMin := self minX.  xMax := self maxX.
    yMin := self minY.  yMax := self maxY.

    xRange := (xMax - xMin) asFloat.
    yRange := (yMax - yMin) asFloat.
    ((xRange < 1e-30) or: [yRange < 1e-30])
        ifTrue: [ self error: 'Range too small'. ^self].

    xScale := (xDelta asFloat) / xRange.
    yScale := (yDelta asFloat) / yRange.

    "Now draw it"

   self pen setLineWidth: 4.


    1 to: ySeries size do: [ :aPoint |
        self pen up; north; turn: 90.
        xP := ((xSeries at: aPoint) asFloat) - (xMin asFloat).
        yP := ((ySeries at: aPoint) asFloat) - (yMin asFloat).
        xPixels := (xP * xScale) truncated.
        yPixels := (yP * yScale) truncated.
        self pen goto: ((base x + xPixels)@(base y - yPixels)).
        self pen down; go: 1.
    ].!
   
drawFrame
        "Draw the x and y axes"
    | theRect |


    theRect := self insetRect.
    self pen up;
            goto: theRect leftTop;
            down;
            goto: theRect leftBottom;
            goto: theRect rightBottom;
            up.
    ^self.!
   
drawLineGraph
        "comment"
    | xScale yScale xDelta yDelta base xPixels yPixels
                            xRange yRange xMin yMin xMax yMax xP yP |

    "First scale it"

    yDelta := self insetRect height.
    xDelta := self insetRect width.

    base := self insetRect leftBottom.

    xMin := self minX.  xMax := self maxX.
    yMin := self minY.  yMax := self maxY.

    xRange := (xMax - xMin) asFloat.
    yRange := (yMax - yMin) asFloat.
    ((xRange < 1e-30) or: [yRange < 1e-30])
        ifTrue: [ self error: 'Range too small'. ^self].

    xScale := (xDelta asFloat) / xRange.
    yScale := (yDelta asFloat) / yRange.

    "Now draw it"

    self pen setLineType: PsDot.
    self pen setLineWidth: 1.
    self pen up; north; turn: 90.


    1 to: ySeries size do: [ :aPoint |
        xP := ((xSeries at: aPoint) asFloat) - (xMin asFloat).
        yP := ((ySeries at: aPoint) asFloat) - (yMin asFloat).
        xPixels := (xP * xScale) truncated.
        yPixels := (yP * yScale) truncated.
        self pen goto: ((base x + xPixels)@(base y - yPixels)).
        self pen down; go: 1.
    ].!
   
drawString: aString at: aPoint
        "comment"

    | theRect xPos yPos theWidth theHeight theStart theTextRect z |

    self pen setBackgroundMode: Transparent.
    self pen foreColor: ClrBlack.

   " self pen centerText: self title."
    self pen displayText: aString at: aPoint.

    ^self.!
 
drawTitle
        "comment"

    | theRect xPos yPos theWidth theHeight theStart theTextRect z |

    theRect := self insetRect.
    xPos :=theRect left + (((theRect right) - (theRect left)) / 2.0) truncated.
    yPos := theRect top.

    self centerString: self title at: xPos@yPos.

    ^self.!
 
font
        "Answer the font associated with this Graph"

    ^font.!
   
font: aFont
        "Set the font associated with this Graph to aFont"

    font := aFont.!
  
insetRect
        "comment"

    | rFactor theRect newExtentX newExtentY newExtent newOrigin |

    rFactor := 0.7.
    newExtentX := (rFactor * self bitmap extent x) truncated.
    newExtentY := (rFactor * self bitmap extent y) truncated.
    newExtent := newExtentX@newExtentY.
    newOrigin := ((self bitmap extent - newExtent) / 2.0) truncated.
    ^(Rectangle origin: newOrigin extent: newExtent).!
   
maxX
        "Answer the maximum X associated with this Graph"

    ^maxX.!
  
maxX: aNumber
        "Set the maximum X associated with this Graph to aNumber"

    maxX := aNumber.!
   
maxY
        "Answer the maximum Y associated with this Graph"

    ^maxY.!
  
maxY: aNumber
        "Set the maximum Y associated with this Graph to aNumber"

    maxY := aNumber.!
   
minX
        "Answer the minimum X associated with this Graph"

    ^minX.!
  
minX: aNumber
        "Set the minimum X associated with this Graph to aNumber"

    minX := aNumber.!
   
minY
        "Answer the minimum Y associated with this Graph"

    ^minY.!
  
minY: aNumber
        "Set the minimum Y associated with this Graph to aNumber"

    minY := aNumber.!
   
pen
        "Answer the pen associated with this Graph"

    ^self bitmap pen.!
  
title
        "Answer the title associated with this Graph"

    ^title.!

title: aString
        "Set the title associated with this Graph to aString and draw the title"

    title := aString.
    self drawTitle.
   " self drawString: '1.23' at: 0@10.
    self drawString: '4.56' at: 10@(self insetRect bottom + self pen font height).   "!
 
xSeries
        "Answer the xSeries associated with this Graph"

    ^xSeries.!
  
xSeries: aCollection
        "Set the xSeries associated with this Graph to aCollection"

    xSeries := aCollection.
    self minX: (aCollection min).
    self maxX: (aCollection max).!
 
ySeries
        "Answer the ySeries associated with this Graph"

    ^ySeries.!
  
ySeries: aCollection
        "Set the ySeries associated with this Graph to aCollection"

    ySeries := aCollection.
    self minY: (aCollection min).
    self maxY: (aCollection max).! !

Object subclass: #GPNode
  instanceVariableNames: 
    'type child sibling value '
  classVariableNames: ''
  poolDictionaries: '' !


!GPNode class methods !
  
new
        "Anser an initialized GPNode"

    | theGPNode |

    theGPNode := super new.

    theGPNode type: nil.
    theGPNode value: nil.
    theGPNode child: nil.
    theGPNode sibling: nil.

    ^theGPNode.! !



!GPNode methods !

child
        "Answer the child for this node with aGPNode"

    ^child.!

child: aGPNode
        "Set the child for this node to aGPNode"

    child := aGPNode.!
  
duplicate
        "Answer a copy of the receiver"

    | theCopy |

    theCopy := GPNode new.

    theCopy child: (self child).                       "should it be copy? or no copy?"
    theCopy sibling: (self sibling).
    theCopy type: (self type copy).
    theCopy value: (self value copy).

    ^theCopy.!
  
initialize
        "Initialize the GPNode"

    self type: nil.
    self value: nil.
    self child: nil.
    self sibling: nil.

    ^self.!
   
sibling
        "Answer the sibling for this node with aGPNode"

    ^sibling.!
  
sibling: aGPNode
        "Set the sibling for this node to aGPNode"

    sibling := aGPNode.!

type
        "Answer the type for this node with aCharacter $T or $F
            for terminal and function respectively"

    ^type.!
   
type: aCharacter
        "Set the type for this node to aCharacter"

    type := aCharacter.!

value
        "Answer the value for this node with anInteger"

    ^value.!
  
value: anInteger
        "Set the value for this node to anInteger"

    value := anInteger.! !

Object subclass: #GPAnt
  instanceVariableNames: 
    'direction position foodPlain foodEaten '
  classVariableNames: ''
  poolDictionaries: ''   !


!GPAnt class methods !
   
new
        "Answer a new GPAnt"

    ^super new initialize.! !



!GPAnt methods !
  
direction
        "Answer the direction the ant is currently facing"

    ^direction.!
   
direction: anInt
        "Set the direction the ant is currently facing to anInt,
            0 for North, 90 for East.... etc."

    direction := anInt.!
  
faceLeft
        "comment"

    self direction: ((self direction + 270) \\ 360).!

faceRight
        "comment"

    self direction: ((self direction + 90) \\ 360).!

foodEaten
        "Answer the amount of food the ant has eaten in this run"

    ^foodEaten.!

foodEaten: anInt
        "Set the amount of food the ant has eaten in this run to anInt"

    foodEaten := anInt.!
   
foodPlain
        "Answer the foodPlain the ant is currently in"

    ^foodPlain.!
   
foodPlain: aGPFoodPlain
        "Set the foodPlain for the ant to aGPFoodPlain"

    foodPlain := aGPFoodPlain.!
 
ifFoodAhead
        "Answer true or false based on the food status ahead"

    | positionAhead |

    positionAhead := self nextForwardPosition.

    ^((self foodPlain getGridStatusAt: positionAhead) = $F).!
  
initialize
        "Initialize the GPAnt"

    self direction: 90.
    self position: 1@1.
    self foodEaten: 0.
    ^self.!
 
move
        "Move the ant based on current direction faced"

    | aPoint newPosition oldPosition |


    oldPosition := self position.

    newPosition :=  self nextForwardPosition.

    self position: newPosition.

    self foodPlain clear: oldPosition.

    "self foodPlain setAntAt: newPosition."
    self foodPlain setAntAt: newPosition facing: self direction.

    ((self foodPlain getGridStatusAt: newPosition) = $F)
            ifTrue: [
                self foodPlain setGridStatusAt: newPosition to: $E.     "Eat the food"
                self foodEaten: (self foodEaten + 1).
    ].!

nextForwardPosition
        "Answer aPoint indicating the position directly
            in front of the ant"

    | aPoint newPosition oldPosition |

    oldPosition := self position.

    newPosition := 0@0.

    (self direction = 0)
        ifTrue: [
            newPosition x: oldPosition x.
            (oldPosition y = 1)
                ifTrue: [ newPosition y: 32]
                ifFalse: [newPosition y: (oldPosition y - 1)].
            ^newPosition
        ].

    (self direction = 90)
        ifTrue: [
            newPosition y: oldPosition y.
            (oldPosition x = 32)
                ifTrue: [ newPosition x: 1]
                ifFalse: [newPosition x: (oldPosition x + 1)].
            ^newPosition
        ].

    (self direction = 180)
        ifTrue: [
            newPosition x: oldPosition x.
            (oldPosition y = 32)
                ifTrue: [ newPosition y: 1]
                ifFalse: [newPosition y: (oldPosition y + 1)].
            ^newPosition
        ].

    (self direction = 270)
        ifTrue: [
            newPosition y: oldPosition y.
            (oldPosition x = 1)
                ifTrue: [ newPosition x: 32]
                ifFalse: [newPosition x: (oldPosition x - 1)].
            ^newPosition
        ].!
  
nextForwardPositionOld
        "Answer aPoint indicating the position directly
            in front of the ant"

    | aPoint newPosition oldPosition |

    (self direction = 0)
        ifTrue: [ aPoint := (0@31) ].
    (self direction = 90)
        ifTrue: [ aPoint := (1@0) ].
    (self direction = 180)
        ifTrue: [ aPoint := (0@1) ].
    (self direction = 270)
        ifTrue: [ aPoint := (31@0) ].

    oldPosition := self position.

    newPosition :=  (1@1) + ((oldPosition - (1@1) + aPoint) \\ (32@32)).

    ^newPosition.!
 
position
        "Answer the position of the ant as aPoint relative to 1@1 (upper left)"

    ^position.!

position: aPoint
        "Set the position of the ant to aPoint, relative to 1@1 (upper left)"

    position := aPoint.! !

Object subclass: #GPComputer
  instanceVariableNames: 
    'program currentNode programViewer iLength iDepth maxDepth nodeID nodeFound nodeArray nodeArrayPtr executionCount executionLimit nodeIndex '
  classVariableNames: 
    'Terminals FunctionAritys Functions '
  poolDictionaries: 
    'ColorConstants WBConstants '  !


!GPComputer class methods !
  
new
        "Create a new GPComputer"

    ^super new initialize.! !



!GPComputer methods !

computeProgramStats
        "Fill the instance variables for the currently loaded program"

    "This is currently not very efficient. Several passes are made thru the nodes
        to compute the statisitics "

    | funcs terms |

    funcs := 0.
    terms := 0.

    self program depth: (self programDepth).
    self program length: (self programLength).

    self flattenProgram.
    self nodeArray do: [ :aPoint |
        (aPoint x asCharacter = $F)
            ifTrue: [funcs := funcs + 1]
            ifFalse: [terms := terms + 1].
    ].
    self program funcNodes: funcs.
    self program termNodes: terms.

    ^self.!
 
currentNode
        "Answer the current position for this GPComputer"

    ^currentNode.!

currentNode: aGPNode
        "Set the currentNode of the program to aGPNode"

    currentNode := aGPNode.!
   
evaluate: aGPNode
        "Recursively evaluate the nodes"

    (self executionLimitExceeded)
        ifTrue: [^self].                                                      "Suspend execution"

    (aGPNode isNil)

        ifFalse: [
            self currentNode: aGPNode.
            (aGPNode type = $T)
                ifTrue: [
                    self  perform:
                            (self  terminals at: (aGPNode value))
                ]
                ifFalse: [
                    self  perform:
                            (self  functions at: (aGPNode value))
                ].

        ]
        ifTrue: [ self error: 'Attempt fo evaluate nil node'].!
 
execute
        "Resets program to beginning but doesn't affect
            other instance variables"

    self currentNode: self program firstNode.

    self evaluate: self  currentNode.

    ^self.!

executionCount
        "Answer the executionCount for this GPComputer"

    ^executionCount.!

executionCount: anInt
        "Set the executionCount of the program to anInt"

    executionCount := anInt.!

executionLimit
        "Answer the executionLimit for this GPComputer"

    ^executionLimit.!

executionLimit: anInt
        "Set the executionLimit of the program to anInt"

    executionLimit := anInt.!

executionLimitExceeded
        "Answer true if the execution limit for this program has
            been exceeded"

    ^(self executionCount >= self executionLimit).!
 
findFuncNodeNo: anInt
        "Answer the an index of the node anInt function nodes from the beginning of the
            currently loaded GPProgram (1 is the firstNode)"

    | theNode |

    "Traverse the nodes"

    self iLength: 0.
    self nodeIndex: 0.
    self nodeID: anInt.
    self nodeFound: nil.

    self subTreeFuncCount: (self program firstNode).

    ^self nodeIndex.!
 
findNodeNo: anInt
        "Answer the theNode anInt from the beginning of the
            currently loaded GPProgram (1 is the firstNode)"

    | theNode |

    "Traverse the nodes"

    self iLength: 0.
    self nodeID: (anInt - 1).       "count routine is zero relative"
    self nodeFound: nil.

    self subTreeCount: (self program firstNode).

    ^self nodeFound.!

findSuperiorNodeTo: aGPNode
        "Answer the theNode which points to aGPNode"

    | theNode |

    "Traverse the nodes"

    self nodeFound: nil.

    self nodeID: aGPNode.                     "Set node to search for"

    self subTreeFind: (self program firstNode).

    ^self nodeFound.!
  
findTermNodeNo: anInt
        "Answer the an index of the node anInt terminal nodes from the beginning of the
            currently loaded GPProgram (1 is the firstNode)"

    | theNode |

    "Traverse the nodes"

    self iLength: 0.
    self nodeIndex: 0.
    self nodeID: anInt.
    self nodeFound: nil.

    self subTreeTermCount: (self program firstNode).

    ^self nodeIndex.!
 
flattenProgram
        "Answer nodeArray. Update nodeArray with the flattened program.
            Each entry in nodeArray is aPoint. x=> the node type;
                y => the node value."

    | theNode |

    "Traverse the nodes"

    self iLength: 0.
    self nodeArrayPtr: 1.
    self nodeArray: (Array new: (self program length)).

    self subTreeFlatten: (self program firstNode).

    ^nodeArray.!
  
functionAritys
        "Answer the functionAritys for this GPComputer"

    ^FunctionAritys.!

functions
        "Answer the functions array for this GPComputer"

    ^Functions.!
 
iDepth
        "Answer the interim depth for the program currently
            loaded in this GPComputer"

    ^iDepth.!

iDepth: anInt
        "Set the interim depth for the program currently
            loaded in this GPComputer to anInt"

    iDepth := anInt.!
   
iLength
        "Answer the interim length for the program currently
            loaded in this GPComputer"

    ^iLength.!
 
iLength: anInt
        "Set the interim length for the program currently
            loaded in this GPComputer to anInt"

    iLength := anInt.!

initialize
        "Setup the computer"

    ^self.!
 
load: aGPProgram
        "Method to keep up the computer paradigm"

    self program: aGPProgram.
    self reset.!
  
maxDepth
        "Answer the maximum depth for the program currently
            loaded in this GPComputer"

    ^maxDepth.!

maxDepth: anInt
        "Set the maximum depth for the program currently
            loaded in this GPComputer to anInt"

    maxDepth := anInt.!
   
next
        "Answer the next GPNode in this GPProgram"

    | theNode |

    (( theNode := self curentNode child)  = nil)
        ifTrue:  [
            (( theNode := self currentNode sibling) = nil)
                ifTrue: [^nil]
                ifFalse: [
                    self currentNode: theNode.
                    ^ theNode
                ].
        ]
        ifFalse: [
            self currentNode: theNode.
            ^ theNode
        ].!
   
nodeArray
        "Answer the nodeArray for this GPComputer"

    ^nodeArray.!
   
nodeArray: anArray
        "Set the nodeArray for this GPComputer to anArray"

    nodeArray := anArray.!

nodeArrayPtr
        "Answer the nodeArrayPtr for this GPComputer"

    ^nodeArrayPtr.!
  
nodeArrayPtr: anInt
        "Set the nodeArrayPtr for this GPComputer to anInt"

    nodeArrayPtr := anInt.!
 
nodeFound
        "Answer the GPNode at nodeID for this GPComputer"

    ^nodeFound.!

nodeFound: aGPNode
        "Set the GPNode at nodeID for this GPComputer to aGPNode"

    nodeFound := aGPNode.!
 
nodeID
        "Answer the nodeID  to find for the program currently
            loaded in this GPComputer"

    ^nodeID.!
  
nodeID: anInt
        "Set the nodeID  to find for the program currently
            loaded in this GPComputer to anInt"

    nodeID := anInt.!
 
nodeIndex
        "Answer the nodeIndex for this GPComputer"

    ^nodeIndex.!
   
nodeIndex: anInt
        "Set the nodeIndex for this GPComputer to anInt"

    nodeIndex := anInt.!
  
program
        "Answer the current program for this GPComputer"

    ^program.!
 
program: aGPProgram
        "Set the current program for this GPComputer to aGPProgram"

    program := aGPProgram.!
 
programDepth
        "Answer the depth  for the
            currently loaded GPProgram"

    "Traverse the nodes"

    | node1 |

    node1 := self program firstNode.
    ((node1 child isNil) and: [ node1 sibling isNil ] )
        ifTrue: [
            self maxDepth: 1.
            ^self maxDepth
        ].

    self iDepth: 1. self maxDepth: -1.

    self subTreeDepth: (self program firstNode).

    ^self maxDepth.!
 
programLength
        "Answer the length (total number of nodes) for the
            currently loaded GPProgram"

    "Traverse the nodes"

    self iLength: 0.    self iDepth: 0.

    self subTreeLength: (self program firstNode).

    ^self iLength.!
   
programViewer
        "Answer the programViewer for this GPComputer "

    ^programViewer.!
  
programViewer: aGPProgramViewer
        "Set the programViewer for this GPComputer to aGPProgramViewer"

    programViewer := aGPProgramViewer.!
 
reset
        "Reset the pointer to the program start"

    self executionCount: 0.

    self currentNode: self program firstNode.!

subTreeCount: aGPNode
        "Answer the GPnode at nodeID for the currently
            loaded program"

    | funcID aCurrentNode theArity |

    "Traverse the nodes"

    (self nodeFound isNil) ifFalse: [^self ].   "Once the requested node is found"
                                                                  "reached exhaust the pending rets"
    (self iLength = self nodeID)
        ifTrue: [
            self nodeFound: aGPNode.            "Node is found"
            ^self
        ].


    (aGPNode type = $T)
        ifTrue: [
            self iLength: (self iLength + 1).
            ^self
        ].

    funcID := aGPNode value.
    self iLength: (self iLength + 1).
    aCurrentNode := aGPNode child.                              "Handle the function itself"
    self subTreeCount: aCurrentNode.

    theArity := self  functionAritys at: funcID.
    1 to: (theArity - 1) do: [ :i |
        aCurrentNode := aCurrentNode sibling.
        self subTreeCount: aCurrentNode.                      "Handle it's children and siblings"
    ].!

subTreeDepth: aGPNode
        "Answer the length (total number of nodes) for the currently
            loaded program"

    | funcID aCurrentNode theArity |

    "Traverse the nodes"

    (aGPNode type = $T)
        ifTrue: [ ^self ].

    funcID := aGPNode value.
    self iDepth: (self iDepth + 1).
    aCurrentNode := aGPNode child.                    "Handle the function itself"
    self subTreeDepth: aCurrentNode.

    theArity := self  functionAritys at: funcID.
    1 to: (theArity - 1) do: [ :i |
        aCurrentNode := aCurrentNode sibling.
        self subTreeDepth: aCurrentNode.             "Handle it's children and siblings"
    ].

    (self iDepth > self maxDepth)
        ifTrue: [ self maxDepth: (self iDepth) ].
    self iDepth: (self iDepth - 1).!
  
subTreeFind: aGPNode
        "Answer the GPnode. Set nodeFound to the node superior to the
            node stored  at nodeID is found in the current program"

    | funcID aCurrentNode theArity |

    "Traverse the nodes"

    (self nodeFound isNil) ifFalse: [^self ].   "Once the requested node is"
                                                                  "reached exhaust the pending rets"

    (aGPNode type = $T)
        ifTrue: [
            (aGPNode sibling == nodeID)
                ifTrue: [self nodeFound: aGPNode].
            ^self
        ].

    ((aGPNode child == nodeID) or: [ aGPNode sibling == nodeID ])
        ifTrue: [self nodeFound: aGPNode].

    funcID := aGPNode value.
    aCurrentNode := aGPNode child.                              "Handle the function itself"
    self subTreeFind: aCurrentNode.

    theArity := self  functionAritys at: funcID.
    1 to: (theArity - 1) do: [ :i |
        aCurrentNode := aCurrentNode sibling.
        self subTreeFind: aCurrentNode.                      "Handle it's children and siblings"
    ].!
 
subTreeFlatten: aGPNode
        "Answer the GPnode. Fill nodeArray with the flattened nodetypes and
            nodeValues as a collection of strings."

    | funcID aCurrentNode theArity theEntry |

    "Traverse the nodes"

    theEntry := Point new.
    theEntry x: (aGPNode type asInteger).
    theEntry y: (aGPNode value).
    self nodeArray at: (self nodeArrayPtr) put: theEntry.
    self nodeArrayPtr: (self nodeArrayPtr + 1).

    (aGPNode type = $T)
        ifTrue: [ ^self ].

    funcID := aGPNode value.
    aCurrentNode := aGPNode child.                              "Handle the function itself"
    self subTreeFlatten: aCurrentNode.

    theArity := self  functionAritys at: funcID.
    1 to: (theArity - 1) do: [ :i |
        aCurrentNode := aCurrentNode sibling.
        self subTreeFlatten: aCurrentNode.                      "Handle it's children and siblings"
    ].!

subTreeFuncCount: aGPNode
        "Answer the Function GPnode at nodeID for the currently
            loaded program"

    | funcID aCurrentNode theArity |

    "Traverse the nodes"

    (self nodeFound isNil) ifFalse: [^self ].   "Once the requested node is found"
                                                                  "reached exhaust the pending rets"

    (self iLength = self nodeID)
        ifTrue: [
            self nodeFound: aGPNode.            "Node is found"
            ^self
        ].

    (aGPNode type = $T)
        ifTrue: [
            self nodeIndex: (self nodeIndex + 1).      "Incr node count"
            ^self
        ].

    funcID := aGPNode value.
    self iLength: (self iLength + 1).                    "Incr function count"
    self nodeIndex: (self nodeIndex + 1).          "Incr node count"
    aCurrentNode := aGPNode child.                              "Handle the function itself"
    self subTreeFuncCount: aCurrentNode.

    theArity := self  functionAritys at: funcID.
    1 to: (theArity - 1) do: [ :i |
        aCurrentNode := aCurrentNode sibling.
        self subTreeFuncCount: aCurrentNode.                      "Handle it's children and siblings"
    ].!
 
subTreeLength: aGPNode
        "Answer the length (total number of nodes) for the currently
            loaded program"

    | funcID aCurrentNode theArity |

    "Traverse the nodes"

    (aGPNode type = $T)
        ifTrue: [
            self iLength: (self iLength + 1).
            ^self
        ].

    funcID := aGPNode value.
    self iLength: (self iLength + 1).
    aCurrentNode := aGPNode child.                    "Handle the function itself"
    self subTreeLength: aCurrentNode.

    theArity := self  functionAritys at: funcID.
    1 to: (theArity - 1) do: [ :i |
        aCurrentNode := aCurrentNode sibling.
        self subTreeLength: aCurrentNode.             "Handle it's children and siblings"
    ].!
 
subTreeTermCount: aGPNode
        "Answer the Terminal GPnode at nodeID for the currently
            loaded program"

    | funcID aCurrentNode theArity |

    "Traverse the nodes"

    (self nodeFound isNil) ifFalse: [^self ].   "Once the requested node is found"
                                                                  "reached exhaust the pending rets"

    (aGPNode type = $T)
        ifTrue: [
            self iLength: (self iLength + 1).
            self nodeIndex: (self nodeIndex + 1).      "Incr node count"
            (self iLength = self nodeID)
                ifTrue: [  self nodeFound: aGPNode ].           "Node is found"
            ^self
        ].

    funcID := aGPNode value.
    self nodeIndex: (self nodeIndex + 1).      "Incr node count"
    aCurrentNode := aGPNode child.                              "Handle the function itself"
    self subTreeTermCount: aCurrentNode.

    theArity := self  functionAritys at: funcID.
    1 to: (theArity - 1) do: [ :i |
        aCurrentNode := aCurrentNode sibling.
        self subTreeTermCount: aCurrentNode.                      "Handle it's children and siblings"
    ].!
  
terminals
        "Answer the terminals array for this GPComputer"

    ^Terminals.! !

GPComputer subclass: #GPDispenserComputer
  instanceVariableNames: 
    'dispenser '
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants WBConstants '  !


!GPDispenserComputer class methods ! !



!GPDispenserComputer methods !
 
dispenser
        "Answer the GPDispenser for this GPDispenserComputer"
    ^dispenser.!
  
dispenser: aGPDispenser
        "Set the GPDispenser for this GPDispenserComputer to
                aGPDispenser"
    dispenser := aGPDispenser.! !

WindowDialog subclass: #GPAbout
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants WBConstants '  !


!GPAbout class methods !
 
wbCreated

    ^true! !



!GPAbout methods !
 
createViews

     "WARNING!!  This method was automatically generated by
      WindowBuilder.  Code you add here which does not conform
      to the WindowBuilder API will probably be lost the next time
      you save your layout definition."

     | v |

    self addView: (
        v := self topPaneClass new
            owner: self;
            labelWithoutPrefix:  'About Dialog';
            noSmalltalkMenuBar;
            viewName: 'mainView';
            framingBlock: ( FramingParameters new iDUE: 569 @ 518; xC; yC; cRDU: (9 @ 510 rightBottom: 560 @ 8));
            pStyle: #(modal);
            backColor: ClrDarkgray;
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 427 @ 38; lDU: 57 r: #left; rDU: 484 r: #left; tDU: 352 r: #top; bDU: 390 r: #top);
                    centered;
                    startGroup;
                    contents: 'trademark of Digitalk Inc.';
                    foreColor: ClrWhite;
                    backColor: ClrDarkgray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 484 @ 32; lDU: 28 r: #left; rDU: 512 r: #left; tDU: 314 r: #top; bDU: 346 r: #top);
                    centered;
                    startGroup;
                    contents: 'Smalltalk V/Win is a registered';
                    foreColor: ClrWhite;
                    backColor: ClrDarkgray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 373 @ 38; lDU: 84 r: #left; rDU: 457 r: #left; tDU: 134 r: #top; bDU: 173 r: #top);
                    centered;
                    startGroup;
                    contents: 'All Rights Reserved';
                    foreColor: ClrWhite;
                    backColor: ClrDarkgray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 327 @ 38; lDU: 107 r: #left; rDU: 434 r: #left; tDU: 19 r: #top; bDU: 58 r: #top);
                    centered;
                    startGroup;
                    contents: 'GP Artificial Ant';
                    foreColor: ClrWhite;
                    backColor: ClrDarkgray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 409 @ 38; lDU: 66 r: #left; rDU: 475 r: #left; tDU: 58 r: #top; bDU: 96 r: #top);
                    centered;
                    startGroup;
                    contents: 'Written by Tom Poliquin';
                    foreColor: ClrWhite;
                    backColor: ClrDarkgray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 405 @ 38; lDU: 68 r: #left; rDU: 473 r: #left; tDU: 186 r: #top; bDU: 224 r: #top);
                    centered;
                    startGroup;
                    contents: '(poliquin@netcom.com)';
                    foreColor: ClrWhite;
                    backColor: ClrDarkgray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 316 @ 38; lDU: 112 r: #left; rDU: 428 r: #left; tDU: 237 r: #top; bDU: 275 r: #top);
                    centered;
                    startGroup;
                    contents: 'Implemented in';
                    foreColor: ClrWhite;
                    backColor: ClrDarkgray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 384 @ 38; lDU: 78 r: #left; rDU: 462 r: #left; tDU: 275 r: #top; bDU: 314 r: #top);
                    centered;
                    startGroup;
                    contents: 'Digitalk Smalltalk V/Win';
                    foreColor: ClrWhite;
                    backColor: ClrDarkgray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 348 @ 32; lDU: 96 r: #left; rDU: 444 r: #left; tDU: 96 r: #top; bDU: 128 r: #top);
                    centered;
                    startGroup;
                    contents: 'Copyright (C) 1994';
                    foreColor: ClrWhite;
                    backColor: ClrDarkgray;
                    yourself
            );
            addSubpane: (
                Button new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 135 @ 45; lDU: 203 r: #left; rDU: 338 r: #left; tDU: 429 r: #top; bDU: 474 r: #top);
                    idOK;
                    defaultPushButton;
                    startGroup;
                    when: #clicked perform: #oKClicked:;
                    contents: 'OK';
                    backColor: ClrDarkgray;
                    yourself
            );
        yourself
    ).!
 
oKClicked: aPane

    "Callback for the #clicked event in an unnamed Button (contents is 'OK').
     (Generated by WindowBuilder)"

               super closeWindow.! !

ViewManager subclass: #GPOverlord
  instanceVariableNames: 
    'custodian bitmap genDialog '
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants WBConstants ' !


!GPOverlord class methods !
  
wbCreated

    ^true! !



!GPOverlord methods !
  
bitmap
        "Answer the bitmap for this GPOverlord "

    ^bitmap.!
   
bitmap: aBitmap
        "Set the bitmap for this GPOverlord "

    bitmap := aBitmap.!
   
custodian
        "Answer the custodian for this GPOverlord "

    ^custodian.!
  
custodian: aGPCustodian
        "Set the custodian for this GPOverlord to aGPCustodian"

    custodian := aGPCustodian.!
 
displayProgram: aGPProgram
        "Display the program in the program list box"

   | theOutline |

    self custodian computer programViewer reset.

    theOutline := self custodian computer programViewer inspectSubtree:
                                aGPProgram firstNode.

    (self paneNamed: 'programListBox') contents: theOutline.!
   
documentation

"
Basic Documentation:

OBJECTS

    General objects
        GPOverlord:         Controls user interface.
        GPCustodian:       Controls a region
        GPNode:              A function or terminal node
        GPProblem:         The superclass of problem specific objects
        GPProgram:         A collection of nodes making up a program
        GPRegion:           A 'place' were programs mutate under the control
                                    of a GPCustodian.
        GPFunction:         Operations, functions, operators ... required by the
                                    GPProgram
        GPTerminal:         Constants, or variables required  by the GPProgram.


    Problem Specific Objects

        ArtificialAnt: Reads a GPProgram and executes it. It updates the GPOverlord
                            display and determines its fitness.

Maybe there should be a GPEvaluator?  ... instead of a GPProblem??










"!

evolveBP: aPane

    "Callback for the #clicked event in an unnamed Button (contents is 'Evolve').
     (Generated by WindowBuilder)"

    | loopCount theDC thePgms theSortedPgms |
         self graphicsOff.
    loopCount := (self paneNamed: 'evolveCount') value.
    (self paneNamed: 'genDisplay') max: loopCount.
    theDC := OrderedCollection new.

    1 to: loopCount do: [ :evolutionNo |

        self custodian performGenetics.

        self custodian evaluateFitness.

        thePgms := self custodian programs.
        theSortedPgms := thePgms asSortedCollection: self programSortBlock.
        (self paneNamed: 'mainList') contents: theSortedPgms.
        (self paneNamed: 'mainList') restoreSelected: theSortedPgms first.

        self displayProgram: theSortedPgms first.
        self custodian maxFitnessCollection add: theSortedPgms first rawFitness.
        self showFitnessGraph.

        (self paneNamed: 'genDisplay') contents: evolutionNo.
        self writeLogEntry.
        self writeExpandedLogEntry.

    ].
        self graphicsOn.!
 
executePgm

    "Callback for the menu item titled 'executePgm'.
     (Generated by WindowBuilder)"

    self runPgm: (self paneNamed: 'mainList').!
   
fileInPgm

    "Callback for the menu item titled 'fileInPgm'.
     (Generated by WindowBuilder)"

    | theFileStream thePID theStrings theFunction theTerminal
        theArray thePgm restorePosition thePgms theSortedPgms |

    theFileStream := File pathName: ( Prompter
               prompt: 'Enter filename:)'
               default: 'pgm01.gpp' ).

    thePID := (self paneNamed: 'mainList') selectedItem pgmID.
    theStrings := theFileStream nextLine asArrayOfSubstrings.
    theFileStream close.

    thePgm := self custodian programGenerator
                             unflattenPgm: theStrings.
    thePgm pgmID: thePID.

    self custodian programs at: thePID put: thePgm.
    self graphicsOff.
    self custodian evaluateIndividualFitness: thePgm.
    self graphicsOn.

    thePgms := self custodian programs.
    theSortedPgms := thePgms asSortedCollection: self programSortBlock.
    (self paneNamed: 'mainList') contents: theSortedPgms.

    (self paneNamed: 'mainList') restoreSelected: thePgm.!
  
fileOutPgm

    "Callback for the menu item titled 'fileOutPgm'.
     (Generated by WindowBuilder)"

    | thePID theFileStream theWS theArray theFile theDirectory |
"-------------------------------------------------
    theDirectory := Directory pathName: 'c:\'.
    theDirectory makeCurrent.
    theFile := FileDialog new.
    theFile setDir: theDirectory pathName;
            title: 'Save Genetic Program';
            fileSpec: '.gpp';
            hideReadonly;
            overwritePrompt;
            addFilter: '*.gpp' description: 'Genetic Pgms (*.GPP)'.
    theFile defFilter: '*.gpp'.
    theFile save.
    theFileStream := File pathName: theFile file.
---------------------------------------------------"
    theFileStream := File pathName: ( Prompter
               prompt: 'Enter filename:)'
               default: 'pgm01.gpp' ).

    thePID := (self paneNamed: 'mainList') selectedItem pgmID.
    self custodian computer load: (self custodian programs at: thePID).
    theArray := self custodian computer flattenProgram.

    theArray do: [ :aPoint |
        theWS := WriteStream on: (String new: (theArray size * 10)).
        theWS nextPut: aPoint x asCharacter.
        theWS nextPutAll: aPoint y asString.
        theWS space.
        theFileStream nextPutAll: theWS contents.
    ].
    theFileStream close.!

genDialog
        "Answer the genDialog for this GPOverlord "

    ^genDialog.!
  
genDialog: aDialog
        "Set the Dialog for this GPOverlord "

    genDialog := aDialog.!
 
genDialogSetupMin: anInt1  max: anInt2 comment: aString
        "Update the GPGenerate Dialog associated with this GPOverlord"

    self genDialog progress min: anInt1; max: anInt2.
    self genDialog comment contents: aString.!

genDialogValue: anInt
        "Update the GPGenerate Dialog associated with this GPOverlord"

    self genDialog progress value: anInt.!
 
generateBP: aPane

    "Callback for the #clicked event in an unnamed Button (contents is 'Generate').
     (Generated by WindowBuilder)"

    | thePgms theSortedPgms |

    CursorManager execute change.
     self graphicsOff.

    self custodian generatePopulation.
    self custodian evaluateInitialFitness.

    thePgms := self custodian programs.
    theSortedPgms := thePgms asSortedCollection: self programSortBlock.
    (self paneNamed: 'mainList') contents: theSortedPgms.
    (self paneNamed: 'mainList') restoreSelected: theSortedPgms first.

    self displayProgram: theSortedPgms first.

    self custodian maxFitnessCollection add: theSortedPgms first rawFitness.
    self showFitnessGraph.

    self writeLogEntry.

    self graphicsOn.
    CursorManager normal change.!
  
graphGetContents: aPane

    "Callback for the #getContents event in the CPBitmapPane named 'graphBitmap'.
     (Generated by WindowBuilder)"!
   
graphicsOff
        "Implimented by subclass if necessary"!

graphicsOn
        "Implimented by subclass if necessary"!
 
initializeOverlord
        "Part of the initialization is done here. The rest is done in
                     the subclass"

   | theDialog |

    CursorManager execute change.

    self custodian computer reset.

    self custodian logStream: (File newFile: 'gplog.txt').
    self custodian logStream nextPutAll: self custodian logComment.
    self custodian logStream cr; flush.

    self custodian expandedLogStream: (File newFile: 'gpexlog.txt').

    self genDialog: GPGenerate new.

    CursorManager normal change.!

inspectPgm: aPane

    "Callback for the #doubleClickSelect event in the CPColumnarListBox named 'mainList'.
     (Generated by WindowBuilder)"

    | theOutline thePID |

    thePID := (self paneNamed: 'mainList') selectedItem pgmID.

    self custodian computer programViewer reset.

    theOutline := self custodian computer programViewer inspectSubtree:
                                 ((self custodian programs at: thePID) firstNode).

    (self paneNamed: 'programListBox') contents: theOutline.!
   
programSortBlock
        "Answer the sortblock to sort programs in fitness, parsimony order"

    ^ [ :a :b |
            (a rawFitness > b rawFitness) or: [
                (a rawFitness = b rawFitness) and: [
                    (a length <= b length)]].
        ].!
 
showFitnessGraph
        "comment"
    | thePane theGraph |


    thePane := self paneNamed: 'graphBitmap'.
    thePane backColor: ClrBlack.
    thePane foreColor: ClrGreen.

    theGraph := Graph new: thePane extent.

    theGraph title: 'Best of Generation Fitness History'.
    theGraph ySeries: self custodian maxFitnessCollection.
    theGraph maxX: (100 max: self custodian maxFitnessCollection size).
    theGraph minY: 0; maxY: 89.
    theGraph drawAxes.
    theGraph drawLineGraph.

    thePane contents: theGraph bitmap.
    thePane display.!
 
updateFitnessProgress: anInt
        "Show the progress of the fitness evalutation"

    (self paneNamed: 'currentCount') contents: anInt asString.!
 
writeExpandedLogEntry

    "At the end of each evolution cycle write the best individual
          program in expanded format. Flush the file to insure power failures
                  don't cause loss of data"

    | thePID theWS theArray thePgm theOutline |

    self custodian computer programViewer reset.

    thePID := (self paneNamed: 'mainList') selectedItem pgmID.
    thePgm := self custodian programs at: thePID.

    theOutline := self custodian computer programViewer inspectSubtree:
                                thePgm firstNode.

    self custodian expandedLogStream nextPutAll: (thePgm rawFitness asString); cr.

    theOutline do: [ :anEntry |
        self custodian expandedLogStream nextPutAll: anEntry; cr.
    ].

    self custodian expandedLogStream cr.
    self custodian expandedLogStream flush.            "Insure data written"

    ^self.!
   
writeLogEntry

    "At the end of each evolution cycle write the best individual fitness
            and flattened program. Flush the file to insure power failures
                  don't cause loss of data"

    | thePID theWS theArray thePgm |

    thePID := (self paneNamed: 'mainList') selectedItem pgmID.
    thePgm := self custodian programs at: thePID.

    self custodian computer load: thePgm.

    self custodian logStream nextPutAll: (thePgm rawFitness asString).
    self custodian logStream tab.

    theArray := self custodian computer flattenProgram.

    theArray do: [ :aPoint |
        theWS := WriteStream on: ( String new: 20 ).
        theWS nextPut: aPoint x asCharacter.
        theWS nextPutAll: aPoint y asString.
        theWS space.
        self custodian logStream nextPutAll: theWS contents.
    ].

    self custodian logStream cr.
    self custodian logStream flush.            "Insure data written"

    ^self.! !

Object subclass: #GPProgram
  instanceVariableNames: 
    'fitness rawFitness firstNode computer length depth funcNodes termNodes pgmID hits '
  classVariableNames: ''
  poolDictionaries: ''    !


!GPProgram class methods !
   
new
        "Answer a new GPProgram"

    ^super new initialize.! !



!GPProgram methods !
  
computer
        "Answer the computer for this GPProgram"
    ^computer.!
 
computer: aGPComputer
        "Set the computer for this GPProgram to aGPComputer"
    computer := aGPComputer.!
  
depth
        "Answer the depth for this GPProgram"
    ^depth.!
  
depth: anInt
        "Set the depth for this GPProgram to anInt"
    depth := anInt.!
 
firstNode
        "Answer the first node of the program for this GPProgram"
    ^firstNode.!
  
firstNode: aGPNode
        "Set the first node of the program to aGPNode"
    firstNode := aGPNode.!
  
fitness
        "Answer the fitness for this GPProgram"
    ^fitness.!

fitness:  aFloat
        "Set the fitness of the program to aFloat"
    fitness := aFloat.!
   
funcNodes
        "Answer the number of function nodes for this GPProgram"
    ^funcNodes.!
   
funcNodes: anInt
        "Set the number of function nodes for this GPProgram to anInt"
    funcNodes := anInt.!
  
hits
        "Answer the hits for this GPProgram"
    ^hits.!
 
hits: anArray
        "Set the hits for this GPProgram to anArray"
    hits := anArray.!
  
initialize
        "Initialize the GPProgram"

    self firstNode: nil.
    self fitness: nil.
    self depth: nil.
    self length: nil.
    self funcNodes: nil.
    self termNodes: nil.

    ^self.!
  
length
        "Answer the length for this GPProgram"
    ^length.!
   
length: anInt
        "Set the length for this GPProgram to anInt"
    length := anInt.!
  
next
        "Answer the next GPNode in this GPProgram"

    | theNode |

    (( theNode := self curentNode child)  = nil)
        ifTrue:  [
            (( theNode := self currentNode sibling) = nil)
                ifTrue: [^nil]
                ifFalse: [
                    self currentNode: theNode.
                    ^ theNode
                ].
        ]
        ifFalse: [
            self currentNode: theNode.
            ^ theNode
        ].!
   
pgmID
        "Answer the pgmID for this GPProgram"
    ^pgmID.!
  
pgmID: anInt
        "Set the pgmID for this GPProgram to anInt"
    pgmID := anInt.!
 
rawFitness
        "Answer the rawFitness for this GPProgram"
    ^rawFitness.!
   
rawFitness: anInt
        "Set the rawFitness for this GPProgram to anInt"
    rawFitness := anInt.!
  
termNodes
        "Answer the number of terminal nodes for this GPProgram"
    ^termNodes.!
   
termNodes: anInt
        "Set the number of terminal nodes for this GPProgram to anInt"
    termNodes := anInt.! !

Object subclass: #GPProgramGenerator
  instanceVariableNames: 
    'randomizer computer depth maxDepth flatProgramPool flatPgmStream '
  classVariableNames: ''
  poolDictionaries: ''  !


!GPProgramGenerator class methods !
  
new
        "Answer an initialized GPProgramGenerator"

    ^super new initialize.! !



!GPProgramGenerator methods !
   
computer
        "Answer the computer for this GPProgramGenerator "

    ^computer.!
 
computer: aGPComputer
        "Set the computer for this GPProgramGenerator to aGPComputer"

    computer := aGPComputer.!
   
createFNode
        "Answer a GPNode configured as a function "

    | theNode |

    theNode := GPNode new.

    theNode type: $F; value: (self selectFunction).

    ^theNode.!
  
createTNode
        "Answer a GPNode configured as a terminal "

    | theNode |

    theNode := GPNode new.

    theNode type: $T; value: (self selectTerminal).

    ^theNode.!
  
createTorFNode
        "Answer a GP{Node configured as randomly chosen function or terminal
                selected from the function and terminal sets"

    | theNode |

    theNode := GPNode new.

       ((self randomizer getMax: 2) = 0)   "Function or Terminal? 0=>Function"
            ifTrue: [
                theNode type: $F; value: (self selectFunction).
            ]
            ifFalse: [
                theNode type: $T; value: (self selectTerminal).
            ].

    ^theNode.!

depth
        "Answer the depth for this GPProgramGenerator "

    ^depth.!
  
depth: anInt
        "Set the depth for this GPProgramGenerator to anInt"

    depth := anInt.!
  
duplicate: aGPProgram
        "Answer a GPProgram which is a duplicate of aGPProgram with
                 no links to the original"

    | aGPNode newProgram |

    self computer load: aGPProgram.             "Create flat nodeArray from program"
    self computer flattenProgram.

    aGPNode := GPNode new.
    aGPNode type: ((aGPProgram  firstNode type) copy).            "Setup first node"
    aGPNode value: ((aGPProgram  firstNode value) copy).

    newProgram := GPProgram new.
    newProgram firstNode: aGPNode.
    newProgram fitness: aGPProgram fitness copy.      "Make the new program"
    newProgram rawFitness: aGPProgram rawFitness copy.
    newProgram length: aGPProgram length copy.
    newProgram depth: aGPProgram depth copy.
    newProgram funcNodes: aGPProgram funcNodes copy.
    newProgram termNodes: aGPProgram termNodes copy.

    (aGPProgram firstNode type = $T)                                        "Handle a 1 node pgm"
        ifTrue: [^newProgram].

    self computer nodeArrayPtr: 2.                                              "Reset array pointer"

    self generateDuplicate: aGPNode.                         "Duplicate the subtree"

    ^newProgram.!

flatPgmStream
        "Answer the flatPgmStream for this GPProgramGenerator"
    ^flatPgmStream.!
 
flatPgmStream: aStream
        "Set the flatPgmStream for this GPProgramGenerator to aStream"
    flatPgmStream := aStream.!
  
flatProgramPool
        "Answer the flatProgramPool for this GPProgramGenerator.
                This is a collection of flat programs which are used to check
                    for duplicates when creating the initial population"

    ^flatProgramPool.!

flatProgramPool: aCollection
        "Set the flatProgramPool for this GPProgramGenerator to aCollection.
                This is a collection of flat programs which are used to check
                    for duplicates when creating the initial population"

    flatProgramPool := aCollection.!
 
generateDuplicate: aGPNode
        "Answer a GPNode which is part of a connected subtree"

    | currentNode funcID theArity newNode theArray |

    theArray := self computer nodeArray.

    funcID := aGPNode value.
    theArity := self computer functionAritys at: funcID.

    currentNode := aGPNode.

    1 to: theArity do: [ :i |

        newNode := GPNode new.
        newNode type: (((theArray at:
            self computer nodeArrayPtr) x asCharacter) copy).     "Copy the flattened node"
        newNode value: (((theArray at:
            self computer nodeArrayPtr) y) copy).                       "to the new program"
        self computer nodeArrayPtr: (self computer nodeArrayPtr + 1).

        (i = 1)
            ifTrue: [ currentNode child: newNode . ]
            ifFalse: [ currentNode sibling: newNode ].
        currentNode := newNode.
        (newNode type = $F)
            ifTrue: [
                self generateDuplicate: newNode
            ].
    ].

    ^aGPNode.!

generateFullProgram
        "Recursively generate the tree"

    | aGPNode theProgram |

    aGPNode := GPNode new.
    aGPNode type: $F; value: (self selectFunction); sibling: nil.

    self depth: 1.

    self generateFullSubtreeWithLimit: aGPNode.

    theProgram := GPProgram new.
    theProgram firstNode: aGPNode.

    ^theProgram.!
   
generateFullProgramNoDups
        "Answer aGPProgram which is not a duplicate of any program
            currently in the flatProgramPool"

    | dupFlag theFlatPgm potentialProgram |

    1 to: 7 do: [ :depthIncr |                         "7 tries to increase depth.. never happen"

        1 to: 20 do: [ :attemptNumber |             "20 attempts to find a non duplicate program"
                                                                    "at the current depth"

            potentialProgram := self generateFullProgram.
            self computer load: potentialProgram.
            self computer computeProgramStats.
            theFlatPgm := self computer flattenProgram.

            dupFlag := false.
            self flatProgramPool do: [ :aFlatPgm |
                (aFlatPgm = theFlatPgm)
                    ifTrue: [ dupFlag := true ].
            ].
            (dupFlag = false)
                ifTrue: [
                    flatProgramPool add: theFlatPgm.
                    ^potentialProgram
            ].
        ].
        self maxDepth: (self maxDepth + 1).   "Incr maxDepth and try again"
    ].

    self error: 'Not able to Gen Program'.!
   
generateFullSubtreeWithLimit: aGPNode
        "Answer a GPNode which is part of a connected subtree"

    | currentNode funcID theArity newNode |

    funcID := aGPNode value.
    theArity := self computer functionAritys at: funcID.

    currentNode := aGPNode.

    1 to: theArity do: [ :i |
        (self depth = (self maxDepth - 1))
            ifTrue: [ newNode := self createTNode ]
            ifFalse: [ newNode := self createFNode ].
        (i = 1)
            ifTrue: [ currentNode child: newNode . ]
            ifFalse: [ currentNode sibling: newNode ].
        currentNode := newNode.
        (newNode type = $F)
            ifTrue: [
                self depth: (self depth + 1).
                self generateFullSubtreeWithLimit: newNode
            ].
    ].
    self depth: (self depth - 1).

    ^aGPNode.!
  
generateProgram
        "Recursively generate the tree"

    | aGPNode theProgram |

    aGPNode := GPNode new.
    aGPNode type: $F; value: (self selectFunction); sibling: nil.

    self depth: 1.

   " self generateSubtree: aGPNode. "
    self generateSubtreeWithLimit: aGPNode.

    theProgram := GPProgram new.
    theProgram firstNode: aGPNode.

    ^theProgram.!

generateRandomProgram
        "Recursively generate the tree"

    | aGPNode theProgram |

    aGPNode := GPNode new.
    aGPNode type: $F; value: (self selectFunction); sibling: nil.

    self depth: 1.

    self generateSubtreeWithLimit: aGPNode.

    theProgram := GPProgram new.
    theProgram firstNode: aGPNode.

    ^theProgram.!
 
generateRandomProgramNoDups
        "Answer aGPProgram which is not a duplicate of any program
            currently in the flatProgramPool"

    | dupFlag theFlatPgm potentialProgram |

    1 to: 7 do: [ :depthIncr |                         "7 tries to increase depth.. never happen"

        1 to: 20 do: [ :attemptNumber |             "20 attempts to find a non duplicate program"
                                                                    "at the current depth"

            potentialProgram := self generateRandomProgram.
            self computer load: potentialProgram.
            self computer computeProgramStats.
            theFlatPgm := self computer flattenProgram.

            dupFlag := false.
            self flatProgramPool do: [ :aFlatPgm |
                (aFlatPgm = theFlatPgm)
                    ifTrue: [ dupFlag := true ].
            ].
            (dupFlag = false)
                ifTrue: [
                    flatProgramPool add: theFlatPgm.
                    ^potentialProgram
            ].
        ].
        self maxDepth: (self maxDepth + 1).   "Incr maxDepth and try again"
    ].

    self error: 'Not able to Gen Program'.!
   
generateSubtree: aGPNode
        "Answer a GPNode which is part of a connected subtree"

    | currentNode funcID theArity newNode |

    funcID := aGPNode value.
    theArity := self computer functionAritys at: funcID.
    self depth: (self depth + 1).

    currentNode := aGPNode.

    1 to: theArity do: [ :i |
        newNode := self createTorFNode.
        (i = 1)
            ifTrue: [ currentNode child: newNode . ]
            ifFalse: [ currentNode sibling: newNode ].
        currentNode := newNode.
        (newNode type = $F)
            ifTrue: [self generateSubtree: newNode ].
    ].

    ^aGPNode.!
 
generateSubtreeNoLimit: aGPNode
        "Answer a GPNode which is part of a connected subtree"

    | currentNode funcID theArity newNode |

    funcID := aGPNode value.
    theArity := self computer functionAritys at: funcID.
    self depth: (self depth + 1).

    currentNode := aGPNode.

    1 to: theArity do: [ :i |
        newNode := self createTorFNode.
        (i = 1)
            ifTrue: [ currentNode child: newNode . ]
            ifFalse: [ currentNode sibling: newNode ].
        currentNode := newNode.
        (newNode type = $F)
            ifTrue: [self generateSubtreeNoLimit: newNode ].
    ].

    ^aGPNode.!
   
generateSubtreeWithLimit: aGPNode
        "Answer a GPNode which is part of a connected subtree"

    | currentNode funcID theArity newNode |

    funcID := aGPNode value.
    theArity := self computer functionAritys at: funcID.

    currentNode := aGPNode.

    1 to: theArity do: [ :i |
        (self depth = (self maxDepth - 1))
            ifTrue: [ newNode := self createTNode ]
            ifFalse: [ newNode := self createTorFNode ].
        (i = 1)
            ifTrue: [ currentNode child: newNode . ]
            ifFalse: [ currentNode sibling: newNode ].
        currentNode := newNode.
        (newNode type = $F)
            ifTrue: [
                self depth: (self depth + 1).
                self generateSubtreeWithLimit: newNode
            ].
    ].
    self depth: (self depth - 1).

    ^aGPNode.!
   
initialize
        "Initialize this GPProgramViewer"

    self depth: 0.
    self maxDepth: 6.

    ^self.!
   
maxDepth
        "Answer the maxDepth for this GPProgramGenerator "

    ^maxDepth.!
 
maxDepth: anInt
        "Set the maxDepth for this GPProgramGenerator to anInt"

    maxDepth := anInt.!
 
randomizer
        "Answer the randomizer for this GPCustodian "

    ^randomizer.!
  
randomizer: aRan2
        "Set the randomizer for this GPCustodian to aRan2"

    randomizer := aRan2.!
  
selectFunction
        "Answer a randomly chosen function
                selected from the function set"

    ^((self randomizer getMax: (self computer functions size)) + 1).!

selectTerminal
        "Answer a randomly chosen terminal
                selected from the terminal set"

    ^((self randomizer getMax: (self computer terminals size)) + 1).!

unflattenPgm: anArray
        "Answer a GPProgram generated from anArray of substrings in the format
               F3 T2 ..... where the first character is F (function) or T (terminal), and
               the number following is the identifier."

    | aGPNode pointArray aPoint aPgm |

    "First convert the array of substrings to anArray of points"

    pointArray := OrderedCollection new.

    anArray do: [ :aNode |
        aPoint := 0@0.
        aPoint x: (aNode at: 1).
        aPoint y: ((aNode copyFrom: 2 to: aNode size) asInteger).
        pointArray add: aPoint.
    ].

    "Now do the unflattening"

    self flatPgmStream: (ReadStream on: pointArray).

    aPoint := self flatPgmStream next.
    aGPNode := GPNode new.

    (aPoint x = $T)                                            "If 1st node is a terminal ... done"
        ifTrue: [
            aGPNode child: nil;  sibling: nil; value: aPoint y;  type: aPoint x.
            aPgm := GPProgram new.
            aPgm firstNode: aGPNode.
            self computer load: aPgm; computeProgramStats.
            ^aPgm
        ]
        ifFalse: [
            aGPNode type: aPoint x; value: aPoint y.
            self unflattenSubtree: aGPNode.
            aPgm := GPProgram new.
            aPgm firstNode: aGPNode.
            self computer load: aPgm; computeProgramStats.
            ^aPgm
        ].!
 
unflattenSubtree: aGPNode
        "Answer a GPNode which is part of a connected subtree"

    | currentNode funcID theArity newNode nextPoint |

    funcID := aGPNode value.
    theArity := self computer functionAritys at: funcID.

    currentNode := aGPNode.

    1 to: theArity do: [ :i |
        newNode := GPNode new.
        (self flatPgmStream atEnd) ifTrue: [^aGPNode].
        nextPoint := self flatPgmStream next.
        newNode type: nextPoint x; value: nextPoint y.
        (i = 1)
            ifTrue: [ currentNode child: newNode . ]
            ifFalse: [ currentNode sibling: newNode ].
        currentNode := newNode.
        (newNode type = $F)
            ifTrue: [self unflattenSubtree: newNode ].
    ].

    ^aGPNode.! !

ViewManager subclass: #GraphTester
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants WBConstants '  !


!GraphTester class methods !
 
wbCreated

    ^true! !



!GraphTester methods !
 
doItBP: aPane

    "Callback for the #clicked event in an unnamed Button (contents is 'Do It').
     (Generated by WindowBuilder)"

    | c thePane theGraph |

    thePane := self paneNamed: 'graphBitmap'.
    thePane backColor: ClrBlack.
    thePane foreColor: ClrGreen.

    theGraph := Graph new: thePane extent.

    theGraph title: 'Test Graph'.
    theGraph ySeries:
        #(1 2 3 2 3 3 4 3 4 5 4 5 5 6 5 6 7 6 7 6 7 8 9 10).
    theGraph maxX: 50.
    theGraph drawAxes.
    theGraph drawLineGraph.

    thePane contents: theGraph bitmap.
    thePane display.!
  
drawJohn

    "Callback for the #clicked event in an unnamed Button (contents is 'Do It').
     (Generated by WindowBuilder)"

    | c thePane theByteArray size b f p |

    thePane := self paneNamed: 'graphBitmap'.
    thePane backColor: ClrBlack.
    thePane foreColor: ClrGreen.

    c := Bitmap extent: thePane extent.

    p := c pen.
    p setLineWidth: 2.

    p up;
         goto: 80@80; north; turn: 180; down;
        go: 50; turn: 90; go: 20; turn: 90;  go: 20.

    p up;
        goto: 80@80; north; turn: 90; go: 10; down;
        go: 20; turn: 90; go: 50; turn: 90; go: 20; turn: 90; go: 50.

    p up;
        goto: 80@80; north; turn: 90; go: 40; turn: 90; down;
        go: 50; turn: 180; go: 25; turn: 90; go: 20; turn: 90; go: 25; turn: 180; go: 50.

    p up;
        goto: 80@80; north; turn: 90; go: 70; turn: 90;  go: 50; down;
        north; go: 50; turn: 150; go: 58; north; go: 50.


    thePane contents: c.
    thePane display.!
  
getBitmapContents: aPane

    "Callback for the #getContents event in the CPBitmapPane named 'graphBitmap'.
     (Generated by WindowBuilder)"!
  
open


     "WARNING!!  This method was automatically generated by
      WindowBuilder.  Code you add here which does not conform
      to the WindowBuilder API will probably be lost the next time
      you save your layout definition."

     | v |

    self addView: (
        v := self topPaneClass new
            owner: self;
            labelWithoutPrefix:  'Graph Tester';
            noSmalltalkMenuBar;
            viewName: 'mainView';
            framingBlock: ( FramingParameters new iDUE: 1029 @ 570; xC; yC; cRDU: (7 @ 563 rightBottom: 1022 @ 50));
            pStyle: #(sysmenu sizable titlebar minimize maximize);
            addSubpane: (
                CPBitmapPane new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 507 @ 312; lDU: 400 r: #left; tDU: 112 r: #top);
                    paneName: 'graphBitmap';
                    contents: (CPBitmapDict at: 'checkBox');
                    startGroup;
                    when: #getContents perform: #getBitmapContents:;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 151 @ 32; lDU: 107 r: #left; rDU: 258 r: #left; tDU: 184 r: #top; bDU: 216 r: #top);
                    paneName: 'output1';
                    rightJustified;
                    contents: '0';
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 151 @ 32; lDU: 107 r: #left; rDU: 258 r: #left; tDU: 240 r: #top; bDU: 272 r: #top);
                    paneName: 'output2';
                    rightJustified;
                    contents: '0';
                    yourself
            );
            addSubpane: (
                CPNumericEditor new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 178 @ 45; lDU: 98 r: #left; tDU: 104 r: #top);
                    paneName: 'input1';
                    startGroup;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                Button new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 128 @ 53; lDU: 80 r: #left; rDU: 208 r: #left; tDU: 352 r: #top; bDU: 405 r: #top);
                    startGroup;
                    when: #clicked perform: #doItBP:;
                    contents: 'Do It';
                    yourself
            );
        yourself
    ).

    self openWindow! !

WindowDialog subclass: #GPInitializer
  instanceVariableNames: 
    'custodian '
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants WBConstants '    !


!GPInitializer class methods !
   
setInitializeInfo: aGPCustodian
        "Fill instance variables in aGPCustodian with
            initialize information... initPopSize, maxInitDepth, etc."

    | theInitializer |

    theInitializer := self new.
    theInitializer custodian: aGPCustodian.

    theInitializer open.!
   
wbCreated

    ^true! !



!GPInitializer methods !
   
cancelBP: aPane

    "Callback for the #clicked event in an unnamed Button (contents is 'Cancel').
     (Generated by WindowBuilder)"

      self close.!
  
createViews

     "WARNING!!  This method was automatically generated by
      WindowBuilder.  Code you add here which does not conform
      to the WindowBuilder API will probably be lost the next time
      you save your layout definition."

     | v |

    self addView: (
        v := self topPaneClass new
            owner: self;
            labelWithoutPrefix:  'GP Initializer';
            noSmalltalkMenuBar;
            viewName: 'mainView';
            framingBlock: ( FramingParameters new iDUE: 841 @ 764; xC; yC; cRDU: (11 @ 754 rightBottom: 830 @ 48));
            pStyle: #(modal titlebar);
            backColor: ClrPalegray;
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 336 @ 32; lDU: 43 r: #left; rDU: 379 r: #left; tDU: 550 r: #top; bDU: 582 r: #top);
                    rightJustified;
                    contents: 'Random Seed:';
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 258 @ 32; lDU: 9 r: #left; rDU: 267 r: #left; tDU: 128 r: #top; bDU: 160 r: #top);
                    rightJustified;
                    contents: 'Selection Type:';
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 219 @ 38; lDU: 14 r: #left; rDU: 233 r: #left; tDU: 38 r: #top; bDU: 76 r: #top);
                    rightJustified;
                    contents: 'Log Title:';
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 329 @ 36; lDU: 50 r: #left; rDU: 379 r: #left; tDU: 310 r: #top; bDU: 346 r: #top);
                    rightJustified;
                    contents: 'Initial Population:';
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 343 @ 46; lDU: 37 r: #left; rDU: 379 r: #left; tDU: 390 r: #top; bDU: 436 r: #top);
                    rightJustified;
                    contents: 'Max Initial Depth:';
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 373 @ 36; lDU: 7 r: #left; rDU: 379 r: #left; tDU: 470 r: #top; bDU: 506 r: #top);
                    rightJustified;
                    contents: 'Max Crossover Depth:';
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                Button new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 128 @ 52; lDU: 667 r: #left; rDU: 795 r: #left; tDU: 622 r: #top; bDU: 674 r: #top);
                    idOK;
                    defaultPushButton;
                    startGroup;
                    when: #clicked perform: #okBP:;
                    contents: 'OK';
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                CPNumericEditor new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 178 @ 46; lDU: 421 r: #left; tDU: 302 r: #top);
                    paneName: 'initPopEd';
                    startGroup;
                    when: #getContents perform: #setInitPop:;
                    foreColor: ClrWhite;
                    backColor: ClrDarkcyan;
                    yourself
            );
            addSubpane: (
                CPNumericEditor new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 178 @ 46; lDU: 421 r: #left; tDU: 382 r: #top);
                    paneName: 'maxInitDepthEd';
                    startGroup;
                    when: #getContents perform: #setMaxInitDepth:;
                    foreColor: ClrWhite;
                    backColor: ClrDarkcyan;
                    yourself
            );
            addSubpane: (
                CPNumericEditor new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 178 @ 46; lDU: 421 r: #left; tDU: 462 r: #top);
                    paneName: 'maxCrossoverDepthEd';
                    startGroup;
                    when: #getContents perform: #setMaxCrossoverDepth:;
                    foreColor: ClrWhite;
                    backColor: ClrDarkcyan;
                    yourself
            );
            addSubpane: (
                EntryField new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 434 @ 48; lDU: 249 r: #left; rDU: 683 r: #left; tDU: 32 r: #top; bDU: 78 r: #top; indent: 3 @ 4);
                    paneName: 'logTitle';
                    startGroup;
                    when: #getContents perform: #setInitLogComment:;
                    foreColor: ClrWhite;
                    backColor: ClrDarkcyan;
                    yourself
            );
            addSubpane: (
                CPNumericEditor new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 178 @ 46; lDU: 421 r: #left; tDU: 542 r: #top);
                    paneName: 'randomSeed';
                    startGroup;
                    when: #getContents perform: #setRandomSeed:;
                    foreColor: ClrWhite;
                    backColor: ClrDarkcyan;
                    yourself
            );
            addSubpane: (
                ComboBox new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 400 @ 148; lDU: 283 r: #left; rDU: 683 r: #left; tDU: 122 r: #top; bDU: 270 r: #top);
                    paneName: 'selectionType';
                    contents: #( 'Fitness Proportionate' 'Tournament' );
                    dropDownList;
                    startGroup;
                    when: #getContents perform: #setSelectionType:;
                    when: #select perform: #selectionTypeSel:;
                    foreColor: ClrWhite;
                    backColor: ClrDarkcyan;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 334 @ 40; lDU: 43 r: #left; rDU: 377 r: #left; tDU: 230 r: #top; bDU: 270 r: #top);
                    paneName: 'tSizeText';
                    rightJustified;
                    startGroup;
                    contents: 'Tournament Size:';
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                CPNumericEditor new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 178 @ 46; lDU: 421 r: #left; tDU: 224 r: #top);
                    paneName: 'tSizeEd';
                    startGroup;
                    when: #getContents perform: #setTSize:;
                    foreColor: ClrWhite;
                    backColor: ClrDarkcyan;
                    yourself
            );
        yourself
    ).!

custodian
        "Answer the GPCustodian associated with this GPInitializer"

    ^custodian.!
  
custodian: aGPCustodian
        "Set the GPCustodian associated with this GPInitializer to aGPCustodian"

    custodian := aGPCustodian.!

initWindow
        "comment"
    | temporaries |

    self setTWindows.!

okBP: aPane

    "Callback for the #clicked event in an unnamed Button (contents is 'OK').
     (Generated by WindowBuilder). Take the info from the valuators and
        pass them on them to the GPCustodian"

    self custodian initPopulationSize:
            ((self paneNamed: 'initPopEd') value).
    self custodian maxInitDepth:
            ((self paneNamed: 'maxInitDepthEd') value).
    self custodian maxCrossoverDepth:
            ((self paneNamed: 'maxCrossoverDepthEd') value).
    self custodian logComment: ((self paneNamed: 'logTitle') contents).
    self custodian selectionType: ((self paneNamed: 'selectionType') selectedItem).
    self custodian randomSeed: ((self paneNamed: 'randomSeed') value).
    self custodian tournamentSize:
            ((self paneNamed: 'tSizeEd') value).

    self close.!
  
preInitWindow
        "comment"
    | temporaries |!
  
selectionTypeSel: aPane

    "Callback for the #select event in the ComboBox named 'selectionType'.
     (Generated by WindowBuilder)"

    self setTWindows.!
 
setInitLogComment: aPane

    "Callback for the #getContents event in the CPNumericEditor named 'maxInitDepthEd'.
     (Generated by WindowBuilder)"

    aPane contents: 'No Comment'.!
   
setInitPop: aPane

    "Callback for the #getContents event in the CPNumericEditor named 'initPopEd'.
     (Generated by WindowBuilder)"

    aPane value: 50.!

setMaxCrossoverDepth: aPane

    "Callback for the #getContents event in the CPNumericEditor named 'maxCrossoverDepthEd'.
     (Generated by WindowBuilder)"

    aPane value: 17.!

setMaxInitDepth: aPane

    "Callback for the #getContents event in the CPNumericEditor named 'maxInitDepthEd'.
     (Generated by WindowBuilder)"

    aPane value: 6.!
   
setRandomSeed: aPane

    "Callback for the #getContents event in the CPNumericEditor named 'randomSeed'.
     (Generated by WindowBuilder)"

    aPane value: 12345.!
 
setSelectionType: aPane

    "Callback for the #getContents event in the ComboBox named 'selectionType'.
     (Generated by WindowBuilder)"

    | theOC |

    theOC := OrderedCollection new.
    theOC add: 'FitnessProportionate'.
    theOC add: 'Tournament'.
    aPane contents: theOC.

    aPane selection: 1.
    self setTWindows.!
 
setTSize: aPane

    "Callback for the #getContents event in the CPNumericEditor named 'tSizeEd'.
     (Generated by WindowBuilder)"

    aPane value: 2.!
 
setTWindows
        "comment"

     ((self paneNamed: 'selectionType') selectedItem ~= 'Tournament')
        ifTrue: [
            (self paneNamed: 'tSizeEd') hideWindow.
           ( self paneNamed: 'tSizeText') hideWindow.
        ]
        ifFalse: [
            (self paneNamed: 'tSizeEd') showWindow.
            (self paneNamed: 'tSizeText') showWindow.
        ].! !

Object subclass: #GPCustodian
  instanceVariableNames: 
    'computer generationNo overlord programs randomizer programGenerator initPopulationSize maxInitDepth maxCrossoverDepth maxFitnessCollection logComment logStream expandedLogStream selectionType randomSeed tournamentSize '
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants WBConstants '   !


!GPCustodian class methods !
 
new
        "comment"

    ^super new initialize.! !



!GPCustodian methods !
   
computer
        "Answer the computer for this GPCustodian "

    ^computer.!

computer: aGPComputer
        "Set the computer for this GPCustodian to aGPComputer"

    computer := aGPComputer.!
  
crossover: aGPProgram1 at: anInt1 with: aGPProgram2 at: anInt2
        "Perform the crossover of aGPProgram1 and aGPProgram2 and
            answer an array of two programs as a result"

    | position1 position2 node1Parent node2Parent node1 node2
                savedNode1Sibling pgm1Copy pgm2Copy resultArray  pgm1Depth
                        pgm2Depth |

    resultArray := Array new: 2.

   "Make some copies"
    pgm1Copy := self programGenerator duplicate: aGPProgram1.
    pgm2Copy := self programGenerator duplicate: aGPProgram2.

    self  computer load: pgm1Copy.
    position1 := anInt1.
    node1 := self computer findNodeNo: position1.

    (position1 = 1)
        ifTrue: [node1Parent := nil.]
        ifFalse: [ node1Parent := self computer findSuperiorNodeTo: node1 ].

    self  computer load: pgm2Copy.
    position2 := anInt2.
    node2 := self computer findNodeNo: position2.

    (position2 = 1)
        ifTrue: [node2Parent := nil.]
        ifFalse: [ node2Parent := self computer findSuperiorNodeTo: node2].

    "Piece it all together"

    savedNode1Sibling := node1 sibling.

    (node1Parent isNil)
        ifTrue: [pgm1Copy firstNode: node2.]
        ifFalse: [
            (node1Parent child == node1)
                ifTrue: [ node1Parent child: node2.]
                ifFalse: [ node1Parent sibling: node2 ].
        ].

    (node2Parent isNil)
        ifTrue: [pgm2Copy firstNode: node1.]
        ifFalse: [
            (node2Parent child == node2)
                ifTrue: [ node2Parent child: node1.]
                ifFalse: [ node2Parent sibling: node1 ].
        ].

    node1 sibling: node2 sibling.                           "Swap the siblings of node 1 and 2 "
    node2 sibling: savedNode1Sibling.

    "Now check out the final depth. It it's too long just use the uncrossed pgms"

    self computer load: pgm1Copy.
    pgm1Depth := self computer programDepth.
    self computer load: pgm2Copy.
    pgm2Depth := self computer programDepth.

    (pgm1Depth > self maxCrossoverDepth)
        ifTrue: [ resultArray at: 1 put:
                        (self programGenerator duplicate: aGPProgram1). ]
        ifFalse: [ resultArray at: 1 put: pgm1Copy].

    (pgm2Depth > self maxCrossoverDepth)
        ifTrue: [ resultArray at: 2 put:
                        (self programGenerator duplicate: aGPProgram2). ]
        ifFalse: [ resultArray at: 2 put: pgm2Copy].

    ^resultArray.!
   
crossover: aGPProgram1 with: aGPProgram2
        "Perform the crossover of aGPProgram1 and aGPProgram2 in place"

    | position1 position2 len1 len2  |

    (self randomizer next > 0.9)
        ifTrue: [                                                                "external points"
            len1 :=   aGPProgram1 termNodes.
            self computer load: aGPProgram1.
            position1 := self computer findTermNodeNo:
                                    (1 + (self randomizer getMax: len1)).
        ]
        ifFalse: [                                                              "internal points"
            len1 :=   aGPProgram1 funcNodes.
            (len1 = 0)
                ifTrue: [ position1 := 1.]
                ifFalse: [ position1 := 1 + (self randomizer getMax: len1)].
            self computer load: aGPProgram1.
            position1 := self computer findFuncNodeNo: position1.
        ].

    (self randomizer next > 0.9)
        ifTrue: [
            len2 :=   aGPProgram2 termNodes.
            self computer load: aGPProgram2.
            position2 := self computer findTermNodeNo:
                                    (1 + (self randomizer getMax: len2)).
        ]
        ifFalse: [
            len2 :=   aGPProgram2 funcNodes.
            (len2 = 0)
                ifTrue: [ position2 := 1.]
                ifFalse: [ position2 := 1 + (self randomizer getMax: len2)].
            self computer load: aGPProgram2.
            position2 := self computer findFuncNodeNo: position2.
        ].


    ^ (self crossover: aGPProgram1 at: position1
                            with: aGPProgram2 at: position2).!
   
currentTotalFitness
        "Answer the totalFitness for the current population"

    | totalFitness |

    totalFitness := 0.0.

    self programs do: [ :aProgram |
        totalFitness := totalFitness + aProgram fitness.
    ].

    ^totalFitness.!
   
evaluateFitness
        "Analyze the fitness of each member of -programs-. Updates
                main Window"

    | count |

    count := 0.

    programs do: [ :aProgram |
        count := count + 1.
        self overlord updateFitnessProgress: count.
        self evaluateIndividualFitness: aProgram.
    ].!
   
evaluateInitialFitness
        "Analyze the fitness of each member of -programs-. Updates
                    GPGenerate"

    |  count   |

    count := 0.
    self overlord genDialogSetupMin: 0 max: programs size
                      comment: 'Evaluating Fitness'.

    programs do: [ :aProgram |
        count := count + 1.
        self overlord genDialogValue: count.
        self evaluateIndividualFitness: aProgram.
    ].!

expandedLogStream
        "Answer the expandedLogStream for this GPCustodian "

    ^expandedLogStream.!
 
expandedLogStream: aFileStream
        "Set the expandedLogStream for this GPCustodian to aFileStream"

    expandedLogStream := aFileStream.!
   
generatePopulation
        "Generates a population ala Koza ramped half and half method
            while scanning for duplicates"

    | maxPrograms loc chunkSize aProgram |

    maxPrograms := self programs size.
    self programGenerator flatProgramPool: OrderedCollection new.  "Init the"
                                                                                                "duplicate check pool"
    loc := 1.
    chunkSize := ( maxPrograms / 10.0) truncated.

    self overlord genDialogSetupMin: 2 max: 6 comment: 'Generating Programs'.

    2 to: 6 do: [ :theDepth |

        self overlord genDialogValue: theDepth.

        self programGenerator maxDepth: theDepth.

        1 to: chunkSize do: [ :i |
            aProgram := self programGenerator generateRandomProgramNoDups.
            aProgram pgmID: loc.
            self programs at: loc put: aProgram.
            loc := loc + 1.
        ].

        1 to: chunkSize do: [ :i |
            aProgram := self programGenerator generateFullProgramNoDups.
            aProgram pgmID: loc.
            self programs at: loc put: aProgram.
            loc := loc + 1.
        ].

    ].

    [loc > maxPrograms]                  "Generate  stragglers"
        whileFalse: [
            aProgram := self programGenerator generateRandomProgramNoDups.
            aProgram pgmID: loc.
            self programs at: loc put: aProgram.
            loc := loc + 1.
        ].

    self programGenerator flatProgramPool:
                (OrderedCollection new). "Reclaim storage... normally don't do this but"
                                                        "here it's worth it"
    ^self.!
 
generatePopulationWithDups
        "comment"

    | maxPrograms loc chunkSize |

    maxPrograms := self programs size.
    loc := 1.
    chunkSize := ( maxPrograms / 10.0) truncated.

    2 to: 6 do: [ :theDepth |

        self programGenerator maxDepth: theDepth.

        1 to: chunkSize do: [ :i |
            self programs at: loc put:
                self  programGenerator generateRandomProgram.
                (self programs at: loc) pgmID: loc.
                self computer load: (self programs at: loc).
                self computer computeProgramStats.
            loc := loc + 1.
        ].

        1 to: chunkSize do: [ :i |
             self programs at: loc put:
                self  programGenerator generateFullProgram.
                (self programs at: loc) pgmID: loc.
                self computer load: (self programs at: loc).
                self computer computeProgramStats.
            loc := loc + 1.
        ].

    ].

    [loc > maxPrograms]                  "Generate  stragglers"
        whileFalse: [
            self programs at: loc put:
                self  programGenerator generateRandomProgram.
                (self programs at: loc) pgmID: loc.
                self computer load: (self programs at: loc).
                self computer computeProgramStats.
            loc := loc + 1.
        ].

    ^self.!
 
generationNo
        "Answer the generation for this GPCustodian "

    ^generationNo.!
  
generationNo: anInt
        "Set the generation for this GPCustodian to anInt"

    generationNo := anInt.!
  
initialize

        "Perform the initialization"

    | theProgram |

    GPInitializer setInitializeInfo: self.                 "Get the info from the user"

    maxFitnessCollection := OrderedCollection new.

    self generationNo: 1.

    programs := Array new: self initPopulationSize.
    randomizer := Ran2 new initialize: (self randomSeed negated).
    programGenerator := GPProgramGenerator new.           "Let the pgmGen know about"
    self programGenerator maxDepth: self maxInitDepth.    "maxDepth from the Initializer"
    self programGenerator randomizer: randomizer.             "and the randomizer"
                                                                                                   "The subclass will inform"
                                                                                                   "the pgmGen abt the computer"

    ^self.!
  
initPopulationSize
        "Anwer the initial population size for this GPCustodian"

    ^initPopulationSize.!
   
initPopulationSize: anInt
        "Set the initial population size for this GPCustodian to anInt"

    initPopulationSize := anInt.!
 
logComment
        "Answer the logComment for this GPCustodian "

    ^logComment.!
  
logComment: aString
        "Set the logComment for this GPCustodian to aString"

    logComment := aString.!

logStream
        "Answer the logStream for this GPCustodian "

    ^logStream.!
 
logStream: aFileStream
        "Set the logStream for this GPCustodian to aFileStream"

    logStream := aFileStream.!
   
maxCrossoverDepth
        "Anwer the maximum crossover depth for this GPCustodian"

    ^maxCrossoverDepth.!
 
maxCrossoverDepth: anInt
        "Set the maximum crossover depth for this GPCustodian to anInt"

    maxCrossoverDepth := anInt.!
   
maxFitnessCollection
        "Answer the maxFitnessCollection for this GPCustodian "

    ^maxFitnessCollection.!

maxFitnessCollection: anOrderedCollection
        "Set the maxFitnessCollection for this GPCustodian to anOrderedCollection"

    maxFitnessCollection := anOrderedCollection.!
  
maxInitDepth
        "Anwer the maximum initial depth for this GPCustodian"

    ^maxInitDepth.!
 
maxInitDepth: anInt
        "Set the maximum initial depth for this GPCustodian to anInt"

    maxInitDepth := anInt.!
   
overlord
        "Answer the overlord for this GPCustodian "

    ^overlord.!

overlord: aGPOverlord
        "Set the overlord for this GPCustodian to aGPOverlord"

    overlord := aGPOverlord.!
  
performGenetics
        "Pick the user requested genetic method"

    (self selectionType = 'Tournament')
        ifTrue: [ self performGeneticsTS].

    (self selectionType = 'Fitness Proportionate')
        ifTrue: [ self performGeneticsFP].!
 
performGeneticsFP
        "Answer self. Create a new population to replace -programs- based
            on crossover, reproduction, and mutation using fitness proportionate
                selection and aFloat as the total population fitness"

    |  totalFitness selectedProgram1 selectedProgram2
            newPgm1 newPgm2 i pSize newPrograms theResults |

    totalFitness := self currentTotalFitness.
    pSize := self programs size.

    newPrograms := Array new: pSize.

    i := 0.

    [i < pSize]
        whileTrue: [
            ((self randomizer next > 0.9) or: [i = (pSize - 1)])  "Insure pop remains same"
                ifTrue: [                                               "Reproduce"
                    selectedProgram1 := self selectProgramFP: totalFitness.
                    newPgm1 := self programGenerator duplicate: selectedProgram1.
                    i := i + 1.
                    newPrograms at: i put: newPgm1.
                    self computer load: newPgm1.
                    self computer computeProgramStats.
                ]
                ifFalse: [
                    selectedProgram1 := self selectProgramFP: totalFitness.
                    selectedProgram2 := self selectProgramFP: totalFitness.
                    theResults := self crossover: selectedProgram1 with: selectedProgram2.
                    newPgm1 := theResults at: 1. newPgm2 := theResults at: 2.
                    newPgm1 fitness: nil. newPgm2 fitness: nil.    "Invalidate the fitness"
                    i := i + 1.
                    newPrograms at: i put: newPgm1.
                    i := i + 1.
                    newPrograms at: i put: newPgm2.
                    self computer load: newPgm1.
                    self computer computeProgramStats.
                    self computer load: newPgm2.
                    self computer computeProgramStats.
               ].
        ].

        1 to: newPrograms size do: [ :i |
            (newPrograms at: i) pgmID: i.        "Label the programs"
        ].

        self programs: newPrograms.    "Out with the old, in with the new"!

performGeneticsTS
        "Answer self. Create a new population to replace -programs- based
            on crossover, reproduction, and mutation using fitness proportionate
                selection and aFloat as the total population fitness"

    |  totalFitness selectedProgram1 selectedProgram2
            newPgm1 newPgm2 i pSize newPrograms theResults |

    totalFitness := self currentTotalFitness.
    pSize := self programs size.

    newPrograms := Array new: pSize.

    i := 0.

    [i < pSize]
        whileTrue: [
            ((self randomizer next > 0.9) or: [i = (pSize - 1)])  "Insure pop remains same"
                ifTrue: [                                               "Reproduce"
                    selectedProgram1 := self selectProgramTS: totalFitness.
                    newPgm1 := self programGenerator duplicate: selectedProgram1.
                    i := i + 1.
                    newPrograms at: i put: newPgm1.
                    self computer load: newPgm1.
                    self computer computeProgramStats.
                ]
                ifFalse: [
                    selectedProgram1 := self selectProgramTS: totalFitness.     "Both tournament"
                    selectedProgram2 := self selectProgramTS: totalFitness.
                    theResults := self crossover: selectedProgram1 with: selectedProgram2.
                    newPgm1 := theResults at: 1. newPgm2 := theResults at: 2.
                    newPgm1 fitness: nil. newPgm2 fitness: nil.    "Invalidate the fitness"
                    i := i + 1.
                    newPrograms at: i put: newPgm1.
                    i := i + 1.
                    newPrograms at: i put: newPgm2.
                    self computer load: newPgm1.
                    self computer computeProgramStats.
                    self computer load: newPgm2.
                    self computer computeProgramStats.
               ].
        ].

        1 to: newPrograms size do: [ :i |
            (newPrograms at: i) pgmID: i.        "Label the programs"
        ].

        self programs: newPrograms.    "Out with the old, in with the new"!
  
programGenerator
        "Answer the programGenerator for this GPCustodian "

    ^programGenerator.!

programGenerator: aGPProgramGenerator
        "Set the programGenerator for this GPCustodian to aGPProgramGenerator"

    programGenerator := aGPProgramGenerator.!
  
programs
        "Answer the programs for this GPCustodian "

    ^programs.!

programs: anArray
        "Set the programs for this GPCustodian to anArray"

    programs := anArray.!
  
randomizer
        "Answer the randomizer for this GPCustodian "

    ^randomizer.!
  
randomizer: aRan2
        "Set the randomizer for this GPCustodian to aRan2"

    randomizer := aRan2.!
  
randomSeed
        "Anwer the random seed for this GPCustodian"

    ^randomSeed.!
   
randomSeed: anInt
        "Set the random seed for this GPCustodian to anInt"

    randomSeed := anInt.!
 
selectionType
        "Answer the selectionType for this GPCustodian"

    ^selectionType.!
  
selectionType: aString
        "Set the selectionType for this GPCustodian to aString"

    selectionType := aString.!
   
selectProgram: anInt
        "Select a program from the program pool based on
                random selection."

    | selectorValue  |

        selectorValue := (((self programs size) * (self randomizer next)) truncated) + 1.
         ^self programs at: selectorValue.!
  
selectProgramFP: anInt
        "Select a program from the program pool based on
                fitness proportionality with anInt as the total fitness of
                    the current population"

    | runningTotal totalFitness selectorValue |

    totalFitness := anInt.

    runningTotal := 0.0.

    selectorValue := self randomizer next.

    self programs do: [ :aProgram |
        runningTotal := runningTotal + (aProgram fitness / totalFitness).
        (runningTotal > selectorValue)
            ifTrue: [^aProgram].
    ].!
   
selectProgramTS: anInt
        "Select a program from the program pool based on
                tournament selection."

    | runningTotal totalFitness selectorValue thePgms theMax maxIndex tSize |

    thePgms := OrderedCollection new.

    tSize := self tournamentSize.

    1 to: tSize do: [ :i |
        selectorValue := (((self programs size) * (self randomizer next)) truncated) + 1.
        thePgms add: (self programs at: selectorValue).
    ].

    theMax := 1.0 negated.   maxIndex := 1.
    1 to: tSize do: [ :i |
        (((thePgms at: i) fitness) > theMax)
            ifTrue: [
                maxIndex := i.
                theMax := (thePgms at: i) fitness.
            ].
    ].

    ^thePgms at: maxIndex.!

tournamentSize
        "Answer the tournamentSize for this GPCustodian"

    ^tournamentSize.!
   
tournamentSize: anInt
        "Set the tournamentSize for this GPCustodian to anInt"

    tournamentSize := anInt.! !

Object subclass: #GPFoodPlain
  instanceVariableNames: 
    'gridStatus rngenerator windowPane drawSwitch elementSize gridOffset scaledPix '
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants WBConstants '   !


!GPFoodPlain class methods !
 
new
        "Answer an initialized foodPlain"

    ^super new initialize.! !



!GPFoodPlain methods !
   
clear: aPoint

    "Remove a piece of food at aPoint in aBitmap"

    | thePen  boxSize boxToSet startLocation thePane |

    (self drawSwitch) ifFalse: [^self].

    thePane := self windowPane.

    boxSize := elementSize.
    boxToSet := aPoint.

     thePen := thePane pen.

    "Clear a piece of food"

    thePen direction: 0.

    startLocation :=  self gridOffset + (((boxToSet x - 1) * boxSize x ) @
                                                   ((boxToSet y - 1) * boxSize y)).

    startLocation := startLocation + (1@1). "Avoid the grid"

         thePen fill: (startLocation extent: (boxSize - 1)) color: ClrWhite.

    ^self.!
  
determineScaling
        "Find the element size and gridOffset for this size windowPane"

    | thePane bX bY yOffset xOffset |

   thePane := windowPane.

    bX :=(((thePane extent x) - 1) / 32.0) truncated.
    bY :=(((thePane extent y) - 1) / 32.0) truncated.
    self elementSize: bX@bY.
    xOffset := ((thePane extent x - ((32 * bX) + 1))  asFloat / 2.0 ) truncated.
    yOffset := ((thePane extent y - ((32 *bY) + 1))  asFloat / 2.0 ) truncated.
    self gridOffset: xOffset @ yOffset.!
  
drawFood
        "Draw the food on the grid"

    | thePoint |

   (self drawSwitch) ifFalse: [^self].

    1 to: 32 do: [ :i |
        1 to: 32 do: [ :j |
            thePoint := i@j.
            ((self getGridStatusAt: thePoint) = $F)
                ifTrue: [ self setFoodAt: thePoint].
        ].
    ].!
   
drawGrid
        "Draw the grid for the foodplain"

    | thePen xPos yPos maxX maxY |

    thePen := self windowPane pen.
    thePen foreColor: ClrBlack; backColor: ClrWhite.
    thePen fill: ClrWhite.

    xPos := self gridOffset x.
    maxY := (32 * (elementSize y)) + self gridOffset y.
    thePen up; goto: xPos@ (self gridOffset y).

    1 to: 32 do: [ :i |
        thePen down; goto: xPos @ maxY.
        xPos := xPos + elementSize x.
        thePen up; goto: xPos @ (self gridOffset y).
    ].
    thePen down; goto: xPos @ maxY.

    yPos := self gridOffset y.
    maxX := (32 * (elementSize x)) + self gridOffset x.
    thePen up; goto: (self gridOffset x) @ yPos.

    1 to: 32 do: [ :i |
        thePen down; goto: maxX @ yPos.
        yPos := yPos + elementSize y.
        thePen up; goto: (self gridOffset x) @ yPos.
    ].
    thePen down; goto: maxX @ yPos.!
 
drawSwitch
        "Answer the drawSwitch for this GPFoodPlain"

    ^drawSwitch.!
   
drawSwitch: aBoolean
        "Set the drawSwitch for this GPFoodPlain to aBoolean"

    drawSwitch := aBoolean.!
 
elementSize
        "Answer the elementSize for this GPFoodPlain"

    ^elementSize.!

elementSize: aPoint
        "Set the elementSize for this GPFoodPlain to aPoint"

    elementSize := aPoint.!

foodLocsA
        "Answer anOrderedCollection of food locations"
    | theLocs |
     theLocs := OrderedCollection new.
    theLocs
        add: 2@1;  add: 3@1; add:4@1; add: 4@2; add: 4@3; add: 4@4;
        add: 4@5;  add: 4@6; add: 5@6; add: 6@6; add: 7@6;
        add: 9@6;  add: 10@6; add: 11@6; add: 12@6; add: 13@6;
        add: 13@7; add: 13@8; add: 13@9; add: 13@10;
        add: 13@12; add: 13@13; add: 13@14; add:   13@15;
        add: 13@18; add: 13@19; add: 13@20; add: 13@21; add: 13@22;
        add: 13@23; add: 13@24;
        add: 12@25; add: 11@25; add: 10@25; add: 9@25; add: 8@25;
        add: 5@25; add: 4@25; add: 2@26; add: 2@27; add: 2@28; add: 2@29;
        add: 3@31; add: 4@31; add: 5@31; add: 6@31; add: 8@30; add: 8@29;
        add: 9@28; add: 10@28; add: 11@28; add: 12@28; add: 13@28; add: 14@28;
        add: 15@28; add: 17@27; add: 17@26; add: 17@25; add: 17@22; add: 17@21;
        add: 17@20; add: 17@19; add: 18@16; add: 21@15; add: 21@14;
        add: 21@11; add: 21@10; add: 21@9; add: 21@8; add: 22@6; add: 23@6;
        add: 25@5; add: 25@4; add: 26@3; add: 27@3; add: 28@3; add: 30@4;
        add: 30@5; add: 30@7; add: 30@10; add: 30@13; add: 29@15; add: 28@15;
        add: 27@15; add: 24@16; add: 25@19; add: 28@20; add: 27@23;
        add: 24@24.

    ^theLocs.!
   
foodLocsB
        "Answer anOrderedCollection of food locations"
    | theLocs allLocs  aPos foodSupply |

    theLocs := OrderedCollection new.
    allLocs := self foodLocsA.

    foodSupply := 1 + (self rngenerator getMax: 40).

    1 to: foodSupply do: [ :i |
        aPos := 1 + (self rngenerator getMax: 89).
        theLocs add: (allLocs at: aPos).
    ].

    ^theLocs.!
 
foodLocsC
        "Answer anOrderedCollection of food locations"
    | theLocs allLocs  count |

    theLocs := OrderedCollection new.
    allLocs := self foodLocsA.

    count := 0.
    allLocs do: [ :aLoc |
        ((count \\ 2) = 0) ifTrue: [theLocs add: aLoc].
        count := count + 1.
    ].

    ^theLocs.!

getGridStatusAt: aPoint
        "Get the grid status - an array which represents the
            status of each square of the foodPlain"

    | index |

    index := (aPoint x) + (((aPoint y) - 1) * 32).
    ^self gridStatus at: index.!
 
gridOffset
        "Answer a point which is where the food grid begins
                 in the plane's bitmap"
    ^gridOffset.!
 
gridOffset: aPoint
        "Set the point which is where the food grid begins
                 in the plane's bitmap"
    gridOffset := aPoint.!
 
gridStatus
        "Answer the gridStatus for this GPFoodPlain"

    ^gridStatus.!
   
gridStatus: anArray
        "Set the gridStatus for this GPFoodPlain to anArray"

    gridStatus := anArray.!

initialize
        "Setup the foodPlain"

    | theDict theNewBMap theOldBMap |

    self rngenerator: (Ran2 standardInitialize).

    self reset.
    ^self.!
  
reset
        "Reset the foodplain - gridstatus, and foodLocations"
    | theArray |

    theArray := Array new: 1024.
    1 to: 1024 do: [ :i |
        theArray at: i put: $E.
    ].
    self gridStatus: theArray.

    self foodLocsA do: [ :aLoc |
        self setGridStatusAt: aLoc to: $F.
    ].!
 
resetFamine
        "Reset the foodplain - gridstatus, and foodLocations"
    | theArray |

    theArray := Array new: 1024.
    1 to: 1024 do: [ :i |
        theArray at: i put: $E.
    ].
    self gridStatus: theArray.

    self foodLocsB do: [ :aLoc |
        self setGridStatusAt: aLoc to: $F.
    ].!
   
resetFamine2
        "Reset the foodplain - gridstatus, and foodLocations"
    | theArray |

    theArray := Array new: 1024.
    1 to: 1024 do: [ :i |
        theArray at: i put: $E.
    ].
    self gridStatus: theArray.

    self foodLocsC do: [ :aLoc |
        self setGridStatusAt: aLoc to: $F.
    ].!
  
rngenerator
        "Answer the rngenerator for this GPFoodPlain"

    ^rngenerator.!

rngenerator: aRan2
        "Set the rngenerator for this GPFoodPlain to aRan2"

    rngenerator := aRan2.!
   
scaledPix
        "Answer the CPBitmapPixes scaled by elementSize dictionary
                so instead of 'CPBitmapDict at: 'antE'' methods here will
                use 'self scaledPix at: 'antE''   "
    ^scaledPix.!
 
scaledPix: aDictionary
        "Set the CPBitmapPixes scaled by
                     elementSize dictionary to aDictionary"
    scaledPix := aDictionary.!
   
scaleThePix
        "Scale the pix from the CPBitmap"

    | theDict theNewBMap theOldBMap |

 " First create the unscaled dictionary "

    theDict := Dictionary new.
    theDict  at: 'antfood1' put: (CPBitmapDict at: 'antfood1');
                 at: 'antfood2' put: (CPBitmapDict at: 'antfood2');
                 at: 'antfood3' put: (CPBitmapDict at: 'antfood3');
                 at: 'antfood4' put: (CPBitmapDict at: 'antfood4');
                 at: 'antfood5' put: (CPBitmapDict at: 'antfood5');
                 at: 'antN' put: (CPBitmapDict at: 'antN');
                 at: 'antS' put: (CPBitmapDict at: 'antS');
                 at: 'antE' put: (CPBitmapDict at: 'antE');
                 at: 'antW' put: (CPBitmapDict at: 'antW').

    "Now scale the little devils"

    theDict keys do: [ :aKey |
        theOldBMap :=theDict at: aKey.
        theNewBMap := Bitmap screenWidth: ((elementSize x) - 2)
                                                         height: ((elementSize y) - 2).

        theNewBMap pen fill: theNewBMap boundingBox color: ClrWhite.
                                        "    theOldBMap pen backColor.  "
        theNewBMap pen foreColor: theOldBMap pen foreColor.
        theNewBMap pen backColor: theOldBMap pen backColor.

        theNewBMap pen copyBitmap: theOldBMap
                                 from: theOldBMap boundingBox      " Do the scaling"
                                     to: theNewBMap boundingBox.
        theDict at: aKey put: theNewBMap.
    ].

    self scaledPix: theDict.   "Set the dictionary"!
   
setAntAt: aPoint facing: anInteger

    "Place the Ant at aPoint in aBitmap facing anInteger Degrees .. East = 90"

    | thePen  boxSize boxToSet startLocation thePane theAntPix q |

   (self drawSwitch) ifFalse: [^self].

    thePane := self windowPane.

    boxSize := elementSize.
    boxToSet := aPoint.

    thePen := thePane pen.

    "Place the ant"

    thePen direction: 0.

    startLocation :=  self gridOffset + (((boxToSet x - 1) * boxSize x) @
                                                          ((boxToSet y - 1) * boxSize y)).

   startLocation := startLocation + (1@1). "Avoid the grid"

    (anInteger = 90)   ifTrue: [theAntPix := self scaledPix at: 'antE'].
    (anInteger = 180) ifTrue: [theAntPix := self scaledPix at: 'antS'].
    (anInteger = 270) ifTrue: [theAntPix := self scaledPix at: 'antW'].
    (anInteger = 0)     ifTrue: [theAntPix := self scaledPix at: 'antN'].

    thePane pen copyBitmap: theAntPix
                        from: theAntPix boundingBox
                        at: startLocation.


 "
    thePane pen fill: (startLocation extent: (boxSize - 1)) color:
            (theAntPix) pen backColor.

    thePane pen foreColor: theAntPix pen foreColor.
    thePane pen backColor: theAntPix pen backColor.
    thePane pen copyBitmap: theAntPix
                                 from: ((0@0) extent: theAntPix extent)
                                      to: (startLocation extent: (boxSize - 1)).  "

    thePane pen copyBitmap: theAntPix
                                 from: ((1@1) extent: theAntPix extent)
                                      at: startLocation.

    10000 timesRepeat: [ q := 1.23 ].  "Delay a little"

    ^self.!
  
setFoodAt: aPoint

    "Place the food at aPoint in aBitmap"

    | thePen theFoodPic thePane boxSize boxToSet startLocation selector |

    thePane := self windowPane.
    boxSize := elementSize.
    boxToSet := aPoint.
    thePen := thePane pen.
    thePen direction: 0.

    startLocation :=  self gridOffset + (((boxToSet x - 1) * boxSize x ) @
                                                          ((boxToSet y - 1) * boxSize y)).

    startLocation := startLocation + (1@1). "Avoid the grid"

    selector := (self rngenerator getMax: 5) + 1.

    theFoodPic := self scaledPix at: ('antfood', (selector asString)).

    theFoodPic displayAt: startLocation with: thePane pen.

   ^self.!
 
setGridStatusAt: aPoint to: aCharacter
        "Set the grid status - an array which represents the
            status of each square of the foodPlain"

    | index |

    index := (aPoint x) + (((aPoint y) - 1) * 32).
    self gridStatus at: index put: aCharacter.!
   
windowPane
        "Answer the GraphPane for this GPFoodPlain"

    ^windowPane.!

windowPane: aGraphPane
        "Set the GraphPane for this GPFoodPlain"

    windowPane := aGraphPane.
    self determineScaling.
    self scaleThePix.! !

Object subclass: #GPFunction
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''  !


!GPFunction class methods ! !



!GPFunction methods ! !

Object subclass: #GPProgramViewer
  instanceVariableNames: 
    'outline computer indentLevel '
  classVariableNames: ''
  poolDictionaries: ''  !


!GPProgramViewer class methods !
 
new
        "Answer a new initialized GPProgramViewer"

    ^super new initialize.! !



!GPProgramViewer methods !
  
addToOutline: aGPNode
        "comment"

    | theWS blanks |

    theWS := WriteStream on: (String new: 50).
    blanks := '    '.

    1 to: self indentLevel do: [ :i |
        theWS nextPutAll: blanks.
    ].

"    theWS nextPut: aGPNode type.
    aGPNode value printOn: theWS.   "

    (aGPNode type = $F)
        ifTrue: [
            theWS nextPutAll: ((self computer functions at:(aGPNode value)) asString).
        ]
        ifFalse: [
            theWS nextPutAll: ((self computer terminals at:(aGPNode value)) asString).
        ].

    self outline add: theWS contents.

    ^self.!
  
addToOutlineTandF: aGPNode
        "This function creates an outline of the form F1, T9 etc."

    | theWS blanks |

    theWS := WriteStream on: (String new: 50).
    blanks := '    '.

    1 to: self indentLevel do: [ :i |
        theWS nextPutAll: blanks.
    ].

    theWS nextPut: aGPNode type.
    aGPNode value printOn: theWS.

    self outline add: theWS contents.

    ^self.!
  
computer
        "Answer the computer for this GPProgramViewer"

    ^computer.!
 
computer: aGPComputer
        "Set the computer for this GPProgramViewer to aGPComputer"

    computer := aGPComputer.!
  
generateFOutlineEntry: aGPNode
        "Answer a GPNode. Add the the outline instance variable"

    | currentNode funcID theArity |

    funcID := aGPNode value.

    self addToOutline: aGPNode.
    currentNode := aGPNode child.                    "Handle the function itself"
    self indentLevel: (self indentLevel + 1).

    self generateOutline: currentNode.

    theArity := self computer functionAritys at: funcID.
    1 to: (theArity - 1) do: [ :i |
        currentNode := currentNode sibling.
        self generateOutline: currentNode.                    "Handle it's children and siblings"
    ].
    self indentLevel: (self indentLevel - 1).

    ^aGPNode.!

generateOutline: aGPNode
        "Recursively evaluate the tree and produce an outline in
                the instance variable outline"

    | funcID theArity currentNode nextNode |

    (aGPNode isNil)

        ifFalse: [
            currentNode := aGPNode.
            (currentNode type = $T)
                ifTrue: [
                    self generateTOutlineEntry: currentNode.
               ]
                ifFalse: [
                        self generateFOutlineEntry: currentNode.
                ].

        ]
        ifTrue: [ self error: 'Attempt fo evaluate nil node'].!

generateTOutlineEntry: aGPNode
        "Answer a GPNode. Add the the outline instance variable"

    self addToOutline: aGPNode.

    ^aGPNode.!
   
indentLevel
        "Answer the indentLevel for this GPProgramViewer"

    ^indentLevel.!

indentLevel: anInt
        "Set the indentLevel for this GPProgramViewer to anInt"

    indentLevel := anInt.!
   
initialize
        "Initialize the GPProgramViewer"

    indentLevel := 1.!
  
inspectSubtree: aGPNode
        "Answer a collection of lines structured
            as an outline representing function or terminal
                values as a subtree with aGPNode as the root."

    |  theOC theLine |

    self outline: OrderedCollection new.

    self generateOutline: aGPNode.

    ^self outline.!
   
outline
        "Answer the outline for this GPProgramViewer"

    ^outline.!

outline: anOrderedCollection
        "Set the outline for this GPProgramViewer to anOrderedCollection"

    outline := anOrderedCollection.!
 
reset
        "Reset this GPProgramViewer"

    self initialize.! !

GPCustodian subclass: #GPDispenserCustodian
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants WBConstants '   !


!GPDispenserCustodian class methods ! !



!GPDispenserCustodian methods ! !

GPComputer subclass: #GPArtificialAntComputer
  instanceVariableNames: 
    'ant foodPlain '
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants WBConstants '    !


!GPArtificialAntComputer class methods ! !



!GPArtificialAntComputer methods !
 
ant
        "Answer the GPAnt associated with this GPArtificialAntComputer"

    ^ant.!
  
ant: aGPAnt
        "Set the GPAnt associated with this GPArtificialAntComputer to aGPAnt"

    ant := aGPAnt.!
  
faceLeft
        "Tell the ant to face left"

    self ant faceLeft.
    self executionCount: (self executionCount + 1).!
   
faceRight
        "Tell the ant to face right"

    self ant faceRight.
    self executionCount: (self executionCount + 1).!

foodPlain
        "Anser the GPFoodPlain for this problem "

    ^foodPlain.!

foodPlain: aGPFoodPlain
        "Set the GPFoodPlain for this problem to aGPFoodPlain"

    foodPlain := aGPFoodPlain.!
  
ifFoodAhead
        "Ask the ant if food is ahead and return
            the appropriate node"

    | theNode |

    theNode := self  currentNode.

        (self ant ifFoodAhead)
            ifTrue: [ self  evaluate: theNode child ]
            ifFalse: [ self  evaluate: theNode child sibling].!
  
initialize
        "Initialize the Problem"

    | theFoodPlain |

    self ant: GPAnt new.
    self program: GPProgram new.

    self programViewer: GPProgramViewer new.   "Let the programViewer and"
    self programViewer computer: self.                  "computer be aware of each other"

    theFoodPlain := GPFoodPlain new.             "Let both the computer and"
    self foodPlain: theFoodPlain.                      " the ant be aware of the foodPlain"
    self ant  foodPlain: theFoodPlain.

    self iLength: 0.

    Terminals := Array new: 3.
    Functions := Array new: 3.
    FunctionAritys := Array new: 3.

    Terminals at: 1 put: #faceLeft.
    Terminals at: 2 put: #faceRight.
    Terminals at: 3 put: #move.

    Functions at: 1 put: #ifFoodAhead.
    Functions at: 2 put: #progN2.
    Functions at: 3 put: #progN3.

    FunctionAritys at: 1 put: 2.
    FunctionAritys at: 2 put: 2.
    FunctionAritys at: 3 put: 3.

   ^self.!
 
move
        "Tell the ant to move forward"

    self ant move.
    self executionCount: (self executionCount + 1).!

progN2
        "Two node connector"

    | theNode |

    theNode := self  currentNode.

    self  evaluate: theNode child.
    self  evaluate: theNode child sibling.!
 
progN3
        "Two node connector"

    | theNode |

    theNode := self  currentNode.

    self  evaluate: theNode child.
    self  evaluate: theNode child sibling.
    self  evaluate: theNode child sibling sibling.! !

GPCustodian subclass: #GPArtificialAntCustodian
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants WBConstants '    !


!GPArtificialAntCustodian class methods ! !



!GPArtificialAntCustodian methods !
   
evaluateFamineFitness
        "Analyze the fitness of each member of -programs- and
                answer the total fitness of the population"

    | totalFitness count r adjFitness |

    count := 0.

    programs do: [ :aProgram |
        count := count + 1.
        self overlord updateFitnessProgress: count.
        self evaluateIndividualFamineFitness: aProgram.
    ].!
   
evaluateIndividualFamineFitness: aGPProgram
        "Analyze the fitness of aGPProgram"

    | r adjFitness |

    self  computer load: aGPProgram.
    self  computer foodPlain clear:
            (self  computer ant position).        "Clear any leftover ants"
    self  computer ant initialize.
    self  computer foodPlain resetFamine2.
    self  computer foodPlain drawFood.

    [self  computer executionLimitExceeded]
        whileFalse: [
            self  computer execute.
        ].
    r := 89 - self computer ant foodEaten.
    adjFitness := (1.0 / (1.0 + r)).
    aGPProgram fitness: adjFitness.
    aGPProgram rawFitness: self computer ant foodEaten.

    ^self.!

evaluateIndividualFitness: aGPProgram
        "Analyze the fitness of aGPProgram"

    | r adjFitness |

    self  computer load: aGPProgram.
    self  computer foodPlain clear:
            (self  computer ant position).        "Clear any leftover ants"
    self  computer ant initialize.
    self  computer foodPlain reset.
    self  computer foodPlain drawFood.

    [self  computer executionLimitExceeded]
        whileFalse: [
            self  computer execute.
        ].
    r := 89 - self computer ant foodEaten.
    adjFitness := (1.0 / (1.0 + r)).
    aGPProgram fitness: adjFitness.
    aGPProgram rawFitness: self computer ant foodEaten.

    ^self.!
 
initialize

        "Perform the initialization"

    super initialize.  "Let the superclass do most of the initialization"

    computer := GPArtificialAntComputer new.
    self programGenerator computer: computer.                  " Tell the PgmGen abt the computer"
    computer executionLimit: 550.

    ^self.! !

GPOverlord subclass: #GPAntOverlord
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants WBConstants '  !


!GPAntOverlord class methods !
   
wbCreated

    ^true! !



!GPAntOverlord methods !
   
aboutButtonClicked: aPane

    "Callback for the #clicked event in an unnamed CPBitmapButton (contents is '').
     (Generated by WindowBuilder)"

    | theDialog |

    theDialog := GPAbout new.
    theDialog open.
    ^self.!

close: aPane
        "Private - Close the receiver."
    | answer |
       self custodian logStream close.

    Smalltalk isRunTime
        ifTrue: [
            (MessageBox confirm: 'Are you sure you want to exit?')
                ifTrue: [self close. ^Smalltalk exit] ifFalse: [^self]]
        ifFalse: [^self close].!
  
createViews

     "WARNING!!  This method was automatically generated by
      WindowBuilder.  Code you add here which does not conform
      to the WindowBuilder API will probably be lost the next time
      you save your layout definition."

     | v |

    self addView: (
        v := self topPaneClass new
            owner: self;
            labelWithoutPrefix:  'GP Artificial Ant - V1.0';
            noSmalltalkMenuBar;
            iconFile: '\STVWBPB2\ST.ICO';
            viewName: 'mainView';
            framingBlock: ( FramingParameters new iDUE: 1801 @ 1136; xC; yC; cRDU: (5 @ 1132 rightBottom: 1797 @ 42));
            pStyle: #(sysmenu maximize titlebar sizable minimize);
            when: #close perform: #close:;
            backColor: ClrPalegray;
            addSubpane: (
                CP3DFrame new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 654 @ 250; lDU: 171 r: #left; tDU: 32 r: #top);
                    out;
                    startGroup;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                CP3DFrame new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 512 @ 64; lDU: 57 r: #left; tDU: 590 r: #top);
                    out;
                    startGroup;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 107 @ 32; lDU: 469 r: #left; rDU: 576 r: #left; tDU: 218 r: #top; bDU: 250 r: #top);
                    paneName: 'currentCount';
                    centered;
                    contents: '0';
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 213 @ 32; lDU: 192 r: #left; rDU: 405 r: #left; tDU: 148 r: #top; bDU: 180 r: #top);
                    rightJustified;
                    contents: 'Completion';
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 194 @ 32; lDU: 235 r: #left; rDU: 430 r: #left; tDU: 218 r: #top; bDU: 250 r: #top);
                    rightJustified;
                    contents: 'Active Pgm';
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 377 @ 32; lDU: 185 r: #left; rDU: 562 r: #left; tDU: 78 r: #top; bDU: 110 r: #top);
                    rightJustified;
                    contents: 'Generations to Evolve:';
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 590 @ 32; lDU: 1102 r: #left; rDU: 1691 r: #left; tDU: 26 r: #top; bDU: 58 r: #top);
                    centered;
                    contents: 'CAUTION:   Ant Feeding Area';
                    foreColor: ClrRed;
                    backColor: ClrYellow;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 352 @ 32; lDU: 82 r: #left; rDU: 434 r: #left; tDU: 600 r: #top; bDU: 632 r: #top);
                    rightJustified;
                    startGroup;
                    contents: 'Selected Program Display';
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                CPBitmapPane new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 43 @ 46; lDU: 448 r: #left; tDU: 594 r: #top);
                    contents: (CPBitmapDict at: 'downArrow');
                    startGroup;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                GraphPane new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 775 @ 704; lDU: 997 r: #left; rDU: 1771 r: #left; tDU: 78 r: #top; bDU: 782 r: #top);
                    paneName: 'antBitmap';
                    noScrollBars;
                    startGroup;
                    when: #display perform: #drawAntBitmap:;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                CPColumnarListBox new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 896 @ 276; lDU: 43 r: #left; tDU: 302 r: #top);
                    paneName: 'mainList';
                    headerColor: (ColorConstants at: 'ClrDarkcyan');
                    fields: (
                        OrderedCollection new
                        addLast: (
                            CPCLBField new
                                header: 'PgmID';
                                justification: #center;
                                selector: #pgmID
                        );
                        addLast: (
                            CPCLBField new
                                header: 'RawFitn';
                                justification: #center;
                                selector: #rawFitness
                        );
                        addLast: (
                            CPCLBField new
                                header: 'Nodes';
                                justification: #center;
                                selector: #length
                        );
                        addLast: (
                            CPCLBField new
                                header: 'Depth';
                                justification: #center;
                                selector: #depth
                        );
                        addLast: (
                            CPCLBField new
                                header: 'Fitness';
                                justification: #center;
                                selector: #fitness
                        );
                        yourself
                    );
                    startGroup;
                    when: #select perform: #inspectPgm:;
                    when: #doubleClickSelect perform: #runPgm:;
                    setPopupMenu: (
                        Menu new
                            title: '';
                            owner: self;
                            appendItem: 'executePgm' selector: #executePgm acceleratorString: '';
                            appendSeparator;
                            appendItem: 'fileInPgm' selector: #fileInPgm acceleratorString: '';
                            appendItem: 'fileOutPgm' selector: #fileOutPgm acceleratorString: ''
                    );
                    foreColor: ClrWhite;
                    backColor: ClrDarkcyan;
                    yourself
            );
            addSubpane: (
                ListBox new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 896 @ 384; lDU: 43 r: #left; rDU: 939 r: #left; tDU: 672 r: #top; bDU: 1056 r: #top);
                    paneName: 'programListBox';
                    startGroup;
                    foreColor: ClrWhite;
                    backColor: ClrDarkcyan;
                    yourself
            );
            addSubpane: (
                CPBitmapButton new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 155 @ 56; lDU: 640 r: #left; rDU: 795 r: #left; tDU: 200 r: #top; bDU: 256 r: #top);
                    startGroup;
                    when: #clicked perform: #evolveBP:;
                    contents: 'Evolve';
                    foreColor: ClrWhite;
                    backColor: ClrDarkcyan;
                    yourself
            );
            addSubpane: (
                CPNumericEditor new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 123 @ 46; lDU: 583 r: #left; tDU: 70 r: #top);
                    paneName: 'evolveCount';
                    min: 1;
                    contents: 1;
                    startGroup;
                    foreColor: ClrWhite;
                    backColor: ClrDarkcyan;
                    yourself
            );
            addSubpane: (
                CPCircularGauge new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 73 @ 62; lDU: 455 r: #left; tDU: 128 r: #top);
                    paneName: 'genDisplay';
                    min: 0;
                    contents: 0;
                    showPercentage: false;
                    startGroup;
                    foreColor: ClrBlue;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                CPBitmapPane new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 775 @ 256; lDU: 997 r: #left; tDU: 794 r: #top);
                    paneName: 'graphBitmap';
                    contents: (CPBitmapDict at: 'checkBox');
                    startGroup;
                    when: #getContents perform: #graphGetContents:;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                Button new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 151 @ 58; lDU: 789 r: #left; rDU: 939 r: #left; tDU: 596 r: #top; bDU: 654 r: #top);
                    startGroup;
                    when: #clicked perform: #aboutButtonClicked:;
                    contents: 'About';
                    backColor: ClrPalegray;
                    yourself
            );
        yourself
    ).!

drawAntBitmap: aPane

    "Callback for the #getContents event in the CPBitmapPane named 'antBitmap'.
     (Generated by WindowBuilder)"

    self setAntGrid.
    self custodian computer foodPlain drawFood.!
   
evolveBP: aPane

    "Callback for the #clicked event in an unnamed Button (contents is 'Evolve').
     (Generated by WindowBuilder)"

    | loopCount theDC thePgms theSortedPgms |

    CursorManager execute change.

     self graphicsOff.
    loopCount := (self paneNamed: 'evolveCount') value.
    (self paneNamed: 'genDisplay') max: loopCount.
    theDC := OrderedCollection new.

    1 to: loopCount do: [ :evolutionNo |

        self custodian performGenetics.
        self custodian evaluateFitness.

    "    ((evolutionNo \\ 5) ~= 0)
            ifTrue: [ self custodian evaluateFitness ]
            ifFalse: [ self custodian evaluateFamineFitness ].   "

        thePgms := self custodian programs.
        theSortedPgms := thePgms asSortedCollection: self programSortBlock.
        (self paneNamed: 'mainList') contents: theSortedPgms.
        (self paneNamed: 'mainList') restoreSelected: theSortedPgms first.

        self displayProgram: theSortedPgms first.
        self custodian maxFitnessCollection add: theSortedPgms first rawFitness.
        self showFitnessGraph.

        (self paneNamed: 'genDisplay') contents: evolutionNo.
        self writeLogEntry.
    ].
        self graphicsOn.
        CursorManager normal change.!
   
graphicsOff
        "Hide the ant from view to speed up evolution "

    self custodian computer foodPlain drawSwitch: false.

    ^self.!
 
graphicsOn
        "Show the world how the ant works"

    self custodian computer foodPlain drawSwitch: true.

    ^self.!

initializeOverlord
   | theDialog |

    super initializeOverlord.    "First do the standard things"

    self custodian computer foodPlain reset.
    self custodian computer foodPlain setAntAt:
                 self custodian computer ant position
           facing: self custodian computer ant direction.

    self genDialog open.
    self generateBP: self custodian computer foodPlain windowPane.
    self genDialog closeWindow.

    self custodian computer foodPlain reset.!

initWindow
        "Initialization stuff. Setup the contents of the feeding plain"

    | theBitmap theFoodPlain theFarm |

    theFoodPlain := self custodian computer foodPlain.
    theFoodPlain windowPane: (self paneNamed: 'antBitmap').

    self initializeOverlord.!
   
preInitWindow

        "Perform the initialization"

    custodian := GPArtificialAntCustodian new.      "Let the custodian and "
    custodian overlord: self.                                         "overlord be aware of each other"
    self custodian computer foodPlain drawSwitch: false.
    ^self.!
   
runPgm: aPane

    "Callback for the #doubleClickSelect event in the CPColumnarListBox named 'mainList'.
     (Generated by WindowBuilder)"

    | thePID |

    CursorManager execute change.

    thePID := (self paneNamed: 'mainList') selectedItem pgmID.

    self custodian computer load: (self custodian programs at: thePID).

    self custodian computer foodPlain clear:
        (self custodian computer ant position).        "Clear any leftover ants"

    self custodian computer ant initialize.
    self custodian computer foodPlain reset.
    self custodian computer foodPlain drawFood.

    [self custodian computer executionLimitExceeded]
        whileFalse: [
        self custodian computer execute.
    ].

   self custodian computer foodPlain clear:
        (self custodian computer ant position).        "Clear any leftover ants"

    CursorManager normal change.!
   
setAntGrid

    self custodian computer foodPlain drawGrid.! !

Object subclass: #GPTerminal
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: '' !


!GPTerminal class methods ! !



!GPTerminal methods ! !

GPOverlord subclass: #GPDispenserOverlord
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants WBConstants '    !


!GPDispenserOverlord class methods !
 
wbCreated

    ^true! !



!GPDispenserOverlord methods !
 
drawAntBitmap: aPane

    "Callback for the #activate event in the TopPane 'mainView'.
     (Generated by WindowBuilder)"!
   
open


     "WARNING!!  This method was automatically generated by
      WindowBuilder.  Code you add here which does not conform
      to the WindowBuilder API will probably be lost the next time
      you save your layout definition."

     | v |

    self addView: (
        v := self topPaneClass new
            owner: self;
            labelWithoutPrefix:  'GP Dispenser Overlord';
            noSmalltalkMenuBar;
            viewName: 'mainView';
            framingBlock: ( FramingParameters new iDUE: 1586 @ 1133; xC; yC; cRDU: (7 @ 1126 rightBottom: 1579 @ 50));
            pStyle: #(sysmenu maximize titlebar sizable minimize);
            when: #activate perform: #drawAntBitmap:;
            addSubpane: (
                CPColumnarListBox new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 773 @ 264; lDU: 782 r: #left; tDU: 800 r: #top);
                    paneName: 'mainList';
                    headerColor: (ColorConstants at: 'ClrBackground');
                    fields: (
                        OrderedCollection new
                        addLast: (
                            CPCLBField new
                                header: 'PgmID';
                                justification: #center;
                                selector: #pgmID
                        );
                        addLast: (
                            CPCLBField new
                                header: 'RawFitn';
                                justification: #center;
                                selector: #rawFitness
                        );
                        addLast: (
                            CPCLBField new
                                header: 'Nodes';
                                justification: #center;
                                selector: #length
                        );
                        addLast: (
                            CPCLBField new
                                header: 'Depth';
                                justification: #center;
                                selector: #depth
                        );
                        addLast: (
                            CPCLBField new
                                header: 'Fitness';
                                justification: #center;
                                selector: #fitness
                        );
                        yourself
                    );
                    startGroup;
                    when: #select perform: #inspectPgm:;
                    when: #doubleClickSelect perform: #runPgm:;
                    setPopupMenu: (
                        Menu new
                            title: '';
                            owner: self;
                            appendItem: 'executePgm' selector: #executePgm acceleratorString: '';
                            appendSeparator;
                            appendItem: 'fileInPgm' selector: #fileInPgm acceleratorString: '';
                            appendItem: 'fileOutPgm' selector: #fileOutPgm acceleratorString: ''
                    );
                    font: (
                        Font new
                        fromBytes: #( 243 255 0 0 0 0 0 0 188 2 255 0 0 0 3 2 1 34 65 114 105 97 108 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 )
                    );
                    foreColor: ClrCyan;
                    yourself
            );
            addSubpane: (
                CPBitmapPane new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 44 @ 40; lDU: 1404 r: #left; tDU: 24 r: #top);
                    contents: (CPBitmapDict at: 'downArrow');
                    startGroup;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                CPBitmapPane new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 791 @ 704; lDU: 773 r: #left; tDU: 72 r: #top);
                    paneName: 'antBitmap';
                    contents: (CPBitmapDict at: 'crayons');
                    startGroup;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                Button new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 498 @ 48; lDU: 36 r: #left; rDU: 533 r: #left; tDU: 16 r: #top; bDU: 64 r: #top);
                    startGroup;
                    when: #clicked perform: #generateBP:;
                    contents: 'Generate Initial Population';
                    foreColor: ClrBlack;
                    yourself
            );
            addSubpane: (
                ListBox new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 640 @ 280; lDU: 62 r: #left; rDU: 702 r: #left; tDU: 288 r: #top; bDU: 568 r: #top);
                    paneName: 'programListBox';
                    startGroup;
                    font: (
                        Font new
                        fromBytes: #( 243 255 0 0 0 0 0 0 188 2 255 0 0 0 3 2 1 34 65 114 105 97 108 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 )
                    );
                    foreColor: ClrCyan;
                    yourself
            );
            addSubpane: (
                Button new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 169 @ 48; lDU: 124 r: #left; rDU: 293 r: #left; tDU: 104 r: #top; bDU: 152 r: #top);
                    startGroup;
                    when: #clicked perform: #evolveBP:;
                    contents: 'Evolve';
                    foreColor: ClrBlack;
                    yourself
            );
            addSubpane: (
                CPNumericEditor new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 124 @ 45; lDU: 311 r: #left; tDU: 104 r: #top);
                    paneName: 'evolveCount';
                    min: 1;
                    contents: 1;
                    startGroup;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                CPHorizontalBarGauge new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 267 @ 40; lDU: 133 r: #left; tDU: 168 r: #top);
                    paneName: 'genDisplay';
                    min: 0;
                    contents: 0;
                    startGroup;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                CPBitmapPane new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 640 @ 360; lDU: 62 r: #left; tDU: 592 r: #top);
                    paneName: 'graphBitmap';
                    contents: (CPBitmapDict at: 'checkBox');
                    startGroup;
                    when: #getContents perform: #graphGetContents:;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                CPValueSet new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 578 @ 48; lDU: 89 r: #left; tDU: 1000 r: #top);
                    paneName: 'graphFunction';
                    rows: 1 columns: 3;
                    textItem: 'Max Fitness' row: 1 column: 1;
                    textItem: 'Avg Fitness' row: 1 column: 2;
                    textItem: 'Avg Nodes' row: 1 column: 3;
                    startGroup;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 267 @ 40; lDU: 1102 r: #left; rDU: 1369 r: #left; tDU: 16 r: #top; bDU: 56 r: #top);
                    contents: 'Dispenser Area:';
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 107 @ 32; lDU: 373 r: #left; rDU: 480 r: #left; tDU: 232 r: #top; bDU: 264 r: #top);
                    paneName: 'currentCount';
                    rightJustified;
                    contents: '0';
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 151 @ 32; lDU: 453 r: #left; rDU: 604 r: #left; tDU: 176 r: #top; bDU: 208 r: #top);
                    contents: 'Complete
';
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 196 @ 32; lDU: 204 r: #left; rDU: 400 r: #left; tDU: 232 r: #top; bDU: 264 r: #top);
                    contents: 'Active Pgm';
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 187 @ 32; lDU: 453 r: #left; rDU: 640 r: #left; tDU: 112 r: #top; bDU: 144 r: #top);
                    contents: 'Generations';
                    yourself
            );
        yourself
    ).

    self openWindow!
 
runPgm: aPane

    "Callback for the #doubleClickSelect event in the CPColumnarListBox named 'mainList'.
     (Generated by WindowBuilder)"! !

Object subclass: #ArtificialAnt
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: '' !


!ArtificialAnt class methods ! !



!ArtificialAnt methods ! !

Object subclass: #GPRegion
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''  !


!GPRegion class methods ! !



!GPRegion methods ! !

GPFoodPlain subclass: #GPInvisibleFoodPlain
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''   !


!GPInvisibleFoodPlain class methods ! !



!GPInvisibleFoodPlain methods !
   
clear: aPoint!
  
drawFood!
   
drawGrid!
   
setAntAt: aPoint! !

Object subclass: #GPFlexure
  instanceVariableNames: 
    'workValue dataCollection parm1 parm2 parm3 parm4 parm5 parm6 '
  classVariableNames: ''
  poolDictionaries: ''    !


!GPFlexure class methods !
   
new
        "comment"
    ^super new initialize.! !



!GPFlexure methods !
   
dataCollection
        "Answer the dataCollection for this GPFlexure as anArray. This contains the
                input parameters and one result parameter.. 1.0=> Pass, -1.0-> Fail"
    ^dataCollection.!

dataCollection: anArray
        "Set the dataCollection for this GPFlexure to anArray. This contains the
                input parameters and one result parameter.. 1.0=> Pass, -1.0-> Fail"
    dataCollection := anArray.!

initialize
        "comment"

    | theCollection theFile theLine theArray |

    self reset.

    theCollection := OrderedCollection new.

    theFile := File pathName: 'flex.txt'.
    theFile nextLine asArrayOfSubstrings. "Skip the first line of titles"

    [theFile atEnd]
        whileFalse: [
            theLine := theFile nextLine asArrayOfSubstrings.
            theArray := Array new: (theLine size - 1).
            2 to: theLine size do: [ :index  |
                theArray at: (index - 1)  put: ((theLine at: index) asFloat).
            ].
            theCollection add: theArray.
    ].

    self dataCollection: theCollection.!
  
parm1
        "Answer a parameter for this GPFlexure"

    ^parm1.!
  
parm1: aFloat
        "Set a parameter for this GPFlexure to aFloat"

    parm1 := aFloat.!
  
parm2
        "Answer a parameter for this GPFlexure"

    ^parm2.!
  
parm2: aFloat
        "Set a parameter for this GPFlexure to aFloat"

    parm2 := aFloat.!
  
parm3
        "Answer a parameter for this GPFlexure"

    ^parm3.!
  
parm3: aFloat
        "Set a parameter for this GPFlexure to aFloat"

    parm3 := aFloat.!
  
parm4
        "Answer a parameter for this GPFlexure"

    ^parm4.!
  
parm4: aFloat
        "Set a parameter for this GPFlexure to aFloat"

    parm4 := aFloat.!
  
parm5
        "Answer a parameter for this GPFlexure"

    ^parm5.!
  
parm5: aFloat
        "Set a parameter for this GPFlexure to aFloat"

    parm5 := aFloat.!
  
parm6
        "Answer a parameter for this GPFlexure"

    ^parm6.!
  
parm6: aFloat
        "Set a parameter for this GPFlexure to aFloat"

    parm6 := aFloat.!
  
reset
        "Zero out the flexure"

    self workValue: 0.0.!
  
workValue
        "Answer the workValue for this GPFlexure as aFloat. This contains the
                current value of the symbolic regression"
    ^workValue.!
   
workValue: aFloat
        "Set the workValue for this GPFlexure to aFloat. This contains the
                current value of the symbolic regression"
    workValue := aFloat.! !

GPComputer subclass: #GPFlexureComputer
  instanceVariableNames: 
    'flexure '
  classVariableNames: ''
  poolDictionaries: ''   !


!GPFlexureComputer class methods ! !



!GPFlexureComputer methods !
 
const1
        "Answer a constant"
    self flexure workValue: 1.0.!
  
const2
        "Answer a constant"
    self flexure workValue: 2.0.!
  
const3
        "Answer a constant"
    self flexure workValue: 3.0.!
  
const4
        "Answer a constant"
    self flexure workValue: 10.0.!
 
const5
        "Answer a constant"
    self flexure workValue: 100.0.!

divide
        "Divide two nodes .. child / sibling"

    | theNode a b |

    theNode := self  currentNode.

    self  evaluate: theNode child.
    a := self flexure workValue.

    self  evaluate: theNode child sibling.
    b := self flexure workValue.

   ( (b abs < 1.0e-10) or: [a abs > 1.0e10])
        ifTrue: [self flexure workValue: 0.]
        ifFalse: [self flexure workValue: (a / b)].!
   
exp
        "Take exponential of the child ... ie 2.71828.."

    | theNode a b |

    theNode := self  currentNode.

    self  evaluate: theNode child.
    a := self flexure workValue.
    (a   > 20)
        ifTrue: [self flexure workValue: 1.0e10]
        ifFalse: [
            (a < 20 negated)
                ifTrue: [self flexure workValue: 1e-10]
                ifFalse: [self flexure workValue: (a exp)].
        ].!

flexure
        "Answer the flexure associated with this GPFlexureComputer"
    ^flexure.!

flexure: aGPFlexure
        "Set the flexure associated with this GPFlexureComputer to aGPFlexure"
    flexure := aGPFlexure.!

ifAltB
        "If A less than B then perform C else D"

    | theNode a b |

    theNode := self  currentNode.

    self evaluate: theNode child.
    a := self flexure workValue.
    self evaluate: theNode child sibling.
    b := self flexure workValue.
    (a < b)
        ifTrue: [ self evaluate: theNode child sibling sibling]
        ifFalse: [ self evaluate: theNode child sibling sibling sibling].!
  
initialize
        "Initialize the Problem"

    | theFoodPlain |

    self flexure: GPFlexure new.
    self program: GPProgram new.

    self programViewer: GPProgramViewer new.   "Let the programViewer and"
    self programViewer computer: self.                  "computer be aware of each other"

    self iLength: 0.

    Terminals := Array new: 11.
    Functions := Array new: 7.
    FunctionAritys := Array new: 7.

    Terminals at: 1 put: #const1.
    Terminals at: 2 put: #const2.
    Terminals at: 3 put: #const3.
    Terminals at: 4 put: #const4.
    Terminals at: 5 put: #const5.
    Terminals at: 6 put: #parm1.
    Terminals at: 7 put: #parm2.
    Terminals at: 8 put: #parm3.
    Terminals at: 9 put: #parm4.
    Terminals at: 10 put: #parm5.
    Terminals at: 11 put: #parm6.

    Functions at: 1 put: #plus.
    Functions at: 2 put: #minus.
    Functions at: 3 put: #times.
    Functions at: 4 put: #divide.
    Functions at: 5 put: #exp.
    Functions at: 6 put: #sqrt.
    Functions at: 7 put: #ln.

    FunctionAritys at: 1 put: 2.
    FunctionAritys at: 2 put: 2.
    FunctionAritys at: 3 put: 2.
    FunctionAritys at: 4 put: 2.
    FunctionAritys at: 5 put: 1.
    FunctionAritys at: 6 put: 1.
    FunctionAritys at: 7 put: 1.

   ^self.!
  
ln
        "Take exponential of the child ... ie 2.71828.."

    | theNode a b |

    theNode := self  currentNode.

    self  evaluate: theNode child.
    a := self flexure workValue.
    (a   < 1e-10)
        ifTrue: [self flexure workValue: 10 negated]
        ifFalse: [ self flexure workValue: (a ln)].!
 
minus
        "Subtract two nodes"

    | theNode a b |

    theNode := self  currentNode.

    self  evaluate: theNode child.
    a := self flexure workValue.

    self  evaluate: theNode child sibling.
    b := self flexure workValue.

    self flexure workValue: (a - b).!

parm1
        "Answer the parm"
    self flexure workValue: self flexure parm1.!
  
parm2
        "Answer the parm"
    self flexure workValue: self flexure parm2.!
  
parm3
        "Answer the parm"
    self flexure workValue: self flexure parm3.!
  
parm4
        "Answer the parm"
    self flexure workValue: self flexure parm4.!
  
parm5
        "Answer the parm"
    self flexure workValue: self flexure parm5.!
  
parm6
        "Answer the parm"
    self flexure workValue: self flexure parm6.!
  
plus
        "Add two nodes"

    | theNode a b |

    theNode := self  currentNode.

    self  evaluate: theNode child.
    a := self flexure workValue.

    self  evaluate: theNode child sibling.
    b := self flexure workValue.

    self flexure workValue: (a + b).!
  
progN2
        "Two node connector"

    | theNode |

    theNode := self  currentNode.

    self  evaluate: theNode child.
    self  evaluate: theNode child sibling.!
 
progN3
        "Two node connector"

    | theNode |

    theNode := self  currentNode.

    self  evaluate: theNode child.
    self  evaluate: theNode child sibling.
    self  evaluate: theNode child sibling sibling.!
 
sqrt
        "Take sqrt of the absolute value of the child ."

    | theNode a  |

    theNode := self  currentNode.

    self  evaluate: theNode child.
    a := self flexure workValue.
    self flexure workValue: ( a abs sqrt).!
  
times
        "Multiply two nodes"

    | theNode a b |

    theNode := self  currentNode.

    self  evaluate: theNode child.
    a := self flexure workValue.

    self  evaluate: theNode child sibling.
    b := self flexure workValue.

    self flexure workValue: (a * b).! !

GPCustodian subclass: #GPFlexureCustodian
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''  !


!GPFlexureCustodian class methods ! !



!GPFlexureCustodian methods !
   
evaluateIndividualFitness: aGPProgram
        "Analyze the fitness of aGPProgram"

    | r adjFitness theCollection points ppHits pfHits fpHits ffHits theHits |

    self  computer load: aGPProgram.
    theCollection := self computer flexure dataCollection.

    points := 0.
    ppHits := 0. pfHits := 0. fpHits := 0. ffHits := 0.

    theCollection do: [ :aFlexElement |
        self  computer flexure reset.
        self computer flexure parm1: (aFlexElement at: 1).
        self computer flexure parm2: (aFlexElement at: 2).
        self computer flexure parm3: (aFlexElement at: 3).
        self computer flexure parm4: (aFlexElement at: 4).
        self computer flexure parm5: (aFlexElement at: 5).
        self computer flexure parm6: (aFlexElement at: 6).
        self  computer execute.
        r :=  self computer flexure workValue.
        (r > 0)
            ifTrue: [                                               "Pass is predicted"
                ((aFlexElement at: 7) > 0)
                    ifTrue: [
                        points := points + 1.
                        ppHits := ppHits + 1.
                    ]
                    ifFalse: [
                        points := points - 4.
                        pfHits := pfHits + 1.
                    ].
            ]
            ifFalse: [                                              "Fail is predicted"
                ((aFlexElement at: 7) > 0)
                    ifTrue: [
                        points := points - 8.
                        fpHits := fpHits + 1.
                    ]
                     ifFalse: [
                        points := points + 1.
                        ffHits := ffHits + 1.
                    ].
           ].
    ].

    adjFitness := (1.0 / (1.0 + (theCollection size - points))).
    aGPProgram fitness: adjFitness.
    aGPProgram rawFitness: points.

    theHits := Array new: 4.
    theHits at: 1 put: ppHits. theHits at: 2 put: pfHits.
    theHits at: 3 put: fpHits.  theHits at: 4 put: ffHits.
    aGPProgram hits: theHits.

    ^self.!
 
initialize

        "Perform the initialization"

    super initialize.  "Let the superclass do most of the initialization"

    computer := GPFlexureComputer new.
    self programGenerator computer: computer.                  " Tell the pgmGen abt the computer"
    computer executionLimit: 550.

    ^self.! !

GPOverlord subclass: #GPFlexureOverlord
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants WBConstants '    !


!GPFlexureOverlord class methods !
   
wbCreated

    ^true! !



!GPFlexureOverlord methods !
   
close: aPane
        "Private - Close the receiver."
    | answer |
       self custodian logStream close.
       self custodian expandedLogStream close.

    Smalltalk isRunTime
        ifTrue: [
            (MessageBox confirm: 'Are you sure you want to exit?')
                ifTrue: [self close. ^Smalltalk exit] ifFalse: [^self]]
        ifFalse: [^self close].!
  
displayProgram: aGPProgram

    "Callback for the #doubleClickSelect event in the CPColumnarListBox named 'mainList'.
     (Generated by WindowBuilder)"

    | theOutline thePID thePgm theOC theWS |

    thePgm :=aGPProgram.

    "Handle the program outline"

    self custodian computer programViewer reset.

    theOutline := self custodian computer programViewer inspectSubtree:
                                 thePgm firstNode.

    (self paneNamed: 'programListBox') contents: theOutline.

    "Handle the stats"

    self custodian computer load:thePgm.
    self custodian computer flexure reset.
    self custodian computer execute.

    theOC := OrderedCollection new.
    theWS := WriteStream on: (String new: 40).
    theWS nextPutAll: ( 'Predict Pass / Actual Pass  ', (thePgm hits at: 1) asString).
    theOC add: theWS contents.
    theWS reset.
    theWS nextPutAll: ( 'Predict Pass / Actual Fail  ', (thePgm hits at: 2) asString).
    theOC add: theWS contents.
    theWS reset.
    theWS nextPutAll: ( 'Predict Fail / Actual Pass  ', (thePgm hits at: 3) asString).
    theOC add: theWS contents.
    theWS reset.
    theWS nextPutAll: ( 'Predict Fail / Actual Fail  ', (thePgm hits at: 4) asString).
    theOC add: theWS contents.
    theWS reset.

    (self paneNamed: 'hitsList') contents:theOC.!
  
drawAntBitmap: aPane

    "Callback for the #activate event in the TopPane 'mainView'.
     (Generated by WindowBuilder)"!
   
initializeOverlord
   | theDialog |

    super initializeOverlord.    "First do the standard things"

    self custodian computer flexure initialize.

    self genDialog open.
    self generateBP: nil.
    self genDialog closeWindow.!
 
initWindow
        "Initialization stuff. Setup the contents of the feeding plain"

    self initializeOverlord.!

inspectPgm: aPane

    "Callback for the #doubleClickSelect event in the CPColumnarListBox named 'mainList'.
     (Generated by WindowBuilder)"

    | theOutline thePID thePgm theOC theWS |

    thePID := (self paneNamed: 'mainList') selectedItem pgmID.
    thePgm := self custodian programs at: thePID.

    "Handle the program outline"

    self custodian computer programViewer reset.

    theOutline := self custodian computer programViewer inspectSubtree:
                                 ((self custodian programs at: thePID) firstNode).

    (self paneNamed: 'programListBox') contents: theOutline.

    "Handle the stats"

    self custodian computer load:thePgm.
    self custodian computer flexure reset.
    self custodian computer execute.

    theOC := OrderedCollection new.
    theWS := WriteStream on: (String new: 40).
    theWS nextPutAll: ( 'Predict Pass / Actual Pass  ', (thePgm hits at: 1) asString).
    theOC add: theWS contents.
    theWS reset.
    theWS nextPutAll: ( 'Predict Pass / Actual Fail  ', (thePgm hits at: 2) asString).
    theOC add: theWS contents.
    theWS reset.
    theWS nextPutAll: ( 'Predict Fail / Actual Pass  ', (thePgm hits at: 3) asString).
    theOC add: theWS contents.
    theWS reset.
    theWS nextPutAll: ( 'Predict Fail / Actual Fail  ', (thePgm hits at: 4) asString).
    theOC add: theWS contents.
    theWS reset.

    (self paneNamed: 'hitsList') contents:theOC.!
  
open


     "WARNING!!  This method was automatically generated by
      WindowBuilder.  Code you add here which does not conform
      to the WindowBuilder API will probably be lost the next time
      you save your layout definition."

     | v |

    self addView: (
        v := self topPaneClass new
            owner: self;
            labelWithoutPrefix:  'GP Flexure Overlord';
            noSmalltalkMenuBar;
            viewName: 'mainView';
            framingBlock: ( FramingParameters new iDUE: 1586 @ 1133; xC; yC; cRDU: (7 @ 1126 rightBottom: 1579 @ 50));
            pStyle: #(sysmenu maximize titlebar sizable minimize);
            when: #activate perform: #drawAntBitmap:;
            addSubpane: (
                CPColumnarListBox new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 773 @ 264; lDU: 782 r: #left; tDU: 800 r: #top);
                    paneName: 'mainList';
                    headerColor: (ColorConstants at: 'ClrBackground');
                    fields: (
                        OrderedCollection new
                        addLast: (
                            CPCLBField new
                                header: 'PgmID';
                                justification: #center;
                                selector: #pgmID
                        );
                        addLast: (
                            CPCLBField new
                                header: 'RawFitn';
                                justification: #center;
                                selector: #rawFitness
                        );
                        addLast: (
                            CPCLBField new
                                header: 'Nodes';
                                justification: #center;
                                selector: #length
                        );
                        addLast: (
                            CPCLBField new
                                header: 'Depth';
                                justification: #center;
                                selector: #depth
                        );
                        addLast: (
                            CPCLBField new
                                header: 'Fitness';
                                justification: #center;
                                selector: #fitness
                        );
                        yourself
                    );
                    startGroup;
                    when: #select perform: #inspectPgm:;
                    when: #doubleClickSelect perform: #runPgm:;
                    setPopupMenu: (
                        Menu new
                            title: '';
                            owner: self;
                            appendItem: 'executePgm' selector: #executePgm acceleratorString: '';
                            appendSeparator;
                            appendItem: 'fileInPgm' selector: #fileInPgm acceleratorString: '';
                            appendItem: 'fileOutPgm' selector: #fileOutPgm acceleratorString: ''
                    );
                    font: (
                        Font new
                        fromBytes: #( 243 255 0 0 0 0 0 0 188 2 255 0 0 0 3 2 1 34 65 114 105 97 108 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 )
                    );
                    foreColor: ClrDarkblue;
                    yourself
            );
            addSubpane: (
                CPBitmapPane new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 44 @ 40; lDU: 1404 r: #left; tDU: 24 r: #top);
                    contents: (CPBitmapDict at: 'downArrow');
                    startGroup;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                CPBitmapPane new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 53 @ 72; lDU: 773 r: #left; tDU: 72 r: #top);
                    paneName: 'antBitmap';
                    contents: (CPBitmapDict at: 'crayons');
                    startGroup;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                ListBox new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 640 @ 280; lDU: 62 r: #left; rDU: 702 r: #left; tDU: 288 r: #top; bDU: 568 r: #top);
                    paneName: 'programListBox';
                    startGroup;
                    font: (
                        Font new
                        fromBytes: #( 243 255 0 0 0 0 0 0 188 2 255 0 0 0 3 2 1 34 65 114 105 97 108 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 )
                    );
                    foreColor: ClrDarkblue;
                    yourself
            );
            addSubpane: (
                Button new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 169 @ 48; lDU: 107 r: #left; rDU: 276 r: #left; tDU: 56 r: #top; bDU: 104 r: #top);
                    startGroup;
                    when: #clicked perform: #evolveBP:;
                    contents: 'Evolve';
                    foreColor: ClrBlack;
                    yourself
            );
            addSubpane: (
                CPNumericEditor new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 124 @ 45; lDU: 293 r: #left; tDU: 56 r: #top);
                    paneName: 'evolveCount';
                    min: 1;
                    contents: 1;
                    startGroup;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                CPHorizontalBarGauge new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 267 @ 40; lDU: 133 r: #left; tDU: 168 r: #top);
                    paneName: 'genDisplay';
                    min: 0;
                    contents: 0;
                    startGroup;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                CPBitmapPane new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 649 @ 448; lDU: 62 r: #left; tDU: 592 r: #top);
                    paneName: 'graphBitmap';
                    contents: (CPBitmapDict at: 'checkBox');
                    startGroup;
                    when: #getContents perform: #graphGetContents:;
                    backColor: ClrPalegray;
                    yourself
            );
            addSubpane: (
                ListBox new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 649 @ 288; lDU: 844 r: #left; rDU: 1493 r: #left; tDU: 280 r: #top; bDU: 568 r: #top);
                    paneName: 'hitsList';
                    startGroup;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 267 @ 40; lDU: 1102 r: #left; rDU: 1369 r: #left; tDU: 16 r: #top; bDU: 56 r: #top);
                    contents: 'Flexure Area:';
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 107 @ 32; lDU: 373 r: #left; rDU: 480 r: #left; tDU: 232 r: #top; bDU: 264 r: #top);
                    paneName: 'currentCount';
                    rightJustified;
                    contents: '0';
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 151 @ 32; lDU: 453 r: #left; rDU: 604 r: #left; tDU: 176 r: #top; bDU: 208 r: #top);
                    contents: 'Complete
';
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 196 @ 32; lDU: 204 r: #left; rDU: 400 r: #left; tDU: 232 r: #top; bDU: 264 r: #top);
                    contents: 'Active Pgm';
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 187 @ 32; lDU: 436 r: #left; rDU: 622 r: #left; tDU: 64 r: #top; bDU: 96 r: #top);
                    contents: 'Generations';
                    yourself
            );
        yourself
    ).

    self openWindow!
   
preInitWindow

        "Perform the initialization"

    custodian := GPFlexureCustodian new.      "Let the custodian and "
    custodian overlord: self.                                         "overlord be aware of each other"
    ^self.!
   
runPgm: aPane

    "Callback for the #doubleClickSelect event in the CPColumnarListBox named 'mainList'.
     (Generated by WindowBuilder)"

    | thePID thePgm theOC theWS |

    thePID := (self paneNamed: 'mainList') selectedItem pgmID.
    thePgm := self custodian programs at: thePID.

    self custodian computer load:thePgm.

    self custodian computer flexure reset.

    self custodian computer execute.

    theOC := OrderedCollection new.
    theWS := WriteStream on: (String new: 40).
    theWS nextPutAll: ( 'Predict Pass / Actual Pass  ', (thePgm hits at: 1) asString).
    theOC add: theWS contents.
    theWS reset.
    theWS nextPutAll: ( 'Predict Pass / Actual Fail  ', (thePgm hits at: 2) asString).
    theOC add: theWS contents.
    theWS reset.
    theWS nextPutAll: ( 'Predict Fail / Actual Pass  ', (thePgm hits at: 3) asString).
    theOC add: theWS contents.
    theWS reset.
    theWS nextPutAll: ( 'Predict Fail / Actual Fail  ', (thePgm hits at: 4) asString).
    theOC add: theWS contents.
    theWS reset.

    (self paneNamed: 'hitsList') contents:theOC.!
  
showFitnessGraph
        "comment"
    | thePane theGraph |


    thePane := self paneNamed: 'graphBitmap'.
    thePane backColor: ClrBlack.
    thePane foreColor: ClrGreen.

    theGraph := Graph new: thePane extent.

    theGraph title: 'Function Fitness'.
    theGraph ySeries: self custodian maxFitnessCollection.
    theGraph maxX: (100 max: self custodian maxFitnessCollection size).
    theGraph minY: 100 negated; maxY:200.
    theGraph drawAxes.
    theGraph drawLineGraph.

    thePane contents: theGraph bitmap.
    thePane display.! !
