Object variableSubclass: #Trail
	instanceVariableNames: 'map '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAEnv'!


!Trail methodsFor: 'accessing'!

contents: aPoint

	^(map at: aPoint y) at: aPoint x.!

map

	"This returns the instance variable"

	^map.! !

!Trail methodsFor: 'updating'!

markAsVisited: aPoint
	"Picks up food at the location indicated; the map is updated."

	(map at: aPoint y) at: aPoint x  put: $+.!

pickUpFood: aPoint

	"Picks up food at the location indicated; the map is updated."

	(map at: aPoint y) at: aPoint x  put: $+.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Trail class
	instanceVariableNames: ''!


!Trail class methodsFor: 'instance creation'!

new

	^super new initialize.! !

Trail variableSubclass: #SantaFeTrail
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAEnv'!


!SantaFeTrail methodsFor: 'initialization'!

initialize

	"This initializes a new instance of the SantaFeTrail. The board is a 32x32 grid 

	with food in specific locations."





	map := Array new: 32.

	map at:   1 put: '01110000000000000000000000000000' copy.

	map at:   2 put: '00010000000000000000000000000000' copy.

	map at:   3 put: '000100000000000000000000+111++00' copy.

	map at:   4 put: '00010000000000000000000010000100' copy.

	map at:   5 put: '00010000000000000000000010000100' copy.

	map at:   6 put: '0001111+111110000000+11++0000+00' copy.

	map at:   7 put: '00000000000010000000+00000000100' copy.

	map at:   8 put: '00000000000010000000100000000+00' copy.

	map at:   9 put: '00000000000010000000100000000+00' copy.

	map at: 10 put: '00000000000010000000100000000100' copy.

	map at: 11 put: '000000000000+0000000100000000+00' copy.

	map at: 12 put: '00000000000010000000+00000000+00' copy.

	map at: 13 put: '00000000000010000000+00000000100' copy.

	map at: 14 put: '00000000000010000000100000000+00' copy.

	map at: 15 put: '00000000000010000000100+++111+00' copy.

	map at: 16 put: '000000000000+000+1+++00100000000' copy.

	map at: 17 put: '000000000000+000+000000+00000000' copy.

	map at: 18 put: '0000000000001000+000000+00000000' copy.

	map at: 19 put: '00000000000010001000000+1+++0000' copy.

	map at: 20 put: '00000000000010001000000000010000' copy.

	map at: 21 put: '000000000000100010000000000+0000' copy.

	map at: 22 put: '000000000000100010000000000+0000' copy.

	map at: 23 put: '0000000000001000+000000+++1+0000' copy.

	map at: 24 put: '0000000000001000+000000100000000' copy.

	map at: 25 put: '0++11++11111+0001000000000000000' copy.

	map at: 26 put: '01000000000000001000000000000000' copy.

	map at: 27 put: '01000000000000001000000000000000' copy.

	map at: 28 put: '0100000+1111111++000000000000000' copy.

	map at: 29 put: '01000001000000000000000000000000' copy.

	map at: 30 put: '0+000001000000000000000000000000' copy.

	map at: 31 put: '0+1111++000000000000000000000000' copy.

	map at: 32 put: '00000000000000000000000000000000' copy.! !

Trail variableSubclass: #JohnMuirTrail
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAEnv'!


!JohnMuirTrail methodsFor: 'initialization'!

initialize

	"This initializes a new instance of the JohnMuirTrail. The board is a 32x32 grid 

	with food in specific locations."



	map := Array new: 32.

	map at:   1 put: '01111111111000000000000000000000' copy.

	map at:   2 put: '00000000001000000000000000000000' copy.

	map at:   3 put: '00000000001000000000000000000000' copy.

	map at:   4 put: '00000000001000000000000000000000' copy.

	map at:   5 put: '00000000001000+10000000000000000' copy.

	map at:   6 put: '11110000001000+000000000+1111111' copy.

	map at:   7 put: '00010000001000+00000000010000000' copy.

	map at:   8 put: '00010000001000100000000010000000' copy.

	map at:   9 put: '00010000001+1++00000000010000000' copy.

	map at: 10 put: '00010000001+00000000000010000000' copy.

	map at: 11 put: '00011111111+00000000000010000000' copy.

	map at: 12 put: '000000000001000000+11111+0000000' copy.

	map at: 13 put: '00000000000+++1+0010000000000000' copy.

	map at: 14 put: '000000000000000+0010000000000000' copy.

	map at: 15 put: '00000000000000010010000000000000' copy.

	map at: 16 put: '00000000000+1+++0010000000000000' copy.

	map at: 17 put: '00000000000+00000010000000000000' copy.

	map at: 18 put: '00000000000100000010000000000000' copy.

	map at: 19 put: '0000000+1+++000000+0000000000000' copy.

	map at: 20 put: '0000000+0000000000+0000000000000' copy.

	map at: 21 put: '0000000+000000000010000000000000' copy.

	map at: 22 put: '00000001000000000010000000000000' copy.

	map at: 23 put: '0000+1++000000000010000000000000' copy.

	map at: 24 put: '0000+000000000000010000000000000' copy.

	map at: 25 put: '00001000000000000010000000000000' copy.

	map at: 26 put: '00001000000000000010000000000000' copy.

	map at: 27 put: '000010000000000000+0000000000000' copy.

	map at: 28 put: '00001++1111+111111+0000000000000' copy.

	map at: 29 put: '00000000000000000000000000000000' copy.

	map at: 30 put: '00000000000000000000000000000000' copy.

	map at: 31 put: '00000000000000000000000000000000' copy.

	map at: 32 put: '00000000000000000000000000000000' copy.! !

Object subclass: #GeneticEnvironment
	instanceVariableNames: 'semaphore '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAEnv'!


!GeneticEnvironment methodsFor: 'accessing'!

semaphore
	"This returns the instance variable"
	^semaphore.!

semaphore: aSemaphore
	"This returns the instance variable"
	^semaphore := aSemaphore.! !

!GeneticEnvironment methodsFor: 'initialization'!

initialize
	"This initializes the instance"
	self semaphore: (SharedQueue new).! !

!GeneticEnvironment methodsFor: 'protocol'!

continue
	"This allows the GAEnv to continue."

	self semaphore nextPut: self.
	Processor yield.! !

!GeneticEnvironment methodsFor: 'updating'!

changed: aSymbol with: anObject
	"This allows a changed message to be sent to my dependents"

	super changed: aSymbol with: anObject.
	self dependents do: [:obj | self semaphore next].! !

GeneticEnvironment subclass: #AntEnvironment
	instanceVariableNames: 'board position steps foodFound orientation foodTotal '
	classVariableNames: 'AntImageDictionary '
	poolDictionaries: ''
	category: 'GAEnv'!


!AntEnvironment methodsFor: 'testing'!

senseFood
	"Returns true if food is present, false otherwise"
	^self senseFoodAt: (position + orientation).!

senseFoodAt: aPoint
	"Returns true if food is present, false otherwise"

	aPoint x > 32 ifTrue: [aPoint x: 1].
	aPoint x <  1 ifTrue: [aPoint x: 32].
	aPoint y > 32 ifTrue: [aPoint y: 1].
	aPoint y <  1 ifTrue: [aPoint y: 32].

	^(board contents: aPoint) = $1.!

senseTrailAt: aPoint
	"Returns true if a trail is present, false otherwise"

	aPoint x > 32 ifTrue: [aPoint x: 1].
	aPoint x <  1 ifTrue: [aPoint x: 32].
	aPoint y > 32 ifTrue: [aPoint y: 1].
	aPoint y <  1 ifTrue: [aPoint y: 32].

	^(board contents: aPoint) = $+.! !

!AntEnvironment methodsFor: 'updating'!

advance
	"This moves the ant in a given direction"

	self decrementSteps.
	self changed: #trail.
	position := position + orientation.
	position x > 32 ifTrue: [position x: 1].
	position x <  1 ifTrue: [position x: 32].
	position y > 32 ifTrue: [position y: 1].
	position y <  1 ifTrue: [position y: 32].
	self changed: #position.
	self pickUpFood.!

turnLeft
	"This changes the ant's direction by turning left."

	self decrementSteps.
	orientation = (1@0)
		 ifTrue: [orientation := 0@-1]
		ifFalse: [
			orientation = (0@-1) 
				ifTrue: [orientation := -1@0]
				ifFalse: [
					orientation = (-1@0) 
						ifTrue: [orientation := 0@1]
						ifFalse: [
							orientation = (0@1) ifTrue: [orientation := 1@0]
						]
				]
		].
	self changed: #position.!

turnRight
	"This changes the ant's direction by turning right."

	self decrementSteps.
	orientation = (1@0) 
		ifTrue: [orientation := 0@1]
		ifFalse: [
			orientation = (0@1) 
				ifTrue: [orientation := -1@0]
				ifFalse: [
					orientation = (-1@0) 
						ifTrue: [orientation := 0@-1]
						ifFalse: [
							orientation = (0@-1) ifTrue: [orientation := 1@0]
						]
				]
		].
	self changed: #position.! !

!AntEnvironment methodsFor: 'initialization'!

initialize
	"This initializes the instance of the ant's environment. A JohnMuirTrail is used by default which
	has 89 pieces of food to be gathered. A maximum of 500 time steps is allowed before the Ant
	program should terminate."

	super initialize.
	self foodTotal: 89.
	self foodFound: 0.
	self steps: 510.
	self position: Point unity.
	self orientation: 1@0.! !

!AntEnvironment methodsFor: 'accessing'!

board

	"This returns the instance variable"

	^board.!

board: anAntTrail

	"This sets the instance variable"

	^board := anAntTrail.!

foodFound

	"This returns the instance variable"

	^foodFound.!

foodFound: anInteger

	"This sets the instance variable"

	^foodFound := anInteger.!

foodTotal

	"This returns the instance variable"

	^foodTotal.!

foodTotal: anInteger

	"This sets the instance variable"

	^foodTotal := anInteger.!

orientation

	"This returns the instance variable"

	^orientation.!

orientation: aPoint

	"This sets the instance variable"

	^orientation := aPoint.!

position

	"This returns the instance variable"

	^position.!

position: aPoint

	"This sets the instance variable"

	^position := aPoint.!

steps

	"This returns the instance variable"

	^steps.!

steps: anInteger

	"This sets the instance variable"

	^steps := anInteger.! !

!AntEnvironment methodsFor: 'private'!

antImage
	"This obtains the correct ant image"
	^self class antImages at: self orientation.!

decrementSteps
	"This decrements the number of steps by one"

	steps := steps - 1.
	steps isZero ifTrue: [self changed: #endOfAnimation].!

pickUpFood
	"This picks up the food at the current location."

	(self senseFoodAt: position) ifTrue: [foodFound := foodFound + 1].
	board markAsVisited: position.! !

!AntEnvironment methodsFor: 'displaying'!

displayAntOn: aGC
	"This displays the ant"
	self displayAntOn: aGC at: self position.!

displayAntOn: aGC at: aPoint
	"This displays the ant's image on the trail"
	self displayClear: aGC at: aPoint.
	self antImage displayOn: aGC at: ((((aPoint - 1) * (self class cellExtent)) + self class boardOrigin) + 1).!

displayBoardOn: aGC
	"This displays the board"

	| x end start origin cells size y |

	origin := self class boardOrigin.
	cells := self class cells.
	size := self class cellExtent.
	0 to: cells do: [ :i |
		x := i * (size x) + (origin x).
		end := x @ ((cells + 1) * (size x) - (size x - origin x)).
		start := x @ (origin x).
		(LineSegment from: start to: end) displayStrokedOn: aGC.
	].
	0 to: cells do: [ :i |
		y := i * (size y) + (origin y).
		end := ((cells + 1) * (size y) - (size y - origin y)) @ y.
		start := (origin y) @ y.
		(LineSegment from: start to: end) displayStrokedOn: aGC.
	].!

displayClear: aGC at: aPoint
	"This displays the cell contents on the trail"
	|  size oldPaint |
	oldPaint := aGC paint.
	aGC paint: aGC medium background.
	size := self class cellExtent.
	(Rectangle origin: ((((aPoint - 1) * size) + self class boardOrigin) + 1) extent: (size - 1)) displayFilledOn: aGC.
	aGC paint: oldPaint.!

displayFoodOn: aGC at: aPoint
	"This displays the cell contents on the trail"
	self displayClear: aGC at: aPoint.
	self class foodImage displayOn: aGC at: ((((aPoint - 1) * (self class cellExtent)) + self class boardOrigin) + 1).!

displayOn: aGC
	"This displays the ant environment on a graphics context. It is used during the
	animation process -- if required"

	self displayBoardOn: aGC.
	self displayTrailOn: aGC.
	self displayAntOn: aGC.!

displayTrailOn: aGC
	"This displays the trail"
	| cells point |
	cells := self class cells.
	1 to: cells do: [:x |
		1 to: cells do: [:y |
			point := x @ y.
			(self senseFoodAt: point) 
				ifTrue: [self displayFoodOn: aGC at: point]
				ifFalse: [(self senseTrailAt: point) ifTrue: [self displayTrailOn: aGC at: point]]
		]
	].!

displayTrailOn: aGC at: aPoint
	"This displays the cell contents on the trail"
	self displayClear: aGC at: aPoint.
	self class trailImage displayOn: aGC at: ((((aPoint - 1) * (self class cellExtent)) + self class boardOrigin) + 1).! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

AntEnvironment class
	instanceVariableNames: ''!


!AntEnvironment class methodsFor: 'examples'!

example1

	"AntEnvironment example1"

	^self new.! !

!AntEnvironment class methodsFor: 'instance creation'!

new

	^super new initialize.! !

!AntEnvironment class methodsFor: 'class constants'!

boardOrigin
	"This returns the board origin"
	^6 @ 6.!

cellExtent
	"This returns cell size"
	^10 @ 10.!

cells
	"This returns the number of cells"
	^32.! !

!AntEnvironment class methodsFor: 'accessing'!

antImages
	"This returns a dictionary of all possible ant images"
	^AntImageDictionary! !

!AntEnvironment class methodsFor: 'class initialization'!

initialize
	"This initializes the ant image dictionary"
	"AntEnvironment initialize"
	AntImageDictionary := Dictionary new.
	AntImageDictionary at: 1@0 put: self antImageEast.
	AntImageDictionary at: -1@0 put: self antImageWest.
	AntImageDictionary at: 0@1 put: self antImageSouth.
	AntImageDictionary at: 0@-1 put: self antImageNorth.! !

!AntEnvironment class methodsFor: 'resources'!

antImage
	"UIMaskEditor new openOnClass: self andSelector: #antImage"

	^Image extent: 8@8 depth: 1 palette: CoveragePalette monoMaskPalette bits: #[0 0 0 0 80 0 0 0 42 0 0 0 60 0 0 0 42 0 0 0 80 0 0 0 0 0 0 0 0 0 0 0 ] pad: 32!

antImageEast
	"UIMaskEditor new openOnClass: self andSelector: #antImageEast"

	^Image extent: 8@8 depth: 1 palette: CoveragePalette monoMaskPalette bits: #[0 0 0 0 80 0 0 0 42 0 0 0 60 0 0 0 42 0 0 0 80 0 0 0 0 0 0 0 0 0 0 0 ] pad: 32!

antImageNorth
	"UIMaskEditor new openOnClass: self andSelector: #antImageNorth"

	^Image extent: 8@8 depth: 1 palette: CoveragePalette monoMaskPalette bits: #[0 0 0 0 40 0 0 0 16 0 0 0 56 0 0 0 84 0 0 0 56 0 0 0 68 0 0 0 0 0 0 0 ] pad: 32!

antImageSouth
	"UIMaskEditor new openOnClass: self andSelector: #antImageSouth"

	^Image extent: 8@8 depth: 1 palette: CoveragePalette monoMaskPalette bits: #[0 0 0 0 68 0 0 0 56 0 0 0 84 0 0 0 56 0 0 0 16 0 0 0 40 0 0 0 0 0 0 0 ] pad: 32!

antImageWest
	"UIMaskEditor new openOnClass: self andSelector: #antImageWest"

	^Image extent: 8@8 depth: 1 palette: CoveragePalette monoMaskPalette bits: #[0 0 0 0 10 0 0 0 84 0 0 0 60 0 0 0 84 0 0 0 10 0 0 0 0 0 0 0 0 0 0 0 ] pad: 32!

foodImage
	"UIMaskEditor new openOnClass: self andSelector: #foodImage"

	^Image extent: 8@8 depth: 1 palette: CoveragePalette monoMaskPalette bits: #[255 0 0 0 255 0 0 0 255 0 0 0 255 0 0 0 255 0 0 0 255 0 0 0 255 0 0 0 255 0 0 0 ] pad: 32!

shapeImage

	"UIMaskEditor new openOnClass: self andSelector: #shapeImage"



	^Image extent: 8@8 depth: 1 palette: CoveragePalette monoMaskPalette bits: #[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ] pad: 32!

trailImage
	"UIMaskEditor new openOnClass: self andSelector: #trailImage"

	^Image extent: 8@8 depth: 1 palette: CoveragePalette monoMaskPalette bits: #[85 0 0 0 170 0 0 0 85 0 0 0 170 0 0 0 85 0 0 0 170 0 0 0 85 0 0 0 170 0 0 0 ] pad: 32! !

AntEnvironment subclass: #JohnMuirTrailEnv
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAEnv'!


!JohnMuirTrailEnv methodsFor: 'initialization'!

initialize
	"This sets up the envionment for the JohnMuir Trail"
	super initialize.
	self board: (JohnMuirTrail new).! !

AntEnvironment subclass: #SantaFeTrailEnv
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'GAEnv'!


!SantaFeTrailEnv methodsFor: 'initialization'!

initialize
	"This sets up the envionment for the SantaFe Trail"
	super initialize.
	self board: (SantaFeTrail new).! !
AntEnvironment initialize!

