// gpv(ariables).cc    15/11/93  apf

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// a nice simple class to contain all the genetic programming variables
// this is inherited by the population class....

// RECENT IMPROVEMENTS

// none


// include gpv defn's ( and also gp and gene )
#include "gpv.hpp"

// this global variables is the number of subtrees a genetic program has
// when dealing with adfs.  We generally have a root tree calling the adfs
// in some evolved order.  This value is set by the number of adfs defined
// by the user in 'gp.ini'
unsigned int RootandADF; // global variable...



// MAIN CODE...


// Print out all the data contained within the class GPVariables..........
ostream& operator << ( ostream& os, GPVariables *pgpv )
{
	os << "Population Size           : " << pgpv->PopulationSize << endl;
	os << "Number Of Generations     : " << pgpv->NumberOfGenerations << endl;
	os << "Number Of ADFs            : " << pgpv->NumberOfADFs << endl;
	os << "Creation Type             : ";
// this switch statements inteprets those values defined in gp.hpp
	switch( pgpv->CreationType )
	{
		case VARIABLE :
			os << "Variable";
			break;
		case GROW :
			os << "Grow";
			break;
		case RAMPEDHALF :
			os << "Ramped Half and Half";
			break;
		case RAMPEDVARIABLE :
			os << "Ramped Variable";
			break;
		case RAMPEDGROW :
			os << "Ramped Grow";
			break;
		default       :
			os << "Error...";
	}
	os << endl;
	os << "Number Of Evaluations     : " << pgpv->NumberOfEvaluations << endl;
	os << "Maximum Depth at creation : " << pgpv->MaximumDepthForCreation << endl;
	os << "Maximum Depth at Crossover: " << pgpv->MaximumDepthForCrossover << endl;
	os << "Maximum Fitness           : " << pgpv->MaximumFitness << endl;
	os << "Maximum Sum Fitness       : " << pgpv->MaximumSumFitness << endl;
	os << "Number To Mutate          : " << pgpv->NumberToMutate << endl << endl;

	return os;
}

GPVariables::GPVariables( int pop, int gen )
{
	PopulationSize = pop;
	NumberOfGenerations = gen;

	ifstream ifs( "gp.ini" );

// if this file was opened then.....
	if ( ifs )
	{
// load values from file and...... 
		 Load( ifs );

//set up those values which are not in file.
		MaximumSumFitness = (long)PopulationSize * (long)MaximumFitness;

// we have a naughty global variable floating around which must be set.. 
		RootandADF = (NumberOfADFs + 1);
	}

// if the file wasn't opened create a default gp.ini and exit
	else                           
	{
// the chances of these default values being correct for different code is small so
// forgetting to alter gp.ini is quite an error
		cout << "Cannot find 'gp.ini'. Creating a default version and exiting" << endl;

// give the variables to save some default values ( taken from art. ant problem )
		CreationType = VARIABLE;
		NumberOfEvaluations = 400;

		MaximumFitness = 100;
		MaximumDepthForCreation = 6;
		MaximumDepthForCrossover = 17;

		NumberOfADFs = 0;    // ie no adfs

		NumberToMutate = 0;
// save theses default files in gp.ini
		ofstream ofs( "gp.ini" );    // save defaults
		ofs << "// default gp.ini for gpcpp -- apf '94" << endl;
		Save( ofs );
		ofs.close();

// exit the system as using default adfs is bound to crash the system...
		ExitSystem( " " );
	}
}

// save a file with the values of GPVariables.
void GPVariables::Save( ostream& os )
{
	os << "CreationType  : " << CreationType << endl;
	os << "Evaluations   : " << NumberOfEvaluations << endl;
	os << "MaxFitness    : " << MaximumFitness << endl;
	os << "MaxCreation   : " << MaximumDepthForCreation << endl;
	os << "MaxCrossover  : " << MaximumDepthForCrossover << endl;
	os << "ADFs          : " << NumberOfADFs << endl;
	os << "Mutation      : " << NumberToMutate << endl;
}

// load those variable with the data from input file 
void GPVariables::Load( istream &is )
{
	char ch = '0';

// the data stream is searched until a ':' is found then values are input
	while ( ch != ':' ) is >> ch;    is >> CreationType;
	is >> ch;
	while ( ch != ':' ) is >> ch;  is >> NumberOfEvaluations;
	is >> ch;
	while ( ch != ':' ) is >> ch;  is >> MaximumFitness;
	is >> ch;
	while ( ch != ':' ) is >> ch;  is >> MaximumDepthForCreation;
  is >> ch;
	while ( ch != ':' ) is >> ch;  is >> MaximumDepthForCrossover;
	is >> ch;
	while ( ch != ':' ) is >> ch;  is >> NumberOfADFs;
  is >> ch;
  while ( ch != ':' ) is >> ch;  is >> NumberToMutate;
	is >> ch;
}

// gpv.cc
