// eval.cc

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// Version 0.40 28 February 1994
// By Adam Fraser  10/03/93

#include "pop.hpp"

// This function is called only once after the initial generation has been
// created everything else goes through GP::Evaluate...
void Population::Evaluate()
{
// setting up start of gp 
	GP *pgp = pgpHeader;
	unsigned int pop = PopulationSize;

// loop through whole population evaluating every string
	while (pop--)   pgp++->Evaluate( NumberOfEvaluations );
}

// Evaluation for a genetic program all the complicated stuff is in user
// produced code.
void GP::Evaluate( unsigned int Eval )
{
// assigned fitness from callng evaluatefitness function
	iFitness = EvaluateFitness( this, Eval );
}
// eval.cpp


// Someone asked how to produce multiple population with gpcpp so below I
// shall show how I would do it though this has not been checked and debugged


// Global variables for the two population

/*
void Population::Evaluate( Population *ppop)
{
// setting up start of gp 
	GP *pgp = pgpHeader;
	unsigned int pop = PopulationSize;

// loop through whole population evaluating every string
	while (pop--)   pgp++->Evaluate( ppop, NumberOfEvaluations );
}


// Evaluate fitness would have to be changed to take two gps...
void GP::Evaluate( Population *ppop, unsigned int Eval )
{
// set up starting gp, population size 
	GP *pgp = ppop->pgpHeader;
	unsigned int pop = ppop->PopulationSize;

// move through population evaluating and summating fitness
	while ( pop-- )
	{
		iFitness += EvaluateFitness( this, pgp, Eval );
		pgp++;
	}
}
*/

// eval.cc
