// gpant.cc -> the interface between genetic programming and the artificial ant problem

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


#include "gp.hpp"
#include "function.hpp"
#include "terminal.hpp"

#include "trail.hpp"
#include "ant.hpp"

/* Naughty global variables */

FS *FunctionSets[1];
TS *TerminalSets[1];

// the global variables for the ant....
Ant glbAnt;

// definitions for macro ROOT below
GP *pgpGlobal;
#define ROOT *(pgpGlobal->ppgHeader)

/* Function Prototypes */
unsigned int EvaluateFitness( GP*, int );   /* These four functions MUST be included */
ostream& (*TranslatePrint)( ostream&, Gene* );
void InitialiseGPS();
void CleanUpGPS();

FITNESS (*Translate)( Gene* );

FITNESS TranslateROOT( Gene* );
ostream& TranslatePrintROOT( ostream&, Gene* );


/* Main function codes */
unsigned int EvaluateFitness( GP *pgp, int Evals )
{
// set the rawfitness to 0
	FITNESS rawfitness = 0;

// set up global variable for ROOT macro
	pgpGlobal = pgp;     

// As ant 'eats' trail as it is evaluated we need to create a new one each time
	CreateTrail();                         

// Reset the position of the artificial ant 
	ResetAnt( Evals );

// while the ant still has energy evaluate it accumulating the fitness
	while ( glbAnt.Energy != 0 )    rawfitness += Translate( ROOT );

// in this case the rawfitness is the fitness of the individual
	return (unsigned int)rawfitness;
}


FITNESS TranslateROOT( Gene *pg )
{
	switch ( pg->iValue )
	{
// Functions......................................................
		case 1: return IfFoodAhead( pg->pgChild );
		case 2: return Prog2( pg->pgChild );
		case 3: return Prog3( pg->pgChild );
 // Terminals......................................................
		case 4: return TurnRight();
		case 5: return TurnLeft();
		case 6: return MoveForward();
// it will never happen honestly..................................
		default: { ExitSystem( "TranslateROOT" ); return 0; }
	}
}

ostream& TranslatePrintROOT( ostream& os, Gene *pg )
{
	switch ( pg->iValue )
	{
// Functions......................................................
		case 1:         os << " ( IfFoodAhead";
				break;    
		case 2:         os << " ( Prog2";
				break;
		case 3:         os << " ( Prog3";
				break;
// Terminals......................................................
		case 4:         os << " TurnRight";
				break;        
		case 5:         os << " TurnLeft";
				break;
		case 6:         os << " MoveForward";
				break;
// it will never happen honestly..................................
		default:        os << " Error...Error,its all gone wrong";
				break;
	}
// this value is returned but as yet not used it just keeps everything tidy...
  return os;
}

// Printing the english version of the genetic program...
ostream& operator <<(ostream& os, GP *pgp )
{
	if ( pgp )
	{
		pgpGlobal = pgp;
		TranslatePrint = TranslatePrintROOT;
		os << "(" << ROOT << endl;
	}
	return os; // must return this value or hell breaks loose..
}


void InitialiseGPS()
{

// F( main ) = [ IfFoodAhead, Prog2, Prog3 }
// T( main ) = { TurnRight, TurnLeft, MoveForward ]
 if ( !( FunctionSets[0] = new FS( 3, 1,2,3, 2,2,3 ) ) )   ExitSystem( "InitialiseGPS()" );
 if ( !( TerminalSets[0] = new TS( 3, 4,5,6 ) ) )          ExitSystem( "InitialiseGPS()" );

// creates the world in which the ant resides. The trail is created seperately for
// each evaluation process
 CreateWorld();

// note how as these stay constant they can be placed in the initialise block
 Translate = TranslateROOT;
 TranslatePrint = TranslatePrintROOT;
}

// deletes those members which were allocated memory in InitialiseGPS()
void CleanUpGPS()
{
	delete FunctionSets[0];
	delete TerminalSets[0];
}
