/* ant.c -> My evolving code for Artificial Ant Problem  */

/* Designed by Adam Fraser 10 October 93 */

/* Genetic Programming System using the C++ programming language

 Input is of the form gp <pop> <gen> <output file>

 A Potted History:

	 Version 1.00 BETA (sometime March 1993). Very Buggy,...
	 Version 2.00 C++ version very easy language 16 July 1993
								ERRORS in load and saving a genetic program.
											 No capacity for extended memory in DOS.
											 No differing creation mechanism.
											 No touranment selection
											 No capacity for encapsulation
	 Version 3.00 C++ Version.( Uncompatible with previous versions )
											 Robust with full use of OOP techniques.
											 Compatibility with ANSI standard.
											 Ramped half and half implemented.
											 Tournament selection implemented.
											 Changing variables does not require recompiling.
											 BUT STILL
											 No capacity for expanded or extended memory in DOS.
											 No capacity for encapsulation.

	 C version in progress
	 Windows version in progress but its all gobblydegook.


	 Version 3.00 can be compiled in the DOS and UNIX domain
	 but NOT in Windows. This was not made clear in previous programs.

 Genetic programming in C++ was designed and choreographed by Adam P.Fraser

		Food parcels, cash and trashy sci-fi novels to:

					 a.fraser@eee.salford.ac.uk
					snail:
					 A.Fraser
					 PostGraduate Section,
					 Maxwell Building,
					 Elec & Elec Eng,
					 University Of Salford,
					 Salford,
					 M5 4WT.
					 England


		Your comments, improvements and complaints are welcome.


 This code is intended as a base for C++ GPers. Please if you adapt the code
 send me a msg. Also could you please keeps these comments and my address in
 the code.

							regards,
											Adam Fraser ;-)
											16 November 1993

	' and one day there shall come an artificial ant who can complete the santa
	fe trail in 400 evaluation steps and on that day there shall be oink flap'
*/


#include "gpmain.hpp"          /* for C version change these to *.h */
#include "function.hpp"
#include "terminal.hpp"

#include "trail.h"

/* Naughty global variables */

unsigned int x = 0;
unsigned int y = 0;
unsigned int Moving = 0;
unsigned int Energy = 0;

/* Function Prototypes */

int EvaluateFitness( Gene *,int );   /* These four functions MUST be included */
int Translate( Gene* );
char *TranslatePrint( Gene* );
void Initialise();

void ResetInsect( void );

/* function code definitions */
int IfFoodAhead( Gene* );
int Prog2( Gene* );
int Prog3( Gene* );
int TurnRight( void );
int TurnLeft( void );
int MoveForward( void );
void MoveRight( void );
void MoveUp( void );
void MoveDown( void );
void MoveLeft( void );
int IsFoodHere( void );
int IsFoodAhead( void );
int IsFoodRight( void );
int IsFoodUp( void );
int IsFoodLeft( void );
int IsFoodDown( void );



/* Main function codes */

int Translate( Gene *pg )
{
	switch ( pg->iValue )
	{
		case 1: return IfFoodAhead( pg->pgChild );
		case 2: return Prog2( pg->pgChild );
		case 3: return Prog3( pg->pgChild );
		case 4: return TurnRight();
		case 5: return TurnLeft();
		case 6: return MoveForward();
		default: ExitSystem( "Translate has found value which cannot exist" );
						 return 0;
	}
}

char* TranslatePrint( Gene *pg )
{
	switch ( pg->iValue )
	{
		case 1: 	return " IfFoodAhead (";       /* functions */
		case 2: 	return " Prog2 (";
		case 3: 	return " Prog3 (";
		case 4: 	return " TurnRight ";          /* terminals */
		case 5: 	return " TurnLeft ";
		case 6: 	return " MoveForward ";
		default:  return "Error";
	}
}



int EvaluateFitness( Gene *pg, int Evals )
{
	int fitness = 0;

	CreateTrail();				/* Resets trail when it rebuilds it */

	ResetInsect();
  Energy = Evals;

	while ( Energy > 0 )
	{
		fitness += pg->Evaluate();
	}

	return fitness;
}

void Initialise()
{
	if (!(FunctionSet = new FS( 3, 1,2,3, 2,2,3 )) ) ExitSystem( "Initialise");
	if (!(TerminalSet = new TS( 3, 4,5,6 )) ) ExitSystem( "Initialise" );

	CreateWorld();
}


void ResetInsect( void )
{
	x = 0;
	y = 0;
	Moving = 0;
}


/* function code definitions */

int IfFoodAhead( Gene *pg )
{
	if ( IsFoodAhead() ) return pg->Evaluate();
	else return pg->pgNext->Evaluate();
}

int Prog2( Gene *pg )
{
	int sum = 0;

	sum += pg->Evaluate();
	sum += pg->pgNext->Evaluate();

	return sum;
}

int Prog3( Gene *pg )
{
	int sum = 0;

	sum += pg->Evaluate();
	sum += pg->pgNext->Evaluate();
	sum += pg->pgNext->pgNext->Evaluate();

	return sum;
}



/* terminal code definitions */

int TurnRight( void )
{
	if ( Energy == 0 ) return 0;

	Moving = ( Moving + 3 ) % 4;

	Energy--;

	return 0;
}

int TurnLeft( void )
{
	if ( Energy == 0 ) return 0;

	Moving = ( Moving + 1 ) % 4;

	Energy--;

	return 0;
}

int MoveForward( void )
{
	if ( Energy == 0 ) return 0;

	switch ( Moving )
	{
		case 0: MoveRight();
						break;
		case 1: MoveUp();
						break;
		case 2: MoveLeft();
						break;
		case 3: MoveDown();
						break;
	}


	Energy--;

/* This also clears food out the way so it can't be eaten again */

	return ( IsFoodHere() );
}

void MoveRight( void )
{
	if ( x < World_Horizontal ) x++;
}

void MoveUp( void )
{
	if ( y > 0) y--;
}

void MoveDown( void )
{
	if ( y < World_Vertical) y++;
}

void MoveLeft( void )
{
	if ( x > 0) x--;
}

int IsFoodHere( void )
{
	if ( World[x][y] == 1 )      /* Note spaces will not be seen as they == 2 */
	{
		World[x][y] = 0;           /* Eats Food !!!!  */
		return 1;
	}
	else
		return 0;
}


int IsFoodAhead( void )
{
	switch (Moving)
	{
		case 0: return IsFoodRight();    /* is food right */
		case 1: return IsFoodUp();       /* is food up  */
		case 2:	return IsFoodLeft();     /* is food left */
		case 3:	return IsFoodDown();     /* is food down */
    default:return 0;
	}
}



/* This code works because of a clever bit of C knowledge C looks at the first
	 term in if statement if == false it then stops, therefore not causing
	 an error in the next statement...			APF 13/06/93 */

int IsFoodRight( void )
{
	if ( ( x < World_Horizontal ) && ( World[x+1][y] == 1 ) ) return 1;
	else                                                      return 0;
}

int IsFoodUp( void )
{
	if ( ( y > 0 ) && ( World[x][y-1] == 1 ) ) return 1;
	else                                       return 0;
}

int IsFoodLeft( void )
{
	if ( ( x > 0 ) && ( World[x-1][y] == 1 ) ) return 1;
	else                                       return 0;
}

int IsFoodDown( void )
{
	if ( ( y < World_Vertical ) && ( World[x][y+1] == 1 ) ) return 1;
	else                                                		return 0;
}

/* ant.c */