// rungps.cpp

// 15 November 1993 apf


/* Genetic Programming System using the C++ programming language

 Input is of the form gp <pop> <gen> <output file>

 A Potted History:

	 Version 1.00 BETA (sometime March 1993). Very Buggy,...
	 Version 2.00 C++ version very easy language 16 July 1993
								ERRORS in load and saving a genetic program.
											 No capacity for extended memory in DOS.
											 No differing creation mechanism.
											 No touranment selection
											 No capacity for encapsulation
	 Version 3.00 C++ Version.( Uncompatible with previous versions )
											 Robust with full use of OOP techniques.
											 Compatibility with ANSI standard.
											 Ramped half and half implemented.
											 Tournament selection implemented.
											 Changing variables does not require recompiling.
											 BUT STILL
											 No capacity for expanded or extended memory in DOS.
											 No capacity for encapsulation.

	 C version in progress
	 Windows version in progress but its all gobblydegook.


	 Version 3.00 can be compiled in the DOS and UNIX domain
	 but NOT in Windows. This was not made clear in previous programs.

 Genetic programming in C++ was designed and choreographed by Adam P.Fraser

		Food parcels, cash and trashy sci-fi novels to:

					 a.fraser@eee.salford.ac.uk
					snail:
					 A.Fraser
					 PostGraduate Section,
					 Maxwell Building,
					 Elec & Elec Eng,
					 University Of Salford,
					 Salford,
					 M5 4WT.
					 England


		Your comments, improvements and complaints are welcome.


 This code is intended as a base for C++ GPers. Please if you adapt the code
 send me a msg. Also could you please keeps these comments and my address in
 the code.

							regards,
											Adam Fraser ;-)
											16 November 1993

	' and one day there shall come an artificial ant who can complete the santa
	fe trail in 400 evaluation steps and on that day there shall be oink flap'
*/

#include "gpmain.hpp"
#include "function.hpp"
#include "terminal.hpp"

#include <fstream.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>


void RunGPS( int PopulationSize, int Generation, char *strOut )
{
	Population *ppop;
	GP *BestOfGeneration;
	GP *BestOfAll = new GP;
	char strOutFile[12], strBestOutFile[12];

	sprintf( strOutFile,"%s.dat", strOut );
	sprintf( strBestOutFile, "%sb.dat", strOut );

	ofstream fout( strOutFile );

	srand( (unsigned)time(NULL) );

	Initialise();    // calls function contained in your evolving code

	cout << "About to send all output to file" << endl;

	if ( !(ppop = new Population( PopulationSize, Generation )) )
			ExitSystem( " Creation of Genetic Program family has caused errors" );

	cout << "Creation Completed" << endl;

	ppop->Evaluate();

	cout << "Evaluation Completed" << endl;

	DebugPrint( "Evaluation Worked" );

	fout << ppop;

	for ( int gen = 0; gen < Generation; gen++ )
	{
		cout << "Generation " << gen << " ... ";

		fout << endl << endl << "Generation : " << gen << endl;

		fout << "Average Fitness : " ;
		fout << float ( float( ppop->TotalFitness() )
                                 / float( PopulationSize ) ) << endl;

		fout << "Best Of Generation was : " << endl;

		BestOfGeneration = ppop->Best();

		fout << BestOfGeneration;

		fout << "With a fitness of : " << BestOfGeneration->iFitness << endl;

// Check if best of generation is the best yet

		if ( BestOfAll->iFitness <= BestOfGeneration->iFitness )
		{
			delete BestOfAll;
			if ( !(BestOfAll = new GP( BestOfGeneration)) )
				ExitSystem( "Creation of Best Of  All caused memory overload" );
		}

		ppop->Reproduce();

		ppop->Crossover();

		cout << "completed." << endl;

	}


	fout << endl << endl << "Genetic Programming System Completed" << endl;

	fout << endl << "The Best GP was : " << endl << BestOfAll;

	fout << "With a fitness of : " << BestOfAll->iFitness << endl;

        delete ppop;

	fout.close();

	ofstream bout( strBestOutFile );     // save best of structure to file
	BestOfAll->Save( bout );
	bout.close();

	delete BestOfAll;

	cout << endl;

	cout << "Genetic Programming System Completed. Results in ";
	cout << strOutFile << " and " << strBestOutFile << endl;
        
// NB you may notice that I leave the TerminalSet and FunctionSet allocations
//    alone. This is for the simple reason that under GNU Unix I use  get a
//    fault at this point DOS works fine with no memory leakage and I have no
//    idea why UNIX hates it but it all works fine,,,,  apf 15/11/93

}

