// gene.cpp

#include "gene.hpp"

//  !!!V.Important... The gene functions contained here are generally of a
//    recursive nature. Therefore a design decision has been made to keep
//    the number of error checking components to a minimum it is therefore
//    imperative that any function that calls these functions must check
//    for any possible errors. Once a correct data structure has been sent
//    checking will be contained within the recursive loop. Thanks.. APF

/* Genetic Programming System using the C++ programming language

 Input is of the form gp <pop> <gen> <output file>

 A Potted History:

	 Version 1.00 BETA (sometime March 1993). Very Buggy,...
	 Version 2.00 C++ version very easy language 16 July 1993
								ERRORS in load and saving a genetic program.
											 No capacity for extended memory in DOS.
											 No differing creation mechanism.
											 No touranment selection
											 No capacity for encapsulation
	 Version 3.00 C++ Version.( Uncompatible with previous versions )
											 Robust with full use of OOP techniques.
											 Compatibility with ANSI standard.
											 Ramped half and half implemented.
											 Tournament selection implemented.
											 Changing variables does not require recompiling.
											 BUT STILL
											 No capacity for expanded or extended memory in DOS.
											 No capacity for encapsulation.

	 C version in progress
	 Windows version in progress but its all gobblydegook.


	 Version 3.00 can be compiled in the DOS and UNIX domain
	 but NOT in Windows. This was not made clear in previous programs.

 Genetic programming in C++ was designed and choreographed by Adam P.Fraser

		Food parcels, cash and trashy sci-fi novels to:

					 a.fraser@eee.salford.ac.uk
					snail:
					 A.Fraser
					 PostGraduate Section,
					 Maxwell Building,
					 Elec & Elec Eng,
					 University Of Salford,
					 Salford,
					 M5 4WT.
					 England


		Your comments, improvements and complaints are welcome.


 This code is intended as a base for C++ GPers. Please if you adapt the code
 send me a msg. Also could you please keeps these comments and my address in
 the code.

							regards,
											Adam Fraser ;-)
											16 November 1993

	' and one day there shall come an artificial ant who can complete the santa
	fe trail in 400 evaluation steps and on that day there shall be oink flap'
*/


// Print functions..... using iostream

ostream& operator << ( ostream& os, Gene *pg )
{
	os << TranslatePrint( pg );

	if ( pg->pgChild ) os << pg->pgChild;

	if ( pg->pgNext )  os << pg->pgNext;
	else               os << " )";

	return os;
}

// Class function definitions

// Your fancy constructor debugging tool more than anything

Gene::Gene( int iVal )
{
	iValue = iVal;
	pgChild = NULL;
	pgNext = NULL;
}


Gene::~Gene()
{
	if ( pgChild ) delete pgChild;
	if ( pgNext )	delete pgNext;
}


Gene::Gene( Gene *pg )
{
	DebugPrint( "Gene Copier Function" );

	iValue = pg->iValue;

	if ( pg->pgChild )
	{
		if ( !(pgChild = new Gene( pg->pgChild )) )	ExitSystem("Gene::Gene");
	}
	else pgChild = NULL;

	if ( pg->pgNext )
	{
		if ( !(pgNext = new Gene( pg->pgNext )) ) ExitSystem("Gene::Gene");
	}
	else pgNext = NULL;

	DebugPrint( "Gene Copier Completed" );
}

void Gene::Copy( Gene *pg )
{
	iValue = pg->iValue;

	if ( pgChild ) delete pgChild;
	if ( pgNext )  delete pgNext;

	if ( pg->pgChild )
	{
		if  ( !(pgChild = new Gene( pg->pgChild )) ) ExitSystem( "Gene::Copy" );
	}
	else pgChild = NULL;

	if ( pg->pgNext )
	{
		if  ( !(pgNext = new Gene( pg->pgNext )) ) ExitSystem( "Gene::Copy" );
	}
	else pgNext = NULL;
}



void Gene::Length( int& riLength )
{
	riLength++;
	if ( pgChild ) pgChild->Length( riLength );
	if ( pgNext )  pgNext->Length( riLength );
}


int Gene::Depth( int iDepth, int& riMaxdepth )
{
	if ( iDepth > riMaxdepth ) riMaxdepth = iDepth;
	if ( pgChild ) iDepth = pgChild->Depth( ++iDepth, riMaxdepth );
	if ( pgNext )	 iDepth = pgNext->Depth( iDepth, riMaxdepth );

	return 0;
}

// Gene::Nth now resides in gp.cpp for reasons found in that file....

// gene.cpp