/*
 * Copyright (C) 1993 by Dave Glowacki
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */

#include "operatrsrc.h"
#include "optrivial.h"

result *
opAdd(argv, envp)
const result **argv;
void *envp;
{
  return(resultCreate(dtInteger,
		      resultInteger(argv[0]) + resultInteger(argv[1])));
}

result *
opSubtract(argv, envp)
const result **argv;
void *envp;
{
  return(resultCreate(dtInteger,
		      resultInteger(argv[0]) - resultInteger(argv[1])));
}

result *
opComplexAdd(argc, argv, envp)
int argc;
const object **argv;
void *envp;
{
  result *rp;
  int i;
  int total = 0;

  /* make sure we got the right number of arguments */
  if (argc != 2) {
    fprintf(stderr, "opComplexAdd got %d args, needs 2\n", argc);
    exit(1);
  }

  /* evaluate arguments */
  for (i = 0; i < argc; i++) {
    rp = objectEval(argv[i], envp);

    /* make sure we got an integer */
    if (!resultIsInteger(rp))
      resultSetError(rp, ErrorBadDataType);

    /* if we got an error, return it */
    if (resultIsError(rp)) {
      return(rp);
    }

    /* add this to our running total and free it */
    total += resultInteger(rp);
    resultFree(rp);
  }

  /* return the result */
  return(resultCreate(dtInteger, total));
}

result *
opComplexSubtract(argc, argv, envp)
int argc;
const object **argv;
void *envp;
{
  result *rp;
  int i;
  int total;

  /* make sure we got the right number of arguments */
  if (argc != 2) {
    fprintf(stderr, "opComplexAdd got %d args, needs 2\n", argc);
    exit(1);
  }

  /* evaluate arguments */
  for (i = 0; i < argc; i++) {
    rp = objectEval(argv[i], envp);

    /* make sure we got an integer */
    if (!resultIsInteger(rp))
      resultSetError(rp, ErrorBadDataType);

    /* if we got an error, return it */
    if (resultIsError(rp)) {
      return(rp);
    }

    /* add this to our running total and free it */
    if (i == 0)
      total = resultInteger(rp);
    else
      total -= resultInteger(rp);
    resultFree(rp);
  }

  /* return the result */
  return(resultCreate(dtInteger, total));
}
