#ifndef VARIABLE_H
#define VARIABLE_H

#include "compiler.h"
#include "objtypes.h"
#include "blob.h"
#include "charstring.h"
#include "result.h"

typedef struct variable {
  objecttype otype;
  datatype dtype;
  char *name;
  union {
    bool *bp;
    short *sp;
    int *ip;
    long *lp;
    float *fp;
    double *dp;
    blob *bbp;
  } v;
} variable;

#define variableName(vp)	((const char *)((vp)->name))
#define variableCount(vp, i)	(i ? 0 : 1)
#define variableDepth(vp, d)	(d)+1

variable *variableCreate P((datatype dt, const char *name, void *varptr));
variable *variableCopy P((const variable *vp));
int variableCompare P((const variable *vp1, const variable *vp2));
result *variableEval P((const variable *vp));
const variable **variableNodePtr P((const variable **vpp, int *count,
				    int nodeNum, int internal,
				    datatype *typeptr));
int variableToString P((const variable *vp, charString *cstr));
void variableFree P((variable *vp));
#ifdef KEEP_ALLOCATED_MEMORY
void variableFreeStack P((NOARGS));
#endif /* KEEP_ALLOCATED_MEMORY */

#endif /* VARIABLE_H */
