#ifndef POPULATION_H
#define POPULATION_H

#include "compiler.h"
#include "object.h"
#include "objectlist.h"
#include "program.h"
#include "interface.h"

typedef enum parentSelectionMethod {
  psmFitnessProportionate, psmGreedyOverselection, psmTournament
} parentSelectionMethod;

typedef struct population {
  int populationSize;
  program **programs, **workspace;
  program *bestOfRun;
  int bestGeneration;
} population;

typedef program *(parentSelectionFunction) P((const population *));

#define populationLength(psp)	((const int )((psp)->populationSize))
#define populationEntry(psp, i)	((psp) && ((i) >= 0) &&			\
				 ((i) < (psp)->populationSize) ?	\
				 (const program *)((psp)->programs[i]) : 0)

extern int tournamentRounds;
extern double overselectionPercentage;

population *populationCreate P((const interface *ip, int popSize,
				int initialDepth,
				programCreationMethod method));
int populationEval P((population *pop, const interface *ip, int maxLoops,
		      int alwaysEval, double parsimony, int genNum));
void populationBreed P((population *pop, const interface *ip,
			parentSelectionMethod selector, double pctReproduce,
			double pctXoverAny, double pctXoverInternal,
			int maxMutateDepth, int maxTotalDepth));
int populationCompare P((const population *pop1, const population *pop2));
void populationDump P((const population *pop, int genNum, int dumpPrograms,
		       int countUnique));
population *populationReadCheckpoint P((FILE *infile, const interface *ip,
					int maxLoops, double parsimony));
int populationWriteCheckpoint P((const population *pop, FILE *outfile));
void populationLoop P((population *pop, const interface *ip, int generations,
		       int maxLoops, double parsimony, int alwaysEval,
		       int maxMutateDepth, int maxTotalDepth,
		       parentSelectionMethod method, double pctReproduce,
		       double pctXoverAny, double pctXoverInternal,
		       int verbose, int countUnique));
void populationFree P((population *pop));

#endif /* POPULATION_H */
