#ifndef OPERATORSRC_H
#define OPERATORSRC_H

#include "compiler.h"
#include "charstring.h"
#include "result.h"
#include "object.h"

typedef result *(opSimpProc) P((const result **, void *));
typedef result *(opCompProc) P((int, const object **, void *));
typedef int printProc P((const void *op, charString *cstr));

typedef struct operatorSrc {
  objecttype otype;
  datatype dtype;
  const char *name;
  union {
    opSimpProc *simp;
    opCompProc *comp;
  } proc;
  int minArgs, maxArgs;
  printProc *print;
  datatype *argtypes;  
} operatorSrc;

#define operatorSrcType(osp)		(const objecttype )((osp)->otype)
#define operatorSrcDataType(osp)	(const datatype )((osp)->dtype)
#define operatorSrcName(osp)		(osp)->name
#define operatorSrcMinArgs(osp)		(const int )((osp)->minArgs)
#define operatorSrcMaxArgs(osp)		(const int )((osp)->maxArgs)
#define operatorSrcCount(osp, i)	(i ? 0 : 1)
#define operatorSrcDepth(osp, d)	(d)+1
#define operatorSrcSimpleProc(osp)	((const opSimpProc *)((osp)->proc.simp))
#define operatorSrcComplexProc(osp)	((const opCompProc *)((osp)->proc.comp))
#define operatorSrcPrintProc(osp)	((const printProc *)((osp)->print))

#define operatorSrcArgType(osp, i)	((i < 0 || i >= (osp)->maxArgs) ? \
					  dtError : (osp)->argtypes[i])

#define operatorSrcSetPrintProc(osp, pp) \
					(osp)->print = (pp)

operatorSrc *simpleOperatorSrcCreate P((const char *name, opSimpProc *procptr,
					int args));
operatorSrc *complexOperatorSrcCreate P((const char *name, opCompProc *procptr,
					 datatype returnTypes,
					 int minArgs, int maxArgs, ...));
struct operator *operatorSrcCopy P((const operatorSrc *osp));
result *operatorSrcEval P((const operatorSrc *osp));
int operatorSrcCompare P((const operatorSrc *osp1, const operatorSrc *osp2));
const operatorSrc **operatorSrcNodePtr P((const operatorSrc **ospp,
					  int *count, int nodeNum,
					  int internal, datatype *typeptr));
int operatorSrcToString P((const operatorSrc *osp, charString *cstr));
void operatorSrcFree P((operatorSrc *osp));

#endif /* OPERATORSRC_H */
