#ifndef OBJTYPES_H
#define OBJTYPES_H

#include "compiler.h"
#include "charstring.h"

typedef enum objecttype {
  otConstantSrc, otConstant, otVariable,
  otSimpleOperatorSrc, otSimpleOperator,
  otComplexOperatorSrc, otComplexOperator,
  otResult
} objecttype;

typedef enum datatype {
  dtVoid	= 0x00000001,
  dtBoolean	= 0x00000002,
  dtShort	= 0x00000004,
  dtInteger	= 0x00000008,
  dtLong	= 0x00000010,
  dtFloat   	= 0x00000020,
  dtDouble   	= 0x00000040,
  dtList	= 0x00000100,
  dtBlob	= 0x00004000,
  dtUserDef0	= 0x00010000,
  dtUserDef1	= 0x00020000,
  dtUserDef2	= 0x00040000,
  dtUserDef3	= 0x00080000,
  dtUserDef4	= 0x00100000,
  dtUserDef5	= 0x00200000,
  dtUserDef6	= 0x00400000,
  dtUserDef7	= 0x00800000,
  dtUserDef8	= 0x01000000,
  dtUserDef9	= 0x02000000,
  dtError  	= 0x40000000
} datatype;

typedef enum staticError {
  ErrorNoError, ErrorBadDataType, ErrorUserDefined
} staticError;

typedef int	bool;
typedef int	errorCode;

#define dtMath		(dtShort|dtInteger|dtLong|dtFloat|dtDouble)
#define dtAllUserDef	(dtUserDef0|dtUserDef1|dtUserDef2|dtUserDef3|\
			 dtUserDef4|dtUserDef5|dtUserDef6|dtUserDef7|\
			 dtUserDef8|dtUserDef9)
#define dtAll		(dtVoid|dtBoolean|dtShort|dtInteger|dtLong|dtFloat|\
			 dtDouble|dtList|dtBlob|dtUserDef0|dtUserDef1|\
			 dtUserDef2|dtUserDef3|dtUserDef4|dtUserDef5|\
			 dtUserDef6|dtUserDef7|dtUserDef8|dtUserDef9)

#define datatypeResolve(dt)		((dt) & dtAllUserDef ? \
				 	datatypeLookupAlias(dt) : (dt))

int datatypeMakeAlias P((datatype userDefinedType, datatype actualType));
datatype datatypeLookupAlias P((datatype userDefinedType));
int datatypeToString P((datatype type, charString *cstr));
int errorCodeSetMsgPtr P((errorCode code, const char **message));
void errorCodeFreeStack P((NOARGS));
const char *errorCodeMessage P((errorCode code));

#endif /* OBJTYPES_H */
