#ifndef GENERICLIST_H
#define GENERICLIST_H

#include "compiler.h"

typedef struct genericList {
  void **list;
  int used, allocated;
  int elementSize;
} genericList;

#define genericListLength(glp)		((const int )((glp)->used))
#define genericListEntry(glp, i)	\
	((void *)((unsigned long )(glp)->list + (glp)->elementSize * (i)))

genericList *genericListCreate P((int elementSize, int maxLength));
int genericListExtend P((genericList *glp, int newLength));
int genericListAdd P((genericList *glp, const void *valueptr));
int genericListSet P((genericList *glp, int index, const void *valueptr));
genericList *genericListCopy P((const genericList *glp));
void genericListFree P((genericList *glp));

#endif /* GENERICLIST_H */
