#ifndef CONSTANT_H
#define CONSTANT_H

#include "compiler.h"
#include "objtypes.h"
#include "charstring.h"
#include "result.h"
#include "blob.h"

typedef struct constant {
  objecttype otype;
  datatype dtype;
  union {
    bool b;
    short s;
    int i;
    long l;
    float f;
    double d;
    blob *bbp;
  } v;
} constant;

#define constantBoolean(rp)		(const char )((cp)->v.b)
#define constantShort(rp)		(const short )((cp)->v.s)
#define constantInteger(rp)		(const int )((cp)->v.i)
#define constantLong(rp)		(const long )((cp)->v.l)
#define constantFloat(rp)		(const float )((cp)->v.f)
#define constantDouble(rp)		(const double )((cp)->v.d)
#define constantBlobPtr(rp)		(const blob *)((cp)->v.bbp)

#define constantCount(cp, i)		(i ? 0 : 1)
#define constantDepth(cp, d)		(d)+1

#define booleanCreate(b)		constantCreate(dtBoolean, (int )b)
#define shortCreate(s)			constantCreate(dtShort, (int )s)
#define integerCreate(i)		constantCreate(dtInteger, (int )i)
#define longCreate(l)			constantCreate(dtLong, (int )l)
#define floatCreate(f)			constantCreate(dtFloat, (double )f)
#define doubleCreate(d)			constantCreate(dtDouble, (double )d)
#define blobPtrCreate(bb, dtype)	constantCreate(dtype, (blob *)bbp)

constant *constantCreate P((datatype type, ...));
constant *constantCopy P((const constant *cp));
int constantCompare P((const constant *cp1, const constant *cp2));
result *constantEval P((const constant *cp));
const constant **constantNodePtr P((const constant **cpp, int *count,
				    int nodeNum, int internal,
				    datatype *typeptr));
int constantToString P((const constant *cp, charString *cstr));
void constantFree P((constant *cp));
#ifdef KEEP_ALLOCATED_MEMORY
void constantFreeStack P((NOARGS));
#endif /* KEEP_ALLOCATED_MEMORY */

#endif /* CONSTANT_H */
