#include <math.h>
#include "geppetto.h"

float x;

#define NUMBER_OF_FITNESS_CASES	10

struct {
  float x;
  float answer;
} fitnessCase[NUMBER_OF_FITNESS_CASES];

objectList *
srTerminals()
{
  objectList *list;

  list = objectListCreate(2);
  objectListAdd(list, variableCreate(dtFloat, "X", &x));
  objectListAdd(list, floatSrcCreate(-5.0, 5.0));
  return(list);
}

result *
opAdd(argv, envp)
const result **argv;
void *envp;
{
  float fval;
	
  fval = resultFloat(argv[0]) + resultFloat(argv[1]);
  return(resultCreate(dtFloat, fval));
}

result *
opSubtract(argv, envp)
const result **argv;
void *envp;
{
  float fval;
	
  fval = resultFloat(argv[0]) - resultFloat(argv[1]);
  return(resultCreate(dtFloat, fval));
}

result *
opMultiply(argv, envp)
const result **argv;
void *envp;
{
  float fval;
	
  fval = resultFloat(argv[0]) * resultFloat(argv[1]);
  return(resultCreate(dtFloat, fval));
}

result * 
opDivide(argv, envp)
const result **argv;
void *envp;
{
  float fval;
	
  if (resultFloat(argv[1]) == 0)
    fval = 1;
  else
    fval = resultFloat(argv[0]) / resultFloat(argv[1]);
  return(resultCreate(dtFloat, fval));
}

objectList *
srFunctions()
{
  objectList *list;
	
  list = objectListCreate(4);
  objectListAdd(list, simpleOperatorSrcCreate("+", opAdd, 2));
  objectListAdd(list, simpleOperatorSrcCreate("-", opSubtract, 2));
  objectListAdd(list, simpleOperatorSrcCreate("*", opMultiply, 2));
  objectListAdd(list, simpleOperatorSrcCreate("/", opDivide, 2));
  return(list);
}

void *
srCaseInitialize(fc)
int fc;
{
  x = fitnessCase[fc].x;
  return(0);
}

void
srCaseFitness(rp, fc, hitp, rawp, stdp, envp)
result *rp;
int fc;
int *hitp;
double *rawp;
double *stdp;
void *envp;
{
  float diff;

#ifdef DEBUG
  {
    charString *cstr;

    cstr = charStringCreate();
    resultToString(rp, cstr);
    printf("X=%f, Correct answer=%f, Program returned ", fitnessCase[fc].x,
	   fitnessCase[fc].answer);
    charStringPrint(cstr);
    charStringFree(cstr);
  }
#endif /* DEBUG */

  /* compute difference between program result and actual answer */
  diff = fabs(resultFloat(rp) - fitnessCase[fc].answer);

  /* see if we got a hit */
  if (diff < 0.01)
    *hitp += 1;

  /* set raw fitness */
  *rawp += diff;

  /* set standardized fitness after final fitness case */
  if (fc == NUMBER_OF_FITNESS_CASES-1)
    *stdp = *rawp;
}

int
srTerminateRun(hits, raw, std)
int hits;
double raw, std;
{
  return(hits == NUMBER_OF_FITNESS_CASES);
}

void
appInitialize(ip)
interface *ip;
{
  extern int generations;
  extern int populationSize;
  int i;
  objectList *tList, *fList;
	
  /* initialize fitness cases */
  for (i = 0; i < NUMBER_OF_FITNESS_CASES; i++) {
    x = (float )i / NUMBER_OF_FITNESS_CASES;
    fitnessCase[i].x = x;
    fitnessCase[i].answer = (x*x)/2;
  }

  /* set global variables */
  generations = 30;
  populationSize = 200;

  /* build terminal and function lists */
  tList = srTerminals();
  fList = srFunctions();

  /* set app-specific variables */
  interfaceSetFitnessCases(ip, NUMBER_OF_FITNESS_CASES);
  interfaceSetTerminalList(ip, tList);
  interfaceSetFunctionList(ip, fList);

  /* set app-specific functions */
  interfaceCaseInitializeFunc(ip, srCaseInitialize);
  interfaceCaseFitnessFunc(ip, srCaseFitness);
  interfaceTerminateRunFunc(ip, srTerminateRun);
}

#ifdef DEBUG

#include "program.h"

int generations, populationSize;

int main P((int, char *[]));

int
main(argc, argv)
int argc;
char *argv[];
{
  interface *ip;
  void *envp;
  program *pp;
  const char *src = "(/ (* X X) 2.0)";
  int i = 1;

  ip = interfaceCreate(appInitialize);

  do {
    if (argc != 1)
      src = argv[i];
    pp = programParse(interfaceTerminalList(ip), interfaceFunctionList(ip),
		      src);
    if (pp == 0) {
      printf("Bad program '%s'!\n", src);
    } else {
      envp = interfaceCaseInitialize(ip, 0);
      interfaceEval(ip, pp, 1, 0.0);
      programDump(pp, 1);
      programFree(pp);
    }
  } while (++i < argc);

  exit(0);
}
#endif /* DEBUG */
